/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.social.core.storage.impl;

import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import java.util.concurrent.ConcurrentSkipListSet;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.locks.ReentrantLock;
import javax.jcr.InvalidItemStateException;
import javax.jcr.ItemExistsException;
import javax.jcr.PathNotFoundException;
import org.apache.commons.lang.ArrayUtils;
import org.chromattic.api.ChromatticException;
import org.chromattic.api.query.Ordering;
import org.chromattic.api.query.Query;
import org.chromattic.api.query.QueryBuilder;
import org.chromattic.api.query.QueryResult;
import org.exoplatform.container.PortalContainer;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.social.common.service.ProcessContext;
import org.exoplatform.social.common.service.utils.ObjectHelper;
import org.exoplatform.social.core.activity.filter.ActivityFilter;
import org.exoplatform.social.core.activity.model.ExoSocialActivity;
import org.exoplatform.social.core.chromattic.entity.ActivityEntity;
import org.exoplatform.social.core.chromattic.entity.ActivityRef;
import org.exoplatform.social.core.chromattic.entity.ActivityRefListEntity;
import org.exoplatform.social.core.chromattic.entity.IdentityEntity;
import org.exoplatform.social.core.chromattic.entity.StreamsEntity;
import org.exoplatform.social.core.chromattic.filter.JCRFilterLiteral;
import org.exoplatform.social.core.chromattic.utils.ActivityRefIterator;
import org.exoplatform.social.core.chromattic.utils.ActivityRefList;
import org.exoplatform.social.core.identity.model.Identity;
import org.exoplatform.social.core.space.model.Space;
import org.exoplatform.social.core.storage.ActivityStorageException;
import org.exoplatform.social.core.storage.api.ActivityStorage;
import org.exoplatform.social.core.storage.api.ActivityStreamStorage;
import org.exoplatform.social.core.storage.api.RelationshipStorage;
import org.exoplatform.social.core.storage.api.SpaceStorage;
import org.exoplatform.social.core.storage.exception.NodeNotFoundException;
import org.exoplatform.social.core.storage.impl.AbstractStorage;
import org.exoplatform.social.core.storage.impl.ActivityBuilderWhere;
import org.exoplatform.social.core.storage.impl.IdentityStorageImpl;
import org.exoplatform.social.core.storage.impl.StorageUtils;
import org.exoplatform.social.core.storage.query.JCRProperties;
import org.exoplatform.social.core.storage.query.WhereExpression;
import org.exoplatform.social.core.storage.streams.StreamProcessContext;

public class ActivityStreamStorageImpl
extends AbstractStorage
implements ActivityStreamStorage {
    private final IdentityStorageImpl identityStorage;
    private SpaceStorage spaceStorage;
    private RelationshipStorage relationshipStorage;
    private ActivityStorage activityStorage;
    private static final Log LOG = ExoLogger.getLogger(ActivityStreamStorageImpl.class);

    public ActivityStreamStorageImpl(IdentityStorageImpl identityStorage) {
        this.identityStorage = identityStorage;
    }

    private ActivityStorage getStorage() {
        if (this.activityStorage == null) {
            this.activityStorage = (ActivityStorage)PortalContainer.getInstance().getComponentInstanceOfType(ActivityStorage.class);
        }
        return this.activityStorage;
    }

    private SpaceStorage getSpaceStorage() {
        if (this.spaceStorage == null) {
            this.spaceStorage = (SpaceStorage)PortalContainer.getInstance().getComponentInstanceOfType(SpaceStorage.class);
        }
        return this.spaceStorage;
    }

    private RelationshipStorage getRelationshipStorage() {
        if (this.relationshipStorage == null) {
            this.relationshipStorage = (RelationshipStorage)PortalContainer.getInstance().getComponentInstanceOfType(RelationshipStorage.class);
        }
        return this.relationshipStorage;
    }

    @Override
    public void save(ProcessContext ctx) {
        try {
            StreamProcessContext streamCtx = (StreamProcessContext)((Object)ObjectHelper.cast(StreamProcessContext.class, (Object)ctx));
            Identity owner = streamCtx.getIdentity();
            ActivityEntity activityEntity = this._findById(ActivityEntity.class, streamCtx.getActivity().getId());
            if ("organization".equals(owner.getProviderId())) {
                this.user(owner, activityEntity);
                this.addMentioner(streamCtx.getMentioners(), activityEntity);
            } else if ("space".equals(owner.getProviderId())) {
                this.space(owner, activityEntity);
                this.addMentioner(streamCtx.getMentioners(), activityEntity);
            }
        }
        catch (NodeNotFoundException e) {
            ctx.setException((Throwable)e);
            LOG.warn((Object)"Failed to add Activity Relations references.", (Throwable)e);
        }
    }

    @Override
    public void savePoster(ProcessContext ctx) {
        try {
            StreamProcessContext streamCtx = (StreamProcessContext)((Object)ObjectHelper.cast(StreamProcessContext.class, (Object)ctx));
            Identity owner = streamCtx.getIdentity();
            ActivityEntity activityEntity = this._findById(ActivityEntity.class, streamCtx.getActivity().getId());
            if ("organization".equals(owner.getProviderId())) {
                this.createOwnerRefs(owner, activityEntity);
            } else if ("space".equals(owner.getProviderId())) {
                this.manageRefList(new ActivityStreamStorage.UpdateContext(owner, null), activityEntity, ActivityRefType.SPACE_STREAM);
                Identity ownerPosterOnSpace = this.identityStorage.findIdentityById(activityEntity.getPosterIdentity().getId());
                this.ownerSpaceMembersRefs(ownerPosterOnSpace, activityEntity);
            }
        }
        catch (NodeNotFoundException e) {
            ctx.setException((Throwable)e);
            LOG.warn((Object)"Failed to add Activity references.", (Throwable)e);
        }
    }

    private void user(Identity owner, ActivityEntity activityEntity) throws NodeNotFoundException {
        List<Identity> got = this.getRelationshipStorage().getConnections(owner);
        if (got.size() > 0) {
            this.createConnectionsRefs(got, activityEntity);
        }
    }

    private void removeMentioner(String[] identityIds, ActivityEntity activityEntity) throws NodeNotFoundException {
        if (identityIds != null && identityIds.length > 0) {
            for (String identityId : identityIds) {
                Identity identity = this.identityStorage.findIdentityById(identityId);
                this.removeOwnerRefs(identity, activityEntity);
            }
        }
    }

    private void removeCommenter(String[] identityIds, ActivityEntity activityEntity) throws NodeNotFoundException {
        if (identityIds != null && identityIds.length > 0) {
            for (String identityId : identityIds) {
                Identity identity = this.identityStorage.findIdentityById(identityId);
                this.manageRefList(new ActivityStreamStorage.UpdateContext(null, identity), activityEntity, ActivityRefType.MY_ACTIVITIES);
            }
        }
    }

    private void addMentioner(String[] identityIds, ActivityEntity activityEntity) throws NodeNotFoundException {
        if (identityIds != null && identityIds.length > 0) {
            for (String identityId : identityIds) {
                Identity identity = this.identityStorage.findIdentityById(identityId);
                this.createOwnerRefs(identity, activityEntity);
            }
        }
    }

    private void addCommenter(String[] identityIds, ActivityEntity activityEntity) throws NodeNotFoundException {
        if (identityIds != null && identityIds.length > 0) {
            for (String identityId : identityIds) {
                Identity identity = this.identityStorage.findIdentityById(identityId);
                this.createOwnerRefs(identity, activityEntity);
            }
        }
    }

    private void space(Identity owner, ActivityEntity activityEntity) throws NodeNotFoundException {
        Space space = this.getSpaceStorage().getSpaceByPrettyName(owner.getRemoteId());
        if (space == null) {
            return;
        }
        List<Identity> identities = this.getMemberIdentities(space);
        this.createSpaceMembersRefs(identities, activityEntity);
    }

    private List<Identity> getMemberIdentities(Space space) {
        ArrayList<Identity> identities = new ArrayList<Identity>();
        for (String remoteId : space.getMembers()) {
            identities.add(this.identityStorage.findIdentity("organization", remoteId));
        }
        return identities;
    }

    @Override
    public void delete(String activityId) {
        try {
            ActivityEntity activityEntity = this._findById(ActivityEntity.class, activityId);
            Collection<ActivityRef> references = activityEntity.getActivityRefs();
            ArrayList<ActivityRefListEntity> refList = new ArrayList<ActivityRefListEntity>();
            for (ActivityRef ref : references) {
                refList.add(ref.getDay().getMonth().getYear().getList());
            }
            for (ActivityRefListEntity list : refList) {
                list.remove(activityEntity.getLastUpdated());
            }
        }
        catch (NodeNotFoundException e) {
            LOG.warn((Object)"Failed to delete Activities references.", (Throwable)e);
        }
    }

    @Override
    public void like(Identity liker, ExoSocialActivity activity) {
        try {
            ActivityEntity entity = this._findById(ActivityEntity.class, activity.getId());
            this.manageRefList(new ActivityStreamStorage.UpdateContext(liker, null), entity, ActivityRefType.FEED);
            this.manageRefList(new ActivityStreamStorage.UpdateContext(liker, null), entity, ActivityRefType.MY_ACTIVITIES);
        }
        catch (NodeNotFoundException e) {
            LOG.warn((Object)"Failed to make Activity References for like case.");
        }
    }

    @Override
    public void unLike(Identity removedLike, ExoSocialActivity activity) {
        try {
            ActivityEntity entity = this._findById(ActivityEntity.class, activity.getId());
            boolean notDelete = ArrayUtils.contains((Object[])activity.getCommentedIds(), (Object)removedLike.getId());
            if (notDelete |= this.hasMentioned(removedLike, activity)) {
                return;
            }
            this.manageRefList(new ActivityStreamStorage.UpdateContext(null, removedLike), entity, ActivityRefType.MY_ACTIVITIES);
        }
        catch (NodeNotFoundException e) {
            LOG.warn((Object)"Failed to delete Activity References for unlike case.");
        }
    }

    private boolean hasMentioned(Identity removedLike, ExoSocialActivity activity) {
        for (String id : activity.getMentionedIds()) {
            if (id.indexOf(removedLike.getId()) <= -1) continue;
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void updateCommenter(ProcessContext ctx) {
        ReentrantLock lock = new ReentrantLock();
        try {
            StreamProcessContext streamCtx = (StreamProcessContext)((Object)ObjectHelper.cast(StreamProcessContext.class, (Object)ctx));
            ExoSocialActivity activity = streamCtx.getActivity();
            Identity commenter = streamCtx.getIdentity();
            IdentityEntity identityEntity = this.identityStorage._findIdentityEntity(commenter.getProviderId(), commenter.getRemoteId());
            ActivityEntity activityEntity = this._findById(ActivityEntity.class, activity.getId());
            lock.lock();
            QueryResult<ActivityRef> got = this.getActivityRefs(identityEntity, activityEntity);
            ActivityRef activityRef = null;
            while (got.hasNext()) {
                activityRef = (ActivityRef)got.next();
                activityRef.setName("" + activity.getUpdated().getTime());
                activityRef.setLastUpdated(activity.getUpdated().getTime());
            }
            long oldUpdated = streamCtx.getOldLastUpdated();
            boolean has = this.hasActivityRefs(identityEntity, activityEntity, ActivityRefType.MY_ACTIVITIES, oldUpdated);
            if (!has) {
                this.manageRefList(new ActivityStreamStorage.UpdateContext(commenter, null), activityEntity, ActivityRefType.MY_ACTIVITIES);
            }
            if (!(has = this.hasActivityRefs(identityEntity, activityEntity, ActivityRefType.FEED, oldUpdated))) {
                this.manageRefList(new ActivityStreamStorage.UpdateContext(commenter, null), activityEntity, ActivityRefType.FEED);
            }
            this.createRefForPoster(activityEntity, oldUpdated);
        }
        catch (NodeNotFoundException ex) {
            LOG.warn((Object)"Probably was updated activity reference by another session");
            LOG.debug((Object)ex.getMessage(), (Throwable)ex);
        }
        catch (ChromatticException ex) {
            Throwable throwable = ex.getCause();
            if (throwable instanceof ItemExistsException || throwable instanceof InvalidItemStateException || throwable instanceof PathNotFoundException) {
                LOG.warn((Object)"Probably was updated activity reference by another session");
                LOG.debug((Object)ex.getMessage(), (Throwable)ex);
            } else {
                LOG.warn((Object)"Probably was updated activity reference by another session", (Throwable)ex);
                LOG.debug((Object)ex.getMessage(), (Throwable)ex);
            }
        }
        finally {
            lock.unlock();
        }
    }

    private void createRefForPoster(ActivityEntity activityEntity, long oldUpdated) throws NodeNotFoundException {
        IdentityEntity posterIdentity = activityEntity.getIdentity();
        boolean has = this.hasActivityRefs(posterIdentity, activityEntity, ActivityRefType.MY_ACTIVITIES, oldUpdated);
        if (!has) {
            this.addRefList(posterIdentity, activityEntity, ActivityRefType.MY_ACTIVITIES, false);
            LOG.debug((Object)("createRefForPoster::MyActivities stream :" + posterIdentity.getRemoteId()));
        }
        if (!(has = this.hasActivityRefs(posterIdentity, activityEntity, ActivityRefType.FEED, oldUpdated))) {
            this.addRefList(posterIdentity, activityEntity, ActivityRefType.FEED, false);
            LOG.debug((Object)("createRefForPoster::Feed stream :" + posterIdentity.getRemoteId()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void update(ProcessContext ctx) {
        ReentrantLock lock = new ReentrantLock();
        ThreadLocal idLocal = new ThreadLocal();
        try {
            StreamProcessContext streamCtx = (StreamProcessContext)((Object)ObjectHelper.cast(StreamProcessContext.class, (Object)ctx));
            ExoSocialActivity activity = streamCtx.getActivity();
            ActivityEntity activityEntity = this._findById(ActivityEntity.class, activity.getId());
            lock.lock();
            Collection<ActivityRef> references = activityEntity.getActivityRefs();
            ConcurrentSkipListSet<String> ids = new ConcurrentSkipListSet<String>();
            for (ActivityRef ref : references) {
                ids.add(ref.getId());
            }
            idLocal.set(ids);
            Set idList = (Set)idLocal.get();
            if (idList.size() > 0) {
                for (String id : idList) {
                    ActivityRef old = this._findById(ActivityRef.class, id);
                    LOG.debug((Object)("ActivityRef will be deleted: " + old.toString()));
                    ActivityRefListEntity refList = old.getDay().getMonth().getYear().getList();
                    if (refList.isOnlyUpdate(old, activity.getUpdated().getTime())) {
                        old.setName("" + activity.getUpdated().getTime());
                        old.setLastUpdated(activity.getUpdated().getTime());
                        continue;
                    }
                    ActivityRef newRef = refList.getOrCreated(activity.getUpdated().getTime());
                    newRef.setLastUpdated(activity.getUpdated().getTime());
                    newRef.setActivityEntity(activityEntity);
                    this.getSession().remove((Object)old);
                }
            }
            this.addMentioner(streamCtx.getMentioners(), activityEntity);
        }
        catch (NodeNotFoundException ex) {
            LOG.warn((Object)"Probably was updated activity reference by another session");
            LOG.debug((Object)ex.getMessage(), (Throwable)ex);
        }
        catch (ChromatticException ex) {
            Throwable throwable = ex.getCause();
            if (throwable instanceof ItemExistsException || throwable instanceof InvalidItemStateException || throwable instanceof PathNotFoundException) {
                LOG.warn((Object)"Probably was updated activity reference by another session");
                LOG.debug((Object)ex.getMessage(), (Throwable)ex);
            } else {
                LOG.warn((Object)"Probably was updated activity reference by another session", (Throwable)ex);
                LOG.debug((Object)ex.getMessage(), (Throwable)ex);
            }
        }
        finally {
            this.getSession().save();
            lock.unlock();
        }
    }

    @Override
    public void deleteComment(ProcessContext ctx) {
        try {
            StreamProcessContext streamCtx = (StreamProcessContext)((Object)ObjectHelper.cast(StreamProcessContext.class, (Object)ctx));
            ExoSocialActivity activity = streamCtx.getActivity();
            ActivityEntity activityEntity = this._findById(ActivityEntity.class, activity.getId());
            this.removeMentioner(streamCtx.getMentioners(), activityEntity);
            this.removeCommenter(streamCtx.getCommenters(), activityEntity);
        }
        catch (NodeNotFoundException e) {
            LOG.warn((Object)"Failed to delete Activity references for mentioner and commenter.");
        }
    }

    @Override
    public void addSpaceMember(ProcessContext ctx) {
        try {
            StreamProcessContext streamCtx = (StreamProcessContext)((Object)ObjectHelper.cast(StreamProcessContext.class, (Object)ctx));
            this.createSpaceMemberRefs(streamCtx.getIdentity(), streamCtx.getSpaceIdentity());
        }
        catch (NodeNotFoundException e) {
            LOG.warn((Object)"Failed to addSpaceMember Activity references.");
        }
    }

    @Override
    public void removeSpaceMember(ProcessContext ctx) {
        try {
            StreamProcessContext streamCtx = (StreamProcessContext)((Object)ObjectHelper.cast(StreamProcessContext.class, (Object)ctx));
            this.removeSpaceMemberRefs(streamCtx.getIdentity(), streamCtx.getSpaceIdentity());
        }
        catch (NodeNotFoundException e) {
            LOG.warn((Object)"Failed to removeSpaceMember Activity references.");
        }
    }

    @Override
    public List<ExoSocialActivity> getFeed(Identity owner, int offset, int limit) {
        return this.getActivitiesNotQuery(ActivityRefType.FEED, owner, offset, limit);
    }

    @Override
    public int getNumberOfFeed(Identity owner) {
        return this.getNumberOfActivities(ActivityRefType.FEED, owner);
    }

    @Override
    public List<ExoSocialActivity> getConnections(Identity owner, int offset, int limit) {
        return this.getActivitiesNotQuery(ActivityRefType.CONNECTION, owner, offset, limit);
    }

    @Override
    public int getNumberOfConnections(Identity owner) {
        return this.getNumberOfActivities(ActivityRefType.CONNECTION, owner);
    }

    @Override
    public List<ExoSocialActivity> getMySpaces(Identity owner, int offset, int limit) {
        return this.getActivitiesNotQuery(ActivityRefType.MY_SPACES, owner, offset, limit);
    }

    @Override
    public int getNumberOfMySpaces(Identity owner) {
        return this.getNumberOfActivities(ActivityRefType.MY_SPACES, owner);
    }

    @Override
    public List<ExoSocialActivity> getSpaceStream(Identity owner, int offset, int limit) {
        return this.getActivities(ActivityRefType.SPACE_STREAM, owner, offset, limit);
    }

    @Override
    public int getNumberOfSpaceStream(Identity owner) {
        return this.getNumberOfActivities(ActivityRefType.SPACE_STREAM, owner);
    }

    @Override
    public List<ExoSocialActivity> getMyActivities(Identity owner, int offset, int limit) {
        return this.getActivitiesNotQuery(ActivityRefType.MY_ACTIVITIES, owner, offset, limit);
    }

    @Override
    public int getNumberOfMyActivities(Identity owner) {
        return this.getNumberOfActivities(ActivityRefType.MY_ACTIVITIES, owner);
    }

    @Override
    public void connect(Identity sender, Identity receiver) {
        try {
            QueryResult<ActivityEntity> activities = this.getActivitiesOfConnections(sender);
            IdentityEntity receiverEntity = this.identityStorage._findIdentityEntity(receiver.getProviderId(), receiver.getRemoteId());
            if (activities != null) {
                while (activities.hasNext()) {
                    ActivityEntity entity = (ActivityEntity)activities.next();
                    if (this.isExistingActivityRef(receiverEntity, entity)) continue;
                    this.createConnectionsRefs(receiver, entity);
                }
            }
            IdentityEntity senderEntity = this.identityStorage._findIdentityEntity(sender.getProviderId(), sender.getRemoteId());
            activities = this.getActivitiesOfConnections(receiver);
            if (activities != null) {
                while (activities.hasNext()) {
                    ActivityEntity entity = (ActivityEntity)activities.next();
                    if (this.isExistingActivityRef(senderEntity, entity)) continue;
                    this.createConnectionsRefs(sender, entity);
                }
            }
        }
        catch (NodeNotFoundException e) {
            LOG.warn((Object)"Failed to add Activity references when create relationship.");
        }
    }

    @Override
    public void deleteConnect(Identity sender, Identity receiver) {
        try {
            ActivityEntity entity;
            QueryResult<ActivityEntity> activities = this.getActivitiesOfConnections(sender);
            if (activities != null) {
                while (activities.hasNext()) {
                    entity = (ActivityEntity)activities.next();
                    this.removeRelationshipRefs(receiver, entity);
                }
            }
            if ((activities = this.getActivitiesOfConnections(receiver)) != null) {
                while (activities.hasNext()) {
                    entity = (ActivityEntity)activities.next();
                    this.removeRelationshipRefs(sender, entity);
                }
            }
        }
        catch (NodeNotFoundException e) {
            LOG.warn((Object)"Failed to delete Activity references when delete relationship.");
        }
    }

    private List<ExoSocialActivity> getActivities(ActivityRefType type, Identity owner, int offset, int limit) {
        LinkedList<ExoSocialActivity> got = new LinkedList<ExoSocialActivity>();
        try {
            IdentityEntity identityEntity = this.identityStorage._findIdentityEntity(owner.getProviderId(), owner.getRemoteId());
            QueryResult<ActivityRef> it = this.getActivityRefs(identityEntity, type, offset, limit);
            while (it.hasNext()) {
                ActivityRef current = (ActivityRef)it.next();
                if (current.getActivityEntity() == null) {
                    current.getDay().getActivityRefs().remove(current.getName());
                    continue;
                }
                ExoSocialActivity a = this.getStorage().getActivity(current.getActivityEntity().getId());
                got.add(a);
            }
        }
        catch (NodeNotFoundException e) {
            LOG.warn((Object)"Failed to getActivities()");
        }
        return got;
    }

    private List<ExoSocialActivity> getActivitiesNotQuery(ActivityRefType type, Identity owner, int offset, int limit) {
        LinkedList<ExoSocialActivity> got = new LinkedList<ExoSocialActivity>();
        try {
            IdentityEntity identityEntity = this.identityStorage._findIdentityEntity(owner.getProviderId(), owner.getRemoteId());
            ActivityRefListEntity refList = type.refsOf(identityEntity);
            ActivityRefList list = new ActivityRefList(refList);
            int nb = 0;
            ActivityRefIterator it = list.iterator();
            this._skip(it, offset);
            while (it.hasNext()) {
                ActivityRef current = it.next();
                if (current.getActivityEntity() == null) {
                    current.getDay().getActivityRefs().remove(current.getName());
                    continue;
                }
                got.add(this.getStorage().getActivity(current.getActivityEntity().getId()));
                if (++nb != limit) continue;
                break;
            }
        }
        catch (NodeNotFoundException e) {
            LOG.warn((Object)"Failed to activities!");
        }
        return got;
    }

    private int getNumberOfActivities(ActivityRefType type, Identity owner) {
        try {
            IdentityEntity identityEntity = this.identityStorage._findIdentityEntity(owner.getProviderId(), owner.getRemoteId());
            ActivityRefListEntity refList = type.refsOf(identityEntity);
            if (refList == null) {
                return 0;
            }
            return refList.getNumber();
        }
        catch (NodeNotFoundException e) {
            LOG.warn((Object)"Failed to getNumberOfActivities()");
            return 0;
        }
    }

    private QueryResult<ActivityEntity> getActivitiesOfConnections(Identity ownerIdentity) {
        ArrayList<Identity> connections = new ArrayList<Identity>();
        if (ownerIdentity == null) {
            return null;
        }
        connections.add(ownerIdentity);
        ActivityFilter filter = ActivityFilter.newer();
        return this.getActivitiesOfIdentities(ActivityBuilderWhere.simple().owners(connections), filter, 0L, -1L);
    }

    private QueryResult<ActivityEntity> getActivitiesOfSpace(Identity spaceIdentity) {
        if (spaceIdentity == null) {
            return null;
        }
        ActivityFilter filter = ActivityFilter.space();
        return this.getActivitiesOfIdentities(ActivityBuilderWhere.space().owners(spaceIdentity), filter, 0L, -1L);
    }

    private QueryResult<ActivityEntity> getActivitiesOfIdentities(ActivityBuilderWhere where, ActivityFilter filter, long offset, long limit) throws ActivityStorageException {
        return this.getActivitiesOfIdentitiesQuery(where, filter).objects(Long.valueOf(offset), Long.valueOf(limit));
    }

    private Query<ActivityEntity> getActivitiesOfIdentitiesQuery(ActivityBuilderWhere whereBuilder, JCRFilterLiteral filter) throws ActivityStorageException {
        QueryBuilder builder = this.getSession().createQueryBuilder(ActivityEntity.class);
        builder.where(whereBuilder.build(filter));
        whereBuilder.orderBy((QueryBuilder<ActivityEntity>)builder, filter);
        return builder.get();
    }

    private boolean isExistingActivityRef(IdentityEntity identityEntity, ActivityEntity activityEntity) throws NodeNotFoundException {
        return this.getActivityRefs(identityEntity, activityEntity).size() > 0;
    }

    private QueryResult<ActivityRef> getActivityRefs(IdentityEntity identityEntity, ActivityEntity activityEntity) throws NodeNotFoundException {
        QueryBuilder builder = this.getSession().createQueryBuilder(ActivityRef.class);
        WhereExpression whereExpression = new WhereExpression();
        whereExpression.like(JCRProperties.path, identityEntity.getPath() + "/%");
        whereExpression.and().equals(ActivityRef.target, activityEntity.getId());
        builder.where(whereExpression.toString());
        return builder.get().objects();
    }

    private boolean hasActivityRefs(IdentityEntity identityEntity, ActivityEntity activityEntity, ActivityRefType type, long oldUpdated) throws NodeNotFoundException {
        ActivityRefListEntity refList = type.refsOf(identityEntity);
        ActivityRef ref = refList.get(oldUpdated);
        return ref != null && ref.getActivityEntity().getId() == activityEntity.getId();
    }

    private QueryResult<ActivityRef> getActivityRefs(IdentityEntity identityEntity, ActivityRefType type, long offset, long limit) throws NodeNotFoundException {
        QueryBuilder builder = this.getSession().createQueryBuilder(ActivityRef.class);
        WhereExpression whereExpression = new WhereExpression();
        ActivityRefListEntity refList = type.refsOf(identityEntity);
        whereExpression.like(JCRProperties.path, refList.getPath() + "/%");
        builder.where(whereExpression.toString());
        builder.orderBy(ActivityRef.lastUpdated.getName(), Ordering.DESC);
        builder.orderBy(JCRProperties.name.getName(), Ordering.DESC);
        return builder.get().objects(Long.valueOf(offset), Long.valueOf(limit));
    }

    private void createOwnerRefs(Identity owner, ActivityEntity activityEntity) throws NodeNotFoundException {
        this.manageRefList(new ActivityStreamStorage.UpdateContext(owner, null), activityEntity, ActivityRefType.FEED);
        this.manageRefList(new ActivityStreamStorage.UpdateContext(owner, null), activityEntity, ActivityRefType.MY_ACTIVITIES);
    }

    private void removeOwnerRefs(Identity owner, ActivityEntity activityEntity) throws NodeNotFoundException {
        this.manageRefList(new ActivityStreamStorage.UpdateContext(null, owner), activityEntity, ActivityRefType.FEED);
        this.manageRefList(new ActivityStreamStorage.UpdateContext(null, owner), activityEntity, ActivityRefType.MY_ACTIVITIES);
    }

    private void createConnectionsRefs(List<Identity> identities, ActivityEntity activityEntity) throws NodeNotFoundException {
        this.manageRefList(new ActivityStreamStorage.UpdateContext(identities, null), activityEntity, ActivityRefType.FEED, true);
        this.manageRefList(new ActivityStreamStorage.UpdateContext(identities, null), activityEntity, ActivityRefType.CONNECTION, true);
    }

    private void createConnectionsRefs(Identity identity, ActivityEntity activityEntity) throws NodeNotFoundException {
        this.manageRefList(new ActivityStreamStorage.UpdateContext(identity, null), activityEntity, ActivityRefType.FEED, true);
        this.manageRefList(new ActivityStreamStorage.UpdateContext(identity, null), activityEntity, ActivityRefType.CONNECTION, true);
    }

    private void removeRelationshipRefs(Identity identity, ActivityEntity activityEntity) throws NodeNotFoundException {
        this.manageRefList(new ActivityStreamStorage.UpdateContext(null, identity), activityEntity, ActivityRefType.FEED);
        this.manageRefList(new ActivityStreamStorage.UpdateContext(null, identity), activityEntity, ActivityRefType.CONNECTION);
    }

    private void createSpaceMembersRefs(List<Identity> identities, ActivityEntity activityEntity) throws NodeNotFoundException {
        this.manageRefList(new ActivityStreamStorage.UpdateContext(identities, null), activityEntity, ActivityRefType.FEED);
        this.manageRefList(new ActivityStreamStorage.UpdateContext(identities, null), activityEntity, ActivityRefType.MY_SPACES);
    }

    private void ownerSpaceMembersRefs(Identity identity, ActivityEntity activityEntity) throws NodeNotFoundException {
        this.manageRefList(new ActivityStreamStorage.UpdateContext(identity, null), activityEntity, ActivityRefType.MY_ACTIVITIES);
    }

    private void createSpaceMembersRefs(Identity identity, ActivityEntity activityEntity) throws NodeNotFoundException {
        this.manageRefList(new ActivityStreamStorage.UpdateContext(identity, null), activityEntity, ActivityRefType.FEED);
        this.manageRefList(new ActivityStreamStorage.UpdateContext(identity, null), activityEntity, ActivityRefType.MY_SPACES);
    }

    private void createSpaceMemberRefs(Identity member, Identity space) throws NodeNotFoundException {
        QueryResult<ActivityEntity> spaceActivities = this.getActivitiesOfSpace(space);
        if (spaceActivities != null) {
            while (spaceActivities.hasNext()) {
                this.createSpaceMembersRefs(member, (ActivityEntity)spaceActivities.next());
            }
        }
    }

    private void removeSpaceMemberRefs(Identity removedMember, Identity space) throws NodeNotFoundException {
        QueryResult<ActivityEntity> spaceActivities = this.getActivitiesOfSpace(space);
        if (spaceActivities != null) {
            while (spaceActivities.hasNext()) {
                ActivityEntity entity = (ActivityEntity)spaceActivities.next();
                this.manageRefList(new ActivityStreamStorage.UpdateContext(null, removedMember), entity, ActivityRefType.FEED);
                this.manageRefList(new ActivityStreamStorage.UpdateContext(null, removedMember), entity, ActivityRefType.MY_SPACES);
            }
        }
    }

    private void manageRefList(ActivityStreamStorage.UpdateContext context, ActivityEntity activityEntity, ActivityRefType type) throws NodeNotFoundException {
        this.manageRefList(context, activityEntity, type, false);
    }

    private void manageRefList(ActivityStreamStorage.UpdateContext context, ActivityEntity activityEntity, ActivityRefType type, boolean mustCheck) throws NodeNotFoundException {
        ActivityRefListEntity listRef;
        IdentityEntity identityEntity;
        AtomicBoolean newYearMonthday = new AtomicBoolean(false);
        if (context.getAdded() != null) {
            for (Identity identity : context.getAdded()) {
                identityEntity = this.identityStorage._findIdentityEntity(identity.getProviderId(), identity.getRemoteId());
                if (mustCheck && this.isExistingActivityRef(identityEntity, activityEntity)) continue;
                listRef = type.refsOf(identityEntity);
                newYearMonthday.set(false);
                ActivityRef ref = listRef.getOrCreated(activityEntity, newYearMonthday);
                if (newYearMonthday.get()) {
                    StorageUtils.persist();
                }
                if (ref.getName() == null) {
                    ref.setName(activityEntity.getName());
                }
                if (ref.getLastUpdated() == null) {
                    ref.setLastUpdated(activityEntity.getLastUpdated());
                }
                ref.setActivityEntity(activityEntity);
            }
        }
        if (context.getRemoved() != null) {
            for (Identity identity : context.getRemoved()) {
                identityEntity = this.identityStorage._findIdentityEntity(identity.getProviderId(), identity.getRemoteId());
                listRef = type.refsOf(identityEntity);
                listRef.remove(activityEntity);
            }
        }
    }

    private void addRefList(IdentityEntity identityEntity, ActivityEntity activityEntity, ActivityRefType type, boolean mustCheck) throws NodeNotFoundException {
        AtomicBoolean newYearMonthday = new AtomicBoolean(false);
        if (mustCheck && this.isExistingActivityRef(identityEntity, activityEntity)) {
            return;
        }
        ActivityRefListEntity listRef = type.refsOf(identityEntity);
        newYearMonthday.set(false);
        ActivityRef ref = listRef.getOrCreated(activityEntity, newYearMonthday);
        if (newYearMonthday.get()) {
            StorageUtils.persist();
        }
        if (ref.getName() == null) {
            ref.setName(activityEntity.getName());
        }
        if (ref.getLastUpdated() == null) {
            ref.setLastUpdated(activityEntity.getLastUpdated());
        }
        ref.setActivityEntity(activityEntity);
    }

    @Override
    public void createFeedActivityRef(Identity owner, List<ExoSocialActivity> activities) {
        this.createActivityRef(owner, activities, ActivityRefType.FEED);
    }

    @Override
    public void createConnectionsActivityRef(Identity owner, List<ExoSocialActivity> activities) {
        this.createActivityRef(owner, activities, ActivityRefType.CONNECTION);
    }

    @Override
    public void createMySpacesActivityRef(Identity owner, List<ExoSocialActivity> activities) {
        this.createActivityRef(owner, activities, ActivityRefType.MY_SPACES);
    }

    @Override
    public void createSpaceActivityRef(Identity owner, List<ExoSocialActivity> activities) {
        this.createActivityRef(owner, activities, ActivityRefType.SPACE_STREAM);
    }

    @Override
    public void createMyActivitiesActivityRef(Identity owner, List<ExoSocialActivity> activities) {
        this.createActivityRef(owner, activities, ActivityRefType.MY_ACTIVITIES);
    }

    @Override
    public void createActivityRef(Identity owner, List<ExoSocialActivity> activities, ActivityRefType type) {
        if (activities == null || activities.size() == 0) {
            return;
        }
        try {
            IdentityEntity identityEntity = this.identityStorage._findIdentityEntity(owner.getProviderId(), owner.getRemoteId());
            ActivityRefListEntity listRef = type.create(identityEntity);
            ExoSocialActivity entity = activities.get(activities.size() - 1);
            Long value = entity.getUpdated() != null ? entity.getUpdated().getTime() : entity.getPostedTime().longValue();
            Long oldLastMigration = listRef.getLastMigration();
            listRef.setLastMigration((long)value);
            Integer numberOfStream = listRef.getNumber();
            for (ExoSocialActivity a : activities) {
                ActivityEntity activityEntity = (ActivityEntity)this.getSession().findById(ActivityEntity.class, a.getId());
                ActivityRef ref = listRef.getOrCreated(activityEntity);
                ref.setActivityEntity(activityEntity);
            }
            if (oldLastMigration != null && oldLastMigration > 0L) {
                listRef.setNumber(numberOfStream);
            }
            StorageUtils.persist();
        }
        catch (NodeNotFoundException e) {
            LOG.warn((Object)"Failed to create Activity references.");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void migrateStreamSize(Identity owner, int size, ActivityRefType type) {
        try {
            IdentityEntity identityEntity = this.identityStorage._findIdentityEntity(owner.getProviderId(), owner.getRemoteId());
            ActivityRefListEntity listRef = type.create(identityEntity);
            listRef.setNumber(size);
        }
        catch (NodeNotFoundException e) {
            LOG.warn((Object)"Failed to migrateStreamSize.");
        }
        finally {
            StorageUtils.persist();
        }
    }

    @Override
    public boolean hasSizeOfFeed(Identity owner) {
        return this.hasSizeOfActivities(ActivityRefType.FEED, owner);
    }

    @Override
    public boolean hasSizeOfMySpaces(Identity owner) {
        return this.hasSizeOfActivities(ActivityRefType.MY_SPACES, owner);
    }

    @Override
    public boolean hasSizeOfSpaceStream(Identity owner) {
        return this.hasSizeOfActivities(ActivityRefType.SPACE_STREAM, owner);
    }

    @Override
    public boolean hasSizeOfMyActivities(Identity owner) {
        return this.hasSizeOfActivities(ActivityRefType.MY_ACTIVITIES, owner);
    }

    @Override
    public boolean hasSizeOfConnections(Identity owner) {
        return this.hasSizeOfActivities(ActivityRefType.CONNECTION, owner);
    }

    private boolean hasSizeOfActivities(ActivityRefType type, Identity owner) {
        try {
            IdentityEntity identityEntity = this.identityStorage._findIdentityEntity(owner.getProviderId(), owner.getRemoteId());
            ActivityRefListEntity refList = type.refsOf(identityEntity);
            if (refList == null) {
                return false;
            }
            return refList.getNumber() > 0;
        }
        catch (NodeNotFoundException e) {
            LOG.warn((Object)"Failed to hasSizeOfActivities()");
            return false;
        }
    }

    public static enum ActivityRefType {
        FEED{

            @Override
            public ActivityRefListEntity refsOf(IdentityEntity identityEntity) {
                if (identityEntity.getStreams() == null) {
                    return this.create(identityEntity);
                }
                if (identityEntity.getStreams().getOwner() == null) {
                    return this.create(identityEntity);
                }
                return identityEntity.getStreams().getAll();
            }

            @Override
            public ActivityRefListEntity create(IdentityEntity identityEntity) {
                StreamsEntity streams = identityEntity.getStreams();
                if (streams == null) {
                    streams = identityEntity.createStreams();
                    identityEntity.setStreams(streams);
                }
                ActivityRefListEntity refList = streams.getAll() == null ? streams.createAllStream() : streams.getAll();
                return refList;
            }
        }
        ,
        CONNECTION{

            @Override
            public ActivityRefListEntity refsOf(IdentityEntity identityEntity) {
                if (identityEntity.getStreams() == null) {
                    return this.create(identityEntity);
                }
                if (identityEntity.getStreams().getOwner() == null) {
                    return this.create(identityEntity);
                }
                return identityEntity.getStreams().getConnections();
            }

            @Override
            public ActivityRefListEntity create(IdentityEntity identityEntity) {
                StreamsEntity streams = identityEntity.getStreams();
                if (streams == null) {
                    streams = identityEntity.createStreams();
                    identityEntity.setStreams(streams);
                }
                ActivityRefListEntity refList = streams.getConnections() == null ? streams.createConnectionsStream() : streams.getConnections();
                return refList;
            }
        }
        ,
        MY_SPACES{

            @Override
            public ActivityRefListEntity refsOf(IdentityEntity identityEntity) {
                if (identityEntity.getStreams() == null) {
                    return this.create(identityEntity);
                }
                if (identityEntity.getStreams().getOwner() == null) {
                    return this.create(identityEntity);
                }
                return identityEntity.getStreams().getMySpaces();
            }

            @Override
            public ActivityRefListEntity create(IdentityEntity identityEntity) {
                StreamsEntity streams = identityEntity.getStreams();
                if (streams == null) {
                    streams = identityEntity.createStreams();
                    identityEntity.setStreams(streams);
                }
                ActivityRefListEntity refList = streams.getMySpaces() == null ? streams.createMySpacesStream() : streams.getMySpaces();
                return refList;
            }
        }
        ,
        SPACE_STREAM{

            @Override
            public ActivityRefListEntity refsOf(IdentityEntity identityEntity) {
                if (identityEntity.getStreams() == null) {
                    return this.create(identityEntity);
                }
                if (identityEntity.getStreams().getOwner() == null) {
                    return this.create(identityEntity);
                }
                return identityEntity.getStreams().getSpace();
            }

            @Override
            public ActivityRefListEntity create(IdentityEntity identityEntity) {
                StreamsEntity streams = identityEntity.getStreams();
                if (streams == null) {
                    streams = identityEntity.createStreams();
                    identityEntity.setStreams(streams);
                }
                ActivityRefListEntity refList = streams.getSpace() == null ? streams.createSpaceStream() : streams.getSpace();
                return refList;
            }
        }
        ,
        MY_ACTIVITIES{

            @Override
            public ActivityRefListEntity refsOf(IdentityEntity identityEntity) {
                if (identityEntity.getStreams() == null) {
                    return this.create(identityEntity);
                }
                if (identityEntity.getStreams().getOwner() == null) {
                    return this.create(identityEntity);
                }
                return identityEntity.getStreams().getOwner();
            }

            @Override
            public ActivityRefListEntity create(IdentityEntity identityEntity) {
                StreamsEntity streams = identityEntity.getStreams();
                if (streams == null) {
                    streams = identityEntity.createStreams();
                    identityEntity.setStreams(streams);
                }
                ActivityRefListEntity refList = streams.getOwner() == null ? streams.createOwnerStream() : streams.getOwner();
                return refList;
            }
        };


        public abstract ActivityRefListEntity refsOf(IdentityEntity var1);

        public abstract ActivityRefListEntity create(IdentityEntity var1);
    }
}

