/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.webui.form;

import java.util.List;
import org.exoplatform.commons.serialization.api.annotations.Serialized;
import org.exoplatform.webui.application.WebuiRequestContext;
import org.exoplatform.webui.config.annotation.ComponentConfig;
import org.exoplatform.webui.config.annotation.EventConfig;
import org.exoplatform.webui.core.UIPopupWindow;
import org.exoplatform.webui.event.Event;
import org.exoplatform.webui.event.EventListener;
import org.exoplatform.webui.form.UIForm;
import org.exoplatform.webui.form.UIFormInput;
import org.exoplatform.webui.form.validator.Validator;

@ComponentConfig(template="system:/groovy/webui/core/UIPopupWindow.gtmpl", events={@EventConfig(listeners={CloseActionListener.class}, name="CloseFormPopup", phase=Event.Phase.DECODE)})
@Serialized
public class UIFormPopupWindow
extends UIPopupWindow
implements UIFormInput<Object> {
    public UIFormPopupWindow() {
        this.closeEvent_ = "CloseFormPopup";
    }

    public void processDecode(WebuiRequestContext context) throws Exception {
        UIForm uiForm = (UIForm)this.getAncestorOfType(UIForm.class);
        String action = uiForm.getSubmitAction();
        if (action == null) {
            return;
        }
        Event event = this.createEvent(action, Event.Phase.DECODE, context);
        if (event != null) {
            event.broadcast();
        }
        this.getUIComponent().processDecode(context);
        if (this.getUIComponent() == null) {
            return;
        }
    }

    public String event(String name) throws Exception {
        UIForm uiForm = (UIForm)this.getAncestorOfType(UIForm.class);
        if (uiForm != null) {
            return uiForm.event(name, this.getId(), null);
        }
        return super.event(name);
    }

    @Override
    public String getLabel() {
        return this.getName();
    }

    @Override
    public <E extends Validator> UIFormInput addValidator(Class<E> clazz, Object ... params) throws Exception {
        return this;
    }

    @Override
    public String getBindingField() {
        return null;
    }

    @Override
    public List getValidators() {
        return null;
    }

    @Override
    public Object getValue() throws Exception {
        return null;
    }

    @Override
    public void reset() {
    }

    @Override
    public Class getTypeValue() {
        return null;
    }

    @Override
    public UIFormInput setValue(Object value) throws Exception {
        return null;
    }

    public static class CloseActionListener
    extends EventListener<UIPopupWindow> {
        public void execute(Event<UIPopupWindow> event) throws Exception {
            UIPopupWindow uiPopupWindow = (UIPopupWindow)event.getSource();
            UIForm uiForm = (UIForm)uiPopupWindow.getAncestorOfType(UIForm.class);
            uiPopupWindow.setShow(false);
            event.getRequestContext().addUIComponentToUpdateByAjax(uiForm.getParent());
        }
    }
}

