/*
 * Decompiled with CFR 0.152.
 */
package org.chromattic.groovy;

import java.util.Iterator;
import org.chromattic.groovy.GroovyUtils;
import org.chromattic.groovy.annotations.ChromatticDelegation;
import org.chromattic.groovy.annotations.GroovyInstrumentor;
import org.chromattic.groovy.exceptions.NoSuchGetterException;
import org.chromattic.groovy.exceptions.NoSuchSetterException;
import org.codehaus.groovy.ast.AnnotationNode;
import org.codehaus.groovy.ast.ClassNode;
import org.codehaus.groovy.ast.FieldNode;
import org.codehaus.groovy.ast.MethodNode;

public class ChromatticAnnotationMover {
    public void addFieldAnnotationToMethod(ClassNode classNode, FieldNode fieldNode, AnnotationNode annotationNode) throws NoSuchGetterException {
        MethodNode getterNode = GroovyUtils.getGetter(classNode, fieldNode);
        if (getterNode == null || !getterNode.getDeclaringClass().equals((Object)classNode)) {
            throw new NoSuchGetterException("Cannot apply chromattic annotations because getter don't exist for : " + fieldNode.getName());
        }
        getterNode.addAnnotation(annotationNode);
    }

    public void addSetterDelegationAnnotation(ClassNode classNode, FieldNode fieldNode) throws NoSuchSetterException {
        MethodNode setterNode = GroovyUtils.getSetter(classNode, fieldNode);
        if (setterNode == null || !setterNode.getDeclaringClass().equals((Object)classNode)) {
            throw new NoSuchSetterException("Cannot apply annotation @ChromatticDelegation because setter don't exist for : " + fieldNode.getName());
        }
        setterNode.addAnnotation(new AnnotationNode(new ClassNode(ChromatticDelegation.class)));
    }

    public void generateGetter(ClassNode classNode, FieldNode fieldNode) {
        GroovyUtils.createGetter(classNode, fieldNode);
    }

    public void generateGetter(ClassNode classNode, FieldNode fieldNode, AnnotationNode defaultAnnotatedNode) {
        this.generateGetter(classNode, fieldNode);
        try {
            this.addFieldAnnotationToMethod(classNode, fieldNode, defaultAnnotatedNode);
        }
        catch (NoSuchGetterException ignore) {
            // empty catch block
        }
    }

    public void generateSetter(ClassNode classNode, FieldNode fieldNode) {
        GroovyUtils.createSetter(classNode, fieldNode);
        try {
            this.addSetterDelegationAnnotation(classNode, fieldNode);
        }
        catch (NoSuchSetterException noSuchSetterException) {
            // empty catch block
        }
    }

    public void removeChromatticAnnotation(FieldNode fieldNode) {
        Iterator it = fieldNode.getAnnotations().iterator();
        while (it.hasNext()) {
            if (!((AnnotationNode)it.next()).getClassNode().getName().startsWith("org.chromattic.")) continue;
            it.remove();
        }
    }

    public void applyGroovyInstrumentor(ClassNode classNode) {
        classNode.addAnnotation(new AnnotationNode(new ClassNode(GroovyInstrumentor.class)));
    }
}

