/*
 * Decompiled with CFR 0.152.
 */
package org.gatein.sso.saml.plugin.listener;

import javax.servlet.http.HttpSessionEvent;
import javax.servlet.http.HttpSessionListener;
import org.gatein.common.logging.Logger;
import org.gatein.common.logging.LoggerFactory;
import org.gatein.sso.integration.SSOUtils;

public class IDPHttpSessionListener
implements HttpSessionListener {
    private static final Logger log = LoggerFactory.getLogger(IDPHttpSessionListener.class);
    private static final String PROPERTY_IDP_ENABLED = "gatein.sso.idp.listener.enabled";
    private HttpSessionListener delegate;

    public void sessionDestroyed(HttpSessionEvent se) {
        if ("true".equals(SSOUtils.getSystemProperty((String)PROPERTY_IDP_ENABLED, (String)"false"))) {
            HttpSessionListener delegate = this.getOrInitDelegate();
            delegate.sessionDestroyed(se);
        } else if (log.isTraceEnabled()) {
            log.trace((Object)"Portal is not acting as SAML2 IDP. Ignore this listener");
        }
    }

    public void sessionCreated(HttpSessionEvent se) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private HttpSessionListener getOrInitDelegate() {
        if (this.delegate == null) {
            IDPHttpSessionListener iDPHttpSessionListener = this;
            synchronized (iDPHttpSessionListener) {
                if (this.delegate == null) {
                    this.delegate = new org.picketlink.identity.federation.web.listeners.IDPHttpSessionListener();
                }
            }
        }
        return this.delegate;
    }
}

