/*
 * Decompiled with CFR 0.152.
 */
package org.gatein.sso.saml.plugin.valve;

import java.io.IOException;
import java.io.InputStream;
import java.security.GeneralSecurityException;
import java.security.Principal;
import javax.servlet.RequestDispatcher;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.catalina.Context;
import org.apache.catalina.LifecycleException;
import org.apache.catalina.Session;
import org.apache.catalina.connector.Request;
import org.apache.catalina.connector.Response;
import org.gatein.common.logging.Logger;
import org.gatein.common.logging.LoggerFactory;
import org.picketlink.identity.federation.bindings.tomcat.idp.IDPWebBrowserSSOValve;
import org.picketlink.identity.federation.core.config.IDPType;
import org.picketlink.identity.federation.core.exceptions.ParsingException;
import org.picketlink.identity.federation.core.interfaces.TrustKeyManager;
import org.picketlink.identity.federation.core.saml.v2.constants.JBossSAMLURIConstants;
import org.picketlink.identity.federation.core.util.StringUtil;
import org.picketlink.identity.federation.web.util.ConfigurationUtil;
import org.picketlink.identity.federation.web.util.IDPWebRequestUtil;
import org.picketlink.identity.federation.web.util.RedirectBindingUtil;
import org.w3c.dom.Document;

public class PortalIDPWebBrowserSSOValve
extends IDPWebBrowserSSOValve {
    private static final Logger log = LoggerFactory.getLogger(PortalIDPWebBrowserSSOValve.class);
    private static final boolean trace = log.isTraceEnabled();
    private static final String REQUEST_FROM_SP_METHOD = "requestFromSPMethod";
    private static final String PRINCIPAL_NOTE = "portal-principalNote";
    private Context context = null;
    private TrustKeyManager keyManager;
    private String configFile = "/WEB-INF/picketlink.xml";
    private Boolean skipForwardingToHostedURL = true;

    public void setSkipForwardingToHostedURL(Boolean skipForwardingToHostedURL) {
        this.skipForwardingToHostedURL = skipForwardingToHostedURL;
    }

    public void setConfigFile(String configFile) {
        this.configFile = configFile;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void invoke(Request request, Response response) throws IOException, ServletException {
        Principal userPrincipal;
        boolean valveInvocationPerformed = false;
        String referer = request.getHeader("Referer");
        String relayState = request.getParameter("RelayState");
        if (StringUtil.isNotNull((String)relayState)) {
            relayState = RedirectBindingUtil.urlDecode((String)relayState);
        }
        String samlRequestMessage = request.getParameter("SAMLRequest");
        String samlResponseMessage = request.getParameter("SAMLResponse");
        String signature = request.getParameter("Signature");
        String sigAlg = request.getParameter("SigAlg");
        boolean containsSAMLRequestMessage = StringUtil.isNotNull((String)samlRequestMessage);
        boolean containsSAMLResponseMessage = StringUtil.isNotNull((String)samlResponseMessage);
        Session session = request.getSessionInternal();
        if (containsSAMLRequestMessage || containsSAMLResponseMessage) {
            if (trace) {
                log.trace((Object)"Storing the SAMLRequest/SAMLResponse and RelayState in session");
            }
            if (StringUtil.isNotNull((String)samlRequestMessage)) {
                session.setNote("SAMLRequest", (Object)samlRequestMessage);
            }
            if (StringUtil.isNotNull((String)samlResponseMessage)) {
                session.setNote("SAMLResponse", (Object)samlResponseMessage);
            }
            if (StringUtil.isNotNull((String)relayState)) {
                session.setNote("RelayState", (Object)relayState.trim());
            }
            if (StringUtil.isNotNull((String)signature)) {
                session.setNote("Signature", (Object)signature.trim());
            }
            if (StringUtil.isNotNull((String)sigAlg)) {
                session.setNote("SigAlg", (Object)sigAlg.trim());
            }
            this.saveRequestInfoFromSP(request, session);
        }
        if ((userPrincipal = request.getPrincipal()) == null) {
            if (this.skipProcessingByNextValves(session)) {
                userPrincipal = (Principal)session.getNote(PRINCIPAL_NOTE);
                request.setUserPrincipal(userPrincipal);
                request.setAuthType("FORM");
                session.setAuthType("FORM");
                if (trace) {
                    log.trace((Object)"Skip processing of request by next valves. Going to SAML processing");
                }
            } else {
                try {
                    this.getNext().invoke(request, response);
                    valveInvocationPerformed = true;
                }
                finally {
                    userPrincipal = request.getPrincipal();
                    if (userPrincipal != null) {
                        session.setNote(PRINCIPAL_NOTE, (Object)userPrincipal);
                    } else {
                        session.removeNote(PRINCIPAL_NOTE);
                    }
                    referer = request.getHeader("Referer");
                    if (trace) {
                        log.trace((Object)("Referer in finally block=" + referer + ":user principal=" + userPrincipal));
                    }
                    if (response.isCommitted() || response.isAppCommitted()) {
                        if (trace) {
                            log.trace((Object)"Response is already commited. Returning");
                        }
                        return;
                    }
                }
            }
        }
        if (session.getNote("SAMLRequest") != null || session.getNote("SAMLResponse") != null || containsSAMLRequestMessage || containsSAMLResponseMessage) {
            request = this.restoreRequestInfoFromSP(request, session);
        }
        IDPWebRequestUtil webRequestUtil = new IDPWebRequestUtil((HttpServletRequest)request, this.idpConfiguration, this.keyManager);
        Document samlErrorResponse = null;
        if (response.getStatus() == 403) {
            try {
                samlErrorResponse = webRequestUtil.getErrorResponse(referer, JBossSAMLURIConstants.STATUS_AUTHNFAILED.get(), this.getIdentityURL(), this.idpConfiguration.isSupportsSignature());
                IDPWebRequestUtil.WebRequestUtilHolder holder = webRequestUtil.getHolder();
                holder.setResponseDoc(samlErrorResponse).setDestination(referer).setRelayState(relayState).setAreWeSendingRequest(false).setPrivateKey(null).setSupportSignature(false).setServletResponse((HttpServletResponse)response);
                holder.setPostBindingRequested(webRequestUtil.hasSAMLRequestInPostProfile());
                if (this.idpConfiguration.isSupportsSignature()) {
                    holder.setSupportSignature(true).setPrivateKey(this.keyManager.getSigningKey());
                }
                holder.setStrictPostBinding(this.idpConfiguration.isStrictPostBinding());
                webRequestUtil.send(holder);
            }
            catch (GeneralSecurityException e) {
                throw new ServletException((Throwable)e);
            }
            return;
        }
        if (userPrincipal != null) {
            samlRequestMessage = (String)session.getNote("SAMLRequest");
            samlResponseMessage = (String)session.getNote("SAMLResponse");
            relayState = (String)session.getNote("RelayState");
            signature = (String)session.getNote("Signature");
            sigAlg = (String)session.getNote("SigAlg");
            if (trace) {
                StringBuilder builder = new StringBuilder();
                builder.append("Retrieved saml messages and relay state from session");
                builder.append("saml Request message=").append(samlRequestMessage);
                builder.append("::").append("SAMLResponseMessage=");
                builder.append(samlResponseMessage).append(":").append("relay state=").append(relayState);
                builder.append("Signature=").append(signature).append("::sigAlg=").append(sigAlg);
                log.trace((Object)builder.toString());
            }
            if (samlRequestMessage != null) {
                this.processSAMLRequestMessage(webRequestUtil, request, response);
            } else if (StringUtil.isNotNull((String)samlResponseMessage)) {
                this.processSAMLResponseMessage(webRequestUtil, request, response);
            } else {
                String target = request.getParameter("TARGET");
                if (StringUtil.isNotNull((String)target)) {
                    this.handleSAML11(webRequestUtil, request, response);
                } else if (this.skipForwardingToHostedURL.booleanValue()) {
                    if (trace) {
                        log.trace((Object)"Skip forwarding to Hosted URL and continue with other valves");
                    }
                    if (!valveInvocationPerformed) {
                        this.getNext().invoke(request, response);
                    }
                } else {
                    if (trace) {
                        log.trace((Object)"SAML 1.1::Proceeding to IDP index page");
                    }
                    RequestDispatcher dispatch = this.context.getServletContext().getRequestDispatcher("/hosted/");
                    try {
                        dispatch.forward((ServletRequest)request, (ServletResponse)response);
                    }
                    catch (Exception e) {
                        dispatch.forward((ServletRequest)request.getRequest(), (ServletResponse)response);
                    }
                }
            }
        }
    }

    public void start() throws LifecycleException {
        super.start();
        this.context = (Context)this.getContainer();
        this.keyManager = this.getKeyManager();
        log.info((Object)("Valve started with identityURL=" + this.getIdentityURL() + ", strictPostBinding=" + this.idpConfiguration.isStrictPostBinding() + ", keyManager=" + this.keyManager + ", context=" + this.context));
    }

    protected void initIDPConfiguration() {
        InputStream is = this.getContext().getServletContext().getResourceAsStream(this.configFile);
        if (this.idpConfiguration == null) {
            if (is != null) {
                try {
                    this.picketLinkConfiguration = ConfigurationUtil.getConfiguration((InputStream)is);
                    this.idpConfiguration = (IDPType)this.picketLinkConfiguration.getIdpOrSP();
                }
                catch (ParsingException e) {
                    log.error((Object)("Failed to initialize Picketlink IDM from config file located in " + this.configFile), (Throwable)e);
                }
            } else {
                throw new RuntimeException("Failed to locate configuration file " + this.configFile);
            }
        }
        super.initIDPConfiguration();
    }

    protected void saveRequestInfoFromSP(Request request, Session session) {
        session.setNote(REQUEST_FROM_SP_METHOD, (Object)request.getMethod());
        if (trace) {
            log.trace((Object)("Saving request info from SP. RequestUrl=" + request.getRequestURI() + ", HTTPMethod=" + request.getMethod()));
        }
    }

    protected Request restoreRequestInfoFromSP(Request request, Session session) {
        Object requestMethod = session.getNote(REQUEST_FROM_SP_METHOD);
        if (requestMethod != null) {
            request.getCoyoteRequest().method().setString((String)requestMethod);
            if (trace) {
                log.trace((Object)("Restore original request info from SP. RequestUrl=" + request.getRequestURI() + ", HTTPMethod=" + request.getMethod()));
            }
        }
        return request;
    }

    protected boolean skipProcessingByNextValves(Session session) {
        Principal principal = (Principal)session.getNote(PRINCIPAL_NOTE);
        String samlRequest = (String)session.getNote("SAMLRequest");
        String samlResponse = (String)session.getNote("SAMLResponse");
        return principal != null && (samlRequest != null || samlResponse != null);
    }
}

