/*
 * Decompiled with CFR 0.152.
 */
package com.google.javascript.jscomp;

import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import com.google.javascript.jscomp.AbstractCompiler;
import com.google.javascript.jscomp.CheckLevel;
import com.google.javascript.jscomp.CodingConvention;
import com.google.javascript.jscomp.DiagnosticType;
import com.google.javascript.jscomp.HotSwapCompilerPass;
import com.google.javascript.jscomp.NodeTraversal;
import com.google.javascript.jscomp.NodeUtil;
import com.google.javascript.jscomp.Scope;
import com.google.javascript.jscomp.SyntacticScopeCreator;
import com.google.javascript.rhino.JSDocInfo;
import com.google.javascript.rhino.Node;
import java.util.HashSet;
import java.util.List;

class CheckRequiresForConstructors
implements HotSwapCompilerPass {
    private final AbstractCompiler compiler;
    private final CodingConvention codingConvention;
    private final CheckLevel level;
    static final DiagnosticType MISSING_REQUIRE_WARNING = DiagnosticType.disabled("JSC_MISSING_REQUIRE_WARNING", "''{0}'' used but not goog.require''d");

    CheckRequiresForConstructors(AbstractCompiler compiler, CheckLevel level) {
        this.compiler = compiler;
        this.codingConvention = compiler.getCodingConvention();
        this.level = level;
    }

    @Override
    public void process(Node externs, Node root) {
        CheckRequiresForConstructorsCallback callback = new CheckRequiresForConstructorsCallback();
        new NodeTraversal(this.compiler, callback).traverseRoots(externs, root);
    }

    @Override
    public void hotSwapScript(Node scriptRoot, Node originalRoot) {
        CheckRequiresForConstructorsCallback callback = new CheckRequiresForConstructorsCallback();
        new NodeTraversal(this.compiler, callback).traverseWithScope(scriptRoot, SyntacticScopeCreator.generateUntypedTopScope(this.compiler));
    }

    private static boolean isClassName(String name) {
        return name != null && name.length() > 1 && Character.isUpperCase(name.charAt(0)) && !name.equals(name.toUpperCase());
    }

    private static String getOutermostClassName(String className) {
        for (String part : className.split("\\.")) {
            if (!CheckRequiresForConstructors.isClassName(part)) continue;
            return className.substring(0, className.indexOf(part) + part.length());
        }
        return null;
    }

    private class CheckRequiresForConstructorsCallback
    implements NodeTraversal.Callback {
        private final List<String> constructors = Lists.newArrayList();
        private final List<String> requires = Lists.newArrayList();
        private final List<Node> newNodes = Lists.newArrayList();

        private CheckRequiresForConstructorsCallback() {
        }

        @Override
        public boolean shouldTraverse(NodeTraversal t, Node n, Node parent) {
            return parent == null || parent.getType() != 132 || !t.getInput().isExtern();
        }

        @Override
        public void visit(NodeTraversal t, Node n, Node parent) {
            switch (n.getType()) {
                case 86: {
                    JSDocInfo info = (JSDocInfo)n.getProp(29);
                    if (info == null || !info.isConstructor()) break;
                    String qualifiedName = n.getFirstChild().getQualifiedName();
                    this.constructors.add(qualifiedName);
                    break;
                }
                case 105: {
                    if (NodeUtil.isFunctionExpression(n)) {
                        if (!parent.isName()) break;
                        String functionName = parent.getString();
                        JSDocInfo info = (JSDocInfo)parent.getProp(29);
                        if (info != null && info.isConstructor()) {
                            this.constructors.add(functionName);
                            break;
                        }
                        Node gramps = parent.getParent();
                        Preconditions.checkState((gramps != null && gramps.isVar() ? 1 : 0) != 0);
                        info = (JSDocInfo)gramps.getProp(29);
                        if (info == null || !info.isConstructor()) break;
                        this.constructors.add(functionName);
                        break;
                    }
                    JSDocInfo info = (JSDocInfo)n.getProp(29);
                    if (info == null || !info.isConstructor()) break;
                    String functionName = n.getFirstChild().getString();
                    this.constructors.add(functionName);
                    break;
                }
                case 37: {
                    this.visitCallNode(n, parent);
                    break;
                }
                case 132: {
                    this.visitScriptNode(t);
                    break;
                }
                case 30: {
                    this.visitNewNode(t, n);
                }
            }
        }

        private void visitScriptNode(NodeTraversal t) {
            HashSet classNames = Sets.newHashSet();
            for (Node node : this.newNodes) {
                boolean notProvidedByRequires;
                String className = node.getFirstChild().getQualifiedName();
                String outermostClassName = CheckRequiresForConstructors.getOutermostClassName(className);
                boolean notProvidedByConstructors = this.constructors == null || !this.constructors.contains(className);
                boolean bl = notProvidedByRequires = this.requires == null || !this.requires.contains(className) && !this.requires.contains(outermostClassName);
                if (!notProvidedByConstructors || !notProvidedByRequires || classNames.contains(className)) continue;
                CheckRequiresForConstructors.this.compiler.report(t.makeError(node, CheckRequiresForConstructors.this.level, MISSING_REQUIRE_WARNING, className));
                classNames.add(className);
            }
            this.newNodes.clear();
            this.requires.clear();
            this.constructors.clear();
        }

        private void visitCallNode(Node n, Node parent) {
            String required = CheckRequiresForConstructors.this.codingConvention.extractClassNameIfRequire(n, parent);
            if (required != null) {
                this.requires.add(required);
            }
        }

        private void visitNewNode(NodeTraversal t, Node n) {
            Node qNameNode = n.getFirstChild();
            String qName = qNameNode.getQualifiedName();
            if (qName == null || qName.isEmpty()) {
                return;
            }
            Node nameNode = qNameNode;
            while (nameNode.hasChildren()) {
                nameNode = nameNode.getFirstChild();
            }
            if (nameNode.getType() != 38) {
                return;
            }
            String name = nameNode.getString();
            Scope.Var var = t.getScope().getVar(name);
            if (var == null || var.isLocal() || var.isExtern()) {
                return;
            }
            this.newNodes.add(n);
        }
    }
}

