/*
 * Decompiled with CFR 0.152.
 */
package com.google.javascript.jscomp;

import com.google.common.collect.Sets;
import com.google.javascript.jscomp.AbstractCompiler;
import com.google.javascript.jscomp.CheckLevel;
import com.google.javascript.jscomp.CompilerPass;
import com.google.javascript.jscomp.DiagnosticType;
import com.google.javascript.jscomp.NodeTraversal;
import com.google.javascript.jscomp.Scope;
import com.google.javascript.rhino.Node;
import java.util.Iterator;
import java.util.Set;

class VariableShadowDeclarationCheck
implements CompilerPass {
    static final DiagnosticType SHADOW_VAR_ERROR = DiagnosticType.error("JSC_REDECL_NOSHADOW_VARIABLE", "Highly error prone shadowing of variable name {0}.Consider using a different local variable name.");
    private final AbstractCompiler compiler;
    private final CheckLevel checkLevel;
    private final Set<String> externalNoShadowVariableNames;

    VariableShadowDeclarationCheck(AbstractCompiler compiler, CheckLevel checkLevel) {
        this.compiler = compiler;
        this.checkLevel = checkLevel;
        this.externalNoShadowVariableNames = Sets.newHashSet();
    }

    @Override
    public void process(Node externs, Node root) {
        NodeTraversal.traverse(this.compiler, externs, new NoShadowAnnotationGatheringCallback());
        NodeTraversal.traverse(this.compiler, root, new ShadowDeclarationCheckingCallback());
    }

    private class ShadowDeclarationCheckingCallback
    implements NodeTraversal.ScopedCallback {
        private ShadowDeclarationCheckingCallback() {
        }

        @Override
        public void enterScope(NodeTraversal t) {
            if (t.inGlobalScope()) {
                return;
            }
            Scope scope = t.getScope();
            Scope parentScope = scope.getParent();
            Iterator<Scope.Var> vars = scope.getVars();
            while (vars.hasNext()) {
                Scope.Var var = vars.next();
                if (VariableShadowDeclarationCheck.this.externalNoShadowVariableNames.contains(var.getName())) {
                    VariableShadowDeclarationCheck.this.compiler.report(t.makeError(var.nameNode, VariableShadowDeclarationCheck.this.checkLevel, SHADOW_VAR_ERROR, var.getName()));
                    continue;
                }
                Scope.Var shadowedVar = parentScope.getVar(var.getName());
                if (shadowedVar == null || !shadowedVar.isNoShadow() && !shadowedVar.isLocal()) continue;
                VariableShadowDeclarationCheck.this.compiler.report(t.makeError(var.nameNode, VariableShadowDeclarationCheck.this.checkLevel, SHADOW_VAR_ERROR, var.getName()));
            }
        }

        @Override
        public void exitScope(NodeTraversal t) {
        }

        @Override
        public boolean shouldTraverse(NodeTraversal nodeTraversal, Node n, Node parent) {
            return true;
        }

        @Override
        public void visit(NodeTraversal t, Node n, Node parent) {
        }
    }

    private class NoShadowAnnotationGatheringCallback
    implements NodeTraversal.ScopedCallback {
        private NoShadowAnnotationGatheringCallback() {
        }

        @Override
        public void enterScope(NodeTraversal t) {
            Scope scope = t.getScope();
            Iterator<Scope.Var> vars = scope.getVars();
            while (vars.hasNext()) {
                Scope.Var var = vars.next();
                if (!var.isNoShadow()) continue;
                VariableShadowDeclarationCheck.this.externalNoShadowVariableNames.add(var.getName());
            }
        }

        @Override
        public void exitScope(NodeTraversal t) {
        }

        @Override
        public boolean shouldTraverse(NodeTraversal nodeTraversal, Node n, Node parent) {
            return true;
        }

        @Override
        public void visit(NodeTraversal t, Node n, Node parent) {
        }
    }
}

