/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.portal.resource;

import java.io.IOException;
import java.util.HashMap;
import org.exoplatform.commons.utils.PropertyManager;
import org.exoplatform.portal.resource.SkinConfig;
import org.exoplatform.portal.resource.SkinService;
import org.exoplatform.portal.resource.SkinURL;
import org.exoplatform.services.resources.Orientation;
import org.exoplatform.web.ControllerContext;
import org.exoplatform.web.WebAppController;
import org.exoplatform.web.controller.QualifiedName;
import org.exoplatform.web.controller.router.URIWriter;
import org.exoplatform.web.url.MimeType;
import org.gatein.common.logging.LoggerFactory;
import org.gatein.portal.controller.resource.ResourceRequestHandler;

class SimpleSkin
implements SkinConfig {
    private final SkinService service_;
    private final String module_;
    private final String name_;
    private final String cssPath_;
    private final String id_;
    private final int priority;

    public SimpleSkin(SkinService service, String module, String name, String cssPath) {
        this(service, module, name, cssPath, Integer.MAX_VALUE);
    }

    public SimpleSkin(SkinService service, String module, String name, String cssPath, int cssPriority) {
        this.service_ = service;
        this.module_ = module;
        this.name_ = name;
        this.cssPath_ = cssPath;
        this.id_ = module.replace('/', '_');
        this.priority = cssPriority;
    }

    @Override
    public int getCSSPriority() {
        return this.priority;
    }

    @Override
    public String getId() {
        return this.id_;
    }

    @Override
    public String getModule() {
        return this.module_;
    }

    @Override
    public String getCSSPath() {
        return this.cssPath_;
    }

    @Override
    public String getName() {
        return this.name_;
    }

    public String toString() {
        return "SimpleSkin[id=" + this.id_ + ",module=" + this.module_ + ",name=" + this.name_ + ",cssPath=" + this.cssPath_ + ", priority=" + this.priority + "]";
    }

    @Override
    public SkinURL createURL(final ControllerContext context) {
        if (context == null) {
            throw new NullPointerException("No controller context provided");
        }
        return new SkinURL(){
            Orientation orientation = null;
            boolean compress = !PropertyManager.isDevelopping();

            @Override
            public void setOrientation(Orientation orientation) {
                this.orientation = orientation;
            }

            @Override
            public String toString() {
                try {
                    String resource = SimpleSkin.this.cssPath_.substring(1, SimpleSkin.this.cssPath_.length() - ".css".length());
                    HashMap<QualifiedName, String> params = new HashMap<QualifiedName, String>();
                    params.put(ResourceRequestHandler.VERSION_QN, ResourceRequestHandler.VERSION);
                    params.put(ResourceRequestHandler.ORIENTATION_QN, this.orientation == Orientation.RT ? "rt" : "lt");
                    params.put(ResourceRequestHandler.COMPRESS_QN, this.compress ? "min" : "");
                    params.put(WebAppController.HANDLER_PARAM, "skin");
                    params.put(ResourceRequestHandler.RESOURCE_QN, resource);
                    StringBuilder url = new StringBuilder();
                    context.renderURL(params, new URIWriter((Appendable)url, MimeType.PLAIN));
                    return url.toString();
                }
                catch (IOException e) {
                    LoggerFactory.getLogger(this.getClass()).error((Object)e.getMessage(), (Throwable)e);
                    return null;
                }
            }
        };
    }
}

