/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shindig.expressions.juel;

import de.odysseus.el.ExpressionFactoryImpl;
import de.odysseus.el.misc.TypeConverter;
import de.odysseus.el.tree.Tree;
import de.odysseus.el.tree.TreeBuilder;
import de.odysseus.el.tree.TreeCache;
import de.odysseus.el.tree.TreeStore;
import de.odysseus.el.tree.impl.Builder;
import javax.el.ExpressionFactory;
import org.apache.shindig.common.cache.Cache;
import org.apache.shindig.common.cache.CacheProvider;
import org.apache.shindig.common.cache.NullCache;
import org.apache.shindig.expressions.ELTypeConverter;
import org.apache.shindig.expressions.ExpressionProvider;

public class JuelProvider
implements ExpressionProvider {
    private static final String EXPRESSION_CACHE = "expressions";

    public ExpressionFactory newExpressionFactory(CacheProvider cacheProvider, ELTypeConverter converter) {
        TreeStore store = new TreeStore((TreeBuilder)new Builder(), this.createTreeCache(cacheProvider));
        return new ExpressionFactoryImpl(store, (TypeConverter)converter);
    }

    private TreeCache createTreeCache(CacheProvider cacheProvider) {
        Cache treeCache = cacheProvider == null ? new NullCache() : cacheProvider.createCache(EXPRESSION_CACHE);
        final Cache resolvedTreeCache = treeCache;
        return new TreeCache(){

            public Tree get(String expression) {
                return (Tree)resolvedTreeCache.getElement(expression);
            }

            public void put(String expression, Tree tree) {
                resolvedTreeCache.addElement(expression, tree);
            }
        };
    }
}

