/*
 * Decompiled with CFR 0.152.
 */
package org.gatein.common.text;

import java.io.IOException;
import java.io.Writer;
import org.gatein.common.io.UndeclaredIOException;
import org.gatein.common.text.AbstractCharEncoder;
import org.gatein.common.text.CharToByteEncoder;
import org.gatein.common.text.CharWriter;
import org.gatein.common.text.MalformedInputException;
import org.gatein.common.text.TextTools;
import org.gatein.common.util.ParameterValidation;

public class FastURLEncoder
extends AbstractCharEncoder {
    private static final FastURLEncoder DEFAULT_ENCODER = new FastURLEncoder(CharToByteEncoder.Generic.UTF8);
    private final char[][] table;
    private static final char MAX = '\ufffd';

    public static FastURLEncoder getUTF8Instance() {
        return DEFAULT_ENCODER;
    }

    public FastURLEncoder(CharToByteEncoder encoder) throws IllegalArgumentException {
        if (encoder == null) {
            throw new IllegalArgumentException("No encoding provided");
        }
        this.table = new char[65534][];
        for (char c = '\u0000'; c <= '\ufffd'; c = (char)(c + '\u0001')) {
            char[] z;
            if (TextTools.isAlphaNumeric(c)) {
                z = new char[]{c};
            } else {
                switch (c) {
                    case ' ': {
                        z = new char[]{'+'};
                        break;
                    }
                    case '*': 
                    case '-': 
                    case '.': 
                    case '_': {
                        z = new char[]{c};
                        break;
                    }
                    default: {
                        byte[] v = encoder.encode(c);
                        if (v.length > 0) {
                            z = new char[v.length * 3];
                            int index = 0;
                            for (int i = 0; i < v.length; ++i) {
                                byte b = v[i];
                                z[index++] = 37;
                                z[index++] = TextTools.toHex((b & 0xF0) >> 4);
                                z[index++] = TextTools.toHex(b & 0xF);
                            }
                            break;
                        }
                        z = null;
                    }
                }
            }
            this.table[c] = z;
        }
    }

    @Override
    public void encode(char c, CharWriter writer) {
        ParameterValidation.throwIllegalArgExceptionIfNull(writer, "CharWriter");
        char[] z = this.getEncoding(c);
        writer.append(z);
    }

    private char[] getEncoding(char c) {
        char[] z = this.table[c];
        if (z == null) {
            throw new MalformedInputException("Couldn't find appropriate encoding for '" + c + "'");
        }
        return z;
    }

    @Override
    protected void safeEncode(char[] chars, int off, int len, CharWriter writer) {
        for (int i = off; i < len; ++i) {
            char c = chars[i];
            char[] z = this.getEncoding(c);
            writer.append(z);
        }
    }

    public void encode(String s, Writer out) throws IllegalArgumentException, UndeclaredIOException {
        ParameterValidation.throwIllegalArgExceptionIfNull(s, "String");
        ParameterValidation.throwIllegalArgExceptionIfNull(out, "Writer");
        try {
            for (int i = 0; i < s.length(); ++i) {
                char c = s.charAt(i);
                char[] z = this.getEncoding(c);
                out.write(z);
            }
        }
        catch (IOException e) {
            throw new UndeclaredIOException(e);
        }
    }

    public String toString() {
        return "FastURLEncoder[,[0,\ufffd]]";
    }
}

