/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.jcr.impl.core.query.lucene;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.security.PrivilegedExceptionAction;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.lucene.store.Directory;
import org.exoplatform.commons.utils.SecurityHelper;
import org.exoplatform.services.jcr.impl.core.query.lucene.MultiIndex;
import org.exoplatform.services.jcr.impl.core.query.lucene.directory.IndexInputStream;
import org.exoplatform.services.jcr.impl.core.query.lucene.directory.IndexOutputStream;
import org.exoplatform.services.jcr.impl.util.io.DirectoryHelper;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class IndexInfos {
    private static final Log LOG = ExoLogger.getLogger((String)"exo.jcr.component.core.IndexInfos");
    public static final String DEFALUT_NAME = "indexes";
    private int counter = 0;
    private boolean dirty = false;
    private List<String> indexes = new ArrayList<String>();
    private Set<String> names = new HashSet<String>();
    private final String name;
    private Directory dir;
    protected MultiIndex multiIndex;

    public IndexInfos() {
        this(DEFALUT_NAME);
    }

    public IndexInfos(String fileName) {
        this.name = fileName;
    }

    public String getFileName() {
        return this.name;
    }

    public void read() throws IOException {
        SecurityHelper.doPrivilegedIOExceptionAction((PrivilegedExceptionAction)new PrivilegedExceptionAction<Object>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public Object run() throws Exception {
                IndexInfos.this.dir.listAll();
                IndexInfos.this.names.clear();
                IndexInfos.this.indexes.clear();
                if (IndexInfos.this.dir.fileExists(IndexInfos.this.name)) {
                    IndexInputStream in;
                    block5: {
                        in = new IndexInputStream(IndexInfos.this.dir.openInput(IndexInfos.this.name));
                        DataInputStream di = null;
                        try {
                            di = new DataInputStream(in);
                            IndexInfos.this.counter = di.readInt();
                            for (int i = di.readInt(); i > 0; --i) {
                                String indexName = di.readUTF();
                                IndexInfos.this.indexes.add(indexName);
                                IndexInfos.this.names.add(indexName);
                            }
                            Object var6_5 = null;
                            if (di == null) break block5;
                        }
                        catch (Throwable throwable) {
                            Object var6_6 = null;
                            if (di != null) {
                                di.close();
                            }
                            ((InputStream)in).close();
                            throw throwable;
                        }
                        di.close();
                    }
                    ((InputStream)in).close();
                    {
                    }
                }
                return null;
            }
        });
    }

    public void write() throws IOException {
        SecurityHelper.doPrivilegedIOExceptionAction((PrivilegedExceptionAction)new PrivilegedExceptionAction<Object>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            @Override
            public Object run() throws Exception {
                IndexOutputStream out;
                block6: {
                    if (!IndexInfos.this.dirty) {
                        return null;
                    }
                    out = new IndexOutputStream(IndexInfos.this.dir.createOutput(IndexInfos.this.name + ".new"));
                    DataOutputStream dataOut = null;
                    try {
                        dataOut = new DataOutputStream(out);
                        dataOut.writeInt(IndexInfos.this.counter);
                        dataOut.writeInt(IndexInfos.this.indexes.size());
                        for (int i = 0; i < IndexInfos.this.indexes.size(); ++i) {
                            dataOut.writeUTF(IndexInfos.this.getName(i));
                        }
                        Object var5_4 = null;
                        if (dataOut == null) break block6;
                    }
                    catch (Throwable throwable) {
                        Object var5_5 = null;
                        if (dataOut != null) {
                            dataOut.close();
                        }
                        ((OutputStream)out).close();
                        throw throwable;
                    }
                    dataOut.close();
                }
                ((OutputStream)out).close();
                if (IndexInfos.this.dir.fileExists(IndexInfos.this.name)) {
                    IndexInfos.this.dir.deleteFile(IndexInfos.this.name);
                }
                IndexInfos.this.rename(IndexInfos.this.name + ".new", IndexInfos.this.name);
                IndexInfos.this.dirty = false;
                return null;
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void rename(String from, String to) throws IOException {
        block9: {
            IndexOutputStream out;
            block8: {
                out = null;
                IndexInputStream in = null;
                try {
                    out = new IndexOutputStream(this.dir.createOutput(to));
                    in = new IndexInputStream(this.dir.openInput(from));
                    DirectoryHelper.transfer(in, out);
                    Object var6_5 = null;
                    if (in == null) break block8;
                }
                catch (Throwable throwable) {
                    Object var6_6 = null;
                    if (in != null) {
                        in.close();
                    }
                    if (out != null) {
                        out.flush();
                        out.close();
                    }
                    throw throwable;
                }
                in.close();
            }
            if (out != null) {
                out.flush();
                out.close();
            }
            try {
                if (this.dir.fileExists(from)) {
                    this.dir.deleteFile(from);
                }
            }
            catch (IOException e) {
                if (!LOG.isTraceEnabled()) break block9;
                LOG.trace((Object)("Can't deleted file: " + e.getMessage()));
            }
        }
    }

    public String getName(int i) {
        return this.indexes.get(i);
    }

    public Set<String> getNames() {
        return new HashSet<String>(this.indexes);
    }

    public int size() {
        return this.indexes.size();
    }

    public void addName(String name) {
        if (this.names.contains(name)) {
            throw new IllegalArgumentException("already contains: " + name);
        }
        this.indexes.add(name);
        this.names.add(name);
        this.dirty = true;
    }

    public void removeName(String name) {
        this.indexes.remove(name);
        this.names.remove(name);
        this.dirty = true;
    }

    public void removeName(int i) {
        String name = this.indexes.remove(i);
        this.names.remove(name);
        this.dirty = true;
    }

    public boolean contains(String name) {
        return this.names.contains(name);
    }

    public String newName() {
        this.dirty = true;
        return "_" + Integer.toString(this.counter++, 36);
    }

    public void setDirectory(Directory dir) {
        this.dir = dir;
    }

    protected void setNames(Set<String> names) {
        this.names.clear();
        this.indexes.clear();
        this.names.addAll(names);
        this.indexes.addAll(names);
        this.dirty = false;
    }

    public void setMultiIndex(MultiIndex multiIndex) {
        this.multiIndex = multiIndex;
    }

    public MultiIndex getMultiIndex() {
        return this.multiIndex;
    }

    protected boolean isDirty() {
        return this.dirty;
    }
}

