/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.forum.common.webui;

import java.util.MissingResourceException;
import java.util.ResourceBundle;
import org.apache.commons.lang.StringEscapeUtils;
import org.apache.commons.lang.StringUtils;
import org.exoplatform.forum.common.CommonUtils;
import org.exoplatform.portal.application.PortalRequestContext;
import org.exoplatform.portal.webui.util.Util;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.web.application.RequireJS;
import org.exoplatform.webui.application.WebuiRequestContext;
import org.exoplatform.webui.application.portlet.PortletRequestContext;
import org.exoplatform.webui.form.wysiwyg.FCKEditorConfig;

public class WebUIUtils {
    private static Log LOG = ExoLogger.getLogger(WebUIUtils.class);

    public static String getRemoteIP() {
        String remoteAddr = "";
        try {
            PortalRequestContext context = Util.getPortalRequestContext();
            remoteAddr = context.getRequest().getRemoteAddr();
        }
        catch (Exception e) {
            LOG.error((Object)"Can not get remote IP", (Throwable)e);
        }
        return remoteAddr;
    }

    public static FCKEditorConfig getFCKConfig() {
        FCKEditorConfig fckconfig = new FCKEditorConfig();
        fckconfig.put((Object)"CustomConfigurationsPath", (Object)"/forumResources/fckconfig/fckconfig.js");
        return fckconfig;
    }

    public String getLabel(String key) throws Exception {
        return WebUIUtils.getLabel(null, key);
    }

    public static String getLabel(String componentId, String label) {
        if (!StringUtils.isEmpty((String)componentId)) {
            label = componentId.concat(".label.").concat(label);
        }
        try {
            WebuiRequestContext context = (WebuiRequestContext)WebuiRequestContext.getCurrentInstance();
            ResourceBundle res = context.getApplicationResourceBundle();
            return res.getString(label);
        }
        catch (MissingResourceException e) {
            return label;
        }
    }

    public static String getLabelEscapedJavaScript(String componentId, String label) {
        return StringEscapeUtils.escapeJavaScript((String)WebUIUtils.getLabel(componentId, label));
    }

    public static RequireJS addScripts(String module, String alias) {
        return WebUIUtils.addScripts(module, alias, "");
    }

    public static RequireJS addScripts(String[] scripts) {
        return WebUIUtils.addScripts(null, null, scripts);
    }

    public static RequireJS addScripts(String module, String alias, String ... scripts) {
        PortletRequestContext pContext = (PortletRequestContext)WebuiRequestContext.getCurrentInstance();
        RequireJS requireJS = !CommonUtils.isEmpty(module) ? (!CommonUtils.isEmpty(alias) ? pContext.getJavascriptManager().require("SHARED/" + module, alias) : pContext.getJavascriptManager().require("SHARED/" + module)) : pContext.getJavascriptManager().getRequireJS();
        if (scripts != null) {
            for (int i = 0; i < scripts.length; ++i) {
                String script = scripts[i];
                if (CommonUtils.isEmpty(script)) continue;
                requireJS.addScripts(script + ";");
            }
        }
        return requireJS;
    }
}

