/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.rest.impl.provider;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.io.Writer;
import java.lang.annotation.Annotation;
import java.lang.reflect.Type;
import java.util.Collection;
import java.util.Map;
import javax.activation.DataSource;
import javax.ws.rs.Consumes;
import javax.ws.rs.Produces;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.core.StreamingOutput;
import javax.ws.rs.ext.Provider;
import javax.xml.bind.JAXBElement;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.sax.SAXSource;
import javax.xml.transform.stream.StreamSource;
import org.exoplatform.services.rest.provider.EntityProvider;
import org.exoplatform.ws.frameworks.json.JsonHandler;
import org.exoplatform.ws.frameworks.json.JsonWriter;
import org.exoplatform.ws.frameworks.json.impl.JsonDefaultHandler;
import org.exoplatform.ws.frameworks.json.impl.JsonException;
import org.exoplatform.ws.frameworks.json.impl.JsonGeneratorImpl;
import org.exoplatform.ws.frameworks.json.impl.JsonParserImpl;
import org.exoplatform.ws.frameworks.json.impl.JsonUtils;
import org.exoplatform.ws.frameworks.json.impl.JsonWriterImpl;
import org.exoplatform.ws.frameworks.json.impl.ObjectBuilder;
import org.exoplatform.ws.frameworks.json.value.JsonValue;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Provider
@Consumes(value={"application/json"})
@Produces(value={"application/json"})
public class JsonEntityProvider
implements EntityProvider<Object> {
    private static final Class<?>[] IGNORED = new Class[]{byte[].class, char[].class, DataSource.class, DOMSource.class, File.class, InputStream.class, OutputStream.class, JAXBElement.class, MultivaluedMap.class, Reader.class, Writer.class, SAXSource.class, StreamingOutput.class, StreamSource.class, String.class};

    private static boolean isIgnored(Class<?> type) {
        for (Class<?> c : IGNORED) {
            if (!c.isAssignableFrom(type)) continue;
            return true;
        }
        return false;
    }

    public boolean isReadable(Class<?> type, Type genericType, Annotation[] annotations, MediaType mediaType) {
        return !JsonEntityProvider.isIgnored(type);
    }

    public Object readFrom(Class<Object> type, Type genericType, Annotation[] annotations, MediaType mediaType, MultivaluedMap<String, String> httpHeaders, InputStream entityStream) throws IOException {
        try {
            JsonParserImpl parser = new JsonParserImpl();
            JsonDefaultHandler handler = new JsonDefaultHandler();
            parser.parse(entityStream, (JsonHandler)handler);
            JsonValue jsonValue = handler.getJsonObject();
            if (JsonValue.class.isAssignableFrom(type)) {
                return jsonValue;
            }
            JsonUtils.Types jtype = JsonUtils.getType(type);
            if (jtype == JsonUtils.Types.ARRAY_BOOLEAN || jtype == JsonUtils.Types.ARRAY_BYTE || jtype == JsonUtils.Types.ARRAY_SHORT || jtype == JsonUtils.Types.ARRAY_INT || jtype == JsonUtils.Types.ARRAY_LONG || jtype == JsonUtils.Types.ARRAY_FLOAT || jtype == JsonUtils.Types.ARRAY_DOUBLE || jtype == JsonUtils.Types.ARRAY_CHAR || jtype == JsonUtils.Types.ARRAY_STRING || jtype == JsonUtils.Types.ARRAY_OBJECT) {
                return ObjectBuilder.createArray(type, (JsonValue)jsonValue);
            }
            if (jtype == JsonUtils.Types.COLLECTION) {
                Class<Object> c = type;
                return ObjectBuilder.createCollection(c, (Type)genericType, (JsonValue)jsonValue);
            }
            if (jtype == JsonUtils.Types.MAP) {
                Class<Object> c = type;
                return ObjectBuilder.createObject(c, (Type)genericType, (JsonValue)jsonValue);
            }
            return ObjectBuilder.createObject(type, (JsonValue)jsonValue);
        }
        catch (JsonException e) {
            throw new IOException("Can't read from input stream " + (Object)((Object)e), e);
        }
    }

    public long getSize(Object t, Class<?> type, Type genericType, Annotation[] annotations, MediaType mediaType) {
        return -1L;
    }

    public boolean isWriteable(Class<?> type, Type genericType, Annotation[] annotations, MediaType mediaType) {
        return !JsonEntityProvider.isIgnored(type);
    }

    public void writeTo(Object t, Class<?> type, Type genericType, Annotation[] annotations, MediaType mediaType, MultivaluedMap<String, Object> httpHeaders, OutputStream entityStream) throws IOException {
        try {
            JsonValue jsonValue = null;
            if (t instanceof JsonValue) {
                jsonValue = (JsonValue)t;
            } else {
                JsonGeneratorImpl generator = new JsonGeneratorImpl();
                JsonUtils.Types jtype = JsonUtils.getType(type);
                jsonValue = jtype == JsonUtils.Types.ARRAY_BOOLEAN || jtype == JsonUtils.Types.ARRAY_BYTE || jtype == JsonUtils.Types.ARRAY_SHORT || jtype == JsonUtils.Types.ARRAY_INT || jtype == JsonUtils.Types.ARRAY_LONG || jtype == JsonUtils.Types.ARRAY_FLOAT || jtype == JsonUtils.Types.ARRAY_DOUBLE || jtype == JsonUtils.Types.ARRAY_CHAR || jtype == JsonUtils.Types.ARRAY_STRING || jtype == JsonUtils.Types.ARRAY_OBJECT ? generator.createJsonArray(t) : (jtype == JsonUtils.Types.COLLECTION ? generator.createJsonArray((Collection)t) : (jtype == JsonUtils.Types.MAP ? generator.createJsonObjectFromMap((Map)t) : generator.createJsonObject(t)));
            }
            JsonWriterImpl jsonWriter = new JsonWriterImpl(entityStream);
            jsonValue.writeTo((JsonWriter)jsonWriter);
            jsonWriter.flush();
        }
        catch (JsonException e) {
            throw new IOException("Can't write to output stream " + (Object)((Object)e), e);
        }
    }
}

