/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.dashboard.webui.component;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import org.exoplatform.application.registry.Application;
import org.exoplatform.application.registry.ApplicationCategory;
import org.exoplatform.application.registry.ApplicationRegistryService;
import org.exoplatform.dashboard.webui.component.UIAddGadgetForm;
import org.exoplatform.portal.config.UserACL;
import org.exoplatform.portal.config.model.ApplicationType;
import org.exoplatform.portal.webui.util.Util;
import org.exoplatform.webui.application.WebuiRequestContext;
import org.exoplatform.webui.config.annotation.ComponentConfig;
import org.exoplatform.webui.core.UIContainer;
import org.exoplatform.webui.core.lifecycle.UIFormLifecycle;

@ComponentConfig(template="classpath:groovy/dashboard/webui/component/UIDashboardSelectContainer.gtmpl", lifecycle=UIFormLifecycle.class)
public class UIDashboardSelectContainer
extends UIContainer {
    private List<ApplicationCategory> categories;
    private ApplicationCategory selectedCategory;

    public UIDashboardSelectContainer() throws Exception {
        this.addChild(UIAddGadgetForm.class, null, null);
    }

    public void setSelectedCategory(ApplicationCategory category) {
        this.selectedCategory = category;
    }

    public ApplicationCategory getSelectedCategory() {
        return this.selectedCategory;
    }

    public final List<ApplicationCategory> getCategories() throws Exception {
        ApplicationRegistryService service = (ApplicationRegistryService)this.getApplicationComponent(ApplicationRegistryService.class);
        UserACL acl = (UserACL)Util.getUIPortalApplication().getApplicationComponent(UserACL.class);
        String remoteUser = ((WebuiRequestContext)WebuiRequestContext.getCurrentInstance()).getRemoteUser();
        ArrayList<ApplicationCategory> listCategories = new ArrayList<ApplicationCategory>();
        block0: for (ApplicationCategory cate : service.getApplicationCategories(remoteUser, new ApplicationType[]{ApplicationType.GADGET})) {
            for (String p : cate.getAccessPermissions()) {
                List listGadgets;
                if (!acl.hasPermission(p) || (listGadgets = cate.getApplications()) == null || listGadgets.size() <= 0) continue;
                listCategories.add(cate);
                continue block0;
            }
        }
        Collections.sort(listCategories, new Comparator<ApplicationCategory>(){

            @Override
            public int compare(ApplicationCategory cate1, ApplicationCategory cate2) {
                return cate1.getDisplayName(true).compareToIgnoreCase(cate2.getDisplayName(true));
            }
        });
        this.categories = listCategories;
        return this.categories;
    }

    public void setCategories(List<ApplicationCategory> categories) {
        this.categories = categories;
    }

    public List<Application> getGadgetsOfCategory(ApplicationCategory appCategory) {
        UserACL acl = (UserACL)Util.getUIPortalApplication().getApplicationComponent(UserACL.class);
        ArrayList<Application> listGadgets = new ArrayList<Application>();
        block0: for (Application app : appCategory.getApplications()) {
            for (String p : app.getAccessPermissions()) {
                if (!acl.hasPermission(p)) continue;
                listGadgets.add(app);
                continue block0;
            }
        }
        Collections.sort(listGadgets, new Comparator<Application>(){

            @Override
            public int compare(Application app1, Application app2) {
                return app1.getDisplayName().compareToIgnoreCase(app2.getDisplayName());
            }
        });
        return listGadgets;
    }
}

