/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.social.core.search;

import java.net.URLDecoder;
import java.util.ArrayList;
import java.util.Collection;
import javax.jcr.query.Row;
import javax.jcr.query.RowIterator;
import org.exoplatform.commons.api.search.data.SearchContext;
import org.exoplatform.commons.api.search.data.SearchResult;
import org.exoplatform.container.ExoContainerContext;
import org.exoplatform.container.xml.InitParams;
import org.exoplatform.portal.mop.SiteType;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.services.security.ConversationState;
import org.exoplatform.social.core.chromattic.entity.SpaceEntity;
import org.exoplatform.social.core.search.AbstractSocialSearchConnector;
import org.exoplatform.social.core.search.Sorting;
import org.exoplatform.social.core.space.SpaceFilter;
import org.exoplatform.social.core.space.SpaceListAccess;
import org.exoplatform.social.core.space.model.Space;
import org.exoplatform.social.core.space.spi.SpaceService;
import org.exoplatform.social.core.storage.query.JCRProperties;
import org.exoplatform.social.core.storage.query.WhereExpression;

public class SpaceSearchConnector
extends AbstractSocialSearchConnector {
    private SpaceService spaceService;
    private static final Log LOG = ExoLogger.getLogger(SpaceSearchConnector.class);

    public SpaceSearchConnector(InitParams initParams, SpaceService spaceService) {
        super(initParams);
        this.spaceService = spaceService;
    }

    @Override
    public Collection<SearchResult> search(SearchContext context, String query, AbstractSocialSearchConnector.Range range, Sorting sorting) {
        ArrayList<SearchResult> results = new ArrayList<SearchResult>();
        SpaceFilter filter = new SpaceFilter();
        filter.setSpaceNameSearchCondition(query);
        filter.setSorting(sorting);
        if (filter.getSpaceNameSearchCondition().isEmpty()) {
            return results;
        }
        ExoContainerContext eXoContext = (ExoContainerContext)ExoContainerContext.getCurrentContainer().getComponentInstanceOfType(ExoContainerContext.class);
        String portalName = eXoContext.getPortalContainerName();
        SpaceListAccess la = this.spaceService.getUnifiedSearchSpacesWithListAccess(this.getCurrentUserName(), filter);
        try {
            Space[] spaces = (Space[])la.load(range.offset, range.limit);
            RowIterator rowIt = this.rows(this.buildQuery(filter), range.offset, range.limit);
            Row row = null;
            for (Space s : spaces) {
                if ("hidden".equals(s.getVisibility()) && !this.spaceService.isMember(s, this.getCurrentUserName())) continue;
                StringBuilder sb = new StringBuilder(s.getDisplayName());
                sb.append(String.format(" - %s Member(s)", s.getMembers().length));
                if ("open".equals(s.getRegistration())) {
                    sb.append(" - Free to Join");
                } else if ("validation".equals(s.getRegistration())) {
                    sb.append(" - Register");
                } else if ("close".equals(s.getRegistration())) {
                    sb.append(" - Invitation Only");
                } else {
                    LOG.debug((Object)(s.getRegistration() + " registration unknown"));
                }
                row = rowIt != null && rowIt.hasNext() ? rowIt.nextRow() : null;
                SearchResult result = new SearchResult(this.getSpaceUrl(context, s, portalName), s.getDisplayName(), s.getDescription(), sb.toString(), s.getAvatarUrl() != null ? s.getAvatarUrl() : "/social-resources/skin/images/ShareImages/SpaceAvtDefault.png", s.getCreatedTime(), this.getRelevancy(row));
                results.add(result);
            }
        }
        catch (Exception e) {
            LOG.error((Object)e);
        }
        return results;
    }

    protected String getSpaceUrl(SearchContext context, Space space, String portalName) {
        try {
            String permanentSpaceName = space.getPrettyName();
            String groupId = space.getGroupId();
            String siteName = groupId.replaceAll("/", ":");
            String siteType = SiteType.GROUP.getName();
            String spaceURI = context.handler(portalName).lang("").siteName(siteName).siteType(siteType).path(permanentSpaceName).renderLink();
            return URLDecoder.decode(String.format("/%s%s", portalName, spaceURI), "UTF-8");
        }
        catch (Exception e) {
            LOG.error((Object)("Cannot compute space url for " + space.getDisplayName()), (Throwable)e);
            return "";
        }
    }

    private String getCurrentUserName() {
        return ConversationState.getCurrent().getIdentity().getUserId();
    }

    private String buildQuery(SpaceFilter spaceFilter) {
        WhereExpression whereExpression = new WhereExpression();
        String spaceNameSearchCondition = spaceFilter.getSpaceNameSearchCondition();
        if (spaceNameSearchCondition != null && spaceNameSearchCondition.length() != 0 && this.isValidInput(spaceNameSearchCondition)) {
            if ((spaceNameSearchCondition = this.processSearchCondition(spaceNameSearchCondition)).contains("%")) {
                whereExpression.startGroup();
                whereExpression.like(SpaceEntity.name, spaceNameSearchCondition).or().like(SpaceEntity.description, spaceNameSearchCondition);
                whereExpression.endGroup();
            } else {
                whereExpression.startGroup();
                whereExpression.contains(SpaceEntity.name, spaceNameSearchCondition).or().contains(SpaceEntity.description, spaceNameSearchCondition);
                whereExpression.endGroup();
            }
        }
        StringBuilder sb = new StringBuilder("SELECT ").append(JCRProperties.JCR_EXCERPT.getName()).append(" FROM ");
        sb.append("soc:spacedefinition");
        sb.append(" WHERE ");
        sb.append(whereExpression.toString());
        sb.append(this.applyOrder(spaceFilter));
        return sb.toString();
    }

    private boolean isValidInput(String input) {
        if (input == null || input.length() == 0) {
            return false;
        }
        String cleanString = input.replaceAll("\\*", "");
        return (cleanString = cleanString.replaceAll("\\%", "")).length() != 0;
    }

    private String processSearchCondition(String searchCondition) {
        StringBuffer searchConditionBuffer = new StringBuffer();
        if (!searchCondition.contains("*") && !searchCondition.contains("%")) {
            if (searchCondition.charAt(0) != '*') {
                searchConditionBuffer.append("*").append(searchCondition);
            }
            if (searchCondition.charAt(searchCondition.length() - 1) != '*') {
                searchConditionBuffer.append("*");
            }
        } else {
            searchCondition = searchCondition.replace("*", "%");
            searchConditionBuffer.append("%").append(searchCondition).append("%");
        }
        return searchConditionBuffer.toString();
    }

    private String applyOrder(SpaceFilter spaceFilter) {
        StringBuilder sb = new StringBuilder(" ORDER BY ");
        Sorting sorting = spaceFilter == null ? new Sorting(Sorting.SortBy.TITLE, Sorting.OrderBy.ASC) : spaceFilter.getSorting();
        switch (sorting.sortBy) {
            case DATE: {
                sb.append(SpaceEntity.createdTime.getName()).append(" ").append(sorting.orderBy.toString());
                break;
            }
            case RELEVANCY: {
                sb.append(JCRProperties.JCR_RELEVANCY.getName()).append(" ").append(sorting.orderBy.toString());
                break;
            }
            case TITLE: {
                sb.append(SpaceEntity.name.getName()).append(" ").append(sorting.orderBy.toString());
            }
        }
        return sb.toString();
    }
}

