/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.social.core.storage.cache;

import java.util.List;
import org.exoplatform.social.common.service.ProcessContext;
import org.exoplatform.social.core.activity.model.ExoSocialActivity;
import org.exoplatform.social.core.identity.model.Identity;
import org.exoplatform.social.core.storage.api.ActivityStreamStorage;
import org.exoplatform.social.core.storage.cache.SocialStorageCacheService;
import org.exoplatform.social.core.storage.impl.ActivityStreamStorageImpl;

public class CachedActivityStreamStorage
implements ActivityStreamStorage {
    private final ActivityStreamStorageImpl storage;
    private final SocialStorageCacheService cacheService;

    public CachedActivityStreamStorage(ActivityStreamStorageImpl storage, SocialStorageCacheService cacheService) {
        this.storage = storage;
        this.cacheService = cacheService;
    }

    @Override
    public void save(ProcessContext ctx) {
        this.storage.save(ctx);
    }

    @Override
    public void savePoster(ProcessContext ctx) {
        this.storage.savePoster(ctx);
    }

    @Override
    public void delete(String activityId) {
        this.storage.delete(activityId);
    }

    @Override
    public void unLike(Identity removedLike, ExoSocialActivity activity) {
        this.storage.unLike(removedLike, activity);
    }

    @Override
    public void like(Identity liker, ExoSocialActivity activity) {
        this.storage.like(liker, activity);
    }

    @Override
    public void update(ProcessContext ctx) {
        this.storage.update(ctx);
    }

    @Override
    public void updateCommenter(ProcessContext ctx) {
        this.storage.updateCommenter(ctx);
    }

    @Override
    public void deleteComment(ProcessContext ctx) {
        this.storage.deleteComment(ctx);
    }

    @Override
    public void addSpaceMember(ProcessContext ctx) {
        this.storage.addSpaceMember(ctx);
    }

    @Override
    public void removeSpaceMember(ProcessContext ctx) {
        this.storage.removeSpaceMember(ctx);
    }

    @Override
    public List<ExoSocialActivity> getFeed(Identity owner, int offset, int limit) {
        return this.storage.getFeed(owner, offset, limit);
    }

    @Override
    public int getNumberOfFeed(Identity owner) {
        return this.storage.getNumberOfFeed(owner);
    }

    @Override
    public List<ExoSocialActivity> getConnections(Identity owner, int offset, int limit) {
        return this.storage.getConnections(owner, offset, limit);
    }

    @Override
    public int getNumberOfConnections(Identity owner) {
        return this.storage.getNumberOfConnections(owner);
    }

    @Override
    public List<ExoSocialActivity> getMySpaces(Identity owner, int offset, int limit) {
        return this.storage.getMySpaces(owner, offset, limit);
    }

    @Override
    public int getNumberOfMySpaces(Identity owner) {
        return this.storage.getNumberOfMySpaces(owner);
    }

    @Override
    public List<ExoSocialActivity> getSpaceStream(Identity owner, int offset, int limit) {
        return this.storage.getSpaceStream(owner, offset, limit);
    }

    @Override
    public int getNumberOfSpaceStream(Identity owner) {
        return this.storage.getNumberOfSpaceStream(owner);
    }

    @Override
    public List<ExoSocialActivity> getMyActivities(Identity owner, int offset, int limit) {
        return this.storage.getMyActivities(owner, offset, limit);
    }

    @Override
    public int getNumberOfMyActivities(Identity owner) {
        return this.storage.getNumberOfMyActivities(owner);
    }

    @Override
    public void connect(Identity sender, Identity receiver) {
        this.storage.connect(sender, receiver);
    }

    @Override
    public void deleteConnect(Identity sender, Identity receiver) {
        this.storage.deleteConnect(sender, receiver);
    }

    @Override
    public void createActivityRef(Identity owner, List<ExoSocialActivity> activities, ActivityStreamStorageImpl.ActivityRefType type) {
        this.storage.createActivityRef(owner, activities, type);
    }

    @Override
    public void createFeedActivityRef(Identity owner, List<ExoSocialActivity> activities) {
        this.storage.createFeedActivityRef(owner, activities);
    }

    @Override
    public void createConnectionsActivityRef(Identity owner, List<ExoSocialActivity> activities) {
        this.storage.createConnectionsActivityRef(owner, activities);
    }

    @Override
    public void createMySpacesActivityRef(Identity owner, List<ExoSocialActivity> activities) {
        this.storage.createMySpacesActivityRef(owner, activities);
    }

    @Override
    public void createSpaceActivityRef(Identity owner, List<ExoSocialActivity> activities) {
        this.storage.createSpaceActivityRef(owner, activities);
    }

    @Override
    public void createMyActivitiesActivityRef(Identity owner, List<ExoSocialActivity> activities) {
        this.storage.createMyActivitiesActivityRef(owner, activities);
    }

    @Override
    public boolean hasSizeOfConnections(Identity owner) {
        return this.storage.hasSizeOfConnections(owner);
    }

    @Override
    public boolean hasSizeOfFeed(Identity owner) {
        return this.storage.hasSizeOfFeed(owner);
    }

    @Override
    public boolean hasSizeOfMyActivities(Identity owner) {
        return this.storage.hasSizeOfMyActivities(owner);
    }

    @Override
    public boolean hasSizeOfMySpaces(Identity owner) {
        return this.storage.hasSizeOfMySpaces(owner);
    }

    @Override
    public boolean hasSizeOfSpaceStream(Identity owner) {
        return this.storage.hasSizeOfSpaceStream(owner);
    }

    @Override
    public void migrateStreamSize(Identity owner, int size, ActivityStreamStorageImpl.ActivityRefType type) {
        this.storage.migrateStreamSize(owner, size, type);
    }

    @Override
    public void updateHidable(ProcessContext ctx) {
        this.storage.updateHidable(ctx);
    }
}

