/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.portal.mop.management.exportimport;

import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import org.exoplatform.portal.config.DataStorage;
import org.exoplatform.portal.config.model.NavigationFragment;
import org.exoplatform.portal.config.model.PageNavigation;
import org.exoplatform.portal.config.model.PortalConfig;
import org.exoplatform.portal.mop.SiteKey;
import org.exoplatform.portal.mop.description.DescriptionService;
import org.exoplatform.portal.mop.importer.ImportMode;
import org.exoplatform.portal.mop.importer.NavigationImporter;
import org.exoplatform.portal.mop.management.exportimport.AbstractImportTask;
import org.exoplatform.portal.mop.management.operations.navigation.NavigationUtils;
import org.exoplatform.portal.mop.navigation.NavigationContext;
import org.exoplatform.portal.mop.navigation.NavigationService;
import org.exoplatform.portal.mop.navigation.NodeChangeListener;
import org.exoplatform.portal.mop.navigation.NodeContext;
import org.exoplatform.portal.mop.navigation.NodeState;
import org.exoplatform.portal.mop.navigation.Scope;
import org.gatein.common.logging.Logger;
import org.gatein.common.logging.LoggerFactory;

public class NavigationImportTask
extends AbstractImportTask<PageNavigation> {
    private static final Logger log = LoggerFactory.getLogger(NavigationImportTask.class);
    private NavigationService navigationService;
    private DescriptionService descriptionService;
    private DataStorage dataStorage;
    private RollbackTask rollbackTask;

    public NavigationImportTask(PageNavigation data, SiteKey siteKey, NavigationService navigationService, DescriptionService descriptionService, DataStorage dataStorage) {
        super(data, siteKey);
        this.navigationService = navigationService;
        this.descriptionService = descriptionService;
        this.dataStorage = dataStorage;
    }

    @Override
    public void importData(ImportMode importMode) throws Exception {
        PortalConfig portalConfig = this.dataStorage.getPortalConfig(this.siteKey.getTypeName(), this.siteKey.getName());
        if (portalConfig == null) {
            throw new Exception("Cannot import navigation because site does not exist for " + this.siteKey);
        }
        Locale locale = portalConfig.getLocale() == null ? Locale.ENGLISH : new Locale(portalConfig.getLocale());
        final NavigationContext navContext = this.navigationService.loadNavigation(this.siteKey);
        if (navContext == null) {
            this.rollbackTask = new RollbackTask(){

                @Override
                public String getDescription() {
                    return "Deleting navigation for site " + NavigationImportTask.this.siteKey;
                }

                @Override
                public void rollback() throws Exception {
                    log.debug((Object)("Rollback: " + this.getDescription()));
                    NavigationImportTask.this.navigationService.destroyNavigation(navContext);
                }
            };
        } else {
            final ArrayList snapshots = new ArrayList(((PageNavigation)this.data).getFragments().size());
            for (NavigationFragment fragment : ((PageNavigation)this.data).getFragments()) {
                snapshots.add(NavigationUtils.loadNode(this.navigationService, navContext, fragment.getParentURI()));
            }
            this.rollbackTask = new RollbackTask(){

                @Override
                public String getDescription() {
                    return "Rolling back navigation changes...";
                }

                @Override
                public void rollback() throws Exception {
                    log.debug((Object)this.getDescription());
                    for (NodeContext snapshot : snapshots) {
                        RollbackChangeListener listener = new RollbackChangeListener();
                        NavigationImportTask.this.navigationService.updateNode(snapshot, Scope.ALL, listener);
                        listener.rollback();
                        if (listener.errors) {
                            throw new Exception("Error rolling back navigation snapshot '" + snapshot.getName() + "'");
                        }
                        NavigationImportTask.this.navigationService.saveNode(snapshot, null);
                    }
                    log.debug((Object)"Successfully rolled back navigation changes.");
                }
            };
        }
        NavigationImporter importer = new NavigationImporter(locale, importMode, (PageNavigation)this.data, this.navigationService, this.descriptionService);
        importer.perform();
    }

    @Override
    public void rollback() throws Exception {
        if (this.rollbackTask != null) {
            this.rollbackTask.rollback();
        }
    }

    private static class RollbackChangeListener
    implements NodeChangeListener<NodeContext<NodeContext<?>>> {
        private List<RollbackTask> tasks = new ArrayList<RollbackTask>();
        private boolean errors;

        private RollbackChangeListener() {
        }

        @Override
        public void onAdd(final NodeContext<NodeContext<?>> target, final NodeContext<NodeContext<?>> parent, NodeContext<NodeContext<?>> previous) {
            this.tasks.add(new RollbackTask(){

                @Override
                public String getDescription() {
                    return "Removing node " + target.getName() + " from parent " + parent.getName();
                }

                @Override
                public void rollback() throws Exception {
                    parent.removeNode(target.getName());
                }
            });
        }

        @Override
        public void onCreate(NodeContext<NodeContext<?>> target, final NodeContext<NodeContext<?>> parent, NodeContext<NodeContext<?>> previous, final String name) {
            this.tasks.add(new RollbackTask(){

                @Override
                public String getDescription() {
                    return "Removing node " + name + " from parent " + parent.getName();
                }

                @Override
                public void rollback() throws Exception {
                    parent.removeNode(name);
                }
            });
        }

        @Override
        public void onRemove(final NodeContext<NodeContext<?>> target, final NodeContext<NodeContext<?>> parent) {
            this.tasks.add(new RollbackTask(){
                private String name;
                private Integer index;
                boolean hidden;
                private NodeState state;
                {
                    this.name = target.getName();
                    this.index = target.getIndex();
                    this.hidden = target.isHidden();
                    this.state = target.getState();
                }

                @Override
                public String getDescription() {
                    return "Adding node " + target.getName() + " to parent " + parent.getName();
                }

                @Override
                public void rollback() throws Exception {
                    NodeContext node = parent.add(this.index, this.name);
                    node.setState(this.state);
                    node.setHidden(this.hidden);
                }
            });
        }

        @Override
        public void onDestroy(final NodeContext<NodeContext<?>> target, final NodeContext<NodeContext<?>> parent) {
            this.tasks.add(new RollbackTask(){

                @Override
                public String getDescription() {
                    return "Adding node " + target.getName() + " from parent " + parent.getName();
                }

                @Override
                public void rollback() throws Exception {
                    parent.add(null, target);
                }
            });
        }

        @Override
        public void onRename(final NodeContext<NodeContext<?>> target, final NodeContext<NodeContext<?>> parent, final String name) {
            this.tasks.add(new RollbackTask(){
                private String targetName;
                {
                    this.targetName = target.getName();
                }

                @Override
                public String getDescription() {
                    return "Renaming node " + name + " to " + this.targetName + " for parent " + parent.getName();
                }

                @Override
                public void rollback() throws Exception {
                    target.setName(this.targetName);
                }
            });
        }

        @Override
        public void onUpdate(final NodeContext<NodeContext<?>> target, NodeState state) {
            this.tasks.add(new RollbackTask(){
                private NodeState targetState;
                {
                    this.targetState = target.getState();
                }

                @Override
                public String getDescription() {
                    return "Setting node " + target.getName() + " back to previous state " + this.targetState;
                }

                @Override
                public void rollback() throws Exception {
                    target.setState(this.targetState);
                }
            });
        }

        @Override
        public void onMove(final NodeContext<NodeContext<?>> target, final NodeContext<NodeContext<?>> from, final NodeContext<NodeContext<?>> to, NodeContext<NodeContext<?>> previous) {
            this.tasks.add(new RollbackTask(){

                @Override
                public String getDescription() {
                    return "Moving node " + target.getName() + " from " + to.getName() + " to " + from.getName();
                }

                @Override
                public void rollback() throws Exception {
                    from.add((Integer)target.getIndex(), target);
                    to.removeNode(target.getName());
                }
            });
        }

        public void rollback() {
            boolean debug = log.isDebugEnabled();
            for (RollbackTask task : this.tasks) {
                try {
                    if (debug) {
                        log.debug((Object)("Rollback: " + task.getDescription()));
                    }
                    task.rollback();
                }
                catch (Exception e) {
                    log.error((Object)("Exception during NodeChangeListener's rollback task: " + task.getDescription()), (Throwable)e);
                    this.errors = true;
                }
            }
        }
    }

    private static interface RollbackTask {
        public String getDescription();

        public void rollback() throws Exception;
    }
}

