/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.forum.ext.activity;

import java.util.Collection;
import java.util.Iterator;
import org.exoplatform.commons.utils.CommonsUtils;
import org.exoplatform.forum.common.CommonUtils;
import org.exoplatform.forum.service.Utils;
import org.exoplatform.portal.application.PortalRequestContext;
import org.exoplatform.portal.config.DataStorage;
import org.exoplatform.portal.config.model.ModelObject;
import org.exoplatform.portal.config.model.Page;
import org.exoplatform.portal.mop.SiteKey;
import org.exoplatform.portal.mop.SiteType;
import org.exoplatform.portal.mop.navigation.NavigationContext;
import org.exoplatform.portal.mop.navigation.NavigationService;
import org.exoplatform.portal.mop.navigation.NodeContext;
import org.exoplatform.portal.mop.navigation.NodeModel;
import org.exoplatform.portal.mop.navigation.Scope;
import org.exoplatform.portal.mop.user.UserNavigation;
import org.exoplatform.portal.mop.user.UserNode;
import org.exoplatform.portal.mop.user.UserPortal;
import org.exoplatform.portal.pom.data.ApplicationData;
import org.exoplatform.portal.pom.data.ModelData;
import org.exoplatform.portal.webui.util.Util;
import org.exoplatform.web.application.RequestContext;
import org.exoplatform.web.url.navigation.NavigationResource;
import org.exoplatform.web.url.navigation.NodeURL;

public class BuildLinkUtils {
    public static final String SPACES_GROUP = "/spaces".substring(1);
    public static final String CATEGORY = "category";

    private static String getType(String objectId) {
        if (objectId.indexOf(Utils.POST) == 0) {
            return Utils.POST;
        }
        if (objectId.indexOf(Utils.TOPIC) == 0) {
            return Utils.TOPIC;
        }
        if (objectId.indexOf(Utils.FORUM) == 0) {
            return Utils.FORUM;
        }
        if (objectId.indexOf(Utils.POLL) == 0) {
            return Utils.POLL;
        }
        return "";
    }

    private static boolean isInSpace(String objectId) {
        if (objectId.indexOf("/spaces") >= 0) {
            return true;
        }
        if (objectId.indexOf(Utils.FORUM_SPACE_ID_PREFIX) == 0) {
            return true;
        }
        if (objectId.indexOf(Utils.CATEGORY_SPACE_ID_PREFIX) == 0) {
            return true;
        }
        return objectId.indexOf(org.exoplatform.faq.service.Utils.CATE_SPACE_ID_PREFIX) == 0;
    }

    private static String getGroupId(String parentObjectId, PORTLET_INFO portletInfo) {
        StringBuffer spaceGroupId = new StringBuffer();
        if (parentObjectId.indexOf("/spaces") == 0) {
            spaceGroupId.append(parentObjectId);
        } else {
            spaceGroupId.append("/").append(SPACES_GROUP).append("/");
            if (portletInfo.equals((Object)PORTLET_INFO.ANSWER)) {
                spaceGroupId.append(parentObjectId.replace(Utils.CATEGORY_SPACE_ID_PREFIX, ""));
            } else {
                spaceGroupId.append(parentObjectId.replace(Utils.FORUM_SPACE_ID_PREFIX, ""));
            }
        }
        return spaceGroupId.toString();
    }

    public static String buildLink(String parentObjectId, String objectId, PORTLET_INFO portletInfo) {
        return BuildLinkUtils.buildLink(parentObjectId, objectId, portletInfo, "intranet");
    }

    public static String buildLink(String parentObjectId, String objectId, PORTLET_INFO portletInfo, String siteName) {
        if (CommonUtils.isEmpty((String)objectId)) {
            return "#";
        }
        try {
            String link = "";
            String objectType = BuildLinkUtils.getType(objectId);
            if (BuildLinkUtils.isInSpace(parentObjectId)) {
                link = BuildLinkUtils.buildSpaceLink(BuildLinkUtils.getGroupId(parentObjectId, portletInfo), objectType, objectId, portletInfo);
            } else {
                PortalRequestContext prc = Util.getPortalRequestContext();
                if (!CommonUtils.isEmpty((String)siteName) && !prc.getSiteKey().getName().equals(siteName)) {
                    SiteKey siteKey = SiteKey.portal((String)siteName);
                    String nodeURI = BuildLinkUtils.getSiteName(siteKey, portletInfo);
                    if (!CommonUtils.isEmpty((String)nodeURI)) {
                        link = new StringBuffer(BuildLinkUtils.getSiteHomeURL(siteName, nodeURI)).append(BuildLinkUtils.buildLink_(objectType, objectId, portletInfo)).toString();
                    }
                } else {
                    UserNavigation userNav;
                    UserPortal userPortal = prc.getUserPortal();
                    UserNode rootNode = userPortal.getNode(userNav = userPortal.getNavigation(prc.getSiteKey()), Scope.ALL, null, null);
                    UserNode portletNode = BuildLinkUtils.getPortletNode(rootNode, portletInfo);
                    if (portletNode != null) {
                        link = new StringBuffer(BuildLinkUtils.getNodeURL(portletNode)).append(BuildLinkUtils.buildLink_(objectType, objectId, portletInfo)).toString();
                    }
                }
            }
            return link;
        }
        catch (Exception ex) {
            return "";
        }
    }

    private static UserNode getPortletNode(UserNode rootNode, PORTLET_INFO portletInfo) {
        DataStorage dataStorage = (DataStorage)CommonsUtils.getService(DataStorage.class);
        for (UserNode node : rootNode.getChildren()) {
            UserNode child;
            Page page;
            try {
                page = dataStorage.getPage(node.getPageRef().format());
            }
            catch (Exception e) {
                continue;
            }
            for (ModelObject model : page.getChildren()) {
                ApplicationData applicationData;
                ModelData modelData = model.build();
                if (!(modelData instanceof ApplicationData) || ((applicationData = (ApplicationData)model.build()).getDescription() == null || !applicationData.getDescription().equals(portletInfo.getDescription())) && (applicationData.getTitle() == null || !applicationData.getTitle().equals(portletInfo.getDescription()))) continue;
                return node;
            }
            if (node.getChildrenSize() <= 0 || (child = BuildLinkUtils.getPortletNode(node, portletInfo)) == null) continue;
            return child;
        }
        return null;
    }

    private static String getNodeURL(UserNode node) {
        RequestContext ctx = RequestContext.getCurrentInstance();
        NodeURL nodeURL = (NodeURL)ctx.createURL(NodeURL.TYPE);
        return nodeURL.setNode(node).toString();
    }

    private static String buildLink_(String objectType, String objectId, PORTLET_INFO portletInfo) {
        StringBuffer buffer = new StringBuffer();
        if (portletInfo.equals((Object)PORTLET_INFO.ANSWER)) {
            return buffer.append(org.exoplatform.faq.service.Utils.QUESTION_ID).append(objectId).toString();
        }
        return buffer.append("/").append(objectType).append("/").append(objectId).toString();
    }

    private static String buildSpaceLink(String spaceGroupId, String objectType, String objectId, PORTLET_INFO portletInfo) throws Exception {
        String nodeURI = BuildLinkUtils.getSiteName(SiteKey.group((String)spaceGroupId), portletInfo);
        if (!CommonUtils.isEmpty((String)nodeURI)) {
            String spaceLink = BuildLinkUtils.getSpaceHomeURL(spaceGroupId);
            StringBuffer buffer = new StringBuffer(spaceLink).append("/").append(nodeURI);
            return buffer.append(BuildLinkUtils.buildLink_(objectType, objectId, portletInfo)).toString();
        }
        return "";
    }

    private static String getSiteName(SiteKey siteKey, PORTLET_INFO portletInfo) {
        NavigationContext nav;
        NavigationService navService = (NavigationService)CommonsUtils.getService(NavigationService.class);
        NodeContext parentNodeCtx = navService.loadNode(NodeModel.SELF_MODEL, nav = navService.loadNavigation(siteKey), Scope.ALL, null);
        if (parentNodeCtx.getSize() >= 1) {
            Collection children = parentNodeCtx.getNodes();
            if (siteKey.getType() == SiteType.GROUP) {
                children = ((NodeContext)parentNodeCtx.get(0)).getNodes();
            }
            Iterator it = children.iterator();
            NodeContext child = null;
            while (it.hasNext()) {
                child = (NodeContext)it.next();
                if (portletInfo.getPageId().indexOf(child.getName()) != 0 && child.getName().indexOf(portletInfo.getName()) < 0) continue;
                return child.getName();
            }
        }
        return "";
    }

    private static String getSiteHomeURL(String siteName, String nodeURI) {
        NodeURL nodeURL = (NodeURL)RequestContext.getCurrentInstance().createURL(NodeURL.TYPE);
        NavigationResource resource = new NavigationResource(SiteType.PORTAL, siteName, nodeURI);
        return nodeURL.setResource(resource).toString();
    }

    private static String getSpaceHomeURL(String spaceGroupId) {
        String permanentSpaceName = spaceGroupId.split("/")[2];
        NodeURL nodeURL = (NodeURL)RequestContext.getCurrentInstance().createURL(NodeURL.TYPE);
        NavigationResource resource = new NavigationResource(SiteType.GROUP, spaceGroupId, permanentSpaceName);
        return nodeURL.setResource(resource).toString();
    }

    public static enum PORTLET_INFO {
        FORUM("ForumPortlet", "Forum Portlet", "forum"),
        POLL("PollPortlet", "Polls Portlet", "poll"),
        ANSWER("AnswersPortlet", "Answers Portlet", "answers");

        private final String name;
        private final String description;
        private final String pageId;

        private PORTLET_INFO(String name, String description, String pageId) {
            this.name = name;
            this.pageId = pageId;
            this.description = description;
        }

        public String getName() {
            return this.name;
        }

        public String getPageId() {
            return this.pageId;
        }

        public String getDescription() {
            return this.description;
        }
    }
}

