/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.wiki.service.impl;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.net.URI;
import java.net.URLDecoder;
import java.util.ArrayList;
import java.util.Collection;
import java.util.GregorianCalendar;
import java.util.HashMap;
import java.util.List;
import java.util.Stack;
import java.util.StringTokenizer;
import javax.annotation.security.RolesAllowed;
import javax.servlet.ServletContext;
import javax.servlet.http.HttpServletRequest;
import javax.ws.rs.FormParam;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.CacheControl;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.UriBuilder;
import javax.ws.rs.core.UriBuilderException;
import javax.ws.rs.core.UriInfo;
import org.apache.commons.fileupload.DiskFileUpload;
import org.apache.commons.fileupload.FileItem;
import org.apache.commons.fileupload.FileUploadBase;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.lang.StringUtils;
import org.exoplatform.commons.utils.MimeTypeResolver;
import org.exoplatform.container.ExoContainerContext;
import org.exoplatform.container.PortalContainer;
import org.exoplatform.portal.config.model.PortalConfig;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.services.rest.impl.EnvironmentContext;
import org.exoplatform.services.rest.resource.ResourceContainer;
import org.exoplatform.services.security.ConversationState;
import org.exoplatform.wiki.mow.api.DraftPage;
import org.exoplatform.wiki.mow.api.Page;
import org.exoplatform.wiki.mow.api.Wiki;
import org.exoplatform.wiki.mow.api.WikiType;
import org.exoplatform.wiki.mow.core.api.wiki.AttachmentImpl;
import org.exoplatform.wiki.mow.core.api.wiki.DraftPageImpl;
import org.exoplatform.wiki.mow.core.api.wiki.PageImpl;
import org.exoplatform.wiki.rendering.RenderingService;
import org.exoplatform.wiki.rendering.impl.RenderingServiceImpl;
import org.exoplatform.wiki.service.WikiContext;
import org.exoplatform.wiki.service.WikiPageParams;
import org.exoplatform.wiki.service.WikiResource;
import org.exoplatform.wiki.service.WikiRestService;
import org.exoplatform.wiki.service.WikiService;
import org.exoplatform.wiki.service.image.ResizeImageService;
import org.exoplatform.wiki.service.impl.BeanToJsons;
import org.exoplatform.wiki.service.impl.DraftData;
import org.exoplatform.wiki.service.impl.SpaceBean;
import org.exoplatform.wiki.service.related.JsonRelatedData;
import org.exoplatform.wiki.service.related.RelatedUtil;
import org.exoplatform.wiki.service.rest.model.Attachment;
import org.exoplatform.wiki.service.rest.model.Attachments;
import org.exoplatform.wiki.service.rest.model.Link;
import org.exoplatform.wiki.service.rest.model.ObjectFactory;
import org.exoplatform.wiki.service.rest.model.PageSummary;
import org.exoplatform.wiki.service.rest.model.Pages;
import org.exoplatform.wiki.service.rest.model.Space;
import org.exoplatform.wiki.service.rest.model.Spaces;
import org.exoplatform.wiki.service.search.SearchResult;
import org.exoplatform.wiki.service.search.TitleSearchResult;
import org.exoplatform.wiki.service.search.WikiSearchData;
import org.exoplatform.wiki.tree.JsonNodeData;
import org.exoplatform.wiki.tree.TreeNode;
import org.exoplatform.wiki.tree.WikiTreeNode;
import org.exoplatform.wiki.tree.utils.TreeUtils;
import org.exoplatform.wiki.utils.Utils;
import org.xwiki.context.Execution;
import org.xwiki.context.ExecutionContext;
import org.xwiki.rendering.syntax.Syntax;

@Path(value="/wiki")
public class WikiRestServiceImpl
implements WikiRestService,
ResourceContainer {
    private final WikiService wikiService;
    private final RenderingService renderingService;
    private static Log log = ExoLogger.getLogger((String)"wiki:WikiRestService");
    private static final String DASH = "-";
    private final CacheControl cc;
    private ObjectFactory objectFactory = new ObjectFactory();

    public WikiRestServiceImpl(WikiService wikiService, RenderingService renderingService) {
        this.wikiService = wikiService;
        this.renderingService = renderingService;
        this.cc = new CacheControl();
        this.cc.setNoCache(true);
        this.cc.setNoStore(true);
    }

    @Override
    @POST
    @Path(value="/content/")
    @Produces(value={"text/html"})
    @RolesAllowed(value={"users"})
    public Response getWikiPageContent(@QueryParam(value="sessionKey") String sessionKey, @QueryParam(value="wikiContext") String wikiContextKey, @QueryParam(value="markup") boolean isMarkup, @FormParam(value="html") String data) {
        EnvironmentContext env = EnvironmentContext.getCurrent();
        WikiContext wikiContext = new WikiContext();
        String currentSyntax = Syntax.XWIKI_2_0.toIdString();
        HttpServletRequest request = (HttpServletRequest)env.get(HttpServletRequest.class);
        try {
            Execution ec;
            if (data == null && sessionKey != null && sessionKey.length() > 0) {
                data = (String)request.getSession().getAttribute(sessionKey);
            }
            if (wikiContextKey != null && wikiContextKey.length() > 0 && (wikiContext = (WikiContext)request.getSession().getAttribute(wikiContextKey)) != null) {
                currentSyntax = wikiContext.getSyntax();
            }
            if ((ec = ((RenderingServiceImpl)this.renderingService).getExecution()).getContext() == null) {
                ec.setContext(new ExecutionContext());
            }
            ec.getContext().setProperty("wikicontext", (Object)wikiContext);
            ServletContext wikiServletContext = PortalContainer.getInstance().getPortalContext().getContext("/wiki");
            InputStream is = wikiServletContext.getResourceAsStream("/templates/wiki/webui/xwiki/wysiwyginput.html");
            byte[] b = new byte[is.available()];
            is.read(b);
            is.close();
            data = this.renderingService.render(data, Syntax.XHTML_1_0.toIdString(), currentSyntax, false);
            data = this.renderingService.render(data, currentSyntax, Syntax.ANNOTATED_XHTML_1_0.toIdString(), false);
            data = new String(b).replace("$content", data);
        }
        catch (Exception e) {
            log.error((Object)e.getMessage(), (Throwable)e);
            return Response.serverError().entity((Object)e.getMessage()).cacheControl(this.cc).build();
        }
        return Response.ok((Object)data, (String)"text/html").cacheControl(this.cc).build();
    }

    @POST
    @Path(value="/upload/{wikiType}/{wikiOwner:.+}/{pageId}/")
    @RolesAllowed(value={"users"})
    public Response upload(@PathParam(value="wikiType") String wikiType, @PathParam(value="wikiOwner") String wikiOwner, @PathParam(value="pageId") String pageId) {
        EnvironmentContext env = EnvironmentContext.getCurrent();
        HttpServletRequest req = (HttpServletRequest)env.get(HttpServletRequest.class);
        boolean isMultipart = FileUploadBase.isMultipartContent((HttpServletRequest)req);
        if (isMultipart) {
            DiskFileUpload upload = new DiskFileUpload();
            try {
                List items = upload.parseRequest(req);
                for (FileItem fileItem : items) {
                    byte[] imageBytes;
                    InputStream inputStream = fileItem.getInputStream();
                    if (inputStream != null) {
                        imageBytes = new byte[inputStream.available()];
                        inputStream.read(imageBytes);
                    } else {
                        imageBytes = null;
                    }
                    String fileName = fileItem.getName();
                    if (fileName != null) {
                        fileName = FilenameUtils.getName((String)fileName);
                    }
                    String mimeType = new MimeTypeResolver().getMimeType(StringUtils.lowerCase((String)fileName));
                    WikiResource attachfile = new WikiResource(mimeType, "UTF-8", imageBytes);
                    attachfile.setName(fileName);
                    if (attachfile == null) continue;
                    WikiService wikiService = (WikiService)PortalContainer.getComponent(WikiService.class);
                    Page page = wikiService.getExsitedOrNewDraftPageById(wikiType, wikiOwner, pageId);
                    AttachmentImpl att = ((PageImpl)page).createAttachment(attachfile.getName(), attachfile);
                    ConversationState conversationState = ConversationState.getCurrent();
                    String creator = null;
                    if (conversationState != null && conversationState.getIdentity() != null) {
                        creator = conversationState.getIdentity().getUserId();
                    }
                    att.setCreator(creator);
                }
            }
            catch (IllegalArgumentException e) {
                log.error((Object)"Special characters are not allowed in the name of an attachment.");
                return Response.status((int)400).entity((Object)e.getMessage()).build();
            }
            catch (Exception e) {
                log.error((Object)e.getMessage());
                return Response.status((int)400).entity((Object)e.getMessage()).build();
            }
        }
        return Response.ok().build();
    }

    @GET
    @Path(value="/tree/{type}")
    @Produces(value={"application/json"})
    public Response getTreeData(@PathParam(value="type") String type, @QueryParam(value="path") String path, @QueryParam(value="page") String currentPath, @QueryParam(value="excerpt") Boolean showExcerpt, @QueryParam(value="depth") String depth) {
        try {
            List<Object> responseData = new ArrayList();
            HashMap<String, Object> context = new HashMap<String, Object>();
            if (currentPath != null) {
                currentPath = URLDecoder.decode(currentPath, "utf-8");
                context.put("page", currentPath);
                WikiPageParams currentPageParam = TreeUtils.getPageParamsFromPath(currentPath);
                PageImpl currentPage = (PageImpl)this.wikiService.getPageById(currentPageParam.getType(), currentPageParam.getOwner(), currentPageParam.getPageId());
                context.put("currentPage", currentPage);
            }
            path = URLDecoder.decode(path, "utf-8");
            context.put("path", path);
            WikiPageParams pageParam = TreeUtils.getPageParamsFromPath(path);
            PageImpl page = (PageImpl)this.wikiService.getPageById(pageParam.getType(), pageParam.getOwner(), pageParam.getPageId());
            if (page == null) {
                log.warn("User [{}] can not get wiki path [{}]. Wiki Home is used instead", new Object[]{ConversationState.getCurrent().getIdentity().getUserId(), path});
                page = (PageImpl)this.wikiService.getPageById(pageParam.getType(), pageParam.getOwner(), "WikiHome");
            }
            context.put("selectedPage", page);
            context.put("excerpt", showExcerpt);
            if (type.equalsIgnoreCase(TreeNode.TREETYPE.ALL.toString())) {
                Stack<WikiPageParams> stk = Utils.getStackParams(page);
                context.put("stackParams", stk);
                responseData = this.getJsonTree(pageParam, context);
            } else if (type.equalsIgnoreCase(TreeNode.TREETYPE.CHILDREN.toString())) {
                if (depth == null) {
                    depth = "1";
                }
                context.put("depth", depth);
                responseData = this.getJsonDescendants(pageParam, context);
            }
            return Response.ok(new BeanToJsons(responseData), (String)"application/json").cacheControl(this.cc).build();
        }
        catch (Exception e) {
            if (log.isErrorEnabled()) {
                log.error("Failed for get tree data by rest service.", new Object[]{e.getMessage()});
            }
            return Response.serverError().entity((Object)e.getMessage()).cacheControl(this.cc).build();
        }
    }

    @GET
    @Path(value="/related/")
    @Produces(value={"application/json"})
    @RolesAllowed(value={"users"})
    public Response getRelated(@QueryParam(value="path") String path) {
        if (path == null) {
            return Response.status((Response.Status)Response.Status.NOT_FOUND).build();
        }
        try {
            WikiPageParams params = TreeUtils.getPageParamsFromPath(path);
            PageImpl page = (PageImpl)this.wikiService.getPageById(params.getType(), params.getOwner(), params.getPageId());
            if (page != null) {
                List<PageImpl> relatedPages = page.getRelatedPages();
                List<JsonRelatedData> relatedData = RelatedUtil.pageImplToJson(relatedPages);
                return Response.ok(new BeanToJsons<JsonRelatedData>(relatedData)).cacheControl(this.cc).build();
            }
            return Response.status((Response.Status)Response.Status.NOT_FOUND).build();
        }
        catch (Exception e) {
            if (log.isErrorEnabled()) {
                log.error((Object)String.format("can not get related pages of [%s]", path), (Throwable)e);
            }
            return Response.serverError().cacheControl(this.cc).build();
        }
    }

    @GET
    @Path(value="/{wikiType}/spaces")
    @Produces(value={"application/xml"})
    @RolesAllowed(value={"users"})
    public Spaces getSpaces(@Context UriInfo uriInfo, @PathParam(value="wikiType") String wikiType, @QueryParam(value="start") Integer start, @QueryParam(value="number") Integer number) {
        Spaces spaces = this.objectFactory.createSpaces();
        ArrayList<String> spaceNames = new ArrayList<String>();
        Collection<Wiki> wikis = Utils.getWikisByType(WikiType.valueOf(wikiType.toUpperCase()));
        for (Wiki wiki : wikis) {
            spaceNames.add(wiki.getOwner());
        }
        for (String spaceName : spaceNames) {
            try {
                Page page = this.wikiService.getPageById(wikiType, spaceName, "WikiHome");
                spaces.getSpaces().add(this.createSpace(this.objectFactory, uriInfo.getBaseUri(), wikiType, spaceName, page));
            }
            catch (Exception e) {
                log.error((Object)e.getMessage(), (Throwable)e);
            }
        }
        return spaces;
    }

    private List getLastAccessedSpace(String userId, String appId, int offset, int limit) throws Exception {
        List spaces = new ArrayList();
        Class<?> spaceServiceClass = Class.forName("org.exoplatform.social.core.space.spi.SpaceService");
        Object spaceService = ExoContainerContext.getCurrentContainer().getComponentInstanceOfType(spaceServiceClass);
        spaces = (List)spaceServiceClass.getDeclaredMethod("getLastAccessedSpace", String.class, String.class, Integer.class, Integer.class).invoke(spaceService, userId, appId, new Integer(offset), new Integer(limit));
        return spaces;
    }

    private <T> T getValueFromSpace(Object space, String getterMethod, Class<T> propertyClass) throws Exception {
        Class<?> spaceClass = Class.forName("org.exoplatform.social.core.space.model.Space");
        Object propertyValue = spaceClass.getMethod(getterMethod, new Class[0]).invoke(space, new Object[0]);
        return (T)propertyValue;
    }

    @GET
    @Path(value="/lastVisited/spaces")
    @Produces(value={"application/xml"})
    @RolesAllowed(value={"users"})
    public Spaces getLastVisitedSpaces(@Context UriInfo uriInfo, @QueryParam(value="offset") Integer offset, @QueryParam(value="limit") Integer limit) {
        Spaces spaces = this.objectFactory.createSpaces();
        String currentUser = Utils.getCurrentUser();
        try {
            List lastVisitedSpaces = this.getLastAccessedSpace(currentUser, "Wiki", offset, limit);
            for (Object space : lastVisitedSpaces) {
                String groupId = this.getValueFromSpace(space, "getGroupId", String.class);
                String displayName = this.getValueFromSpace(space, "getDisplayName", String.class);
                Wiki wiki = this.wikiService.getWikiById(groupId);
                Page page = this.wikiService.getPageById(wiki.getType(), wiki.getOwner(), "WikiHome");
                spaces.getSpaces().add(this.createSpace(this.objectFactory, uriInfo.getBaseUri(), wiki.getType(), displayName, page));
            }
        }
        catch (Exception e) {
            log.error((Object)e.getMessage(), (Throwable)e);
        }
        return spaces;
    }

    @GET
    @Path(value="/{wikiType}/spaces/{wikiOwner:.+}/")
    @Produces(value={"application/xml"})
    @RolesAllowed(value={"users"})
    public Space getSpace(@Context UriInfo uriInfo, @PathParam(value="wikiType") String wikiType, @PathParam(value="wikiOwner") String wikiOwner) {
        Page page;
        try {
            page = this.wikiService.getPageById(wikiType, wikiOwner, "WikiHome");
        }
        catch (Exception e) {
            log.error((Object)e.getMessage(), (Throwable)e);
            return this.objectFactory.createSpace();
        }
        return this.createSpace(this.objectFactory, uriInfo.getBaseUri(), wikiType, wikiOwner, page);
    }

    @GET
    @Path(value="/{wikiType}/spaces/{wikiOwner:.+}/pages")
    @Produces(value={"application/xml"})
    @RolesAllowed(value={"users"})
    public Pages getPages(@Context UriInfo uriInfo, @PathParam(value="wikiType") String wikiType, @PathParam(value="wikiOwner") String wikiOwner, @QueryParam(value="start") Integer start, @QueryParam(value="number") Integer number, @QueryParam(value="parentId") String parentFilterExpression) {
        Pages pages = this.objectFactory.createPages();
        PageImpl page = null;
        boolean isWikiHome = true;
        try {
            String parentId = "WikiHome";
            if (parentFilterExpression != null && parentFilterExpression.length() > 0 && !parentFilterExpression.startsWith("^(?!")) {
                parentId = parentFilterExpression;
                if (parentId.indexOf(".") >= 0) {
                    parentId = parentId.substring(parentId.indexOf(".") + 1);
                }
                isWikiHome = false;
            }
            page = (PageImpl)this.wikiService.getPageById(wikiType, wikiOwner, parentId);
            if (isWikiHome) {
                pages.getPageSummaries().add(this.createPageSummary(this.objectFactory, uriInfo.getBaseUri(), page));
            } else {
                for (PageImpl childPage : page.getChildPages().values()) {
                    pages.getPageSummaries().add(this.createPageSummary(this.objectFactory, uriInfo.getBaseUri(), childPage));
                }
            }
        }
        catch (Exception e) {
            log.error((Object)("Can't get children pages of:" + parentFilterExpression), (Throwable)e);
        }
        return pages;
    }

    @GET
    @Path(value="/{wikiType}/spaces/{wikiOwner:.+}/pages/{pageId}")
    @Produces(value={"application/xml"})
    @RolesAllowed(value={"users"})
    public org.exoplatform.wiki.service.rest.model.Page getPage(@Context UriInfo uriInfo, @PathParam(value="wikiType") String wikiType, @PathParam(value="wikiOwner") String wikiOwner, @PathParam(value="pageId") String pageId) {
        try {
            PageImpl page = (PageImpl)this.wikiService.getPageById(wikiType, wikiOwner, pageId);
            if (page != null) {
                return this.createPage(this.objectFactory, uriInfo.getBaseUri(), uriInfo.getAbsolutePath(), page);
            }
        }
        catch (Exception e) {
            log.error((Object)e.getMessage(), (Throwable)e);
        }
        return this.objectFactory.createPage();
    }

    @GET
    @Path(value="/{wikiType}/spaces/{wikiOwner:.+}/pages/{pageId}/attachments")
    @Produces(value={"application/xml"})
    @RolesAllowed(value={"users"})
    public Attachments getAttachments(@Context UriInfo uriInfo, @PathParam(value="wikiType") String wikiType, @PathParam(value="wikiOwner") String wikiOwner, @PathParam(value="pageId") String pageId, @QueryParam(value="start") Integer start, @QueryParam(value="number") Integer number) {
        Attachments attachments = this.objectFactory.createAttachments();
        try {
            PageImpl page = (PageImpl)this.wikiService.getPageById(wikiType, wikiOwner, pageId);
            Collection<AttachmentImpl> pageAttachments = page.getAttachmentsExcludeContent();
            for (AttachmentImpl pageAttachment : pageAttachments) {
                attachments.getAttachments().add(this.createAttachment(this.objectFactory, uriInfo.getBaseUri(), pageAttachment, "attachment", "attachment"));
            }
        }
        catch (Exception e) {
            log.error((Object)e.getMessage(), (Throwable)e);
        }
        return attachments;
    }

    @GET
    @Path(value="contextsearch/")
    @Produces(value={"application/json"})
    @RolesAllowed(value={"users"})
    public Response searchData(@QueryParam(value="keyword") String keyword, @QueryParam(value="wikiType") String wikiType, @QueryParam(value="wikiOwner") String wikiOwner) throws Exception {
        try {
            WikiSearchData data = new WikiSearchData(keyword.toLowerCase(), null, wikiType, wikiOwner);
            data.setNodeType("nt:base");
            data.setLimit(10);
            List results = this.wikiService.search(data).getAll();
            ArrayList<TitleSearchResult> titleSearchResults = new ArrayList<TitleSearchResult>();
            for (SearchResult searchResult : results) {
                String url = null;
                url = "wiki:attachment".equals(searchResult.getType()) ? ((AttachmentImpl)Utils.getObject(searchResult.getPath(), searchResult.getType())).getDownloadURL() : searchResult.getUrl();
                titleSearchResults.add(new TitleSearchResult(searchResult.getTitle(), searchResult.getPath(), searchResult.getType(), url));
            }
            return Response.ok(new BeanToJsons(titleSearchResults), (String)"application/json").cacheControl(this.cc).build();
        }
        catch (Exception e) {
            return Response.status((int)500).cacheControl(this.cc).build();
        }
    }

    @GET
    @Path(value="/images/{wikiType}/space/{wikiOwner:.+}/page/{pageId}/{imageId}")
    @Produces(value={"image"})
    @RolesAllowed(value={"users"})
    public Response getImage(@Context UriInfo uriInfo, @PathParam(value="wikiType") String wikiType, @PathParam(value="wikiOwner") String wikiOwner, @PathParam(value="pageId") String pageId, @PathParam(value="imageId") String imageId, @QueryParam(value="width") Integer width) {
        InputStream result = null;
        try {
            ResizeImageService resizeImgService = (ResizeImageService)ExoContainerContext.getCurrentContainer().getComponentInstanceOfType(ResizeImageService.class);
            PageImpl page = (PageImpl)this.wikiService.getPageByRootPermission(wikiType, wikiOwner, pageId);
            AttachmentImpl att = page.getAttachmentByRootPermisison(imageId);
            ByteArrayInputStream bis = new ByteArrayInputStream(att.getContentResource().getData());
            result = width != null ? resizeImgService.resizeImageByWidth(imageId, bis, width) : bis;
            return Response.ok((Object)result, (String)"image").cacheControl(this.cc).build();
        }
        catch (Exception e) {
            if (log.isDebugEnabled()) {
                log.debug((Object)String.format("Can't get image name: %s of page %s", imageId, pageId), (Throwable)e);
            }
            return Response.status((int)500).cacheControl(this.cc).build();
        }
    }

    public Space createSpace(ObjectFactory objectFactory, URI baseUri, String wikiName, String spaceName, Page home) {
        Space space = objectFactory.createSpace();
        space.setId(String.format("%s:%s", wikiName, spaceName));
        space.setWiki(wikiName);
        space.setName(spaceName);
        if (home != null) {
            space.setHome("home");
            space.setXwikiRelativeUrl("home");
            space.setXwikiAbsoluteUrl("home");
        }
        String pagesUri = UriBuilder.fromUri((URI)baseUri).path("/wiki/{wikiName}/spaces/{spaceName}/pages").build(new Object[]{wikiName, spaceName}).toString();
        Link pagesLink = objectFactory.createLink();
        pagesLink.setHref(pagesUri);
        pagesLink.setRel("http://www.xwiki.org/rel/pages");
        space.getLinks().add(pagesLink);
        if (home != null) {
            String homeUri = UriBuilder.fromUri((URI)baseUri).path("/wiki/{wikiName}/spaces/{spaceName}/pages/{pageName}").build(new Object[]{wikiName, spaceName, home.getName()}).toString();
            Link homeLink = objectFactory.createLink();
            homeLink.setHref(homeUri);
            homeLink.setRel("http://www.xwiki.org/rel/home");
            space.getLinks().add(homeLink);
        }
        String searchUri = UriBuilder.fromUri((URI)baseUri).path("/wiki/{wikiName}/spaces/{spaceName}/search").build(new Object[]{wikiName, spaceName}).toString();
        Link searchLink = objectFactory.createLink();
        searchLink.setHref(searchUri);
        searchLink.setRel("http://www.xwiki.org/rel/search");
        space.getLinks().add(searchLink);
        return space;
    }

    public org.exoplatform.wiki.service.rest.model.Page createPage(ObjectFactory objectFactory, URI baseUri, URI self, PageImpl doc) throws Exception {
        org.exoplatform.wiki.service.rest.model.Page page = objectFactory.createPage();
        WikiRestServiceImpl.fillPageSummary(page, objectFactory, baseUri, doc);
        page.setVersion("current");
        page.setMajorVersion(1);
        page.setMinorVersion(0);
        page.setLanguage(doc.getSyntax());
        page.setCreator(doc.getOwner());
        GregorianCalendar calendar = new GregorianCalendar();
        page.setCreated(calendar);
        page.setModifier(doc.getAuthor());
        calendar = new GregorianCalendar();
        calendar.setTime(doc.getUpdatedDate());
        page.setModified(calendar);
        page.setContent(doc.getContent().getText());
        if (self != null) {
            Link pageLink = objectFactory.createLink();
            pageLink.setHref(self.toString());
            pageLink.setRel("self");
            page.getLinks().add(pageLink);
        }
        return page;
    }

    public PageSummary createPageSummary(ObjectFactory objectFactory, URI baseUri, PageImpl doc) throws IllegalArgumentException, UriBuilderException, Exception {
        PageSummary pageSummary = objectFactory.createPageSummary();
        WikiRestServiceImpl.fillPageSummary(pageSummary, objectFactory, baseUri, doc);
        String wikiName = doc.getWiki().getType();
        String spaceName = doc.getWiki().getOwner();
        String pageUri = UriBuilder.fromUri((URI)baseUri).path("/wiki/{wikiName}/spaces/{spaceName}/pages/{pageName}").build(new Object[]{wikiName, spaceName, doc.getName()}).toString();
        Link pageLink = objectFactory.createLink();
        pageLink.setHref(pageUri);
        pageLink.setRel("http://www.xwiki.org/rel/page");
        pageSummary.getLinks().add(pageLink);
        return pageSummary;
    }

    public Attachment createAttachment(ObjectFactory objectFactory, URI baseUri, AttachmentImpl pageAttachment, String xwikiRelativeUrl, String xwikiAbsoluteUrl) throws Exception {
        Attachment attachment = objectFactory.createAttachment();
        this.fillAttachment(attachment, objectFactory, baseUri, pageAttachment, xwikiRelativeUrl, xwikiAbsoluteUrl);
        PageImpl page = pageAttachment.getParentPage();
        String attachmentUri = UriBuilder.fromUri((URI)baseUri).path("/wiki/{wikiName}/spaces/{spaceName}/pages/{pageName}/attachments/{attachmentName}").build(new Object[]{page.getWiki().getType(), page.getWiki().getOwner(), page.getName(), pageAttachment.getName()}).toString();
        Link attachmentLink = objectFactory.createLink();
        attachmentLink.setHref(attachmentUri);
        attachmentLink.setRel("http://www.xwiki.org/rel/attachmentData");
        attachment.getLinks().add(attachmentLink);
        return attachment;
    }

    private List<JsonNodeData> getJsonTree(WikiPageParams params, HashMap<String, Object> context) throws Exception {
        ArrayList<JsonNodeData> responseData = new ArrayList();
        Wiki wiki = Utils.getWiki(params);
        WikiTreeNode wikiNode = new WikiTreeNode(wiki);
        wikiNode.pushDescendants(context);
        responseData = TreeUtils.tranformToJson(wikiNode, context);
        return responseData;
    }

    private List<JsonNodeData> getJsonDescendants(WikiPageParams params, HashMap<String, Object> context) throws Exception {
        TreeNode treeNode = TreeUtils.getDescendants(params, context);
        return TreeUtils.tranformToJson(treeNode, context);
    }

    private static void fillPageSummary(PageSummary pageSummary, ObjectFactory objectFactory, URI baseUri, PageImpl doc) throws IllegalArgumentException, UriBuilderException, Exception {
        String wikiType = doc.getWiki().getType();
        pageSummary.setWiki(wikiType);
        pageSummary.setFullName(doc.getTitle());
        pageSummary.setId(wikiType + ":" + doc.getWiki().getOwner() + "." + doc.getName());
        pageSummary.setSpace(doc.getWiki().getOwner());
        pageSummary.setName(doc.getName());
        pageSummary.setTitle(doc.getTitle());
        pageSummary.setTranslations(objectFactory.createTranslations());
        pageSummary.setSyntax(doc.getSyntax());
        PageImpl parent = doc.getParentPage();
        if (parent != null) {
            pageSummary.setParent(parent.getName());
            pageSummary.setParentId(parent.getName());
        } else {
            pageSummary.setParent("");
            pageSummary.setParentId("");
        }
        String spaceUri = UriBuilder.fromUri((URI)baseUri).path("/wiki/{wikiName}/spaces/{spaceName}").build(new Object[]{wikiType, doc.getWiki().getOwner()}).toString();
        Link spaceLink = objectFactory.createLink();
        spaceLink.setHref(spaceUri);
        spaceLink.setRel("http://www.xwiki.org/rel/space");
        pageSummary.getLinks().add(spaceLink);
        if (parent != null) {
            String parentUri = UriBuilder.fromUri((URI)baseUri).path("/wiki/{wikiName}/spaces/{spaceName}/pages/{pageName}").build(new Object[]{parent.getWiki().getType(), parent.getWiki().getOwner(), parent.getName()}).toString();
            Link parentLink = objectFactory.createLink();
            parentLink.setHref(parentUri);
            parentLink.setRel("http://www.xwiki.org/rel/parent");
            pageSummary.getLinks().add(parentLink);
        }
        if (!doc.getChildPages().isEmpty()) {
            String pageChildrenUri = UriBuilder.fromUri((URI)baseUri).path("/wiki/{wikiName}/spaces/{spaceName}/pages/{pageName}/children").build(new Object[]{wikiType, doc.getWiki().getOwner(), doc.getName()}).toString();
            Link pageChildrenLink = objectFactory.createLink();
            pageChildrenLink.setHref(pageChildrenUri);
            pageChildrenLink.setRel("http://www.xwiki.org/rel/children");
            pageSummary.getLinks().add(pageChildrenLink);
        }
        if (!doc.getAttachmentsExcludeContent().isEmpty()) {
            String attachmentsUri = UriBuilder.fromUri((URI)baseUri).path("/wiki/{wikiName}/spaces/{spaceName}/pages/{pageName}/attachments").build(new Object[]{wikiType, doc.getWiki().getOwner(), doc.getName()}).toString();
            Link attachmentsLink = objectFactory.createLink();
            attachmentsLink.setHref(attachmentsUri);
            attachmentsLink.setRel("http://www.xwiki.org/rel/attachments");
            pageSummary.getLinks().add(attachmentsLink);
        }
    }

    private void fillAttachment(Attachment attachment, ObjectFactory objectFactory, URI baseUri, AttachmentImpl pageAttachment, String xwikiRelativeUrl, String xwikiAbsoluteUrl) throws Exception {
        PageImpl page = pageAttachment.getParentPage();
        attachment.setId(String.format("%s@%s", page.getName(), pageAttachment.getName()));
        attachment.setName(pageAttachment.getName());
        attachment.setSize((int)pageAttachment.getWeightInBytes());
        attachment.setVersion("current");
        attachment.setPageId(page.getName());
        attachment.setPageVersion("current");
        attachment.setMimeType(pageAttachment.getContentResource().getMimeType());
        attachment.setAuthor(pageAttachment.getCreator());
        GregorianCalendar calendar = new GregorianCalendar();
        calendar.setTime(pageAttachment.getCreated());
        attachment.setDate(calendar);
        attachment.setXwikiRelativeUrl(xwikiRelativeUrl);
        attachment.setXwikiAbsoluteUrl(xwikiAbsoluteUrl);
        String pageUri = UriBuilder.fromUri((URI)baseUri).path("/wiki/{wikiName}/spaces/{spaceName}/pages/{pageName}").build(new Object[]{page.getWiki().getType(), page.getWiki().getOwner(), page.getName()}).toString();
        Link pageLink = objectFactory.createLink();
        pageLink.setHref(pageUri);
        pageLink.setRel("http://www.xwiki.org/rel/page");
        attachment.getLinks().add(pageLink);
    }

    @GET
    @Path(value="/help/{syntaxId}")
    @Produces(value={"text/html"})
    @RolesAllowed(value={"users"})
    public Response getHelpSyntaxPage(@PathParam(value="syntaxId") String syntaxId, @QueryParam(value="portalUrl") String portalUrl) {
        CacheControl cacheControl = new CacheControl();
        syntaxId = syntaxId.replace("SLASH", "/").replace("DOT", ".");
        try {
            PageImpl page = this.wikiService.getHelpSyntaxPage(syntaxId);
            if (page == null) {
                return Response.status((int)404).cacheControl(this.cc).build();
            }
            Page fullHelpPage = page.getChildPages().values().iterator().next();
            if (!StringUtils.isEmpty((String)portalUrl)) {
                RenderingService renderingService = (RenderingService)ExoContainerContext.getCurrentContainer().getComponentInstanceOfType(RenderingService.class);
                Execution ec = ((RenderingServiceImpl)renderingService).getExecution();
                if (ec.getContext() == null) {
                    ec.setContext(new ExecutionContext());
                }
                WikiContext wikiContext = new WikiContext();
                wikiContext.setPortalURL(portalUrl);
                wikiContext.setType(PortalConfig.PORTAL_TYPE);
                ec.getContext().setProperty("wikicontext", (Object)wikiContext);
            }
            String body = this.renderingService.render(fullHelpPage.getContent().getText(), fullHelpPage.getSyntax(), Syntax.XHTML_1_0.toIdString(), false);
            StringBuilder script = new StringBuilder("<script type=\"text/javascript\">").append("var local = String(window.location);").append("var i = local.indexOf('/', local.indexOf('//') + 2);").append("local = (i <= 0) ? local : local.substring(0, i);").append("local = local + '/wiki/skin/DefaultSkin/webui/Stylesheet.css';").append("var link = document.createElement('link');").append("link.rel = 'stylesheet';").append("link.type = 'text/css';").append("link.href = local;").append("document.head = document.head || document.getElementsByTagName(\"head\")[0] || document.documentElement;").append("document.head.appendChild(link);").append("</script>");
            StringBuilder htmlOutput = new StringBuilder();
            htmlOutput.append("<!DOCTYPE html PUBLIC \"-//W3C//DTD XHTML 1.0 Strict//EN\" \"http://www.w3.org/TR/xhtml1/DTD/xhtml1-strict.dtd\">").append("<html xmlns=\"http://www.w3.org/1999/xhtml\" xml:lang=\"en\" lang=\"en\" dir=\"ltr\">").append("<head id=\"head\">").append("<title>Wiki help page</title>").append("<meta http-equiv=\"Content-Type\" content=\"text/html; charset=UTF-8\"/>").append((CharSequence)script).append("</head>").append("<body>").append("<div class=\"UIWikiPageContentArea\">").append(body).append("</div>").append("</body>").append("</html>");
            return Response.ok((Object)htmlOutput.toString(), (String)"text/html").cacheControl(cacheControl).build();
        }
        catch (Exception e) {
            if (log.isWarnEnabled()) {
                log.warn((Object)"An exception happens when getHelpSyntaxPage", (Throwable)e);
            }
            return Response.status((int)500).cacheControl(this.cc).build();
        }
    }

    @GET
    @Path(value="/spaces/accessibleSpaces/")
    @Produces(value={"application/json"})
    @RolesAllowed(value={"users"})
    public Response searchAccessibleSpaces(@QueryParam(value="keyword") String keyword) {
        try {
            List<SpaceBean> spaceBeans = this.wikiService.searchSpaces(keyword);
            return Response.ok(new BeanToJsons<SpaceBean>(spaceBeans), (String)"application/json").cacheControl(this.cc).build();
        }
        catch (Exception ex) {
            if (log.isWarnEnabled()) {
                log.warn((Object)"An exception happens when searchAccessibleSpaces", (Throwable)ex);
            }
            return Response.status((int)500).cacheControl(this.cc).build();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @POST
    @Path(value="/saveDraft/")
    @RolesAllowed(value={"users"})
    public Response saveDraft(@QueryParam(value="wikiType") String wikiType, @QueryParam(value="wikiOwner") String wikiOwner, @QueryParam(value="pageId") String rawPageId, @QueryParam(value="pageRevision") String pageRevision, @QueryParam(value="lastDraftName") String lastDraftName, @QueryParam(value="isNewPage") boolean isNewPage, @QueryParam(value="clientTime") long clientTime, @FormParam(value="title") String title, @FormParam(value="content") String content, @FormParam(value="isMarkup") String isMarkup) {
        String pageId = null;
        try {
            if ("__anonim".equals(Utils.getCurrentUser())) {
                return Response.status((int)400).cacheControl(this.cc).build();
            }
            pageId = URLDecoder.decode(rawPageId, "utf-8");
            WikiPageParams param = new WikiPageParams(wikiType, wikiOwner, pageId);
            PageImpl pageImpl = (PageImpl)this.wikiService.getPageById(wikiType, wikiOwner, pageId);
            if (StringUtils.isEmpty((String)pageId) || pageImpl == null) {
                throw new IllegalArgumentException("Can not find the target page");
            }
            DraftPage draftPage = null;
            if (!isNewPage) {
                draftPage = this.wikiService.getDraft(param);
                if (draftPage != null && !draftPage.getName().equals(lastDraftName)) {
                    draftPage = null;
                }
            } else if (!StringUtils.isEmpty((String)lastDraftName)) {
                draftPage = (DraftPageImpl)this.wikiService.getDraft(lastDraftName);
            }
            if (draftPage == null) {
                if (!isNewPage) {
                    String string = pageImpl.getJCRPageNode().getUUID();
                    synchronized (string) {
                        draftPage = (DraftPageImpl)this.wikiService.createDraftForExistPage(param, pageRevision, clientTime);
                    }
                } else {
                    draftPage = (DraftPageImpl)this.wikiService.createDraftForNewPage(param, clientTime);
                }
            }
            if (StringUtils.isEmpty((String)isMarkup) || !isMarkup.toLowerCase().equals("true")) {
                content = this.renderingService.render(content, Syntax.XHTML_1_0.toIdString(), this.wikiService.getDefaultWikiSyntaxId(), false);
            }
            if ("".equals(title = this.replaceSpecialCharacter(title))) {
                draftPage.setTitle(draftPage.getName());
            } else {
                draftPage.setTitle(title);
            }
            draftPage.getContent().setText(content);
            ((DraftPageImpl)draftPage).getChromatticSession().save();
            Utils.logEditPageTime(param, Utils.getCurrentUser(), System.currentTimeMillis(), draftPage.getName(), isNewPage);
            return Response.ok((Object)new DraftData(draftPage.getName()), (String)"application/json").cacheControl(this.cc).build();
        }
        catch (UnsupportedEncodingException uee) {
            log.warn((Object)"Cannot decode page name");
            return Response.status((int)500).cacheControl(this.cc).build();
        }
        catch (Exception ex) {
            if (StringUtils.isEmpty(pageId)) {
                pageId = rawPageId;
            }
            log.warn((Object)String.format("Failed to perform auto save wiki page %s:%s:%s", wikiType, wikiOwner, pageId), (Throwable)ex);
            return Response.status((int)500).cacheControl(this.cc).build();
        }
    }

    private String replaceSpecialCharacter(String s) {
        StringTokenizer tokens = new StringTokenizer("% = : @ / \\ | ^ # ; [ ] { } < > * ' \" + ? &");
        while (tokens.hasMoreTokens()) {
            s = s.replace(tokens.nextToken(), DASH);
        }
        return s;
    }

    @GET
    @Path(value="/removeDraft/")
    @RolesAllowed(value={"users"})
    public Response removeDraft(@QueryParam(value="draftName") String draftName) {
        if (StringUtils.isEmpty((String)draftName)) {
            return Response.status((int)400).cacheControl(this.cc).build();
        }
        try {
            this.wikiService.removeDraft(draftName);
            return Response.ok().cacheControl(this.cc).build();
        }
        catch (Exception e) {
            return Response.status((int)500).cacheControl(this.cc).build();
        }
    }
}

