/*
 * Decompiled with CFR 0.152.
 */
package com.google.caja.render;

import com.google.caja.lexer.FilePosition;
import com.google.caja.lexer.InputSource;
import com.google.caja.lexer.TokenConsumer;
import com.google.caja.render.Concatenator;
import com.google.caja.render.JsPrettyPrinter;
import com.google.caja.render.TokenClassification;
import com.google.caja.reporting.MessageContext;
import com.google.caja.reporting.RenderContext;
import com.google.caja.util.Lists;
import com.google.caja.util.Maps;
import java.util.Collections;
import java.util.Formatter;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SourceSnippetRenderer
implements TokenConsumer {
    private final MessageContext mc;
    private final RenderContext rc;
    private final TokenConsumer delegateRenderer;
    private final List<RenderedSourceLine> renderedLines = Lists.newArrayList();
    private final Map<InputSource, List<OriginalSourceLine>> originalSourceLines = Maps.newHashMap();
    private final List<FilePosition> marks = Lists.newArrayList();
    private final StringBuilder renderedTextAccumulator = new StringBuilder();

    public SourceSnippetRenderer(Map<InputSource, ? extends CharSequence> originalSource, MessageContext mc, RenderContext rc) {
        this.mc = mc;
        this.rc = rc;
        this.delegateRenderer = new JsPrettyPrinter(new Concatenator(this.renderedTextAccumulator));
        this.buildOriginalSourceLines(originalSource);
        this.renderedLines.add(new RenderedSourceLine(""));
    }

    @Override
    public void mark(FilePosition pos) {
        this.delegateRenderer.mark(pos);
        this.delegateRenderer.consume("/*@" + this.marks.size() + "*/");
        this.marks.add(pos);
    }

    @Override
    public void consume(String text) {
        if (TokenClassification.isComment(text)) {
            return;
        }
        this.delegateRenderer.consume(text);
    }

    @Override
    public void noMoreTokens() {
        this.delegateRenderer.noMoreTokens();
        int consumed = 0;
        String renderedText = this.renderedTextAccumulator.toString();
        Matcher m = Pattern.compile(" */\\*@([0-9]+)\\*/").matcher(renderedText);
        FilePosition currentMark = FilePosition.UNKNOWN;
        boolean first = true;
        while (m.find()) {
            String chunk = renderedText.substring(consumed, m.start());
            consumed = m.end();
            if ("".equals(chunk)) continue;
            if (first) {
                chunk = chunk.replaceFirst("^[\r\n]+", "");
                first = false;
            }
            this.processCurrentMark(currentMark, SourceSnippetRenderer.splitLines(chunk));
            currentMark = this.marks.get(Integer.parseInt(m.group(1)));
        }
        this.processCurrentMark(currentMark, SourceSnippetRenderer.splitLines(renderedText.substring(consumed)));
        this.processProgram();
        this.renderOutput();
    }

    private void buildOriginalSourceLines(Map<InputSource, ? extends CharSequence> originalSource) {
        for (Map.Entry<InputSource, ? extends CharSequence> entry : originalSource.entrySet()) {
            List<OriginalSourceLine> lines = Lists.newArrayList();
            String[] text = SourceSnippetRenderer.splitLines(((Object)entry.getValue()).toString());
            for (int i = 0; i < text.length; ++i) {
                lines.add(new OriginalSourceLine(i, text[i]));
            }
            this.originalSourceLines.put(entry.getKey(), lines);
        }
    }

    private static String[] splitLines(String s) {
        return s.split("\r\n?|\n");
    }

    private void processCurrentMark(FilePosition mark, String[] textLines) {
        if (textLines.length == 0) {
            return;
        }
        this.renderedLines.get(this.renderedLines.size() - 1).appendText(textLines[0]);
        this.addEvidenceForCurrentMark(mark, textLines[0].length());
        for (int i = 1; i < textLines.length; ++i) {
            this.renderedLines.add(new RenderedSourceLine(textLines[i]));
            this.addEvidenceForCurrentMark(mark, textLines[i].length());
        }
    }

    private void addEvidenceForCurrentMark(FilePosition mark, int evidence) {
        if (mark == null || InputSource.UNKNOWN.equals(mark.source())) {
            return;
        }
        List<OriginalSourceLine> sourceList = this.originalSourceLines.get(mark.source());
        if (sourceList == null) {
            return;
        }
        for (int l = mark.startLineNo() - 1; l <= mark.endLineNo() - 1; ++l) {
            sourceList.get(l).addEvidence(this.renderedLines.size() - 1, evidence);
        }
    }

    private void processProgram() {
        for (InputSource is : this.originalSourceLines.keySet()) {
            List<OriginalSourceLine> orig = this.originalSourceLines.get(is);
            int lastRenderedLine = 0;
            for (int lineIdx = 0; lineIdx < orig.size(); ++lineIdx) {
                OriginalSourceLine line = orig.get(lineIdx);
                int bsl = line.computeBestRenderedLine();
                System.out.println("***** " + bsl + " --- " + line.getText());
                if (bsl < 0) {
                    bsl = lastRenderedLine;
                }
                this.renderedLines.get(bsl).addOriginalSourceLine(is, lineIdx, line);
            }
        }
    }

    private void renderOutput() {
        for (RenderedSourceLine rl : this.renderedLines) {
            rl.render((Concatenator)this.rc.getOut());
        }
    }

    private static String scrubJsString(String orig) {
        return orig.replaceAll("[\\p{javaIdentifierIgnorable}]", "\ufffd").replace('@', '\ufffd').replace("*/", "\ufffd/").replace("<!", "<\ufffd").replace("-->", "-\ufffd>").replace("]]>", "]\ufffd>").replace("</", "<\ufffd");
    }

    private static String shrinkSpaces(String orig) {
        return orig.replaceAll("^ +", "");
    }

    private static String formatLineNo(int lineNo) {
        StringBuilder sb = new StringBuilder();
        Formatter f = new Formatter(sb);
        f.format("%5d", lineNo + 1);
        return sb.toString();
    }

    private class RenderedSourceLine {
        private final StringBuilder textBuffer = new StringBuilder();
        private final Map<InputSource, Map<Integer, OriginalSourceLine>> lines = Maps.newHashMap();

        public RenderedSourceLine(String text) {
            this.textBuffer.append(text);
        }

        public void appendText(String text) {
            this.textBuffer.append(text);
        }

        public void addOriginalSourceLine(InputSource inputSource, int lineNo, OriginalSourceLine line) {
            Map<Integer, OriginalSourceLine> m = this.lines.get(inputSource);
            if (m == null) {
                m = Maps.newHashMap();
                this.lines.put(inputSource, m);
            }
            m.put(lineNo, line);
        }

        public void render(Concatenator out) {
            for (InputSource s : this.lines.keySet()) {
                out.consume("\n");
                out.consume("// *** ");
                out.consume(SourceSnippetRenderer.this.mc.abbreviate(s));
                out.consume(" ***\n");
                Map<Integer, OriginalSourceLine> forSource = this.lines.get(s);
                List<Integer> sortedLines = Lists.newArrayList(forSource.keySet());
                Collections.sort(sortedLines);
                for (int l : sortedLines) {
                    OriginalSourceLine sl = forSource.get(l);
                    out.consume("// ");
                    out.consume(SourceSnippetRenderer.formatLineNo(sl.getLineNo()));
                    out.consume(": ");
                    out.consume(SourceSnippetRenderer.scrubJsString(forSource.get(l).getText()));
                    out.consume("\n");
                }
                out.consume("\n");
            }
            out.consume(SourceSnippetRenderer.shrinkSpaces(this.textBuffer.toString()));
            out.consume("\n");
        }
    }

    private class OriginalSourceLine {
        private final int lineNo;
        private final String text;
        private Map<Integer, Integer> evidence = Maps.newHashMap();

        public OriginalSourceLine(int lineNo, String text) {
            this.lineNo = lineNo;
            this.text = text;
        }

        public int getLineNo() {
            return this.lineNo;
        }

        public String getText() {
            return this.text;
        }

        public void addEvidence(int renderedLine, int weight) {
            if (!this.evidence.containsKey(renderedLine)) {
                this.evidence.put(renderedLine, 0);
            }
            this.evidence.put(renderedLine, this.evidence.get(renderedLine) + weight);
        }

        public int computeBestRenderedLine() {
            int bestLine = -1;
            int bestEvidence = 0;
            for (int renderedLine : this.evidence.keySet()) {
                if (this.evidence.get(renderedLine) <= bestEvidence) continue;
                bestLine = renderedLine;
                bestEvidence = this.evidence.get(renderedLine);
            }
            return bestLine;
        }
    }
}

