/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.commons.notification;

import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import javax.jcr.Value;
import javax.mail.internet.AddressException;
import javax.mail.internet.InternetAddress;
import org.apache.commons.lang.StringUtils;
import org.exoplatform.commons.api.notification.plugin.config.TemplateConfig;
import org.exoplatform.commons.api.notification.template.Element;
import org.exoplatform.commons.notification.template.DigestTemplate;
import org.exoplatform.commons.notification.template.SimpleElement;
import org.exoplatform.commons.notification.template.TemplateUtils;
import org.exoplatform.container.xml.InitParams;

public class NotificationUtils {
    public static final String DEFAULT_SUBJECT_KEY = "Notification.subject.{0}";
    public static final String DEFAULT_SIMPLE_DIGEST_KEY = "Notification.digest.{0}";
    public static final String DEFAULT_DIGEST_ONE_KEY = "Notification.digest.one.{0}";
    public static final String DEFAULT_DIGEST_THREE_KEY = "Notification.digest.three.{0}";
    public static final String DEFAULT_DIGEST_MORE_KEY = "Notification.digest.more.{0}";
    public static final String FEATURE_NAME = "notification";

    public static String getDefaultKey(String key, String providerId) {
        return MessageFormat.format(key, providerId);
    }

    public static DigestTemplate getDigest(TemplateConfig templateConfig, String pluginId, String language) {
        String srcResource = templateConfig.getBundlePath();
        String digestOneKey = templateConfig.getKeyValue("digest.one", NotificationUtils.getDefaultKey(DEFAULT_DIGEST_ONE_KEY, pluginId));
        String digestThreeKey = templateConfig.getKeyValue("digest.three", NotificationUtils.getDefaultKey(DEFAULT_DIGEST_THREE_KEY, pluginId));
        String digestMoreKey = templateConfig.getKeyValue("digest.more", NotificationUtils.getDefaultKey(DEFAULT_DIGEST_MORE_KEY, pluginId));
        Locale locale = new Locale(language);
        return new DigestTemplate().digestOne(TemplateUtils.getResourceBundle(digestOneKey, locale, srcResource)).digestThree(TemplateUtils.getResourceBundle(digestThreeKey, locale, srcResource)).digestMore(TemplateUtils.getResourceBundle(digestMoreKey, locale, srcResource));
    }

    public static Element getSubject(TemplateConfig templateConfig, String pluginId, String language) {
        String bundlePath = templateConfig.getBundlePath();
        String subjectKey = templateConfig.getKeyValue("subject", NotificationUtils.getDefaultKey(DEFAULT_SUBJECT_KEY, pluginId));
        Locale locale = new Locale(language);
        return new SimpleElement().language(locale.getLanguage()).template(TemplateUtils.getResourceBundle(subjectKey, locale, bundlePath));
    }

    public static String listToString(List<String> list) {
        if (list == null || list.size() == 0) {
            return "";
        }
        StringBuffer values = new StringBuffer();
        for (String str : list) {
            if (values.length() > 0) {
                values.append(",");
            }
            values.append(str);
        }
        return values.toString();
    }

    public static String[] valuesToArray(Value[] values) throws Exception {
        if (values.length < 1) {
            return new String[0];
        }
        List<String> list = NotificationUtils.valuesToList(values);
        return list.toArray(new String[list.size()]);
    }

    public static List<String> valuesToList(Value[] values) throws Exception {
        ArrayList<String> list = new ArrayList<String>();
        if (values.length < 1) {
            return list;
        }
        for (int i = 0; i < values.length; ++i) {
            String s = values[i].getString();
            if (s == null || s.trim().length() <= 0) continue;
            list.add(s);
        }
        return list;
    }

    public static String getValueParam(InitParams params, String key, String defaultValue) {
        try {
            return params.getValueParam(key).getValue();
        }
        catch (Exception e) {
            return defaultValue;
        }
    }

    public static int getValueParam(InitParams params, String key, int defaultValue) {
        try {
            return Integer.valueOf(params.getValueParam(key).getValue());
        }
        catch (Exception e) {
            return defaultValue;
        }
    }

    public static String getSystemValue(InitParams params, String systemKey, String paramKey, String defaultValue) {
        try {
            String vl = System.getProperty(systemKey);
            if (vl == null || vl.length() == 0) {
                vl = NotificationUtils.getValueParam(params, paramKey, defaultValue);
            }
            return vl.trim();
        }
        catch (Exception e) {
            return defaultValue;
        }
    }

    public static int getSystemValue(InitParams params, String systemKey, String paramKey, int defaultValue) {
        return Integer.valueOf(NotificationUtils.getSystemValue(params, systemKey, paramKey, String.valueOf(defaultValue)));
    }

    public static boolean isValidEmailAddresses(String addressList) {
        if (addressList == null || addressList.length() < 0) {
            return false;
        }
        addressList = StringUtils.remove((String)addressList, (String)" ");
        addressList = StringUtils.replace((String)addressList, (String)";", (String)",");
        try {
            InternetAddress[] iAdds = InternetAddress.parse((String)addressList, (boolean)true);
            String emailRegex = "[_A-Za-z0-9-]+(\\.[_A-Za-z0-9-]+)*@[_A-Za-z0-9-.]+\\.[A-Za-z]{2,5}";
            for (int i = 0; i < iAdds.length; ++i) {
                if (iAdds[i].getAddress().matches(emailRegex)) continue;
                return false;
            }
        }
        catch (AddressException e) {
            return false;
        }
        return true;
    }
}

