/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.commons.notification.impl;

import org.exoplatform.commons.api.notification.stat.EntityStatistics;
import org.exoplatform.commons.api.notification.stat.PluginStatistics;
import org.exoplatform.commons.api.notification.stat.QueryStatistics;
import org.exoplatform.commons.api.notification.stat.QueueStatistics;
import org.exoplatform.commons.api.notification.stat.Statistics;
import org.exoplatform.commons.api.notification.stat.StatisticsCollector;
import org.exoplatform.commons.notification.impl.PluginStatisticService;
import org.exoplatform.commons.notification.stat.ThreadLocalStatisticsImpl;
import org.exoplatform.commons.utils.PrivilegedSystemHelper;
import org.exoplatform.management.annotations.Managed;
import org.exoplatform.management.annotations.ManagedDescription;
import org.exoplatform.management.jmx.annotations.NameTemplate;
import org.exoplatform.management.jmx.annotations.Property;
import org.picocontainer.Startable;

@Managed
@NameTemplate(value={@Property(key="service", value="notification"), @Property(key="view", value="statistic")})
@ManagedDescription(value="Social notifiaction statistics service.")
public class StatisticsService
implements Startable {
    private final Statistics stats;

    public StatisticsService(PluginStatisticService pluginStatisticService) {
        this.stats = new ThreadLocalStatisticsImpl(pluginStatisticService);
    }

    public Statistics getStatistics() {
        return this.stats;
    }

    public StatisticsCollector getStatisticsCollector() {
        return (StatisticsCollector)this.stats;
    }

    @Managed
    @ManagedDescription(value="Gets notification statistice is enabled")
    public boolean isStatisticsEnabled() {
        return this.stats.isStatisticsEnabled();
    }

    @Managed
    @ManagedDescription(value="Set notification statistice is enabled or disabled: TRUE | FALSE")
    public void setStatisticsEnabled(boolean enable) {
        this.stats.setStatisticsEnabled(enable);
    }

    @Managed
    @ManagedDescription(value="Set notification statistice is enabled.")
    public void activeStatistics() {
        this.stats.setStatisticsEnabled(true);
    }

    @Managed
    @ManagedDescription(value="Set notification statistice is disabled.")
    public void deactiveStatistics() {
        this.stats.setStatisticsEnabled(false);
    }

    @Managed
    @ManagedDescription(value="Reset statistics information")
    public void clear() {
        this.stats.clear();
    }

    @Managed
    @ManagedDescription(value="Gets plugin statistics by pluginId")
    public PluginStatistics getPluginStatistics(String pluginId) {
        return this.stats.getPluginStatistics(pluginId);
    }

    @Managed
    @ManagedDescription(value="Gets entity statistics by nodetype")
    public EntityStatistics getEntityStatistics(String nodeType) {
        return this.stats.getEntityStatistics(nodeType);
    }

    @Managed
    @ManagedDescription(value="Gets queue statistics by pluginId")
    public QueueStatistics getQueueStatistics(String pluginId) {
        return this.stats.getQueueStatistics(pluginId);
    }

    @Managed
    @ManagedDescription(value="Gets query statistics by pluginId")
    public QueryStatistics getQueryStatistics(String queryString) {
        return this.stats.getQueryStatistics(queryString);
    }

    @Managed
    @ManagedDescription(value="Gets message info created count")
    public long getMessageCreatedCount() {
        return this.stats.getMessageCreatedCount();
    }

    @Managed
    @ManagedDescription(value="Gets notification info created count")
    public long getNotificationCreatedCount() {
        return this.stats.getNotificationCreatedCount();
    }

    @Managed
    @ManagedDescription(value="Gets digest info created count")
    public long getDigestCreatedCount() {
        return this.stats.getDigestCreatedCount();
    }

    @Managed
    @ManagedDescription(value="Gets entity deleted count")
    public long getEntityDeleteCount() {
        return this.stats.getEntityDeleteCount();
    }

    @Managed
    @ManagedDescription(value="Gets entity load count")
    public long getEntityLoadCount() {
        return this.stats.getEntityLoadCount();
    }

    @Managed
    @ManagedDescription(value="Gets entity insert count")
    public long getEntityInsertCount() {
        return this.stats.getEntityInsertCount();
    }

    @Managed
    @ManagedDescription(value="Gets execute query count")
    public long getQueryExecutionCount() {
        return this.stats.getQueryExecutionCount();
    }

    @Managed
    @ManagedDescription(value="Gets execute query max time")
    public long getQueryExecutionMaxTime() {
        return this.stats.getQueryExecutionMaxTime();
    }

    @Managed
    @ManagedDescription(value="Gets execute query statement longest time")
    public String getQueryExecutionMaxTimeQueryString() {
        return this.stats.getQueryExecutionMaxTimeQueryString();
    }

    @Managed
    @ManagedDescription(value="Gets queue put count")
    public long getQueuePutCount() {
        return this.stats.getQueuePutCount();
    }

    @Managed
    @ManagedDescription(value="Gets queue poll count")
    public long getQueuePollCount() {
        return this.stats.getQueuePollCount();
    }

    @Managed
    @ManagedDescription(value="Gets all queue statement have been executed")
    public String[] getQueries() {
        return this.stats.getQueries();
    }

    @Managed
    @ManagedDescription(value="Gets all pluginIds have been executed")
    public String[] getPluginNames() {
        return this.stats.getPluginNames();
    }

    @Managed
    @ManagedDescription(value="Gets start time of statistics.")
    public long getStartTime() {
        return this.stats.getStartTime();
    }

    public void start() {
        boolean stats = "true".equalsIgnoreCase(PrivilegedSystemHelper.getProperty((String)"exo.social.notification.statistics.active", (String)"false"));
        this.setStatisticsEnabled(stats);
    }

    public void stop() {
    }
}

