/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.commons.notification.impl.service.template;

import java.io.StringWriter;
import java.io.Writer;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.exoplatform.commons.api.notification.NotificationContext;
import org.exoplatform.commons.api.notification.model.MessageInfo;
import org.exoplatform.commons.api.notification.model.NotificationInfo;
import org.exoplatform.commons.api.notification.model.NotificationKey;
import org.exoplatform.commons.api.notification.model.UserSetting;
import org.exoplatform.commons.api.notification.plugin.AbstractNotificationPlugin;
import org.exoplatform.commons.api.notification.plugin.NotificationPluginUtils;
import org.exoplatform.commons.api.notification.service.setting.PluginSettingService;
import org.exoplatform.commons.api.notification.service.template.DigestorService;
import org.exoplatform.commons.api.notification.service.template.TemplateContext;
import org.exoplatform.commons.notification.NotificationConfiguration;
import org.exoplatform.commons.notification.NotificationContextFactory;
import org.exoplatform.commons.notification.impl.NotificationContextImpl;
import org.exoplatform.commons.notification.impl.setting.NotificationPluginContainer;
import org.exoplatform.commons.notification.template.TemplateUtils;
import org.exoplatform.commons.utils.CommonsUtils;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.webui.utils.TimeConvertUtils;

public class DigestorServiceImpl
implements DigestorService {
    private static final Log LOG = ExoLogger.getLogger(DigestorServiceImpl.class);

    public MessageInfo buildMessage(Map<NotificationKey, List<NotificationInfo>> notificationData, UserSetting userSetting) {
        MessageInfo messageInfo = null;
        if (notificationData == null || notificationData.size() == 0) {
            return messageInfo;
        }
        long startTime = System.currentTimeMillis();
        try {
            messageInfo = new MessageInfo();
            PluginSettingService pluginService = CommonsUtils.getService(PluginSettingService.class);
            NotificationPluginContainer containerService = CommonsUtils.getService(NotificationPluginContainer.class);
            NotificationConfiguration configuration = CommonsUtils.getService(NotificationConfiguration.class);
            List activeProviders = pluginService.getActivePluginIds();
            NotificationContext nCtx = NotificationContextImpl.cloneInstance();
            int totalDigestMsg = 0;
            for (String providerId : activeProviders) {
                List<NotificationInfo> messages = notificationData.get(NotificationKey.key((String)providerId));
                if (messages == null || messages.size() == 0) continue;
                totalDigestMsg += messages.size();
            }
            StringWriter writer = new StringWriter();
            if (totalDigestMsg < 1) {
                return null;
            }
            if (totalDigestMsg == 1) {
                ((Writer)writer).append("<ul style=\"margin: 0 0  40px -13px; list-style-type: none; padding-left: 0; color: #2F5E92; \">");
            } else {
                ((Writer)writer).append("<ul style=\"margin: 0 0  40px; padding-left: 0; color: #2F5E92; list-style-position: outside;  list-style: disc; \">");
            }
            for (String providerId : activeProviders) {
                List<NotificationInfo> messages = notificationData.get(NotificationKey.key((String)providerId));
                if (messages == null || messages.size() == 0) continue;
                AbstractNotificationPlugin plugin = containerService.getPlugin(NotificationKey.key((String)providerId));
                nCtx.setNotificationInfos(messages);
                plugin.buildDigest(nCtx, (Writer)writer);
            }
            ((Writer)writer).append("</ul>");
            StringBuffer sb = writer.getBuffer();
            if (sb.length() == 0) {
                return null;
            }
            DigestInfo digestInfo = new DigestInfo(configuration, userSetting);
            TemplateContext ctx = new TemplateContext(digestInfo.getPluginId(), digestInfo.getLocale().getLanguage());
            ctx.put((Object)"FIRSTNAME", (Object)digestInfo.getFirstName());
            ctx.put((Object)"PORTAL_NAME", (Object)digestInfo.getPortalName());
            ctx.put((Object)"PORTAL_HOME", (Object)digestInfo.getPortalHome());
            ctx.put((Object)"PERIOD", (Object)digestInfo.getPeriodType());
            ctx.put((Object)"FROM_TO", (Object)digestInfo.getFromTo());
            String subject = TemplateUtils.processSubject(ctx);
            ctx.put((Object)"FOOTER_LINK", (Object)digestInfo.getFooterLink());
            ctx.put((Object)"DIGEST_MESSAGES_LIST", (Object)sb.toString());
            String body = TemplateUtils.processGroovy(ctx);
            messageInfo.from(NotificationPluginUtils.getFrom(null)).subject(subject).body(body).to(digestInfo.getSendTo());
        }
        catch (Exception e) {
            LOG.error((Object)"Can not build template of DigestorProviderImpl ", (Throwable)e);
            return null;
        }
        LOG.info((Object)("End build template of DigestorProviderImpl ... " + (System.currentTimeMillis() - startTime) + " ms"));
        boolean stats = NotificationContextFactory.getInstance().getStatistics().isStatisticsEnabled();
        if (stats) {
            NotificationContextFactory.getInstance().getStatisticsCollector().createDigestCount(messageInfo.getPluginId());
        }
        return messageInfo;
    }

    private class DigestInfo {
        private String firstName;
        private String portalName;
        private String portalHome;
        private String sendTo;
        private String footerLink;
        private String fromTo;
        private String periodType;
        private String pluginId;
        private Locale locale;
        private boolean isWeekly;

        public DigestInfo(NotificationConfiguration configuration, UserSetting userSetting) {
            this.periodType = this.fromTo = "Today";
            this.pluginId = "DigestDailyPlugin";
            this.firstName = NotificationPluginUtils.getFirstName((String)userSetting.getUserId());
            this.sendTo = NotificationPluginUtils.getTo((String)userSetting.getUserId());
            this.portalName = NotificationPluginUtils.getBrandingPortalName();
            this.portalHome = NotificationPluginUtils.getPortalHome((String)this.portalName);
            this.footerLink = NotificationPluginUtils.getProfileUrl((String)userSetting.getUserId());
            String language = NotificationPluginUtils.getLanguage((String)userSetting.getUserId());
            this.locale = language == null || language.length() == 0 ? Locale.ENGLISH : new Locale(language);
            boolean bl = this.isWeekly = configuration.isSendWeekly() && userSetting.getWeeklyProviders().size() > 0;
            if (this.isWeekly) {
                this.pluginId = "DigestWeeklyPlugin";
                this.periodType = "Weekly";
                Calendar periodFrom = userSetting.getLastUpdateTime();
                long t = System.currentTimeMillis() - 604800000L;
                if (t > periodFrom.getTimeInMillis()) {
                    periodFrom.setTimeInMillis(t);
                }
                StringBuffer buffer = new StringBuffer();
                buffer.append(TimeConvertUtils.getFormatDate((Date)periodFrom.getTime(), (String)"mmmm dd", (Locale)this.locale)).append(" - ").append(TimeConvertUtils.getFormatDate((Date)Calendar.getInstance().getTime(), (String)"mmmm dd, yyyy", (Locale)this.locale));
                this.fromTo = buffer.toString();
            }
        }

        public String getFromTo() {
            return this.fromTo;
        }

        public String getPeriodType() {
            return this.periodType;
        }

        public String getPluginId() {
            return this.pluginId;
        }

        public Locale getLocale() {
            return this.locale;
        }

        public String getFirstName() {
            return this.firstName;
        }

        public String getPortalName() {
            return this.portalName;
        }

        public String getPortalHome() {
            return this.portalHome;
        }

        public String getSendTo() {
            return this.sendTo;
        }

        public String getFooterLink() {
            return this.footerLink;
        }
    }
}

