/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.commons.notification.impl.setting;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import javax.jcr.Node;
import org.exoplatform.commons.api.notification.model.GroupProvider;
import org.exoplatform.commons.api.notification.model.PluginInfo;
import org.exoplatform.commons.api.notification.plugin.GroupProviderPlugin;
import org.exoplatform.commons.api.notification.plugin.config.GroupConfig;
import org.exoplatform.commons.api.notification.plugin.config.PluginConfig;
import org.exoplatform.commons.api.notification.service.setting.PluginSettingService;
import org.exoplatform.commons.api.settings.SettingService;
import org.exoplatform.commons.api.settings.SettingValue;
import org.exoplatform.commons.api.settings.data.Context;
import org.exoplatform.commons.api.settings.data.Scope;
import org.exoplatform.commons.notification.NotificationConfiguration;
import org.exoplatform.commons.notification.impl.AbstractService;
import org.exoplatform.commons.utils.CommonsUtils;
import org.exoplatform.services.jcr.ext.common.SessionProvider;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;

public class PluginSettingServiceImpl
extends AbstractService
implements PluginSettingService {
    private static final Log LOG = ExoLogger.getLogger(PluginSettingServiceImpl.class);
    private List<PluginConfig> pluginConfigs = new ArrayList<PluginConfig>();
    private Map<String, GroupProvider> groupProviderMap = new ConcurrentHashMap<String, GroupProvider>();
    private List<String> activeProviderIds = new ArrayList<String>();
    private List<PluginInfo> activeProviders = new ArrayList<PluginInfo>();
    private static final String NAME_SPACES = "exo:";
    private SettingService settingService;

    public PluginSettingServiceImpl(SettingService settingService) {
        this.settingService = settingService;
    }

    public void registerPluginConfig(PluginConfig pluginConfig) {
        this.pluginConfigs.add(pluginConfig);
        PluginInfo providerData = new PluginInfo();
        providerData.setType(pluginConfig.getPluginId()).setOrder(Integer.valueOf(pluginConfig.getOrder()).intValue()).setActive(this.isActive(pluginConfig.getPluginId(), true)).setResourceBundleKey(pluginConfig.getResourceBundleKey()).setBundlePath(pluginConfig.getTemplateConfig().getBundlePath()).setDefaultConfig(pluginConfig.getDefaultConfig());
        String groupId = pluginConfig.getGroupId();
        GroupConfig gConfig = pluginConfig.getGroupConfig();
        if (gConfig != null) {
            groupId = gConfig.getId();
        }
        if (this.groupProviderMap.containsKey(groupId)) {
            this.groupProviderMap.get(groupId).addProviderData(providerData);
        } else if (groupId != null && groupId.length() > 0) {
            GroupProvider groupProvider = new GroupProvider(groupId);
            groupProvider.addProviderData(providerData);
            if (gConfig != null) {
                groupProvider.setOrder(Integer.valueOf(gConfig.getOrder()).intValue());
                groupProvider.setResourceBundleKey(gConfig.getResourceBundleKey());
            }
            this.groupProviderMap.put(groupId, groupProvider);
        }
        this.createParentNodeOfPlugin(pluginConfig.getPluginId());
    }

    public void registerGroupConfig(GroupProviderPlugin groupConfigPlg) {
        for (GroupConfig gconfig : groupConfigPlg.getGroupProviders()) {
            GroupProvider groupProvider = new GroupProvider(gconfig.getId());
            groupProvider.setOrder(Integer.valueOf(gconfig.getOrder()).intValue());
            groupProvider.setResourceBundleKey(gconfig.getResourceBundleKey());
            if (this.groupProviderMap.containsKey(gconfig.getId())) {
                groupProvider.setProviderDatas(this.groupProviderMap.get(gconfig.getId()).getProviderDatas());
            }
            this.groupProviderMap.put(gconfig.getId(), groupProvider);
        }
    }

    public PluginConfig getPluginConfig(String pluginId) {
        for (PluginConfig pluginConfig : this.pluginConfigs) {
            if (!pluginConfig.getPluginId().equals(pluginId)) continue;
            return pluginConfig;
        }
        return null;
    }

    public List<GroupProvider> getGroupPlugins() {
        ArrayList<GroupProvider> groupProviders = new ArrayList<GroupProvider>();
        for (GroupProvider groupProvider : this.groupProviderMap.values()) {
            for (PluginInfo providerData : groupProvider.getProviderDatas()) {
                providerData.setActive(this.isActive(providerData.getType()));
            }
            groupProviders.add(groupProvider);
        }
        Collections.sort(groupProviders, new ComparatorASC());
        return groupProviders;
    }

    public void savePlugin(String providerId, boolean isActive) {
        this.saveSetting(providerId, isActive);
        this.activeProviderIds.clear();
        this.activeProviders.clear();
    }

    public boolean isActive(String providerId) {
        return this.isActive(providerId, false);
    }

    public List<String> getActivePluginIds() {
        if (this.activeProviderIds.size() == 0) {
            Collections.sort(this.pluginConfigs, new ComparatorASC());
            for (PluginConfig pluginConfig : this.pluginConfigs) {
                if (!this.isActive(pluginConfig.getPluginId())) continue;
                this.activeProviderIds.add(pluginConfig.getPluginId());
            }
        }
        return this.activeProviderIds;
    }

    public List<PluginInfo> getActivePlugins() {
        if (this.activeProviders.size() == 0) {
            for (GroupProvider groupProvider : this.groupProviderMap.values()) {
                for (PluginInfo providerData : groupProvider.getProviderDatas()) {
                    if (!this.isActive(providerData.getType())) continue;
                    this.activeProviders.add(providerData);
                }
            }
        }
        return this.activeProviders;
    }

    private void saveSetting(String property, boolean value) {
        this.settingService.set(Context.GLOBAL, Scope.GLOBAL, NAME_SPACES + property, SettingValue.create((Boolean)value));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void createParentNodeOfPlugin(String pluginId) {
        SessionProvider sProvider = SessionProvider.createSystemProvider();
        try {
            NotificationConfiguration configuration = CommonsUtils.getService(NotificationConfiguration.class);
            Node node = this.getOrCreateMessageParent(sProvider, configuration.getWorkspace(), pluginId);
            PluginSettingServiceImpl.sessionSave(node);
        }
        catch (Exception e) {
            LOG.error((Object)("Failed to create parent Node for plugin " + pluginId));
        }
        finally {
            sProvider.close();
        }
    }

    private boolean isActive(String providerId, boolean defaultValue) {
        if (providerId == null || providerId.length() == 0) {
            return false;
        }
        SettingValue sValue = this.settingService.get(Context.GLOBAL, Scope.GLOBAL, NAME_SPACES + providerId);
        if (sValue != null) {
            return (Boolean)sValue.getValue() != false;
        }
        if (defaultValue) {
            this.saveSetting(providerId, true);
        }
        return defaultValue;
    }

    private class ComparatorASC
    implements Comparator<Object> {
        private ComparatorASC() {
        }

        @Override
        public int compare(Object o1, Object o2) {
            if (o1 instanceof GroupProvider) {
                Integer order1 = ((GroupProvider)o1).getOrder();
                Integer order2 = ((GroupProvider)o2).getOrder();
                return order1.compareTo(order2);
            }
            if (o1 instanceof PluginConfig) {
                Integer order1 = Integer.valueOf(((PluginConfig)o1).getOrder());
                Integer order2 = Integer.valueOf(((PluginConfig)o2).getOrder());
                return order1.compareTo(order2);
            }
            return 0;
        }
    }
}

