/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.commons.notification.job.mbeans;

import org.exoplatform.commons.api.notification.service.storage.NotificationService;
import org.exoplatform.commons.notification.NotificationConfiguration;
import org.exoplatform.commons.utils.CommonsUtils;
import org.exoplatform.groovyscript.GroovyTemplate;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.quartz.Job;
import org.quartz.JobDataMap;
import org.quartz.JobExecutionContext;
import org.quartz.JobExecutionException;
import org.quartz.PersistJobDataAfterExecution;

@PersistJobDataAfterExecution
public class NotificationDigestJob
implements Job {
    private final Log LOG = ExoLogger.getLogger(NotificationDigestJob.class);

    public NotificationDigestJob() {
        try {
            new GroovyTemplate("");
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void execute(JobExecutionContext context) throws JobExecutionException {
        try {
            long startTime = System.currentTimeMillis();
            JobDataMap data = context.getJobDetail().getJobDataMap();
            String digestType = data.getString("digest");
            if ("daily".equals(digestType)) {
                this.LOG.info((Object)"Starting run DailyJob to send daily email notification ... ");
                CommonsUtils.getService(NotificationConfiguration.class).setSendWeekly(false);
                CommonsUtils.getService(NotificationService.class).processDigest();
            } else if ("weekly".equals(digestType)) {
                this.LOG.info((Object)"Starting run WeeklyJob to send weekly email notification ... ");
                CommonsUtils.getService(NotificationConfiguration.class).setSendWeekly(true);
                CommonsUtils.getService(NotificationService.class).processDigest();
            }
            long endTime = System.currentTimeMillis();
            data.put("duration", (endTime - startTime) / 1000L);
            String countKey = "count";
            if (data.containsKey((Object)countKey)) {
                data.put(countKey, data.getInt(countKey) + 1);
            } else {
                data.put(countKey, 1);
            }
        }
        catch (Exception e) {
            this.LOG.error((Object)"DailyJob exception: ", (Throwable)e);
        }
    }
}

