/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.commons.notification.template;

import java.io.IOException;
import java.io.InputStream;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Scanner;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import javax.servlet.ServletContext;
import org.exoplatform.commons.utils.CommonsUtils;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.services.resources.ResourceBundleData;
import org.exoplatform.services.resources.ResourceBundleService;
import org.gatein.wci.WebApp;
import org.gatein.wci.WebAppEvent;
import org.gatein.wci.WebAppLifeCycleEvent;
import org.gatein.wci.WebAppListener;

public class ResourceBundleConfigDeployer
implements WebAppListener {
    private static final Log LOG = ExoLogger.getLogger(ResourceBundleConfigDeployer.class);
    ResourceBundleService bundleService;
    private static final String CONF_LOCATION = "/WEB-INF/classes/";
    private static final String FILE_EXTENSION_PROPERTIES = ".properties";
    private Map<String, String> dataResourceBundle = new ConcurrentHashMap<String, String>();
    private final Map<String, WebApp> contexts;

    public ResourceBundleConfigDeployer() {
        this.bundleService = CommonsUtils.getService(ResourceBundleService.class);
        this.contexts = new HashMap<String, WebApp>();
    }

    public void onEvent(WebAppEvent event) {
        if (event instanceof WebAppLifeCycleEvent) {
            WebAppLifeCycleEvent lifeCycleEvent = (WebAppLifeCycleEvent)event;
            switch (lifeCycleEvent.getType()) {
                case 1: {
                    this.add(event.getWebApp());
                    break;
                }
                case 0: {
                    this.remove(event.getWebApp());
                }
            }
        }
    }

    private void remove(WebApp webApp) {
        this.contexts.remove(webApp.getContextPath());
    }

    private void add(WebApp webApp) {
        this.contexts.put(webApp.getContextPath(), webApp);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void initBundlePath(Collection<String> list) {
        try {
            for (String path : list) {
                for (WebApp app : this.contexts.values()) {
                    this.initBundle(app.getServletContext(), path);
                }
            }
        }
        catch (Exception e) {
            LOG.debug((Object)"Error when initializing resource bundle of Notification.", (Throwable)e);
        }
        finally {
            this.addAllResourcebundle();
        }
    }

    private void initBundle(ServletContext servletCtx, String path) {
        Set paths = servletCtx.getResourcePaths(this.getPathFile(path));
        if (paths != null) {
            for (String rsLocation : paths) {
                if (rsLocation == null || rsLocation.indexOf(path.replace(".", "/")) < 0) continue;
                try {
                    InputStream is = servletCtx.getResourceAsStream(rsLocation);
                    String lang = this.getLang(rsLocation.replace(FILE_EXTENSION_PROPERTIES, ""));
                    this.addResourceBundle(is, lang, path);
                }
                catch (IOException e) {
                    LOG.debug((Object)("Error when initializing resource bundle: " + path), (Throwable)e);
                }
            }
        }
    }

    private String getPathFile(String path) {
        return new StringBuffer(CONF_LOCATION).append(path.substring(0, path.lastIndexOf(".")).replace(".", "/")).toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addResourceBundle(InputStream is, String lang, String resourceLocale) throws IOException {
        try {
            if (is != null) {
                String key = this.getKey(lang, resourceLocale);
                StringBuilder value = ResourceBundleConfigDeployer.getContent(is);
                if (this.dataResourceBundle.containsKey(key)) {
                    value.append("\n").append(this.dataResourceBundle.get(key));
                }
                this.dataResourceBundle.put(key, value.toString());
            }
        }
        catch (Exception e) {
            LOG.debug((Object)("Error when initializing resource bundle: " + resourceLocale), (Throwable)e);
        }
        finally {
            if (is != null) {
                is.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static StringBuilder getContent(InputStream input) throws IOException {
        StringBuilder content = new StringBuilder();
        Scanner scanner = new Scanner(input, "UTF-8");
        try {
            while (scanner.hasNextLine()) {
                if (content.length() > 0) {
                    content.append("\n");
                }
                String s = scanner.nextLine();
                content.append(s);
            }
        }
        finally {
            scanner.close();
            input.close();
        }
        return content;
    }

    private void addAllResourcebundle() {
        for (String key : this.dataResourceBundle.keySet()) {
            ResourceBundleData bundleData = new ResourceBundleData(this.dataResourceBundle.get(key));
            bundleData.setLanguage(this.getLang(key));
            bundleData.setName(this.getResourceLocale(key));
            bundleData.setCountry("");
            bundleData.setVariant("");
            this.bundleService.saveResourceBundle(bundleData);
        }
        this.dataResourceBundle.clear();
    }

    private String getKey(String lang, String resourceLocale) {
        return new StringBuffer(resourceLocale).append("_").append(lang).toString();
    }

    private String getLang(String key) {
        String[] strs = key.split("_");
        return strs[strs.length - 1];
    }

    private String getResourceLocale(String key) {
        return key.replace("_" + this.getLang(key), "");
    }
}

