/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.commons.utils;

import org.exoplatform.commons.api.settings.ExoFeatureService;
import org.exoplatform.container.ExoContainer;
import org.exoplatform.container.ExoContainerContext;
import org.exoplatform.container.PortalContainer;
import org.exoplatform.container.RootContainer;
import org.exoplatform.container.definition.PortalContainerConfig;
import org.exoplatform.container.xml.PortalContainerInfo;
import org.exoplatform.services.jcr.RepositoryService;
import org.exoplatform.services.jcr.core.ManageableRepository;
import org.exoplatform.services.jcr.ext.app.SessionProviderService;
import org.exoplatform.services.jcr.ext.common.SessionProvider;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;

public class CommonsUtils {
    private static final Log LOG = ExoLogger.getLogger((String)CommonsUtils.class.getName());

    public static SessionProvider getSystemSessionProvider() {
        SessionProviderService sessionProviderService = CommonsUtils.getService(SessionProviderService.class);
        SessionProvider sessionProvider = sessionProviderService.getSystemSessionProvider(null);
        return sessionProvider;
    }

    public static SessionProvider getUserSessionProvider() {
        SessionProviderService sessionProviderService = CommonsUtils.getService(SessionProviderService.class);
        SessionProvider sessionProvider = sessionProviderService.getSessionProvider(null);
        return sessionProvider;
    }

    public static <T> T getService(Class<T> clazz) {
        return CommonsUtils.getService(clazz, null);
    }

    public static <T> T getService(Class<T> clazz, String containerName) {
        ExoContainer container = ExoContainerContext.getCurrentContainer();
        if (containerName != null) {
            container = RootContainer.getInstance().getPortalContainer(containerName);
        }
        if (container.getComponentInstanceOfType(clazz) == null) {
            containerName = PortalContainer.getCurrentPortalContainerName();
            container = RootContainer.getInstance().getPortalContainer(containerName);
        }
        return clazz.cast(container.getComponentInstanceOfType(clazz));
    }

    public static ManageableRepository getRepository() {
        try {
            RepositoryService repositoryService = CommonsUtils.getService(RepositoryService.class);
            return repositoryService.getCurrentRepository();
        }
        catch (Exception e) {
            if (LOG.isErrorEnabled()) {
                LOG.error((Object)"getRepository() failed because of ", (Throwable)e);
            }
            return null;
        }
    }

    public static String getRestContextName() {
        ExoContainer container = ExoContainerContext.getCurrentContainer();
        PortalContainerConfig portalContainerConfig = (PortalContainerConfig)container.getComponentInstance(PortalContainerConfig.class);
        PortalContainerInfo containerInfo = (PortalContainerInfo)container.getComponentInstanceOfType(PortalContainerInfo.class);
        return portalContainerConfig.getRestContextName(containerInfo.getContainerName());
    }

    public static boolean isFeatureActive(String featureName) {
        ExoFeatureService featureService = CommonsUtils.getService(ExoFeatureService.class);
        return featureService.isActiveFeature(featureName);
    }
}

