/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.user;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import javax.jcr.Node;
import javax.jcr.Session;
import org.exoplatform.commons.utils.CommonsUtils;
import org.exoplatform.container.PortalContainer;
import org.exoplatform.services.cache.CacheService;
import org.exoplatform.services.cache.ExoCache;
import org.exoplatform.services.jcr.RepositoryService;
import org.exoplatform.services.jcr.ext.common.SessionProvider;
import org.exoplatform.services.jcr.ext.hierarchy.NodeHierarchyCreator;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.services.security.ConversationState;
import org.exoplatform.services.user.UserStateModel;

public class UserStateService {
    private static final Log LOG = ExoLogger.getLogger((String)UserStateService.class.getName());
    public static String VIDEOCALLS_BASE_PATH = "VideoCalls";
    public static String USER_STATATUS_NODETYPE = "exo:userState";
    public static String USER_ID_PROP = "exo:userId";
    public static String LAST_ACTIVITY_PROP = "exo:lastActivity";
    public static String STATUS_PROP = "exo:status";
    public static String DEFAULT_STATUS = "available";
    public int delay = 60000;
    public static final int _delay_update_DB = 180000;
    public static int pingCounter = 0;
    private static CacheService cacheService;

    public UserStateService(CacheService cacheService) {
        UserStateService.cacheService = cacheService;
        if (System.getProperty("user.status.offline.delay") != null) {
            this.delay = Integer.parseInt(System.getProperty("user.status.offline.delay"));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void save(UserStateModel model) {
        String userId = model.getUserId();
        String status = model.getStatus();
        long lastActivity = model.getLastActivity();
        SessionProvider sessionProvider = new SessionProvider(ConversationState.getCurrent());
        NodeHierarchyCreator nodeHierarchyCreator = CommonsUtils.getService(NodeHierarchyCreator.class);
        try {
            RepositoryService repositoryService = (RepositoryService)PortalContainer.getInstance().getComponentInstanceOfType(RepositoryService.class);
            Session session = sessionProvider.getSession(repositoryService.getCurrentRepository().getConfiguration().getDefaultWorkspaceName(), repositoryService.getCurrentRepository());
            String repoName = repositoryService.getCurrentRepository().getConfiguration().getName();
            Node userNodeApp = nodeHierarchyCreator.getUserApplicationNode(sessionProvider, userId);
            String userKey = repoName + "_" + userId;
            if (!userNodeApp.hasNode(VIDEOCALLS_BASE_PATH)) {
                userNodeApp.addNode(VIDEOCALLS_BASE_PATH, USER_STATATUS_NODETYPE);
                userNodeApp.save();
            }
            Node userState = userNodeApp.getNode(VIDEOCALLS_BASE_PATH);
            userState.setProperty(USER_ID_PROP, userId);
            userState.setProperty(LAST_ACTIVITY_PROP, lastActivity);
            userState.setProperty(STATUS_PROP, status);
            session.save();
            ExoCache<Serializable, UserStateModel> cache = this.getUserStateCache();
            if (cache == null) {
                LOG.warn("Cant save user state of {} to cache", new Object[]{userId});
            } else {
                cache.put((Serializable)((Object)userKey), (Object)model);
            }
        }
        catch (Exception ex) {
            if (LOG.isErrorEnabled()) {
                LOG.error((Object)"save() failed because of ", (Throwable)ex);
            }
        }
        finally {
            sessionProvider.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public UserStateModel getUserState(String userId) {
        UserStateModel model = null;
        String repoName = CommonsUtils.getRepository().getConfiguration().getName();
        String userKey = repoName + "_" + userId;
        ExoCache<Serializable, UserStateModel> userStateCache = this.getUserStateCache();
        if (userStateCache != null && userStateCache.get((Serializable)((Object)userKey)) != null) {
            model = ((UserStateModel)userStateCache.get((Serializable)((Object)userKey))).clone();
        } else {
            SessionProvider sessionProvider = new SessionProvider(ConversationState.getCurrent());
            NodeHierarchyCreator nodeHierarchyCreator = CommonsUtils.getService(NodeHierarchyCreator.class);
            Node userNodeApp = null;
            try {
                userNodeApp = nodeHierarchyCreator.getUserApplicationNode(sessionProvider, userId);
            }
            catch (Exception e) {
                // empty catch block
            }
            try {
                if (userNodeApp == null || !userNodeApp.hasNode(VIDEOCALLS_BASE_PATH)) {
                    UserStateModel e = null;
                    return e;
                }
                Node userState = userNodeApp.getNode(VIDEOCALLS_BASE_PATH);
                model = new UserStateModel();
                model.setUserId(userState.getProperty(USER_ID_PROP).getString());
                model.setLastActivity(Integer.parseInt(userState.getProperty(LAST_ACTIVITY_PROP).getString()));
                model.setStatus(userState.getProperty(STATUS_PROP).getString());
                userStateCache.put((Serializable)((Object)userKey), (Object)model);
            }
            catch (Exception ex) {
                if (LOG.isErrorEnabled()) {
                    LOG.error("getUserState() failed because of ", new Object[]{ex.getMessage()});
                }
            }
            finally {
                sessionProvider.close();
            }
        }
        return model;
    }

    public void ping(String userId) {
        String status = DEFAULT_STATUS;
        String repoName = CommonsUtils.getRepository().getConfiguration().getName();
        String userKey = repoName + "_" + userId;
        ExoCache<Serializable, UserStateModel> userStateCache = this.getUserStateCache();
        if (userStateCache != null && userStateCache.get((Serializable)((Object)userKey)) != null) {
            status = ((UserStateModel)userStateCache.get((Serializable)((Object)userKey))).getStatus();
        }
        UserStateModel model = this.getUserState(userId);
        long lastActivity = new Date().getTime();
        if (model != null && lastActivity - model.getLastActivity() > 180000L) {
            model.setLastActivity(lastActivity);
            this.save(model);
        } else {
            model = new UserStateModel();
            model.setLastActivity(lastActivity);
            model.setUserId(userId);
            model.setStatus(status);
            userStateCache.put((Serializable)((Object)userKey), (Object)model);
        }
    }

    public List<UserStateModel> online() {
        ArrayList<UserStateModel> onlineUsers = new ArrayList<UserStateModel>();
        List users = null;
        try {
            ExoCache<Serializable, UserStateModel> userStateCache = this.getUserStateCache();
            if (userStateCache == null) {
                LOG.warn((Object)"Cant get online users list from cache. Will return an empty list.");
                return new ArrayList<UserStateModel>();
            }
            users = userStateCache.getCachedObjects();
            for (UserStateModel userStateModel : users) {
                int iDate = (int)new Date().getTime();
                if (userStateModel.getLastActivity() < (long)(iDate - this.delay)) continue;
                onlineUsers.add(userStateModel);
            }
        }
        catch (Exception e) {
            LOG.error((Object)"Exception when getting online user: {}", (Throwable)e);
        }
        return onlineUsers;
    }

    private ExoCache<Serializable, UserStateModel> getUserStateCache() {
        return cacheService.getCacheInstance(UserStateService.class.getName() + CommonsUtils.getRepository().getConfiguration().getName());
    }
}

