/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.ed.ph.snuggletex;

import uk.ac.ed.ph.snuggletex.SnuggleRuntimeException;
import uk.ac.ed.ph.snuggletex.WebPageOutputOptions;
import uk.ac.ed.ph.snuggletex.internal.util.ConstraintUtilities;

public final class WebPageOutputOptionsTemplates {
    public static final String DEFAULT_CONTENT_TYPE = "application/xhtml+xml";
    public static final String DEFAULT_ENCODING = "UTF-8";
    public static final String DEFAULT_LANG = "en";

    public static WebPageOutputOptions createWebPageOptions(WebPageOutputOptions.WebPageType webPageType) {
        ConstraintUtilities.ensureNotNull((Object)webPageType, "webPageType");
        WebPageOutputOptions options = new WebPageOutputOptions();
        options.setWebPageType(webPageType);
        switch (webPageType) {
            case MOZILLA: {
                options.setSerializationMethod(WebPageOutputOptions.SerializationMethod.XHTML);
                break;
            }
            case CROSS_BROWSER_XHTML: {
                options.setSerializationMethod(WebPageOutputOptions.SerializationMethod.XHTML);
                break;
            }
            case MATHPLAYER_HTML: {
                options.setSerializationMethod(WebPageOutputOptions.SerializationMethod.HTML);
                options.setContentType("text/html");
                options.setPrefixingMathML(true);
                break;
            }
            case PROCESSED_HTML: {
                options.setSerializationMethod(WebPageOutputOptions.SerializationMethod.HTML);
                options.setContentType("text/html");
                break;
            }
            case CLIENT_SIDE_XSLT_STYLESHEET: {
                options.setSerializationMethod(WebPageOutputOptions.SerializationMethod.XML);
                break;
            }
            case UNIVERSAL_STYLESHEET: {
                options.setSerializationMethod(WebPageOutputOptions.SerializationMethod.XML);
                break;
            }
            default: {
                throw new SnuggleRuntimeException("Unexpected switch case " + (Object)((Object)webPageType));
            }
        }
        return options;
    }
}

