/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.wcm.connector;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Map;
import javax.jcr.ItemExistsException;
import javax.jcr.Node;
import javax.servlet.http.HttpServletRequest;
import javax.ws.rs.core.CacheControl;
import javax.ws.rs.core.Response;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.transform.dom.DOMSource;
import org.apache.commons.lang.StringUtils;
import org.exoplatform.ecm.connector.fckeditor.FCKMessage;
import org.exoplatform.ecm.connector.fckeditor.FCKUtils;
import org.exoplatform.ecm.utils.lock.LockUtil;
import org.exoplatform.ecm.utils.text.Text;
import org.exoplatform.services.cms.impl.Utils;
import org.exoplatform.services.cms.jcrext.activity.ActivityCommonService;
import org.exoplatform.services.cms.mimetype.DMSMimeTypeResolver;
import org.exoplatform.services.cms.templates.TemplateService;
import org.exoplatform.services.listener.ListenerService;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.services.wcm.publication.WCMPublicationService;
import org.exoplatform.services.wcm.utils.WCMCoreUtils;
import org.exoplatform.upload.UploadResource;
import org.exoplatform.upload.UploadService;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class FileUploadHandler {
    private static final Log LOG = ExoLogger.getLogger((String)FileUploadHandler.class.getName());
    public static final String UPLOAD_ACTION = "upload";
    public static final String PROGRESS_ACTION = "progress";
    public static final String ABORT_ACTION = "abort";
    public static final String DELETE_ACTION = "delete";
    public static final String SAVE_ACTION = "save";
    public static final String CHECK_EXIST = "exist";
    public static final String REPLACE = "replace";
    public static final String KEEP_BOTH = "keepBoth";
    private static final String LAST_MODIFIED_PROPERTY = "Last-Modified";
    private static final String IF_MODIFIED_SINCE_DATE_FORMAT = "EEE, dd MMM yyyy HH:mm:ss z";
    public static final String POST_CREATE_CONTENT_EVENT = "CmsService.event.postCreate";
    private UploadService uploadService = (UploadService)WCMCoreUtils.getService(UploadService.class);
    ListenerService listenerService = (ListenerService)WCMCoreUtils.getService(ListenerService.class);
    private ActivityCommonService activityService = (ActivityCommonService)WCMCoreUtils.getService(ActivityCommonService.class);
    private FCKMessage fckMessage = new FCKMessage();
    private Map<String, Long> uploadIdTimeMap = new Hashtable<String, Long>();
    private long UPLOAD_LIFE_TIME = System.getProperty("MULTI_UPLOAD_LIFE_TIME") == null ? 600L : Long.parseLong(System.getProperty("MULTI_UPLOAD_LIFE_TIME"));

    public Response upload(HttpServletRequest servletRequest, String uploadId, Integer limit) throws Exception {
        this.uploadService.addUploadLimit(uploadId, limit);
        this.uploadService.createUploadResource(servletRequest);
        this.uploadIdTimeMap.put(uploadId, System.currentTimeMillis());
        CacheControl cacheControl = new CacheControl();
        cacheControl.setNoCache(true);
        cacheControl.setNoStore(true);
        SimpleDateFormat dateFormat = new SimpleDateFormat(IF_MODIFIED_SINCE_DATE_FORMAT);
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        DocumentBuilder builder = factory.newDocumentBuilder();
        Document doc = builder.newDocument();
        Element rootElement = doc.createElement("html");
        Element head = doc.createElement("head");
        Element body = doc.createElement("body");
        rootElement.appendChild(head);
        rootElement.appendChild(body);
        doc.appendChild(rootElement);
        return Response.ok((Object)new DOMSource(doc), (String)"text/xml").cacheControl(cacheControl).header(LAST_MODIFIED_PROPERTY, (Object)dateFormat.format(new Date())).build();
    }

    public Response checkStatus(String uploadId, String language) throws Exception {
        CacheControl cacheControl = new CacheControl();
        cacheControl.setNoCache(true);
        cacheControl.setNoStore(true);
        SimpleDateFormat dateFormat = new SimpleDateFormat(IF_MODIFIED_SINCE_DATE_FORMAT);
        if (StringUtils.isEmpty((String)uploadId) || this.uploadService.getUploadResource(uploadId) == null) {
            return null;
        }
        if (2 == this.uploadService.getUploadResource(uploadId).getStatus()) {
            this.uploadService.removeUploadResource(uploadId);
            this.uploadIdTimeMap.remove(uploadId);
            String uploadLimit = String.valueOf(((UploadService.UploadLimit)this.uploadService.getUploadLimits().get(uploadId)).getLimit());
            Document fileExceedLimit = this.fckMessage.createMessage(205, "Error", language, new String[]{uploadLimit});
            return Response.ok((Object)new DOMSource(fileExceedLimit), (String)"text/xml").cacheControl(cacheControl).header(LAST_MODIFIED_PROPERTY, (Object)dateFormat.format(new Date())).build();
        }
        return null;
    }

    public Response control(String uploadId, String action) throws Exception {
        CacheControl cacheControl = new CacheControl();
        cacheControl.setNoCache(true);
        cacheControl.setNoStore(true);
        SimpleDateFormat dateFormat = new SimpleDateFormat(IF_MODIFIED_SINCE_DATE_FORMAT);
        if (PROGRESS_ACTION.equals(action)) {
            Document currentProgress = this.getProgress(uploadId);
            return Response.ok((Object)new DOMSource(currentProgress), (String)"text/xml").cacheControl(cacheControl).header(LAST_MODIFIED_PROPERTY, (Object)dateFormat.format(new Date())).build();
        }
        if (ABORT_ACTION.equals(action)) {
            this.uploadService.removeUploadResource(uploadId);
            this.uploadIdTimeMap.remove(uploadId);
            return Response.ok(null, (String)"text/xml").cacheControl(cacheControl).header(LAST_MODIFIED_PROPERTY, (Object)dateFormat.format(new Date())).build();
        }
        if (DELETE_ACTION.equals(action)) {
            this.uploadService.removeUploadResource(uploadId);
            this.uploadIdTimeMap.remove(uploadId);
            return Response.ok(null, (String)"text/xml").cacheControl(cacheControl).header(LAST_MODIFIED_PROPERTY, (Object)dateFormat.format(new Date())).build();
        }
        return Response.status((int)400).cacheControl(cacheControl).header(LAST_MODIFIED_PROPERTY, (Object)dateFormat.format(new Date())).build();
    }

    public Response checkExistence(Node parent, String fileName) throws Exception {
        CacheControl cacheControl = new CacheControl();
        cacheControl.setNoCache(true);
        SimpleDateFormat dateFormat = new SimpleDateFormat(IF_MODIFIED_SINCE_DATE_FORMAT);
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        DocumentBuilder builder = factory.newDocumentBuilder();
        Document fileExistence = builder.newDocument();
        fileName = Text.escapeIllegalJcrChars((String)fileName);
        Element rootElement = fileExistence.createElement(parent.hasNode(fileName) ? "Existed" : "NotExisted");
        fileExistence.appendChild(rootElement);
        return Response.ok((Object)new DOMSource(fileExistence), (String)"text/xml").cacheControl(cacheControl).header(LAST_MODIFIED_PROPERTY, (Object)dateFormat.format(new Date())).build();
    }

    public Response saveAsNTFile(Node parent, String uploadId, String fileName, String language, String siteName, String userId) throws Exception {
        return this.saveAsNTFile(parent, uploadId, fileName, language, siteName, userId, KEEP_BOTH);
    }

    public Response saveAsNTFile(Node parent, String uploadId, String fileName, String language, String siteName, String userId, String existenceAction) throws Exception {
        try {
            CacheControl cacheControl = new CacheControl();
            cacheControl.setNoCache(true);
            UploadResource resource = this.uploadService.getUploadResource(uploadId);
            SimpleDateFormat dateFormat = new SimpleDateFormat(IF_MODIFIED_SINCE_DATE_FORMAT);
            if (parent == null) {
                Document fileNotUploaded = this.fckMessage.createMessage(204, "Error", language, null);
                return Response.ok((Object)new DOMSource(fileNotUploaded), (String)"text/xml").cacheControl(cacheControl).header(LAST_MODIFIED_PROPERTY, (Object)dateFormat.format(new Date())).build();
            }
            if (!FCKUtils.hasAddNodePermission(parent)) {
                Object[] args = new Object[]{parent.getPath()};
                Document message = this.fckMessage.createMessage(203, "Error", language, args);
                return Response.ok((Object)new DOMSource(message), (String)"text/xml").cacheControl(cacheControl).header(LAST_MODIFIED_PROPERTY, (Object)dateFormat.format(new Date())).build();
            }
            if (fileName == null || fileName.length() == 0) {
                fileName = resource.getFileName();
            }
            if (parent.isLocked()) {
                parent.getSession().addLockToken(LockUtil.getLockToken((Node)parent));
            }
            if (parent.hasNode(fileName) && REPLACE.equals(existenceAction)) {
                ListenerService listenerService = (ListenerService)WCMCoreUtils.getService(ListenerService.class);
                listenerService.broadcast(ActivityCommonService.FILE_REMOVE_ACTIVITY, (Object)parent, (Object)parent.getNode(fileName));
                parent.getNode(fileName).remove();
                parent.save();
            }
            String location = resource.getStoreLocation();
            Node file = null;
            boolean fileCreated = false;
            String exoTitle = fileName;
            if (fileName.indexOf(46) > 0) {
                String ext = fileName.substring(fileName.lastIndexOf(46));
                fileName = Utils.cleanString((String)fileName.substring(0, fileName.lastIndexOf(46))).concat(ext);
            } else {
                fileName = Utils.cleanString((String)fileName);
            }
            String nodeName = fileName;
            int count = 0;
            do {
                try {
                    file = parent.addNode(nodeName, "nt:file");
                    fileCreated = true;
                }
                catch (ItemExistsException e) {
                    nodeName = this.increaseName(fileName, ++count);
                }
            } while (!fileCreated);
            if (!file.isNodeType("mix:referenceable")) {
                file.addMixin("mix:referenceable");
            }
            if (!file.isNodeType("mix:commentable")) {
                file.addMixin("mix:commentable");
            }
            if (!file.isNodeType("mix:votable")) {
                file.addMixin("mix:votable");
            }
            if (!file.isNodeType("mix:i18n")) {
                file.addMixin("mix:i18n");
            }
            if (!file.hasProperty("exo:title")) {
                file.setProperty("exo:title", exoTitle);
            }
            Node jcrContent = file.addNode("jcr:content", "nt:resource");
            DMSMimeTypeResolver mimeTypeResolver = DMSMimeTypeResolver.getInstance();
            String mimetype = mimeTypeResolver.getMimeType(resource.getFileName());
            jcrContent.setProperty("jcr:data", (InputStream)new BufferedInputStream(new FileInputStream(new File(location))));
            jcrContent.setProperty("jcr:lastModified", (Calendar)new GregorianCalendar());
            jcrContent.setProperty("jcr:mimeType", mimetype);
            parent.getSession().refresh(true);
            this.uploadService.removeUploadResource(uploadId);
            this.uploadIdTimeMap.remove(uploadId);
            WCMPublicationService wcmPublicationService = (WCMPublicationService)WCMCoreUtils.getService(WCMPublicationService.class);
            wcmPublicationService.updateLifecyleOnChangeContent(file, siteName, userId);
            if (this.activityService.isBroadcastNTFileEvents(file)) {
                this.listenerService.broadcast(ActivityCommonService.FILE_CREATED_ACTIVITY, null, (Object)file);
            }
            file.getSession().save();
            return Response.ok((Object)this.createDOMResponse("Result", mimetype), (String)"text/xml").cacheControl(cacheControl).header(LAST_MODIFIED_PROPERTY, (Object)dateFormat.format(new Date())).build();
        }
        catch (Exception exc) {
            LOG.error((Object)exc.getMessage(), (Throwable)exc);
            return Response.serverError().entity((Object)exc.getMessage()).build();
        }
    }

    public boolean isDocumentNodeType(Node node) throws Exception {
        TemplateService templateService = (TemplateService)WCMCoreUtils.getService(TemplateService.class);
        return templateService.isManagedNodeType(node.getPrimaryNodeType().getName());
    }

    private String increaseName(String origin, int count) {
        int index = origin.indexOf(46);
        if (index == -1) {
            return origin + count;
        }
        return origin.substring(0, index) + count + origin.substring(index);
    }

    public long getUploadingFileCount() {
        this.removeDeadUploads();
        return this.uploadIdTimeMap.size();
    }

    private void removeDeadUploads() {
        HashSet<String> removedIds = new HashSet<String>();
        for (String id : this.uploadIdTimeMap.keySet()) {
            if (System.currentTimeMillis() - this.uploadIdTimeMap.get(id) <= this.UPLOAD_LIFE_TIME * 1000L) continue;
            removedIds.add(id);
        }
        for (String id : removedIds) {
            this.uploadIdTimeMap.remove(id);
        }
    }

    private Document getProgress(String uploadId) throws Exception {
        UploadResource resource = this.uploadService.getUploadResource(uploadId);
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        DocumentBuilder builder = factory.newDocumentBuilder();
        Document doc = builder.newDocument();
        Double percent = 0.0;
        if (resource != null) {
            percent = resource.getStatus() == 0 ? Double.valueOf(resource.getUploadedSize() * 100.0 / resource.getEstimatedSize()) : Double.valueOf(100.0);
        }
        Element rootElement = doc.createElement("UploadProgress");
        rootElement.setAttribute("uploadId", uploadId);
        rootElement.setAttribute("fileName", resource == null ? "" : resource.getFileName());
        rootElement.setAttribute("percent", percent.intValue() + "");
        rootElement.setAttribute("uploadedSize", resource == null ? "0" : resource.getUploadedSize() + "");
        rootElement.setAttribute("totalSize", resource == null ? "0" : resource.getEstimatedSize() + "");
        rootElement.setAttribute("fileType", resource == null ? "null" : resource.getMimeType() + "");
        UploadService.UploadLimit limit = (UploadService.UploadLimit)this.uploadService.getUploadLimits().get(uploadId);
        if (limit != null) {
            rootElement.setAttribute("limit", limit.getLimit() + "");
            rootElement.setAttribute("unit", limit.getUnit() + "");
        }
        doc.appendChild(rootElement);
        return doc;
    }

    private DOMSource createDOMResponse(String name, String mimeType) throws Exception {
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        DocumentBuilder builder = factory.newDocumentBuilder();
        Document doc = builder.newDocument();
        Element rootElement = doc.createElement(name);
        rootElement.setAttribute("mimetype", mimeType);
        doc.appendChild(rootElement);
        return new DOMSource(doc);
    }
}

