/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.jeuclid.elements.presentation.script;

import net.sourceforge.jeuclid.LayoutContext;
import net.sourceforge.jeuclid.context.Display;
import net.sourceforge.jeuclid.context.InlineLayoutContext;
import net.sourceforge.jeuclid.context.Parameter;
import net.sourceforge.jeuclid.context.RelativeScriptlevelLayoutContext;
import net.sourceforge.jeuclid.elements.AbstractJEuclidElement;
import net.sourceforge.jeuclid.elements.JEuclidElement;
import net.sourceforge.jeuclid.elements.presentation.script.ScriptSupport;
import net.sourceforge.jeuclid.elements.support.Dimension2DImpl;
import net.sourceforge.jeuclid.elements.support.ElementListSupport;
import net.sourceforge.jeuclid.elements.support.attributes.AttributesHelper;
import net.sourceforge.jeuclid.layout.LayoutInfo;
import net.sourceforge.jeuclid.layout.LayoutStage;
import net.sourceforge.jeuclid.layout.LayoutView;
import org.w3c.dom.mathml.MathMLElement;
import org.w3c.dom.mathml.MathMLOperatorElement;
import org.w3c.dom.mathml.MathMLUnderOverElement;

public abstract class AbstractUnderOver
extends AbstractJEuclidElement
implements MathMLUnderOverElement {
    public static final String UNDER_OVER_SPACE = "0.1ex";
    public static final float NON_ACCENT_MULTIPLIER = 2.5f;
    public static final String ATTR_ACCENT = "accent";
    public static final String ATTR_ACCENTUNDER = "accentunder";

    public String getAccent() {
        return this.getMathAttribute(ATTR_ACCENT);
    }

    protected boolean getAccentAsBoolean() {
        return Boolean.parseBoolean(this.getAccent());
    }

    private boolean limitsAreMoved(LayoutContext layoutContext) {
        return !this.getAccentAsBoolean() && this.getBase() instanceof MathMLOperatorElement && Boolean.parseBoolean(((MathMLOperatorElement)((Object)this.getBase())).getMovablelimits()) && Display.INLINE.equals(layoutContext.getParameter(Parameter.DISPLAY));
    }

    public String getAccentunder() {
        return this.getMathAttribute(ATTR_ACCENTUNDER);
    }

    public LayoutContext getChildLayoutContext(int n, LayoutContext layoutContext) {
        LayoutContext layoutContext2 = this.applyLocalAttributesToContext(layoutContext);
        if (n == 0) {
            return layoutContext2;
        }
        return new RelativeScriptlevelLayoutContext(new InlineLayoutContext(layoutContext2), 1);
    }

    protected boolean getAccentunderAsBoolean() {
        return Boolean.parseBoolean(this.getAccentunder());
    }

    public JEuclidElement getBase() {
        return this.getMathElement(0);
    }

    public abstract JEuclidElement getOverscript();

    public abstract JEuclidElement getUnderscript();

    public void setAccent(String string) {
        this.setAttribute(ATTR_ACCENT, string);
    }

    public void setAccentunder(String string) {
        this.setAttribute(ATTR_ACCENTUNDER, string);
    }

    public void setBase(MathMLElement mathMLElement) {
        this.setMathElement(0, mathMLElement);
    }

    public boolean hasChildPostscripts(JEuclidElement jEuclidElement, LayoutContext layoutContext) {
        return this.limitsAreMoved(layoutContext) && jEuclidElement.isSameNode(this.getBase());
    }

    protected void layoutStageInvariant(LayoutView layoutView, LayoutInfo layoutInfo, LayoutStage layoutStage, LayoutContext layoutContext) {
        LayoutContext layoutContext2 = this.applyLocalAttributesToContext(layoutContext);
        if (this.limitsAreMoved(layoutContext2)) {
            ScriptSupport.layout(layoutView, layoutInfo, layoutStage, layoutContext2, this, this.getBase(), this.getUnderscript(), this.getOverscript(), null, null);
        } else {
            this.layoutUnderOver(layoutView, layoutInfo, layoutStage, layoutContext2);
        }
    }

    private void layoutUnderOver(LayoutView layoutView, LayoutInfo layoutInfo, LayoutStage layoutStage, LayoutContext layoutContext) {
        LayoutInfo layoutInfo2;
        LayoutInfo layoutInfo3;
        JEuclidElement jEuclidElement = this.getBase();
        JEuclidElement jEuclidElement2 = this.getUnderscript();
        JEuclidElement jEuclidElement3 = this.getOverscript();
        LayoutInfo layoutInfo4 = layoutView.getInfo(jEuclidElement);
        float f = layoutInfo4.getWidth(layoutStage);
        float f2 = AttributesHelper.convertSizeToPt(UNDER_OVER_SPACE, layoutContext, "pt");
        if (jEuclidElement2 == null) {
            layoutInfo3 = null;
        } else {
            layoutInfo3 = layoutView.getInfo(jEuclidElement2);
            f = Math.max(f, layoutInfo3.getWidth(layoutStage));
        }
        if (jEuclidElement3 == null) {
            layoutInfo2 = null;
        } else {
            layoutInfo2 = layoutView.getInfo(jEuclidElement3);
            f = Math.max(f, layoutInfo2.getWidth(layoutStage));
        }
        float f3 = f / 2.0f;
        layoutInfo4.moveTo(f3 - layoutInfo4.getHorizontalCenterOffset(layoutStage), 0.0f, layoutStage);
        if (jEuclidElement2 != null) {
            this.positionUnder(layoutStage, layoutInfo4, layoutInfo3, f2, f3);
        }
        if (jEuclidElement3 != null) {
            this.positionOver(layoutStage, layoutInfo4, layoutInfo2, f2, f3);
        }
        Dimension2DImpl dimension2DImpl = new Dimension2DImpl(0.0f, 0.0f);
        Dimension2DImpl dimension2DImpl2 = new Dimension2DImpl(0.0f, 0.0f);
        ElementListSupport.fillInfoFromChildren(layoutView, layoutInfo, this, layoutStage, dimension2DImpl, dimension2DImpl2);
        layoutInfo.setStretchWidth(f);
    }

    private void positionUnder(LayoutStage layoutStage, LayoutInfo layoutInfo, LayoutInfo layoutInfo2, float f, float f2) {
        float f3 = this.getAccentunderAsBoolean() ? f : f * 2.5f;
        float f4 = layoutInfo.getDescentHeight(layoutStage) + layoutInfo2.getAscentHeight(layoutStage) + f3;
        layoutInfo2.moveTo(f2 - layoutInfo2.getHorizontalCenterOffset(layoutStage), f4, layoutStage);
    }

    private void positionOver(LayoutStage layoutStage, LayoutInfo layoutInfo, LayoutInfo layoutInfo2, float f, float f2) {
        float f3 = this.getAccentAsBoolean() ? f : f * 2.5f;
        float f4 = layoutInfo.getAscentHeight(layoutStage) + layoutInfo2.getDescentHeight(layoutStage) + f3;
        layoutInfo2.moveTo(f2 - layoutInfo2.getHorizontalCenterOffset(layoutStage), -f4, layoutStage);
    }
}

