/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.interceptors;

import java.util.List;
import java.util.Map;
import org.infinispan.commands.tx.PrepareCommand;
import org.infinispan.commands.write.ClearCommand;
import org.infinispan.commands.write.PutKeyValueCommand;
import org.infinispan.commands.write.PutMapCommand;
import org.infinispan.commands.write.RemoveCommand;
import org.infinispan.commands.write.ReplaceCommand;
import org.infinispan.container.entries.InternalCacheEntry;
import org.infinispan.context.Flag;
import org.infinispan.context.InvocationContext;
import org.infinispan.context.impl.TxInvocationContext;
import org.infinispan.distribution.DistributionManager;
import org.infinispan.factories.annotations.Inject;
import org.infinispan.factories.annotations.Start;
import org.infinispan.interceptors.CacheStoreInterceptor;
import org.infinispan.remoting.transport.Address;
import org.infinispan.remoting.transport.Transport;
import org.infinispan.util.logging.Log;
import org.infinispan.util.logging.LogFactory;

public class DistCacheStoreInterceptor
extends CacheStoreInterceptor {
    DistributionManager dm;
    Transport transport;
    Address address;
    private static final Log log = LogFactory.getLog(DistCacheStoreInterceptor.class);

    @Override
    protected Log getLog() {
        return log;
    }

    @Inject
    public void inject(DistributionManager dm, Transport transport) {
        this.dm = dm;
        this.transport = transport;
    }

    @Start(priority=25)
    private void setAddress() {
        this.address = this.transport.getAddress();
    }

    @Override
    public Object visitPutKeyValueCommand(InvocationContext ctx, PutKeyValueCommand command) throws Throwable {
        Object returnValue = this.invokeNextInterceptor(ctx, command);
        Object key = command.getKey();
        if (this.skip(ctx, key) || ctx.isInTxScope() || !command.isSuccessful()) {
            return returnValue;
        }
        InternalCacheEntry se = this.getStoredEntry(key, ctx);
        this.store.store(se);
        log.tracef("Stored entry %s under key %s", se, key);
        if (this.getStatisticsEnabled()) {
            this.cacheStores.incrementAndGet();
        }
        return returnValue;
    }

    @Override
    public Object visitPutMapCommand(InvocationContext ctx, PutMapCommand command) throws Throwable {
        Object returnValue = this.invokeNextInterceptor(ctx, command);
        if (this.skip(ctx) || ctx.isInTxScope()) {
            return returnValue;
        }
        Map<Object, Object> map = command.getMap();
        for (Object key : map.keySet()) {
            if (this.skipKey(key)) continue;
            InternalCacheEntry se = this.getStoredEntry(key, ctx);
            this.store.store(se);
            log.tracef("Stored entry %s under key %s", se, key);
        }
        if (this.getStatisticsEnabled()) {
            this.cacheStores.getAndAdd(map.size());
        }
        return returnValue;
    }

    @Override
    public Object visitRemoveCommand(InvocationContext ctx, RemoveCommand command) throws Throwable {
        Object retval = this.invokeNextInterceptor(ctx, command);
        Object key = command.getKey();
        if (!this.skip(ctx, key) && !ctx.isInTxScope() && command.isSuccessful()) {
            boolean resp = this.store.remove(key);
            log.tracef("Removed entry under key %s and got response %s from CacheStore", key, resp);
        }
        return retval;
    }

    @Override
    public Object visitReplaceCommand(InvocationContext ctx, ReplaceCommand command) throws Throwable {
        Object returnValue = this.invokeNextInterceptor(ctx, command);
        Object key = command.getKey();
        if (this.skip(ctx, key) || ctx.isInTxScope() || !command.isSuccessful()) {
            return returnValue;
        }
        InternalCacheEntry se = this.getStoredEntry(key, ctx);
        this.store.store(se);
        log.tracef("Stored entry %s under key %s", se, key);
        if (this.getStatisticsEnabled()) {
            this.cacheStores.incrementAndGet();
        }
        return returnValue;
    }

    @Override
    public Object visitPrepareCommand(TxInvocationContext ctx, PrepareCommand command) throws Throwable {
        if (!this.skip(ctx)) {
            if (this.getLog().isTraceEnabled()) {
                this.getLog().trace("Transactional so don't put stuff in the cache store yet.");
            }
            this.prepareCacheLoader(ctx, command.getGlobalTransaction(), ctx, command.isOnePhaseCommit());
        }
        return this.invokeNextInterceptor(ctx, command);
    }

    @Override
    public Object visitClearCommand(InvocationContext ctx, ClearCommand command) throws Throwable {
        if (!(!ctx.isOriginLocal() && this.loaderConfig.isShared().booleanValue() || this.skip(ctx) || ctx.isInTxScope())) {
            this.clearCacheStore();
        }
        return this.invokeNextInterceptor(ctx, command);
    }

    private boolean skip(InvocationContext ctx, Object key) {
        return this.skip(ctx) || this.skipKey(key);
    }

    @Override
    protected boolean skip(InvocationContext ctx) {
        if (this.store == null) {
            log.trace("Skipping cache store because the cache loader does not implement CacheStore");
            return true;
        }
        if (ctx.hasFlag(Flag.SKIP_CACHE_STORE)) {
            log.trace("Skipping cache store since the call contain a skip cache store flag");
            return true;
        }
        if (this.loaderConfig.isShared().booleanValue() && ctx.hasFlag(Flag.SKIP_SHARED_CACHE_STORE)) {
            log.trace("Skipping cache store since it is shared and the call contain a skip shared cache store flag");
        }
        return false;
    }

    @Override
    protected boolean skipKey(Object key) {
        if (this.loaderConfig.isShared().booleanValue()) {
            if (!this.dm.getPrimaryLocation(key).equals(this.address)) {
                log.trace("Skipping cache store since the cache loader is shared and the caller is not the first owner of the key");
                return true;
            }
        } else {
            List<Address> addresses = this.dm.locate(key);
            if (this.isL1Put(addresses)) {
                log.trace("Skipping cache store since this is an L1 put");
                return true;
            }
        }
        return false;
    }

    private boolean isL1Put(List<Address> addresses) {
        if (this.address == null) {
            throw new NullPointerException("Local address cannot be null!");
        }
        return !addresses.contains(this.address);
    }
}

