/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.social.notification.plugin;

import java.io.IOException;
import java.io.Writer;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import org.exoplatform.commons.api.notification.NotificationContext;
import org.exoplatform.commons.api.notification.model.MessageInfo;
import org.exoplatform.commons.api.notification.model.NotificationInfo;
import org.exoplatform.commons.api.notification.plugin.AbstractNotificationPlugin;
import org.exoplatform.commons.api.notification.service.template.TemplateContext;
import org.exoplatform.commons.notification.template.TemplateUtils;
import org.exoplatform.container.xml.InitParams;
import org.exoplatform.social.core.activity.model.ExoSocialActivity;
import org.exoplatform.social.core.identity.model.Identity;
import org.exoplatform.social.notification.LinkProviderUtils;
import org.exoplatform.social.notification.Utils;
import org.exoplatform.social.notification.plugin.SocialNotificationUtils;

public class ActivityCommentPlugin
extends AbstractNotificationPlugin {
    public static final String ID = "ActivityCommentPlugin";

    public ActivityCommentPlugin(InitParams initParams) {
        super(initParams);
    }

    public NotificationInfo makeNotification(NotificationContext ctx) {
        ExoSocialActivity comment = (ExoSocialActivity)ctx.value(SocialNotificationUtils.ACTIVITY);
        ExoSocialActivity activity = Utils.getActivityManager().getParentActivity(comment);
        HashSet<String> receivers = new HashSet<String>();
        Utils.sendToCommeters(receivers, activity.getCommentedIds(), comment.getPosterId());
        Utils.sendToStreamOwner(receivers, activity.getStreamOwner(), comment.getPosterId());
        Utils.sendToActivityPoster(receivers, activity.getPosterId(), comment.getPosterId());
        return NotificationInfo.instance().to(new ArrayList<String>(receivers)).with(SocialNotificationUtils.ACTIVITY_ID.getKey(), comment.getId()).with(SocialNotificationUtils.POSTER.getKey(), Utils.getUserId(comment.getUserId())).key(this.getId());
    }

    public MessageInfo makeMessage(NotificationContext ctx) {
        MessageInfo messageInfo = new MessageInfo();
        NotificationInfo notification = ctx.getNotificationInfo();
        String language = this.getLanguage(notification);
        String activityId = notification.getValueOwnerParameter(SocialNotificationUtils.ACTIVITY_ID.getKey());
        ExoSocialActivity activity = Utils.getActivityManager().getActivity(activityId);
        ExoSocialActivity parentActivity = Utils.getActivityManager().getParentActivity(activity);
        Identity identity = Utils.getIdentityManager().getIdentity(activity.getPosterId(), true);
        TemplateContext templateContext = new TemplateContext(notification.getKey().getId(), language);
        templateContext.put((Object)"USER", (Object)identity.getProfile().getFullName());
        String subject = TemplateUtils.processSubject((TemplateContext)templateContext);
        SocialNotificationUtils.addFooterAndFirstName(notification.getTo(), templateContext);
        templateContext.put((Object)"PROFILE_URL", (Object)LinkProviderUtils.getRedirectUrl("user", identity.getRemoteId()));
        templateContext.put((Object)"COMMENT", (Object)activity.getTitle());
        templateContext.put((Object)"ACTIVITY", (Object)parentActivity.getTitle());
        templateContext.put((Object)"REPLY_ACTION_URL", (Object)LinkProviderUtils.getRedirectUrl("reply_activity_highlight_comment", parentActivity.getId() + "-" + activity.getId()));
        templateContext.put((Object)"VIEW_FULL_DISCUSSION_ACTION_URL", (Object)LinkProviderUtils.getRedirectUrl("view_full_activity_highlight_comment", parentActivity.getId() + "-" + activity.getId()));
        String body = TemplateUtils.processGroovy((TemplateContext)templateContext);
        return messageInfo.subject(subject).body(body).end();
    }

    public String getId() {
        return ID;
    }

    public boolean makeDigest(NotificationContext ctx, Writer writer) {
        List notifications = ctx.getNotificationInfos();
        NotificationInfo first = (NotificationInfo)notifications.get(0);
        String language = this.getLanguage(first);
        TemplateContext templateContext = new TemplateContext(first.getKey().getId(), language);
        SocialNotificationUtils.addFooterAndFirstName(first.getTo(), templateContext);
        LinkedHashMap<String, List<String>> receiverMap = new LinkedHashMap<String, List<String>>();
        try {
            for (NotificationInfo message : notifications) {
                String activityId = message.getValueOwnerParameter(SocialNotificationUtils.ACTIVITY_ID.getKey());
                ExoSocialActivity activity = Utils.getActivityManager().getActivity(activityId);
                ExoSocialActivity parentActivity = Utils.getActivityManager().getParentActivity(activity);
                SocialNotificationUtils.processInforSendTo(receiverMap, parentActivity.getId(), message.getValueOwnerParameter("poster"));
            }
            writer.append(SocialNotificationUtils.getMessageByIds(receiverMap, templateContext));
        }
        catch (IOException e) {
            ctx.setException((Throwable)e);
            return false;
        }
        return true;
    }

    public boolean isValid(NotificationContext ctx) {
        ExoSocialActivity comment = (ExoSocialActivity)ctx.value(SocialNotificationUtils.ACTIVITY);
        ExoSocialActivity activity = Utils.getActivityManager().getParentActivity(comment);
        Identity spaceIdentity = Utils.getIdentityManager().getOrCreateIdentity("space", activity.getStreamOwner(), false);
        return spaceIdentity == null || !activity.getPosterId().equals(spaceIdentity.getId());
    }
}

