/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.jcr.impl.core.query.lucene;

import java.util.ArrayList;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.queryParser.ParseException;
import org.apache.lucene.queryParser.QueryParser;
import org.apache.lucene.search.BooleanClause;
import org.apache.lucene.search.Query;
import org.apache.lucene.util.Version;
import org.exoplatform.services.jcr.impl.core.query.lucene.SynonymProvider;
import org.exoplatform.services.jcr.impl.core.query.lucene.WildcardQuery;

public class JcrQueryParser
extends QueryParser {
    private final SynonymProvider synonymProvider;

    public JcrQueryParser(String fieldName, Analyzer analyzer, SynonymProvider synonymProvider) {
        super(Version.LUCENE_30, fieldName, analyzer);
        this.synonymProvider = synonymProvider;
        this.setAllowLeadingWildcard(true);
        this.setDefaultOperator(QueryParser.Operator.AND);
    }

    public Query parse(String textsearch) throws ParseException {
        StringBuffer rewritten = new StringBuffer();
        textsearch = textsearch.replaceAll("AND", "and");
        textsearch = textsearch.replaceAll("NOT", "not");
        boolean escaped = false;
        for (int i = 0; i < textsearch.length(); ++i) {
            if (textsearch.charAt(i) == '\\') {
                if (escaped) {
                    rewritten.append("\\\\");
                    escaped = false;
                    continue;
                }
                escaped = true;
                continue;
            }
            if (textsearch.charAt(i) == '\'') {
                if (escaped) {
                    escaped = false;
                }
                rewritten.append(textsearch.charAt(i));
                continue;
            }
            if (textsearch.charAt(i) == '~') {
                if (i == 0 || Character.isWhitespace(textsearch.charAt(i - 1))) {
                    rewritten.append("\\");
                }
                rewritten.append('~');
                continue;
            }
            if (escaped) {
                rewritten.append('\\');
                escaped = false;
            }
            rewritten.append(textsearch.charAt(i));
        }
        return super.parse(rewritten.toString());
    }

    protected Query getSynonymQuery(String field, String termStr) throws ParseException {
        ArrayList<BooleanClause> synonyms = new ArrayList<BooleanClause>();
        synonyms.add(new BooleanClause(this.getFieldQuery(field, termStr), BooleanClause.Occur.SHOULD));
        if (this.synonymProvider != null) {
            String[] terms = this.synonymProvider.getSynonyms(termStr);
            for (int i = 0; i < terms.length; ++i) {
                synonyms.add(new BooleanClause(this.getFieldQuery(field, terms[i]), BooleanClause.Occur.SHOULD));
            }
        }
        if (synonyms.size() == 1) {
            return ((BooleanClause)synonyms.get(0)).getQuery();
        }
        return this.getBooleanQuery(synonyms);
    }

    protected Query getFieldQuery(String field, String queryText) throws ParseException {
        if (queryText.startsWith("~")) {
            return this.getSynonymQuery(field, queryText.substring(1));
        }
        return super.getFieldQuery(field, queryText, true);
    }

    protected Query getPrefixQuery(String field, String termStr) throws ParseException {
        return this.getWildcardQuery(field, termStr + "*");
    }

    protected Query getWildcardQuery(String field, String termStr) throws ParseException {
        if (this.getLowercaseExpandedTerms()) {
            termStr = termStr.toLowerCase();
        }
        return new WildcardQuery(field, null, this.translateWildcards(termStr));
    }

    private String translateWildcards(String input) {
        StringBuffer translated = new StringBuffer(input.length());
        boolean escaped = false;
        for (int i = 0; i < input.length(); ++i) {
            if (input.charAt(i) == '\\') {
                if (escaped) {
                    translated.append("\\\\");
                    escaped = false;
                    continue;
                }
                escaped = true;
                continue;
            }
            if (input.charAt(i) == '*') {
                if (escaped) {
                    translated.append('*');
                    escaped = false;
                    continue;
                }
                translated.append('%');
                continue;
            }
            if (input.charAt(i) == '?') {
                if (escaped) {
                    translated.append('?');
                    escaped = false;
                    continue;
                }
                translated.append('_');
                continue;
            }
            if (input.charAt(i) == '%' || input.charAt(i) == '_') {
                escaped = false;
                translated.append('\\').append(input.charAt(i));
                continue;
            }
            if (escaped) {
                translated.append('\\');
                escaped = false;
            }
            translated.append(input.charAt(i));
        }
        return translated.toString();
    }
}

