/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.wiki.webui.control.action;

import java.util.Arrays;
import java.util.List;
import org.exoplatform.container.PortalContainer;
import org.exoplatform.webui.config.annotation.ComponentConfig;
import org.exoplatform.webui.config.annotation.EventConfig;
import org.exoplatform.webui.event.Event;
import org.exoplatform.webui.ext.filter.UIExtensionFilter;
import org.exoplatform.webui.ext.filter.UIExtensionFilters;
import org.exoplatform.webui.form.UIFormStringInput;
import org.exoplatform.webui.form.UIFormTextAreaInput;
import org.exoplatform.wiki.commons.Utils;
import org.exoplatform.wiki.mow.api.Page;
import org.exoplatform.wiki.rendering.RenderingService;
import org.exoplatform.wiki.webui.EditMode;
import org.exoplatform.wiki.webui.UIWikiPageEditForm;
import org.exoplatform.wiki.webui.UIWikiPageTitleControlArea;
import org.exoplatform.wiki.webui.UIWikiPortlet;
import org.exoplatform.wiki.webui.UIWikiRichTextArea;
import org.exoplatform.wiki.webui.WikiMode;
import org.exoplatform.wiki.webui.control.action.core.AbstractEventActionComponent;
import org.exoplatform.wiki.webui.control.filter.EditPagesPermissionFilter;
import org.exoplatform.wiki.webui.control.filter.IsViewModeFilter;
import org.exoplatform.wiki.webui.control.listener.UIPageToolBarActionListener;

@ComponentConfig(template="app:/templates/wiki/webui/control/action/EditPageActionComponent.gtmpl", events={@EventConfig(listeners={EditPageActionListener.class})})
public class EditPageActionComponent
extends AbstractEventActionComponent {
    public static final String ACTION = "EditPage";
    public static final String SECTION = "section";
    private static final List<UIExtensionFilter> FILTERS = Arrays.asList(new UIExtensionFilter[]{new IsViewModeFilter(), new EditPagesPermissionFilter()});

    @UIExtensionFilters
    public List<UIExtensionFilter> getFilters() {
        return FILTERS;
    }

    @Override
    public String getActionName() {
        return ACTION;
    }

    @Override
    public boolean isAnchor() {
        return true;
    }

    public static class EditPageActionListener
    extends UIPageToolBarActionListener<EditPageActionComponent> {
        @Override
        protected void processEvent(Event<EditPageActionComponent> event) throws Exception {
            UIWikiPortlet wikiPortlet = (UIWikiPortlet)((EditPageActionComponent)((Object)event.getSource())).getAncestorOfType(UIWikiPortlet.class);
            String sectionIndex = event.getRequestContext().getRequestParameter(EditPageActionComponent.SECTION);
            if (sectionIndex == null || sectionIndex.length() == 0) {
                wikiPortlet.changeEditMode(EditMode.ALL);
            } else {
                wikiPortlet.changeEditMode(EditMode.SECTION);
                wikiPortlet.setSectionIndex(sectionIndex);
            }
            UIWikiPageEditForm pageEditForm = (UIWikiPageEditForm)wikiPortlet.findFirstComponentOfType(UIWikiPageEditForm.class);
            UIFormStringInput titleInput = ((UIWikiPageTitleControlArea)pageEditForm.getChild(UIWikiPageTitleControlArea.class)).getUIStringInput();
            UIFormTextAreaInput markupInput = (UIFormTextAreaInput)pageEditForm.findComponentById("Markup");
            UIFormStringInput commentInput = (UIFormStringInput)pageEditForm.findComponentById("Comment");
            Page page = Utils.getCurrentWikiPage();
            String title = page.getTitle();
            String content = page.getContent().getText();
            titleInput.setEditable(true);
            if (wikiPortlet.getEditMode() == EditMode.SECTION) {
                RenderingService renderingService = (RenderingService)PortalContainer.getComponent(RenderingService.class);
                content = renderingService.getContentOfSection(content, page.getSyntax(), sectionIndex);
                titleInput.setEditable(false);
            }
            titleInput.setValue((Object)title);
            pageEditForm.setTitle(title);
            markupInput.setValue((Object)content);
            commentInput.setValue((Object)"");
            commentInput.setRendered(true);
            UIWikiRichTextArea wikiRichTextArea = (UIWikiRichTextArea)pageEditForm.getChild(UIWikiRichTextArea.class);
            if (wikiRichTextArea.isRendered()) {
                Utils.feedDataForWYSIWYGEditor(pageEditForm, null);
            }
            wikiPortlet.changeMode(WikiMode.EDITPAGE);
            pageEditForm.setInitDraftName("");
            super.processEvent(event);
        }
    }
}

