/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.document.impl;

import java.io.IOException;
import java.io.InputStream;
import java.security.PrivilegedExceptionAction;
import java.util.Properties;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.apache.poi.POIXMLProperties;
import org.apache.poi.openxml4j.exceptions.InvalidFormatException;
import org.apache.poi.openxml4j.exceptions.OpenXML4JException;
import org.apache.poi.openxml4j.opc.OPCPackage;
import org.apache.poi.xssf.eventusermodel.ReadOnlySharedStringsTable;
import org.apache.poi.xssf.eventusermodel.XSSFReader;
import org.apache.xmlbeans.XmlException;
import org.exoplatform.commons.utils.SecurityHelper;
import org.exoplatform.services.document.DocumentReadException;
import org.exoplatform.services.document.impl.BaseDocumentReader;
import org.exoplatform.services.document.impl.MSXExcelSheetXMLHandler;
import org.exoplatform.services.document.impl.POIPropertiesReader;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;

public class MSXExcelDocumentReader
extends BaseDocumentReader {
    private static final Log LOG = ExoLogger.getLogger((String)"exo.core.component.document.MSXExcelDocumentReader");
    private static final int MAX_TABS = 5;
    private static final int MAX_CELLTAB = 1000;

    public String[] getMimeTypes() {
        return new String[]{"application/vnd.openxmlformats-officedocument.spreadsheetml.sheet"};
    }

    public void processSheet(MSXExcelSheetXMLHandler.SheetContentsHandler sheetContentsExtractor, ReadOnlySharedStringsTable strings, InputStream sheetInputStream) throws IOException, SAXException {
        block3: {
            InputSource sheetSource = new InputSource(sheetInputStream);
            SAXParserFactory saxFactory = SAXParserFactory.newInstance();
            try {
                SAXParser saxParser = saxFactory.newSAXParser();
                XMLReader sheetParser = saxParser.getXMLReader();
                MSXExcelSheetXMLHandler handler = new MSXExcelSheetXMLHandler(strings, sheetContentsExtractor, 1000L);
                sheetParser.setContentHandler(handler);
                sheetParser.parse(sheetSource);
            }
            catch (ParserConfigurationException e) {
                throw new RuntimeException("SAX parser appears to be broken - " + e.getMessage());
            }
            catch (MSXExcelSheetXMLHandler.StopSheetParsingException e) {
                if (!LOG.isTraceEnabled()) break block3;
                LOG.trace((Object)e.getLocalizedMessage());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getContentAsText(InputStream is) throws IOException, DocumentReadException {
        if (is == null) {
            throw new IllegalArgumentException("InputStream is null.");
        }
        StringBuilder builder = new StringBuilder("");
        try {
            if (is.available() == 0) {
                String string = "";
                return string;
            }
            try {
                OPCPackage container = OPCPackage.open((InputStream)is);
                ReadOnlySharedStringsTable strings = new ReadOnlySharedStringsTable(container);
                XSSFReader xssfReader = new XSSFReader(container);
                XSSFReader.SheetIterator iter = (XSSFReader.SheetIterator)xssfReader.getSheetsData();
                SheetTextExtractor sheetExtractor = new SheetTextExtractor(builder);
                int parsedTabs = 0;
                while (iter.hasNext() && parsedTabs < 5) {
                    InputStream stream = null;
                    ++parsedTabs;
                    try {
                        stream = iter.next();
                        builder.append('\n');
                        builder.append(iter.getSheetName());
                        builder.append('\n');
                        this.processSheet(sheetExtractor, strings, stream);
                    }
                    finally {
                        if (stream == null) continue;
                        try {
                            stream.close();
                        }
                        catch (IOException e) {
                            if (!LOG.isTraceEnabled()) continue;
                            LOG.trace((Object)("An exception occurred: " + e.getMessage()));
                        }
                    }
                }
            }
            catch (InvalidFormatException e) {
                throw new DocumentReadException("The format of the document to read is invalid.", e);
            }
            catch (SAXException e) {
                throw new DocumentReadException("Problem during the document parsing.", e);
            }
            catch (OpenXML4JException e) {
                throw new DocumentReadException("Problem during the document parsing.", e);
            }
        }
        finally {
            block26: {
                if (is != null) {
                    try {
                        is.close();
                    }
                    catch (IOException e) {
                        if (!LOG.isTraceEnabled()) break block26;
                        LOG.trace((Object)("An exception occurred: " + e.getMessage()));
                    }
                }
            }
        }
        return builder.toString();
    }

    public String getContentAsText(InputStream is, String encoding) throws IOException, DocumentReadException {
        return this.getContentAsText(is);
    }

    public Properties getProperties(final InputStream is) throws IOException, DocumentReadException {
        try {
            OPCPackage container = (OPCPackage)SecurityHelper.doPrivilegedIOExceptionAction((PrivilegedExceptionAction)new PrivilegedExceptionAction<OPCPackage>(){

                @Override
                public OPCPackage run() throws Exception {
                    return OPCPackage.open((InputStream)is);
                }
            });
            POIXMLProperties xmlProperties = new POIXMLProperties(container);
            POIPropertiesReader reader = new POIPropertiesReader();
            reader.readDCProperties(xmlProperties);
            return reader.getProperties();
        }
        catch (InvalidFormatException e) {
            throw new DocumentReadException("The format of the document to read is invalid.", e);
        }
        catch (XmlException e) {
            throw new DocumentReadException("Problem during the document parsing.", e);
        }
        catch (OpenXML4JException e) {
            throw new DocumentReadException("Problem during the document parsing.", e);
        }
    }

    protected class SheetTextExtractor
    implements MSXExcelSheetXMLHandler.SheetContentsHandler {
        private final StringBuilder output;
        private boolean firstCellOfRow = true;

        protected SheetTextExtractor(StringBuilder output) {
            this.output = output;
        }

        public void startRow(int rowNum) {
            this.firstCellOfRow = true;
        }

        public void endRow() {
            this.output.append('\n');
        }

        public void cell(String cellRef, String formattedValue) {
            if (this.firstCellOfRow) {
                this.firstCellOfRow = false;
            } else if (formattedValue != null && formattedValue.length() > 2) {
                this.output.append(' ');
            }
            if (formattedValue != null && formattedValue.length() > 2) {
                this.output.append(formattedValue);
            }
        }

        public void headerFooter(String text, boolean isHeader, String tagName) {
        }
    }
}

