/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.social.webui.activity;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Random;
import org.exoplatform.commons.utils.ListAccess;
import org.exoplatform.portal.webui.util.Util;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.social.core.activity.ActivitiesRealtimeListAccess;
import org.exoplatform.social.core.activity.model.ExoSocialActivity;
import org.exoplatform.social.core.identity.model.Identity;
import org.exoplatform.social.core.manager.ActivityManager;
import org.exoplatform.social.core.space.model.Space;
import org.exoplatform.social.webui.Utils;
import org.exoplatform.social.webui.activity.UIActivitiesContainer;
import org.exoplatform.social.webui.composer.UIComposer;
import org.exoplatform.social.webui.profile.UIUserActivitiesDisplay;
import org.exoplatform.web.application.RequireJS;
import org.exoplatform.webui.application.WebuiRequestContext;
import org.exoplatform.webui.config.annotation.ComponentConfig;
import org.exoplatform.webui.config.annotation.EventConfig;
import org.exoplatform.webui.core.UIComponent;
import org.exoplatform.webui.core.UIContainer;
import org.exoplatform.webui.event.Event;
import org.exoplatform.webui.event.EventListener;

@ComponentConfig(template="war:/groovy/social/webui/activity/UIActivitiesLoader.gtmpl", events={@EventConfig(listeners={LoadMoreActionListener.class})})
public class UIActivitiesLoader
extends UIContainer {
    private static final Log LOG = ExoLogger.getLogger(UIActivitiesLoader.class);
    private int currentLoadIndex;
    private boolean hasMore;
    private UIActivitiesLoader lastActivitiesLoader;
    private ListAccess<ExoSocialActivity> activityListAccess;
    private String ownerName;
    private String selectedDisplayMode;
    private UIComposer.PostContext postContext;
    private boolean isExtendLoader;
    private UIActivitiesContainer activitiesContainer;
    private UIContainer extendContainer;
    private int loadingCapacity;
    private int pageSize;
    private Space space;

    public static String genereateId() {
        Random random = new Random();
        return "UIActivitiesLoader_" + random.nextDouble();
    }

    public UIActivitiesLoader() {
        try {
            this.activitiesContainer = (UIActivitiesContainer)this.addChild(UIActivitiesContainer.class, null, "UIActivitiesContainer_" + ((Object)((Object)this)).hashCode());
            this.extendContainer = (UIContainer)this.addChild(UIContainer.class, null, "ExtendContainer_" + ((Object)((Object)this)).hashCode());
        }
        catch (Exception e) {
            LOG.error((Object)e);
        }
    }

    public ListAccess<ExoSocialActivity> getActivityListAccess() {
        return this.activityListAccess;
    }

    public void setActivityListAccess(ListAccess<ExoSocialActivity> activityListAccess) {
        this.activityListAccess = activityListAccess;
    }

    public void setSpace(Space space) {
        this.space = space;
    }

    public UIComposer.PostContext getPostContext() {
        return this.postContext;
    }

    public void setPostContext(UIComposer.PostContext postContext) {
        this.postContext = postContext;
    }

    public boolean isExtendLoader() {
        return this.isExtendLoader;
    }

    public void setExtendLoader(boolean extendLoader) {
        this.isExtendLoader = extendLoader;
    }

    public UIActivitiesContainer getActivitiesContainer() {
        return this.activitiesContainer;
    }

    public UIContainer getExtendContainer() {
        return this.extendContainer;
    }

    public void setLoadingCapacity(int loadingCapacity) {
        this.pageSize = loadingCapacity;
        this.loadingCapacity = loadingCapacity;
    }

    public boolean isHasMore() {
        return this.hasMore;
    }

    public void setHasMore(boolean hasMore) {
        this.hasMore = hasMore;
    }

    public UIActivitiesLoader getLastActivitiesLoader() {
        return this.lastActivitiesLoader;
    }

    public void setExtendContainer(UIContainer extendContainer) {
        this.extendContainer = extendContainer;
    }

    public void setOwnerName(String ownerName) {
        this.ownerName = ownerName;
    }

    public void setSelectedDisplayMode(String selectedDisplayMode) {
        this.selectedDisplayMode = selectedDisplayMode;
    }

    public String getSelectedDisplayMode() {
        return this.selectedDisplayMode;
    }

    protected boolean isUIUserActivityDisplay() {
        return this.getParent() instanceof UIUserActivitiesDisplay;
    }

    public void init() {
        try {
            this.hasMore = false;
            this.currentLoadIndex = 0;
            this.isExtendLoader = false;
            String activityId = this.getSingleActivityId();
            if (activityId != null && activityId.length() > 0) {
                this.postContext = UIComposer.PostContext.SINGLE;
            }
            this.activitiesContainer.setPostContext(this.postContext);
            this.activitiesContainer.setOwnerName(this.ownerName);
            this.activitiesContainer.setSelectedDisplayMode(this.selectedDisplayMode);
            if (this.space != null) {
                this.activitiesContainer.setSpace(this.space);
            }
            List<ExoSocialActivity> activities = new ArrayList<ExoSocialActivity>(0);
            if (this.isShowActivities(this.space)) {
                activities = this.postContext == UIComposer.PostContext.SINGLE ? this.loadActivity() : this.loadActivities(this.currentLoadIndex, this.loadingCapacity);
            }
            this.activitiesContainer.setActivityList(activities);
        }
        catch (Exception e) {
            LOG.error((Object)e.getMessage(), (Throwable)e);
        }
    }

    private String getSingleActivityId() {
        if ("activity".equals(Utils.getSelectedNode())) {
            if (Utils.getValueFromRequestParam("id") != null) {
                return Utils.getValueFromRequestParam("id");
            }
            return Utils.getValueFromRefererURI("id");
        }
        return null;
    }

    private void loadNext() throws Exception {
        if (this.activityListAccess != null && this.activityListAccess instanceof ActivitiesRealtimeListAccess) {
            ActivitiesRealtimeListAccess listAccess = (ActivitiesRealtimeListAccess)this.activityListAccess;
            listAccess.getNumberOfUpgrade();
        }
        this.currentLoadIndex += this.loadingCapacity;
        ArrayList<ExoSocialActivity> activities = new ArrayList(0);
        this.lastActivitiesLoader = (UIActivitiesLoader)this.extendContainer.addChild(UIActivitiesLoader.class, null, UIActivitiesLoader.genereateId());
        this.lastActivitiesLoader.setExtendLoader(true);
        if (this.isShowActivities(this.space)) {
            activities = this.loadActivities(this.currentLoadIndex, this.loadingCapacity);
        }
        UIActivitiesContainer lastActivitiesContainer = this.lastActivitiesLoader.getActivitiesContainer();
        lastActivitiesContainer.setPostContext(this.postContext);
        lastActivitiesContainer.setSpace(this.space);
        this.lastActivitiesLoader.setActivities(activities);
        this.lastActivitiesLoader.setHasMore(this.isHasMore());
    }

    private void setActivities(List<ExoSocialActivity> activities) throws Exception {
        this.activitiesContainer.setActivityList(activities);
    }

    private List<ExoSocialActivity> loadActivities(int index, int length) throws Exception {
        int newLength;
        ExoSocialActivity[] activities;
        if (this.activityListAccess != null && (activities = (ExoSocialActivity[])this.activityListAccess.load(index, newLength = length + 1)) != null) {
            int size = activities.length;
            boolean hasMore = size > length;
            this.setHasMore(hasMore);
            return hasMore ? new ArrayList<ExoSocialActivity>(Arrays.asList(activities)).subList(0, length) : new ArrayList<ExoSocialActivity>(Arrays.asList(activities));
        }
        return null;
    }

    private List<ExoSocialActivity> loadActivity() throws Exception {
        ExoSocialActivity activity;
        ActivityManager activityManager = Utils.getActivityManager();
        String activityId = this.getSingleActivityId();
        ExoSocialActivity exoSocialActivity = activity = activityId != null ? activityManager.getActivity(activityId) : null;
        if (activity == null) {
            return null;
        }
        return new ArrayList<ExoSocialActivity>(Arrays.asList(activity));
    }

    private boolean isShowActivities(Space space) {
        if (space == null && (space = this.getSpaceByActivityId(Utils.getActivityID())) == null) {
            return true;
        }
        String remoteId = Util.getPortalRequestContext().getRemoteUser();
        return Utils.getSpaceService().isMember(space, remoteId);
    }

    private Space getSpaceByActivityId(String activityId) {
        try {
            ExoSocialActivity activity = Utils.getActivityManager().getActivity(activityId);
            Identity spaceIdentity = Utils.getIdentityManager().getOrCreateIdentity("space", activity.getStreamOwner(), true);
            return Utils.getSpaceService().getSpaceByPrettyName(spaceIdentity.getRemoteId());
        }
        catch (Exception e) {
            return null;
        }
    }

    public static class LoadMoreActionListener
    extends EventListener<UIActivitiesLoader> {
        public void execute(Event<UIActivitiesLoader> event) throws Exception {
            UIActivitiesLoader uiActivitiesLoader = (UIActivitiesLoader)((Object)event.getSource());
            uiActivitiesLoader.loadNext();
            WebuiRequestContext context = event.getRequestContext();
            context.addUIComponentToUpdateByAjax((UIComponent)uiActivitiesLoader.getExtendContainer());
            UIActivitiesLoader lastLoader = uiActivitiesLoader.getLastActivitiesLoader();
            uiActivitiesLoader.setExtendContainer(lastLoader.getExtendContainer());
            RequireJS require = context.getJavascriptManager().require("SHARED/social-ui-activities-loader", "activitiesLoader");
            require.addScripts("activitiesLoader.setStatus('" + uiActivitiesLoader.isHasMore() + "');");
            Utils.resizeHomePage();
        }
    }
}

