/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.jcr.impl.dataflow.persistent.jbosscache;

import java.io.Serializable;
import java.security.PrivilegedAction;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.transaction.TransactionManager;
import org.exoplatform.commons.utils.SecurityHelper;
import org.exoplatform.services.jcr.config.RepositoryConfigurationException;
import org.exoplatform.services.jcr.datamodel.ItemData;
import org.exoplatform.services.jcr.impl.core.itemfilters.QPathEntryFilter;
import org.exoplatform.services.jcr.impl.dataflow.persistent.jbosscache.CompressedChangesBuffer;
import org.exoplatform.services.jcr.impl.dataflow.persistent.jbosscache.JBossCacheWorkspaceStorageCache;
import org.exoplatform.services.jcr.jbosscache.ExoJBossCacheFactory;
import org.exoplatform.services.jcr.jbosscache.PrivilegedJBossCacheHelper;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.jboss.cache.Cache;
import org.jboss.cache.CacheException;
import org.jboss.cache.CacheSPI;
import org.jboss.cache.CacheStatus;
import org.jboss.cache.Fqn;
import org.jboss.cache.InvocationContext;
import org.jboss.cache.Node;
import org.jboss.cache.NodeNotExistsException;
import org.jboss.cache.Region;
import org.jboss.cache.config.Configuration;
import org.jboss.cache.factories.ComponentRegistry;
import org.jboss.cache.interceptors.base.CommandInterceptor;
import org.jboss.cache.lock.LockManager;
import org.jgroups.Address;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BufferedJBossCache
implements Cache<Serializable, Object> {
    private final CacheSPI<Serializable, Object> parentCache;
    private final ThreadLocal<CompressedChangesBuffer> changesList = new ThreadLocal();
    private ThreadLocal<Boolean> local = new ThreadLocal();
    private final boolean useExpiration;
    private final long expirationTimeOut;
    private final TransactionManager tm;
    private volatile LockManager lm;
    protected static final Log LOG = ExoLogger.getLogger((String)"org.exoplatform.services.jcr.impl.dataflow.persistent.jbosscache.BufferedJBossCache");

    public BufferedJBossCache(Cache<Serializable, Object> parentCache, boolean useExpiration, long expirationTimeOut) {
        this.parentCache = (CacheSPI)parentCache;
        this.tm = this.parentCache.getTransactionManager() == null ? parentCache.getConfiguration().getRuntimeConfig().getTransactionManager() : this.parentCache.getTransactionManager();
        this.useExpiration = useExpiration;
        this.expirationTimeOut = expirationTimeOut;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public LockManager getLockManager() {
        if (this.lm == null) {
            BufferedJBossCache bufferedJBossCache = this;
            synchronized (bufferedJBossCache) {
                if (this.lm == null) {
                    this.lm = (LockManager)this.parentCache.getComponentRegistry().getComponent(LockManager.class);
                }
            }
        }
        return this.lm;
    }

    public void beginTransaction() {
        this.changesList.set(new CompressedChangesBuffer(this.parentCache.getConfiguration().getCacheMode() != Configuration.CacheMode.LOCAL && this.parentCache.getMembers().size() > 1 && this.parentCache.getTransactionTable().getCurrentTransaction(false) == null));
        this.local.set(false);
    }

    public boolean isTransactionActive() {
        return this.changesList.get() != null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void commitTransaction() {
        CompressedChangesBuffer changesContainer = this.getChangesBufferSafe();
        try {
            List<ChangesContainer> containers = changesContainer.getSortedList();
            this.commitChanges(containers, changesContainer.isInvalidationEnabled());
            Object var4_3 = null;
            this.changesList.set(null);
            changesContainer = null;
        }
        catch (Throwable throwable) {
            Object var4_4 = null;
            this.changesList.set(null);
            changesContainer = null;
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    private void commitChanges(List<ChangesContainer> containers, boolean invalidationEnabled) {
        if (invalidationEnabled) {
            tx = null;
            gt = null;
            try {
                it = containers.iterator();
                while (it.hasNext()) {
                    cacheChange = it.next();
                    if (!cacheChange.isInvalidation()) continue;
                    if (gt == null && (gt = this.parentCache.getCurrentTransaction()) == null) break;
                    owner = this.getLockManager().getWriteOwner(cacheChange.getFqn());
                    if (owner != null && owner.equals(gt)) continue;
                    if (tx == null) {
                        try {
                            tx = this.tm.suspend();
                        }
                        catch (Exception e) {
                            BufferedJBossCache.LOG.warn((Object)"Could not suspend the tx", (Throwable)e);
                        }
                    }
                    if (tx == null) continue;
                    cacheChange.apply();
                    it.remove();
                }
                var10_14 = null;
                ** if (tx == null) goto lbl-1000
            }
            catch (Throwable var9_18) {
                var10_15 = null;
                if (tx != null) {
                    try {
                        this.tm.resume(tx);
                    }
                    catch (Exception e) {
                        BufferedJBossCache.LOG.error((Object)"Could not resume the tx", (Throwable)e);
                    }
                }
                throw var9_18;
            }
lbl-1000:
            // 1 sources

            {
                try {
                    this.tm.resume(tx);
                }
                catch (Exception e) {
                    BufferedJBossCache.LOG.error((Object)"Could not resume the tx", (Throwable)e);
                }
            }
lbl-1000:
            // 2 sources

            {
            }
        }
        for (ChangesContainer cacheChange : containers) {
            isTxCreated = false;
            try {
                if (cacheChange.isTxRequired() && this.tm != null && this.tm.getStatus() == 6) {
                    if (BufferedJBossCache.LOG.isTraceEnabled()) {
                        BufferedJBossCache.LOG.trace((Object)"No Tx is active we then create a new tx");
                    }
                    this.tm.begin();
                    isTxCreated = true;
                }
            }
            catch (Exception e) {
                BufferedJBossCache.LOG.warn((Object)"Could not create a new tx", (Throwable)e);
            }
            try {
                cacheChange.apply();
            }
            catch (RuntimeException e) {
                if (isTxCreated) {
                    try {
                        if (BufferedJBossCache.LOG.isTraceEnabled()) {
                            BufferedJBossCache.LOG.trace((Object)"An error occurs the tx will be rollbacked");
                        }
                        this.parentCache.getInvocationContext().getTransactionContext().getOption().setCacheModeLocal(cacheChange.localMode);
                        this.tm.rollback();
                    }
                    catch (Exception e1) {
                        BufferedJBossCache.LOG.warn((Object)"Could not rollback the tx", (Throwable)e1);
                    }
                }
                throw e;
            }
            if (!isTxCreated) continue;
            try {
                if (BufferedJBossCache.LOG.isTraceEnabled()) {
                    BufferedJBossCache.LOG.trace((Object)"The tx will be committed");
                }
                this.parentCache.getInvocationContext().getTransactionContext().getOption().setCacheModeLocal(cacheChange.localMode);
                this.tm.commit();
            }
            catch (Exception e) {
                BufferedJBossCache.LOG.warn((Object)"Could not commit the tx", (Throwable)e);
            }
        }
    }

    private CompressedChangesBuffer getChangesBufferSafe() {
        CompressedChangesBuffer changesContainer = this.changesList.get();
        if (changesContainer == null) {
            throw new IllegalStateException("changesContainer should not be empty");
        }
        return changesContainer;
    }

    public void rollbackTransaction() {
        this.changesList.set(null);
    }

    public void setLocal(boolean local) {
        if (local && this.changesList.get() == null) {
            this.beginTransaction();
        }
        this.local.set(local);
    }

    public boolean isLocal() {
        return this.local.get();
    }

    public int getNumberOfNodes() {
        return this.parentCache.getNumberOfNodes();
    }

    public void addCacheListener(Object listener) {
        this.parentCache.addCacheListener(listener);
    }

    public void addInterceptor(CommandInterceptor i, Class<? extends CommandInterceptor> afterInterceptor) {
        this.parentCache.addInterceptor(i, afterInterceptor);
    }

    public void addInterceptor(CommandInterceptor i, int position) {
        this.parentCache.addInterceptor(i, position);
    }

    public void clearData(Fqn fqn) {
        this.parentCache.clearData(fqn);
    }

    public void clearData(String fqn) {
        this.parentCache.clearData(fqn);
    }

    public void create() throws CacheException {
        PrivilegedAction<Object> action = new PrivilegedAction<Object>(){

            @Override
            public Object run() {
                BufferedJBossCache.this.parentCache.create();
                return null;
            }
        };
        SecurityHelper.doPrivilegedAction((PrivilegedAction)action);
    }

    public void destroy() {
        this.parentCache.destroy();
    }

    public void endBatch(boolean successful) {
        this.parentCache.endBatch(successful);
    }

    public void evict(Fqn fqn, boolean recursive) {
        this.parentCache.evict(fqn, recursive);
    }

    public void evict(Fqn fqn) {
        this.parentCache.evict(fqn);
    }

    public Object get(Fqn fqn, Serializable key) {
        return this.parentCache.get(fqn, (Object)key);
    }

    public Object getFromBuffer(Fqn fqn, Serializable key) {
        CompressedChangesBuffer changesContainer = this.getChangesBufferSafe();
        Object objectFromBuffer = this.getObjectFromChangesContainer(changesContainer, fqn, key);
        if (objectFromBuffer != null) {
            return objectFromBuffer;
        }
        return this.parentCache.get(fqn, (Object)key);
    }

    Map<Fqn, Map<Serializable, Object>> getLastChanges() {
        CompressedChangesBuffer changesContainer = this.getChangesBufferSafe();
        return changesContainer.getLastChanges();
    }

    public Object get(String fqn, Serializable key) {
        return this.parentCache.get(fqn, (Object)key);
    }

    public Set<Object> getCacheListeners() {
        return this.parentCache.getCacheListeners();
    }

    public CacheStatus getCacheStatus() {
        return this.parentCache.getCacheStatus();
    }

    public Set<Object> getChildrenNames(Fqn fqn) {
        return this.parentCache.getChildrenNames(fqn);
    }

    public Set<String> getChildrenNames(String fqn) {
        return this.parentCache.getChildrenNames(fqn);
    }

    public Configuration getConfiguration() {
        return this.parentCache.getConfiguration();
    }

    public Map<Serializable, Object> getData(Fqn fqn) {
        return this.parentCache.getData(fqn);
    }

    public InvocationContext getInvocationContext() {
        return this.parentCache.getInvocationContext();
    }

    public Set<Serializable> getKeys(Fqn fqn) {
        return this.parentCache.getKeys(fqn);
    }

    public Set<Serializable> getKeys(String fqn) {
        return this.parentCache.getKeys(fqn);
    }

    public Address getLocalAddress() {
        return this.parentCache.getLocalAddress();
    }

    public List<Address> getMembers() {
        return this.parentCache.getMembers();
    }

    public Node<Serializable, Object> getNode(Fqn fqn) {
        return this.parentCache.getNode(fqn);
    }

    public Node<Serializable, Object> getNode(String fqn) {
        return this.parentCache.getNode(fqn);
    }

    public Region getRegion(Fqn fqn, boolean createIfAbsent) {
        return this.parentCache.getRegion(fqn, createIfAbsent);
    }

    public Node<Serializable, Object> getRoot() {
        return this.parentCache.getRoot();
    }

    public String getVersion() {
        return this.parentCache.getVersion();
    }

    public boolean isLeaf(Fqn fqn) {
        return this.parentCache.isLeaf(fqn);
    }

    public boolean isLeaf(String fqn) {
        return this.parentCache.isLeaf(fqn);
    }

    public void move(Fqn nodeToMove, Fqn newParent) throws NodeNotExistsException {
        this.parentCache.move(nodeToMove, newParent);
    }

    public void move(String nodeToMove, String newParent) throws NodeNotExistsException {
        this.parentCache.move(nodeToMove, newParent);
    }

    public void put(Fqn fqn, Map<? extends Serializable, ? extends Object> data) {
        CompressedChangesBuffer changesContainer = this.getChangesBufferSafe();
        changesContainer.add(new PutObjectContainer(fqn, data, (Cache<Serializable, Object>)this.parentCache, changesContainer.getHistoryIndex(), (boolean)this.local.get(), this.useExpiration, this.expirationTimeOut));
    }

    public Object put(Fqn fqn, Serializable key, Object value) {
        this.putOnly(fqn, key, value);
        return this.parentCache.get(fqn, (Object)key);
    }

    public void putOnly(Fqn fqn, Serializable key, Object value) {
        CompressedChangesBuffer changesContainer = this.getChangesBufferSafe();
        changesContainer.add(new PutKeyValueContainer(fqn, key, value, (Cache<Serializable, Object>)this.parentCache, changesContainer.getHistoryIndex(), (boolean)this.local.get(), this.useExpiration, this.expirationTimeOut));
    }

    protected Object put(Fqn fqn, Serializable key, Object value, boolean putIfAbsent, boolean putOnly) {
        if (putIfAbsent) {
            this.putIfAbsent(fqn, key, value);
            return null;
        }
        if (putOnly) {
            this.putOnly(fqn, key, value);
        }
        return this.put(fqn, key, value);
    }

    protected Object putIfAbsent(Fqn fqn, Serializable key, Object value) {
        CompressedChangesBuffer changesContainer = this.getChangesBufferSafe();
        changesContainer.add(new PutIfAbsentKeyValueContainer(fqn, key, value, (Cache<Serializable, Object>)this.parentCache, changesContainer.getHistoryIndex(), (boolean)this.local.get(), this.useExpiration, this.expirationTimeOut));
        return null;
    }

    protected void remove(Fqn fqn, Serializable key, Object value) {
        CompressedChangesBuffer changesContainer = this.getChangesBufferSafe();
        changesContainer.add(new RemoveIfExistKeyContainer(fqn, key, value, (Cache<Serializable, Object>)this.parentCache, changesContainer.getHistoryIndex(), (boolean)this.local.get(), this.useExpiration, this.expirationTimeOut));
    }

    public Object putInBuffer(Fqn fqn, Serializable key, Object value) {
        CompressedChangesBuffer changesContainer = this.getChangesBufferSafe();
        Object prevObject = this.getObjectFromChangesContainer(changesContainer, fqn, key);
        changesContainer.add(new PutKeyValueContainer(fqn, key, value, (Cache<Serializable, Object>)this.parentCache, changesContainer.getHistoryIndex(), (boolean)this.local.get(), this.useExpiration, this.expirationTimeOut));
        if (prevObject != null) {
            return prevObject;
        }
        return this.parentCache.get(fqn, (Object)key);
    }

    private Object getObjectFromChangesContainer(CompressedChangesBuffer changesContainer, Fqn fqn, Serializable key) {
        return changesContainer.get(fqn, key);
    }

    public void put(String fqn, Map<? extends Serializable, ? extends Object> data) {
        throw new UnsupportedOperationException("Unexpected method call use put(Fqn fqn, Map<? extends Serializable, ? extends Object> data)");
    }

    public Object put(String fqn, Serializable key, Object value) {
        throw new UnsupportedOperationException("Unexpected method call use put(Fqn fqn, Serializable key, Object value)");
    }

    public void putForExternalRead(Fqn fqn, Serializable key, Object value) {
        throw new UnsupportedOperationException("Unexpected method call ");
    }

    public Object remove(Fqn fqn, Serializable key) {
        CompressedChangesBuffer changesContainer = this.getChangesBufferSafe();
        changesContainer.add(new RemoveKeyContainer(fqn, key, (Cache<Serializable, Object>)this.parentCache, changesContainer.getHistoryIndex(), (boolean)this.local.get(), this.useExpiration, this.expirationTimeOut));
        return this.parentCache.get(fqn, (Object)key);
    }

    public Object remove(String fqn, Serializable key) {
        throw new UnsupportedOperationException("Unexpected method call. Use remove(Fqn fqn, Serializable key)");
    }

    public void removeCacheListener(Object listener) {
        this.parentCache.removeCacheListener(listener);
    }

    public void removeInterceptor(Class<? extends CommandInterceptor> interceptorType) {
        this.parentCache.removeInterceptor(interceptorType);
    }

    public void removeInterceptor(int position) {
        this.parentCache.removeInterceptor(position);
    }

    public boolean removeNode(Fqn fqn) {
        CompressedChangesBuffer changesContainer = this.getChangesBufferSafe();
        changesContainer.add(new RemoveNodeContainer(fqn, (Cache<Serializable, Object>)this.parentCache, changesContainer.getHistoryIndex(), this.local.get(), this.useExpiration, this.expirationTimeOut));
        return true;
    }

    public void invalidateNode(Fqn fqn) {
        CompressedChangesBuffer changesContainer = this.getChangesBufferSafe();
        changesContainer.add(new RemoveNodeContainer(fqn, (Cache<Serializable, Object>)this.parentCache, changesContainer.getHistoryIndex(), this.local.get(), this.useExpiration, this.expirationTimeOut, true));
    }

    public boolean removeNode(String fqn) {
        throw new UnsupportedOperationException("Unexpected method call. Use remove removeNode(Fqn fqn)");
    }

    public boolean removeRegion(Fqn fqn) {
        return this.parentCache.removeRegion(fqn);
    }

    public void setInvocationContext(InvocationContext ctx) {
        this.parentCache.setInvocationContext(ctx);
    }

    public void start() throws CacheException {
        PrivilegedJBossCacheHelper.start(this.parentCache);
    }

    public void startBatch() {
        this.parentCache.startBatch();
    }

    public void stop() {
        try {
            ExoJBossCacheFactory.releaseUniqueInstance(ExoJBossCacheFactory.CacheType.JCR_CACHE, this.parentCache);
        }
        catch (RepositoryConfigurationException e) {
            LOG.error((Object)"Can not release cache instance", (Throwable)e);
        }
    }

    public ComponentRegistry getComponentRegistry() {
        return this.parentCache.getComponentRegistry();
    }

    public TransactionManager getTransactionManager() {
        return this.parentCache.getTransactionManager();
    }

    public void addToList(Fqn fqn, String key, Object value, boolean forceModify) {
        CompressedChangesBuffer changesContainer = this.getChangesBufferSafe();
        changesContainer.add(new AddToListContainer(fqn, (Serializable)((Object)key), value, (Cache<Serializable, Object>)this.parentCache, forceModify, changesContainer.getHistoryIndex(), this.local.get(), this.useExpiration, this.expirationTimeOut));
    }

    public void addToPatternList(Fqn fqn, String patternKey, String listKey, ItemData value) {
        CompressedChangesBuffer changesContainer = this.getChangesBufferSafe();
        changesContainer.add(new AddToPatternListContainer(fqn, (Serializable)((Object)patternKey), (Serializable)((Object)listKey), value, (Cache<Serializable, Object>)this.parentCache, changesContainer.getHistoryIndex(), this.local.get(), this.useExpiration, this.expirationTimeOut));
    }

    public void removeFromList(Fqn fqn, String key, Object value) {
        CompressedChangesBuffer changesContainer = this.getChangesBufferSafe();
        changesContainer.add(new RemoveFromListContainer(fqn, (Serializable)((Object)key), value, (Cache<Serializable, Object>)this.parentCache, changesContainer.getHistoryIndex(), (boolean)this.local.get(), this.useExpiration, this.expirationTimeOut));
    }

    public void removeFromPatternList(Fqn fqn, String patternKey, String listKey, ItemData value) {
        CompressedChangesBuffer changesContainer = this.getChangesBufferSafe();
        changesContainer.add(new RemoveFromPatternListContainer(fqn, (Serializable)((Object)patternKey), (Serializable)((Object)listKey), value, (Cache<Serializable, Object>)this.parentCache, changesContainer.getHistoryIndex(), this.local.get(), this.useExpiration, this.expirationTimeOut));
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class RemoveNodeContainer
    extends ChangesContainer {
        public RemoveNodeContainer(Fqn fqn, Cache<Serializable, Object> cache, int historicalIndex, boolean local, boolean useExpiration, long timeOut) {
            super(fqn, ChangesType.REMOVE, cache, historicalIndex, local, useExpiration, timeOut);
        }

        public RemoveNodeContainer(Fqn fqn, Cache<Serializable, Object> cache, int historicalIndex, boolean local, boolean useExpiration, long timeOut, boolean invalidation) {
            super(fqn, ChangesType.REMOVE, cache, historicalIndex, local, useExpiration, timeOut, invalidation);
        }

        @Override
        public void apply() {
            this.setCacheLocalMode();
            this.cache.removeNode(this.fqn);
        }

        @Override
        void applyToBuffer(CompressedChangesBuffer buffer) {
            buffer.put(this.fqn, null, null);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class RemoveIfExistKeyContainer
    extends ChangesContainer {
        private final Serializable key;
        private final Object value;

        public RemoveIfExistKeyContainer(Fqn fqn, Serializable key, Object value, Cache<Serializable, Object> cache, int historicalIndex, boolean local, boolean useExpiration, long timeOut) {
            super(fqn, ChangesType.REMOVE_KEY, cache, historicalIndex, local, useExpiration, timeOut);
            this.key = key;
            this.value = value;
        }

        @Override
        public void apply() {
            this.cache.getInvocationContext().getOptionOverrides().setForceWriteLock(true);
            Object existingObject = this.cache.get(this.getFqn(), (Object)this.key);
            if (existingObject != null && existingObject.equals(this.value)) {
                this.setCacheLocalMode();
                this.cache.remove(this.fqn, (Object)this.key);
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class RemoveKeyContainer
    extends ChangesContainer {
        private final Serializable key;

        public RemoveKeyContainer(Fqn fqn, Serializable key, Cache<Serializable, Object> cache, int historicalIndex, boolean local, boolean useExpiration, long timeOut) {
            super(fqn, ChangesType.REMOVE_KEY, cache, historicalIndex, local, useExpiration, timeOut);
            this.key = key;
        }

        @Override
        public void apply() {
            this.setCacheLocalMode();
            this.cache.remove(this.fqn, (Object)this.key);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class RemoveFromPatternListContainer
    extends ChangesContainer {
        private final Serializable patternKey;
        private final Serializable listKey;
        private final ItemData value;

        public RemoveFromPatternListContainer(Fqn fqn, Serializable patternKey, Serializable listKey, ItemData value, Cache<Serializable, Object> cache, int historicalIndex, boolean local, boolean useExpiration, long timeOut) {
            super(fqn, ChangesType.REMOVE_KEY, cache, historicalIndex, local, useExpiration, timeOut, true);
            this.patternKey = patternKey;
            this.listKey = listKey;
            this.value = value;
        }

        @Override
        public void apply() {
            if (this.invalidation) {
                this.cache.removeNode(this.fqn);
                return;
            }
            this.cache.getInvocationContext().getOptionOverrides().setForceWriteLock(true);
            Iterator patternNames = this.cache.getChildrenNames(this.fqn).iterator();
            while (patternNames.hasNext()) {
                Fqn patternFqn = Fqn.fromRelativeElements((Fqn)this.fqn, (Object[])new Object[]{patternNames.next()});
                this.cache.getInvocationContext().getOptionOverrides().setForceWriteLock(true);
                Object patternObject = this.cache.get(patternFqn, (Object)this.patternKey);
                if (!(patternObject instanceof QPathEntryFilter)) {
                    LOG.error((Object)("Unexpected object found by FQN:" + patternFqn + " and key:" + this.patternKey + ". Expected QPathEntryFilter, but found:" + patternObject.getClass().getName()));
                    continue;
                }
                QPathEntryFilter nameFilter = (QPathEntryFilter)patternObject;
                if (!nameFilter.accept(this.value)) continue;
                this.cache.getInvocationContext().getOptionOverrides().setForceWriteLock(true);
                Object setObject = this.cache.get(patternFqn, (Object)this.listKey);
                if (!(setObject instanceof Set)) {
                    LOG.error((Object)("Unexpected object found by FQN:" + patternFqn + " and key:" + this.listKey + ". Expected Set, but found:" + setObject.getClass().getName()));
                    continue;
                }
                HashSet newSet = new HashSet((Set)setObject);
                newSet.remove(this.value.getIdentifier());
                if (this.useExpiration) {
                    this.putExpiration(this.fqn);
                }
                this.setCacheLocalMode();
                this.cache.put(patternFqn, (Object)this.listKey, newSet);
            }
        }

        @Override
        public boolean isTxRequired() {
            return true;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class RemoveFromListContainer
    extends ChangesContainer {
        private final Serializable key;
        private final Object value;

        public RemoveFromListContainer(Fqn fqn, Serializable key, Object value, Cache<Serializable, Object> cache, int historicalIndex, boolean local, boolean useExpiration, long timeOut) {
            super(fqn, ChangesType.REMOVE_KEY, cache, historicalIndex, local, useExpiration, timeOut, true);
            this.key = key;
            this.value = value;
        }

        @Override
        public void apply() {
            if (this.invalidation) {
                this.cache.removeNode(this.fqn);
                return;
            }
            this.cache.getInvocationContext().getOptionOverrides().setForceWriteLock(true);
            Object existingObject = this.cache.get(this.getFqn(), (Object)this.key);
            if (existingObject instanceof JBossCacheWorkspaceStorageCache.FakeValueSet) {
                this.setCacheLocalMode();
                this.cache.put(this.fqn, (Object)this.key, null);
                return;
            }
            if (existingObject instanceof Set) {
                HashSet newSet = new HashSet((Set)existingObject);
                newSet.remove(this.value);
                if (this.useExpiration) {
                    this.putExpiration(this.fqn);
                }
                this.setCacheLocalMode();
                this.cache.put(this.fqn, (Object)this.key, newSet);
            }
        }

        @Override
        public boolean isTxRequired() {
            return true;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class AddToPatternListContainer
    extends ChangesContainer {
        private final Serializable patternKey;
        private final Serializable listKey;
        private final ItemData value;

        public AddToPatternListContainer(Fqn fqn, Serializable patternKey, Serializable listKey, ItemData value, Cache<Serializable, Object> cache, int historicalIndex, boolean local, boolean useExpiration, long timeOut) {
            super(fqn, ChangesType.PUT_KEY, cache, historicalIndex, local, useExpiration, timeOut, true);
            this.patternKey = patternKey;
            this.listKey = listKey;
            this.value = value;
        }

        @Override
        public void apply() {
            if (this.invalidation) {
                this.cache.removeNode(this.fqn);
                return;
            }
            this.cache.getInvocationContext().getOptionOverrides().setForceWriteLock(true);
            for (Object name : this.cache.getChildrenNames(this.fqn)) {
                Fqn patternFqn = Fqn.fromRelativeElements((Fqn)this.fqn, (Object[])new Object[]{name});
                this.cache.getInvocationContext().getOptionOverrides().setForceWriteLock(true);
                Object patternObject = this.cache.get(patternFqn, (Object)this.patternKey);
                if (!(patternObject instanceof QPathEntryFilter)) {
                    LOG.error((Object)("Unexpected object found by FQN:" + patternFqn + " and key:" + this.patternKey + ". Expected QPathEntryFilter, but found:" + patternObject.getClass().getName()));
                    continue;
                }
                QPathEntryFilter nameFilter = (QPathEntryFilter)patternObject;
                if (!nameFilter.accept(this.value)) continue;
                this.cache.getInvocationContext().getOptionOverrides().setForceWriteLock(true);
                Object setObject = this.cache.get(patternFqn, (Object)this.listKey);
                if (!(setObject instanceof Set)) {
                    LOG.error((Object)("Unexpected object found by FQN:" + patternFqn + " and key:" + this.listKey + ". Expected Set, but found:" + setObject.getClass().getName()));
                    continue;
                }
                HashSet<String> newSet = new HashSet<String>((Set)setObject);
                newSet.add(this.value.getIdentifier());
                if (this.useExpiration) {
                    this.putExpiration(this.fqn);
                }
                this.setCacheLocalMode();
                this.cache.put(patternFqn, (Object)this.listKey, newSet);
            }
        }

        @Override
        public boolean isTxRequired() {
            return true;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class AddToListContainer
    extends ChangesContainer {
        private final Serializable key;
        private final Object value;
        private final boolean forceModify;

        public AddToListContainer(Fqn fqn, Serializable key, Object value, Cache<Serializable, Object> cache, boolean forceModify, int historicalIndex, boolean local, boolean useExpiration, long timeOut) {
            super(fqn, ChangesType.PUT_KEY, cache, historicalIndex, local, useExpiration, timeOut, true);
            this.key = key;
            this.value = value;
            this.forceModify = forceModify;
        }

        @Override
        public void apply() {
            if (this.invalidation) {
                this.cache.removeNode(this.fqn);
                return;
            }
            this.cache.getInvocationContext().getOptionOverrides().setForceWriteLock(true);
            Object existingObject = this.cache.get(this.getFqn(), (Object)this.key);
            HashSet<Object> newSet = new HashSet<Object>();
            if (existingObject instanceof Set || existingObject == null && this.forceModify) {
                if (existingObject instanceof JBossCacheWorkspaceStorageCache.FakeValueSet) {
                    this.setCacheLocalMode();
                    this.cache.put(this.fqn, (Object)this.key, null);
                    return;
                }
                if (existingObject instanceof Set) {
                    newSet.addAll((Set)existingObject);
                }
                newSet.add(this.value);
                if (this.useExpiration) {
                    this.putExpiration(this.fqn);
                }
                this.setCacheLocalMode();
                this.cache.put(this.fqn, (Object)this.key, newSet);
            } else if (existingObject != null) {
                LOG.error((Object)("Unexpected object found by FQN:" + this.getFqn() + " and key:" + this.key + ". Expected Set, but found:" + existingObject.getClass().getName()));
            }
        }

        @Override
        public boolean isTxRequired() {
            return true;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class PutKeyValueContainer
    extends ChangesContainer {
        private final Serializable key;
        private final Object value;

        public PutKeyValueContainer(Fqn fqn, Serializable key, Object value, Cache<Serializable, Object> cache, int historicalIndex, boolean local, boolean useExpiration, long timeOut) {
            super(fqn, ChangesType.PUT_KEY, cache, historicalIndex, local, useExpiration, timeOut);
            this.key = key;
            this.value = value;
        }

        @Override
        public void apply() {
            if (this.useExpiration) {
                this.putExpiration(this.fqn);
            }
            this.setCacheLocalMode();
            this.cache.put(this.fqn, (Object)this.key, this.value);
        }

        @Override
        void applyToBuffer(CompressedChangesBuffer buffer) {
            buffer.put(this.fqn, this.key, this.value);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class PutIfAbsentKeyValueContainer
    extends ChangesContainer {
        private final Serializable key;
        private final Object value;

        public PutIfAbsentKeyValueContainer(Fqn fqn, Serializable key, Object value, Cache<Serializable, Object> cache, int historicalIndex, boolean local, boolean useExpiration, long timeOut) {
            super(fqn, ChangesType.PUT_KEY, cache, historicalIndex, local, useExpiration, timeOut);
            this.key = key;
            this.value = value;
        }

        @Override
        public void apply() {
            if (!this.localMode && this.value instanceof JBossCacheWorkspaceStorageCache.FakeValueSet) {
                return;
            }
            this.cache.getInvocationContext().getOptionOverrides().setForceWriteLock(true);
            Object oldValue = this.cache.get(this.fqn, (Object)this.key);
            if (oldValue != null && !(oldValue instanceof JBossCacheWorkspaceStorageCache.FakeValueSet)) {
                return;
            }
            if (this.useExpiration) {
                this.putExpiration(this.fqn);
            }
            this.setCacheLocalMode();
            this.cache.put(this.fqn, (Object)this.key, this.value);
        }

        @Override
        public boolean isTxRequired() {
            return true;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class PutObjectContainer
    extends ChangesContainer {
        private final Map<? extends Serializable, ? extends Object> data;

        public PutObjectContainer(Fqn fqn, Map<? extends Serializable, ? extends Object> data, Cache<Serializable, Object> cache, int historicalIndex, boolean local, boolean useExpiration, long timeOut) {
            super(fqn, ChangesType.PUT, cache, historicalIndex, local, useExpiration, timeOut);
            this.data = data;
        }

        @Override
        public void apply() {
            if (this.useExpiration) {
                this.putExpiration(this.fqn);
            }
            this.setCacheLocalMode();
            this.cache.put(this.fqn, this.data);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static abstract class ChangesContainer
    implements Comparable<ChangesContainer> {
        protected final Fqn fqn;
        protected final ChangesType changesType;
        protected final Cache<Serializable, Object> cache;
        protected final int historicalIndex;
        protected final boolean localMode;
        protected final boolean useExpiration;
        protected final long timeOut;
        protected boolean invalidation;

        public ChangesContainer(Fqn fqn, ChangesType changesType, Cache<Serializable, Object> cache, int historicalIndex, boolean localMode, boolean useExpiration, long timeOut) {
            this(fqn, changesType, cache, historicalIndex, localMode, useExpiration, timeOut, false);
        }

        public ChangesContainer(Fqn fqn, ChangesType changesType, Cache<Serializable, Object> cache, int historicalIndex, boolean localMode, boolean useExpiration, long timeOut, boolean invalidation) {
            this.fqn = fqn;
            this.changesType = changesType;
            this.cache = cache;
            this.historicalIndex = historicalIndex;
            this.localMode = localMode;
            this.useExpiration = useExpiration;
            this.timeOut = timeOut;
            this.invalidation = invalidation && !localMode;
        }

        public Fqn getFqn() {
            return this.fqn;
        }

        public int getHistoricalIndex() {
            return this.historicalIndex;
        }

        public ChangesType getChangesType() {
            return this.changesType;
        }

        public String toString() {
            return this.fqn + " type=" + (Object)((Object)this.changesType) + " historyIndex=" + this.historicalIndex;
        }

        @Override
        public int compareTo(ChangesContainer o) {
            int result = this.fqn.compareTo(o.getFqn());
            return result == 0 ? this.historicalIndex - o.getHistoricalIndex() : result;
        }

        protected void setCacheLocalMode() {
            this.cache.getInvocationContext().getOptionOverrides().setCacheModeLocal(this.localMode);
        }

        public final void putExpiration(Fqn efqn) {
            this.setCacheLocalMode();
            this.cache.put(efqn, (Object)"expiration", (Object)new Long(System.currentTimeMillis() + this.timeOut));
        }

        public abstract void apply();

        public boolean isTxRequired() {
            return false;
        }

        public boolean isInvalidation() {
            return this.invalidation;
        }

        void setInvalidation(boolean invalidationEnabled) {
            this.invalidation &= invalidationEnabled;
        }

        void applyToBuffer(CompressedChangesBuffer buffer) {
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum ChangesType {
        REMOVE,
        REMOVE_KEY,
        PUT,
        PUT_KEY,
        PUT_TO_LIST;

    }
}

