/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.wiki.webui.control.action;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.exoplatform.container.PortalContainer;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.web.application.ApplicationMessage;
import org.exoplatform.webui.config.annotation.ComponentConfig;
import org.exoplatform.webui.config.annotation.EventConfig;
import org.exoplatform.webui.core.UIComponent;
import org.exoplatform.webui.event.Event;
import org.exoplatform.webui.ext.filter.UIExtensionFilter;
import org.exoplatform.webui.ext.filter.UIExtensionFilters;
import org.exoplatform.webui.form.UIFormStringInput;
import org.exoplatform.webui.form.UIFormTextAreaInput;
import org.exoplatform.webui.form.input.UICheckBoxInput;
import org.exoplatform.wiki.commons.Utils;
import org.exoplatform.wiki.mow.api.DraftPage;
import org.exoplatform.wiki.mow.api.Page;
import org.exoplatform.wiki.mow.core.api.wiki.PageImpl;
import org.exoplatform.wiki.rendering.RenderingService;
import org.exoplatform.wiki.resolver.TitleResolver;
import org.exoplatform.wiki.service.WikiPageParams;
import org.exoplatform.wiki.service.WikiService;
import org.exoplatform.wiki.service.impl.WikiPageHistory;
import org.exoplatform.wiki.webui.EditMode;
import org.exoplatform.wiki.webui.UIWikiPageEditForm;
import org.exoplatform.wiki.webui.UIWikiPageTitleControlArea;
import org.exoplatform.wiki.webui.UIWikiPortlet;
import org.exoplatform.wiki.webui.UIWikiRichTextArea;
import org.exoplatform.wiki.webui.WikiMode;
import org.exoplatform.wiki.webui.control.filter.IsEditAddModeFilter;
import org.exoplatform.wiki.webui.control.filter.IsEditAddPageModeFilter;
import org.exoplatform.wiki.webui.control.listener.UISubmitToolBarActionListener;
import org.xwiki.rendering.syntax.Syntax;

@ComponentConfig(template="app:/templates/wiki/webui/control/action/SavePageActionComponent.gtmpl", events={@EventConfig(listeners={SavePageActionListener.class}, phase=Event.Phase.DECODE)})
public class SavePageActionComponent
extends UIComponent {
    public static final String ACTION = "SavePage";
    private static final Log log = ExoLogger.getLogger((String)"wiki:SavePageActionComponent");
    private static final List<UIExtensionFilter> FILTERS = Arrays.asList(new UIExtensionFilter[]{new IsEditAddModeFilter(), new IsEditAddPageModeFilter()});

    @UIExtensionFilters
    public List<UIExtensionFilter> getFilters() {
        return FILTERS;
    }

    protected boolean isNewMode() {
        return WikiMode.ADDPAGE.equals((Object)((UIWikiPortlet)this.getAncestorOfType(UIWikiPortlet.class)).getWikiMode());
    }

    protected String getPageTitleInputId() {
        return "titleInput";
    }

    protected String getActionLink() throws Exception {
        return Utils.createFormActionLink(this, ACTION, ACTION);
    }

    public static class SavePageActionListener
    extends UISubmitToolBarActionListener<SavePageActionComponent> {
        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        protected void processEvent(Event<SavePageActionComponent> event) throws Exception {
            WikiService wikiService = (WikiService)PortalContainer.getComponent(WikiService.class);
            UIWikiPortlet wikiPortlet = (UIWikiPortlet)((SavePageActionComponent)((Object)event.getSource())).getAncestorOfType(UIWikiPortlet.class);
            WikiPageParams pageParams = Utils.getCurrentWikiPageParams();
            Page page = Utils.getCurrentWikiPage();
            if (page != null) {
                UIWikiPageTitleControlArea pageTitleControlForm = (UIWikiPageTitleControlArea)wikiPortlet.findComponentById("UIWikiPageTitleControlForm_PageControlArea");
                UIWikiPageEditForm pageEditForm = (UIWikiPageEditForm)wikiPortlet.findFirstComponentOfType(UIWikiPageEditForm.class);
                UIWikiRichTextArea wikiRichTextArea = (UIWikiRichTextArea)pageEditForm.getChild(UIWikiRichTextArea.class);
                UIFormStringInput titleInput = ((UIWikiPageTitleControlArea)pageEditForm.getChild(UIWikiPageTitleControlArea.class)).getUIStringInput();
                UIFormTextAreaInput markupInput = (UIFormTextAreaInput)pageEditForm.findComponentById("Markup");
                UIFormStringInput commentInput = (UIFormStringInput)pageEditForm.findComponentById("Comment");
                String syntaxId = Utils.getDefaultSyntax();
                RenderingService renderingService = (RenderingService)PortalContainer.getComponent(RenderingService.class);
                Utils.setUpWikiContext(wikiPortlet);
                String currentUser = org.exoplatform.wiki.utils.Utils.getCurrentUser();
                boolean isRenamedPage = false;
                boolean isContentChange = false;
                String title = ((String)titleInput.getValue()).trim();
                if (StringUtils.isEmpty((String)title)) {
                    event.getRequestContext().getUIApplication().addMessage(new ApplicationMessage("WikiPageNameValidator.msg.EmptyTitle", null, 1));
                    Utils.redirect(Utils.getCurrentWikiPageParams(), WikiMode.EDITPAGE);
                    return;
                }
                if (wikiRichTextArea.isRendered()) {
                    String htmlContent = (String)wikiRichTextArea.getUIFormTextAreaInput().getValue();
                    String markupContent = renderingService.render(htmlContent, Syntax.XHTML_1_0.toIdString(), syntaxId, false);
                    markupInput.setValue((Object)markupContent);
                }
                String markup = markupInput.getValue() == null ? "" : (String)markupInput.getValue();
                markup = markup.trim();
                String newPageId = TitleResolver.getId((String)title, (boolean)false);
                pageParams.setPageId(newPageId);
                if (!("WikiHome".equals(page.getName()) && wikiPortlet.getWikiMode() == WikiMode.EDITPAGE || newPageId.equals(page.getName()) && wikiPortlet.getWikiMode() == WikiMode.EDITPAGE || !wikiService.isExisting(pageParams.getType(), pageParams.getOwner(), newPageId))) {
                    if (log.isDebugEnabled()) {
                        log.debug((Object)("The title '" + title + "' is already existing!"));
                    }
                    event.getRequestContext().getUIApplication().addMessage(new ApplicationMessage("SavePageAction.msg.warning-page-title-already-exist", null, 1));
                    Utils.redirect(pageParams, wikiPortlet.getWikiMode());
                    return;
                }
                try {
                    if (wikiPortlet.getWikiMode() == WikiMode.EDITPAGE) {
                        UICheckBoxInput publishActivityCheckBox;
                        if (wikiPortlet.getEditMode() == EditMode.SECTION) {
                            newPageId = page.getName();
                            title = page.getTitle();
                            markup = renderingService.updateContentOfSection(page.getContent().getText(), page.getSyntax(), wikiPortlet.getSectionIndex(), markup);
                            isContentChange = true;
                        }
                        page.setMinorEdit(!(publishActivityCheckBox = (UICheckBoxInput)wikiPortlet.findComponentById("PublishActivityUpper")).isChecked());
                        pageEditForm.synPublishActivityStatus(false);
                        if (!page.getTitle().equals(title)) {
                            isRenamedPage = true;
                        }
                        if (!page.getName().equals(newPageId)) {
                            wikiService.renamePage(pageParams.getType(), pageParams.getOwner(), page.getName(), newPageId, title);
                        }
                        String string = page.getJCRPageNode().getUUID();
                        synchronized (string) {
                            page.setComment((String)commentInput.getValue());
                            page.setSyntax(syntaxId);
                            pageTitleControlForm.getUIFormInputInfo().setValue((Object)title);
                            pageParams.setPageId(page.getName());
                            page.setURL(Utils.getURLFromParams(pageParams));
                            if (!page.getContent().getText().equals(markup)) {
                                page.getContent().setText(markup);
                                isContentChange = true;
                            }
                            if (!pageEditForm.getTitle().equals(title)) {
                                page.setTitle(title);
                                ((PageImpl)page).checkin();
                                ((PageImpl)page).checkout();
                                pageParams.setPageId(newPageId);
                            } else {
                                ((PageImpl)page).checkin();
                                ((PageImpl)page).checkout();
                            }
                            if (!"__anonim".equals(currentUser)) {
                                wikiService.removeDraft(pageParams);
                            }
                        }
                        if (isRenamedPage && isContentChange) {
                            wikiService.postUpdatePage(pageParams.getType(), pageParams.getOwner(), pageParams.getPageId(), page, "editPageContentAndTitle");
                        } else if (isRenamedPage) {
                            wikiService.postUpdatePage(pageParams.getType(), pageParams.getOwner(), pageParams.getPageId(), page, "editPageTitle");
                        } else if (isContentChange) {
                            wikiService.postUpdatePage(pageParams.getType(), pageParams.getOwner(), pageParams.getPageId(), page, "editPageContent");
                        }
                    } else if (wikiPortlet.getWikiMode() == WikiMode.ADDPAGE) {
                        Page draftPage = Utils.getCurrentNewDraftWikiPage();
                        Collection attachs = draftPage.getAttachments();
                        Page addedPage = wikiService.createPage(pageParams.getType(), pageParams.getOwner(), title, page.getName());
                        pageParams.setPageId(newPageId);
                        addedPage.setURL(Utils.getURLFromParams(pageParams));
                        addedPage.getContent().setText(markup);
                        addedPage.setSyntax(syntaxId);
                        ((PageImpl)addedPage).getAttachments().addAll(attachs);
                        ((PageImpl)addedPage).checkin();
                        ((PageImpl)addedPage).checkout();
                        draftPage.remove();
                        PageImpl parentPage = addedPage.getParentPage();
                        DraftPage contentDraftPage = this.findTheMatchDraft(title, (Page)parentPage);
                        if (contentDraftPage == null) {
                            Map pageLogs = org.exoplatform.wiki.utils.Utils.getLogOfPage((String)parentPage.getName());
                            WikiPageHistory log = (WikiPageHistory)pageLogs.get(currentUser);
                            if (log != null && log.isNewPage()) {
                                wikiService.removeDraft(log.getDraftName());
                            }
                        } else {
                            contentDraftPage.remove();
                        }
                        wikiService.postAddPage(pageParams.getType(), pageParams.getOwner(), pageParams.getPageId(), addedPage);
                    }
                    org.exoplatform.wiki.utils.Utils.removeLogEditPage((WikiPageParams)pageParams, (String)currentUser);
                }
                catch (Exception e) {
                    log.error((Object)("An exception happens when saving the page with title:" + title), (Throwable)e);
                    event.getRequestContext().getUIApplication().addMessage(new ApplicationMessage("UIPageToolBar.msg.Exception", null, 0));
                }
                finally {
                    wikiPortlet.changeMode(WikiMode.VIEW);
                    Utils.redirect(pageParams, WikiMode.VIEW);
                }
            } else {
                wikiPortlet.changeMode(WikiMode.VIEW);
                Utils.redirect(pageParams, WikiMode.VIEW);
            }
        }

        private DraftPage findTheMatchDraft(String pageTitle, Page parentPage) throws Exception {
            WikiService wikiService = (WikiService)PortalContainer.getComponent(WikiService.class);
            String parentUUID = parentPage.getJCRPageNode().getUUID();
            String currentUser = org.exoplatform.wiki.utils.Utils.getCurrentUser();
            List draftPages = wikiService.getDrafts(currentUser);
            for (DraftPage draftPage : draftPages) {
                if (!draftPage.getTitle().equals(pageTitle) || !draftPage.getTargetPage().equals(parentUUID)) continue;
                return draftPage;
            }
            return null;
        }
    }
}

