/*
 * Decompiled with CFR 0.152.
 */
package com.google.javascript.jscomp;

import com.google.common.base.Preconditions;
import com.google.common.base.Supplier;
import com.google.common.collect.Lists;
import com.google.javascript.jscomp.AbstractCompiler;
import com.google.javascript.jscomp.AstParallelizer;
import com.google.javascript.jscomp.CompilerPass;
import com.google.javascript.jscomp.JSError;
import com.google.javascript.rhino.Node;
import java.util.List;

final class ParallelCompilerPass
implements CompilerPass {
    private final AstParallelizer splitter;
    private final AbstractCompiler compiler;
    private final int numWorkers;
    private final Supplier<Task> taskSupply;
    private List<Node> worklist;

    public ParallelCompilerPass(AbstractCompiler compiler, AstParallelizer splitter, Supplier<Task> taskSupply, int numWorkers) {
        Preconditions.checkArgument((numWorkers > 0 ? 1 : 0) != 0);
        this.taskSupply = taskSupply;
        this.splitter = splitter;
        this.numWorkers = numWorkers;
        this.compiler = compiler;
    }

    @Override
    public void process(Node externs, Node root) {
        this.worklist = this.splitter.split();
        Result r = this.execute();
        this.splitter.join();
        r.notifyCompiler(this.compiler);
    }

    private Result execute() {
        int i;
        int numChildThread = this.numWorkers - 1;
        Thread[] workers = new Thread[numChildThread];
        final Result[] results = new Result[numChildThread];
        for (int i2 = 0; i2 < numChildThread; ++i2) {
            Thread worker;
            final int index = i2;
            workers[i2] = worker = new Thread(){

                @Override
                public void run() {
                    results[index] = ParallelCompilerPass.this.processAllTasks();
                }
            };
            worker.start();
        }
        Result result = this.processAllTasks();
        for (i = 0; i < numChildThread; ++i) {
            try {
                workers[i].join();
                continue;
            }
            catch (InterruptedException e) {
                result.exceptions.add(e);
                Thread.currentThread().interrupt();
            }
        }
        for (i = 0; i < numChildThread; ++i) {
            result.combine(results[i]);
        }
        return result;
    }

    private Result processAllTasks() {
        Result passResult;
        Result result = new Result();
        while ((passResult = this.processTask()) != null) {
            result.combine(passResult);
        }
        return result;
    }

    private Result processTask() {
        Node subtree = this.getTask();
        try {
            if (subtree == null) {
                return null;
            }
            return ((Task)this.taskSupply.get()).processSubtree(subtree);
        }
        catch (Exception e) {
            Result r = new Result(true);
            r.exceptions.add(e);
            return r;
        }
    }

    private synchronized Node getTask() {
        if (this.worklist.isEmpty()) {
            return null;
        }
        return this.worklist.remove(0);
    }

    public static class Result {
        boolean changed = false;
        List<JSError> errors = Lists.newArrayList();
        List<Exception> exceptions = Lists.newArrayList();

        public Result() {
        }

        public Result(boolean changed) {
            this.changed = changed;
        }

        private void combine(Result other) {
            this.changed = this.changed || other.changed;
            this.errors.addAll(other.errors);
            this.exceptions.addAll(other.exceptions);
        }

        public void notifyCompiler(AbstractCompiler c) {
            if (!this.exceptions.isEmpty()) {
                throw new RuntimeException(this.exceptions.get(0));
            }
            for (JSError error : this.errors) {
                c.report(error);
            }
            if (this.changed) {
                c.reportCodeChange();
            }
        }
    }

    public static interface Task {
        public Result processSubtree(Node var1);
    }
}

