/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.platform.common.service.plugin;

import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import org.exoplatform.container.component.BaseComponentPlugin;
import org.exoplatform.container.configuration.ConfigurationManager;
import org.exoplatform.container.xml.InitParams;
import org.exoplatform.platform.common.service.MenuConfiguratorService;
import org.exoplatform.portal.config.model.ModelUnmarshaller;
import org.exoplatform.portal.config.model.NavigationFragment;
import org.exoplatform.portal.config.model.PageNavigation;
import org.exoplatform.portal.config.model.PageNode;
import org.exoplatform.portal.config.model.UnmarshalledObject;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;

public class MenuConfiguratorAddNodePlugin
extends BaseComponentPlugin {
    private ConfigurationManager configurationManager;
    private MenuConfiguratorService menuConfiguratorService;
    private String navPath;
    private PageNode targetNav;
    private String isChild;
    private static final String EXTENDED_SETUP_NAVIGATION_FILE = "extended.setup.navigation.file";
    private static final String TARGET_NODE_CONFIG = "target.node.config";
    private static final String IS_CHILD = "isChild";
    private static final Log LOG = ExoLogger.getLogger(MenuConfiguratorAddNodePlugin.class);

    public MenuConfiguratorAddNodePlugin(InitParams initParams, ConfigurationManager configurationManager, MenuConfiguratorService menuConfiguratorService) {
        this.configurationManager = configurationManager;
        this.menuConfiguratorService = menuConfiguratorService;
        if (initParams.containsKey((Object)EXTENDED_SETUP_NAVIGATION_FILE)) {
            this.navPath = initParams.getValueParam(EXTENDED_SETUP_NAVIGATION_FILE).getValue();
        }
        if (initParams.containsKey((Object)TARGET_NODE_CONFIG)) {
            this.targetNav = (PageNode)initParams.getObjectParam(TARGET_NODE_CONFIG).getObject();
        }
        if (initParams.containsKey((Object)IS_CHILD)) {
            this.isChild = initParams.getValueParam(IS_CHILD).getValue();
        }
    }

    public void execute() {
        block9: {
            NavigationFragment extendedFragment = null;
            List<PageNode> setupPageNodes = this.menuConfiguratorService.getSetupMenuOriginalPageNodes();
            if (this.isChild == null || this.isChild.isEmpty()) {
                this.isChild = "false";
                LOG.info((Object)"isChild param is not set, default value will be used");
            }
            if (this.navPath != null && !this.navPath.isEmpty()) {
                try {
                    UnmarshalledObject extendedObj = ModelUnmarshaller.unmarshall(PageNavigation.class, (InputStream)this.configurationManager.getInputStream(this.navPath));
                    PageNavigation extendedPageNav = (PageNavigation)extendedObj.getObject();
                    extendedFragment = extendedPageNav.getFragment();
                    if (this.targetNav == null) {
                        for (PageNode pageNode1 : extendedFragment.getNodes()) {
                            setupPageNodes.add(pageNode1);
                        }
                        break block9;
                    }
                    if (this.targetNav.getName() != null && this.targetNav.getPageReference() != null && !this.targetNav.getName().isEmpty() && !this.targetNav.getPageReference().isEmpty()) {
                        boolean addedNav = this.insertExtendedNodes(setupPageNodes, this.targetNav, this.isChild, extendedFragment);
                        if (!addedNav) {
                            LOG.warn((Object)("Navigation with path " + this.navPath + " not added : target node not found"));
                        }
                        break block9;
                    }
                    LOG.warn((Object)("Navigation with path " + this.navPath + " not added : Both name and pageReference should be specified for the target node"));
                }
                catch (Exception E) {
                    LOG.error((Object)("Can not load or read the file with path " + this.navPath + " Please check the path or the file structure "), (Throwable)E);
                }
            } else {
                LOG.warn((Object)"Path for extended setup navigation file not mentioned");
            }
        }
    }

    private boolean insertExtendedNodes(List<PageNode> setupPageNodes, PageNode targetNavigation, String isChild, NavigationFragment frag) {
        boolean isFound = false;
        for (PageNode pageNode : setupPageNodes) {
            List<Object> L;
            if (pageNode.getName().equals(targetNavigation.getName()) && pageNode.getPageReference().equals(targetNavigation.getPageReference())) {
                if (isChild.equals("true")) {
                    L = pageNode.getChildren();
                    if (L == null) {
                        L = new ArrayList<PageNode>();
                    }
                    for (PageNode pageNode1 : frag.getNodes()) {
                        L.add(pageNode1);
                    }
                    pageNode.setChildren(L);
                } else {
                    if (!isChild.equals("false")) {
                        LOG.warn((Object)"isChild param should be set to true or false");
                    }
                    int i = setupPageNodes.indexOf(pageNode);
                    for (PageNode pageNode1 : frag.getNodes()) {
                        setupPageNodes.add(++i, pageNode1);
                    }
                }
                isFound = true;
                break;
            }
            L = pageNode.getChildren();
            if (L == null || !(isFound = this.insertExtendedNodes((List<PageNode>)L, targetNavigation, isChild, frag))) continue;
            break;
        }
        return isFound;
    }
}

