/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.forum.service;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public class SortSettings {
    private SortField field = SortField.ORDER;
    private Direction direction = Direction.ASC;

    public SortSettings(String field, String direction) {
        this.field = this.toField(field);
        this.direction = this.toDirection(direction);
    }

    public SortSettings(SortField field, Direction direction) {
        this.field = field;
        this.direction = direction;
    }

    public SortField getField() {
        return this.field;
    }

    public Direction getDirection() {
        return this.direction;
    }

    private SortField toField(String sortBy) {
        if (SortField.NAME.toString().equalsIgnoreCase(sortBy)) {
            return SortField.NAME;
        }
        if (SortField.CREATED.toString().equalsIgnoreCase(sortBy)) {
            return SortField.CREATED;
        }
        if (SortField.ISLOCK.toString().equalsIgnoreCase(sortBy)) {
            return SortField.ISLOCK;
        }
        if (SortField.TOPICCOUNT.toString().equalsIgnoreCase(sortBy)) {
            return SortField.TOPICCOUNT;
        }
        if (SortField.LASTPOST.toString().equalsIgnoreCase(sortBy)) {
            return SortField.LASTPOST;
        }
        if (SortField.POSTCOUNT.toString().equalsIgnoreCase(sortBy)) {
            return SortField.POSTCOUNT;
        }
        if (SortField.VIEWCOUNT.toString().equalsIgnoreCase(sortBy)) {
            return SortField.VIEWCOUNT;
        }
        if (SortField.ATTACHMENTS.toString().equalsIgnoreCase(sortBy)) {
            return SortField.ATTACHMENTS;
        }
        if (SortField.MODIFIEDDATE.toString().equalsIgnoreCase(sortBy)) {
            return SortField.MODIFIEDDATE;
        }
        return SortField.ORDER;
    }

    private Direction toDirection(String direction) {
        return Direction.DESCENDING.toString().indexOf(direction.toLowerCase()) == 0 ? Direction.DESC : Direction.ASC;
    }

    public static List<String> getDirections() {
        return Arrays.asList(Direction.toValues());
    }

    public static List<String> getTopicSortBys() {
        ArrayList<String> listOrderBy = new ArrayList<String>(Arrays.asList(SortField.toValues()));
        listOrderBy.remove(SortField.ORDER.toString());
        listOrderBy.remove(SortField.TOPICCOUNT.toString());
        return listOrderBy;
    }

    public static List<String> getForumSortBys() {
        ArrayList<String> listOrderBy = new ArrayList<String>(Arrays.asList(SortField.toValues()));
        listOrderBy.remove(SortField.LASTPOST.toString());
        listOrderBy.remove(SortField.VIEWCOUNT.toString());
        listOrderBy.remove(SortField.ATTACHMENTS.toString());
        return listOrderBy;
    }

    public static enum SortField {
        ORDER("forumOrder"),
        NAME("name"),
        ISLOCK("isLock"),
        CREATED("createdDate"),
        MODIFIEDDATE("modifiedDate"),
        LASTPOST("lastPostDate"),
        TOPICCOUNT("topicCount"),
        POSTCOUNT("postCount"),
        VIEWCOUNT("viewCount"),
        ATTACHMENTS("numberAttachments");

        private final String name;

        private SortField(String name) {
            this.name = name;
        }

        public String toString() {
            return this.name;
        }

        public static String[] toValues() {
            int length = SortField.values().length;
            String[] values = new String[length];
            for (int i = 0; i < length; ++i) {
                values[i] = SortField.values()[i].toString();
            }
            return values;
        }
    }

    public static enum Direction {
        ASC("ASC"),
        ASCENDING("ascending"),
        DESC("DESC"),
        DESCENDING("descending");

        private final String name;

        private Direction(String name) {
            this.name = name;
        }

        public String toString() {
            return this.name;
        }

        public static String[] toValues() {
            int length = Direction.values().length;
            String[] values = new String[length];
            for (int i = 0; i < length; ++i) {
                values[i] = Direction.values()[i].toString();
            }
            return values;
        }
    }
}

