/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.forum.service.impl;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import javax.jcr.NodeIterator;
import org.exoplatform.commons.utils.ListAccess;
import org.exoplatform.container.ExoContainerContext;
import org.exoplatform.container.component.ComponentPlugin;
import org.exoplatform.container.xml.InitParams;
import org.exoplatform.forum.common.conf.ManagedPlugin;
import org.exoplatform.forum.common.conf.RoleRulesPlugin;
import org.exoplatform.forum.common.lifecycle.LifeCycleCompletionService;
import org.exoplatform.forum.service.Category;
import org.exoplatform.forum.service.DataStorage;
import org.exoplatform.forum.service.Forum;
import org.exoplatform.forum.service.ForumAdministration;
import org.exoplatform.forum.service.ForumAttachment;
import org.exoplatform.forum.service.ForumEventLifeCycle;
import org.exoplatform.forum.service.ForumEventListener;
import org.exoplatform.forum.service.ForumEventQuery;
import org.exoplatform.forum.service.ForumLinkData;
import org.exoplatform.forum.service.ForumPrivateMessage;
import org.exoplatform.forum.service.ForumSearchResult;
import org.exoplatform.forum.service.ForumService;
import org.exoplatform.forum.service.ForumStatistic;
import org.exoplatform.forum.service.ForumStatisticsService;
import org.exoplatform.forum.service.ForumSubscription;
import org.exoplatform.forum.service.InitializeForumPlugin;
import org.exoplatform.forum.service.JCRPageList;
import org.exoplatform.forum.service.LazyPageList;
import org.exoplatform.forum.service.MessageBuilder;
import org.exoplatform.forum.service.Post;
import org.exoplatform.forum.service.PruneSetting;
import org.exoplatform.forum.service.SendMessageInfo;
import org.exoplatform.forum.service.Tag;
import org.exoplatform.forum.service.Topic;
import org.exoplatform.forum.service.UserLoginLogEntry;
import org.exoplatform.forum.service.UserProfile;
import org.exoplatform.forum.service.Utils;
import org.exoplatform.forum.service.Watch;
import org.exoplatform.forum.service.filter.model.CategoryFilter;
import org.exoplatform.forum.service.filter.model.ForumFilter;
import org.exoplatform.forum.service.impl.ForumServiceManaged;
import org.exoplatform.forum.service.impl.JobManager;
import org.exoplatform.forum.service.impl.model.PostFilter;
import org.exoplatform.forum.service.impl.model.PostListAccess;
import org.exoplatform.forum.service.impl.model.TopicFilter;
import org.exoplatform.forum.service.impl.model.TopicListAccess;
import org.exoplatform.forum.service.impl.model.UserProfileFilter;
import org.exoplatform.forum.service.impl.model.UserProfileListAccess;
import org.exoplatform.management.annotations.ManagedBy;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.services.organization.User;
import org.exoplatform.services.scheduler.JobSchedulerService;
import org.exoplatform.services.user.UserStateModel;
import org.exoplatform.services.user.UserStateService;
import org.picocontainer.Startable;
import org.quartz.JobDetail;

@ManagedBy(value=ForumServiceManaged.class)
public class ForumServiceImpl
implements ForumService,
Startable {
    private static final Log log = ExoLogger.getLogger(ForumServiceImpl.class);
    private DataStorage storage;
    private ForumServiceManaged managementView;
    private final Map<String, LinkedList<UserLoginLogEntry>> queueMap_ = new HashMap<String, LinkedList<UserLoginLogEntry>>();
    private ForumStatisticsService forumStatisticsService;
    private LifeCycleCompletionService completionService;
    private JobSchedulerService jobSchedulerService;
    private UserStateService userStateService;
    protected List<ForumEventListener> listeners_ = new ArrayList<ForumEventListener>(3);

    public ForumServiceImpl(InitParams params, ExoContainerContext context, DataStorage dataStorage, ForumStatisticsService staticsService, JobSchedulerService jobService, UserStateService userStateService, LifeCycleCompletionService completionService) {
        this.storage = dataStorage;
        this.forumStatisticsService = staticsService;
        this.jobSchedulerService = jobService;
        this.userStateService = userStateService;
        this.completionService = completionService;
    }

    @Override
    public void addPlugin(ComponentPlugin plugin) throws Exception {
        this.storage.addPlugin(plugin);
    }

    @Override
    public void addRolePlugin(ComponentPlugin plugin) throws Exception {
        this.storage.addRolePlugin(plugin);
    }

    @Override
    public void addInitialDefaultDataPlugin(ComponentPlugin plugin) throws Exception {
        this.storage.addInitialDefaultDataPlugin(plugin);
    }

    @Override
    public void addInitialDataPlugin(ComponentPlugin plugin) throws Exception {
        this.storage.addInitialDataPlugin(plugin);
    }

    public void start() {
        try {
            log.info((Object)"initializing category listeners...");
            this.storage.initCategoryListener();
        }
        catch (Exception e) {
            log.error((Object)("Error while updating category listeners " + e.getMessage()));
        }
        try {
            log.info((Object)"initializing default data...");
            this.storage.initDefaultData();
        }
        catch (Exception e) {
            log.error((Object)("Error while initializing default data: " + e.getMessage()));
        }
        try {
            log.info((Object)"initializing data...");
            this.storage.initDataPlugin();
        }
        catch (Exception e) {
            log.error((Object)("Error while initializing data plugin: " + e.getMessage()));
        }
        try {
            log.info((Object)"Calculating active users...");
            this.storage.evaluateActiveUsers("");
        }
        catch (Exception e) {
            log.error((Object)("Error while calculating active users: " + e.getMessage()));
        }
        try {
            log.info((Object)"initializing prune schedulers...");
            this.storage.initAutoPruneSchedules();
        }
        catch (Exception e) {
            log.error((Object)("Error while initializing Prune schedulers: " + e.getMessage()));
        }
        try {
            log.info((Object)"initializing deleted user listener...");
            this.storage.addDeletedUserCalculateListener();
        }
        catch (Exception e) {
            log.error((Object)("Error while initializing Prune schedulers: " + e.getMessage()));
        }
        try {
            log.info((Object)"initializing management view...");
            this.managePlugins();
            this.manageStorage();
            this.manageJobs();
        }
        catch (Exception e) {
            log.error((Object)("Error while initializing Management view: " + e.getMessage()));
        }
    }

    private void manageStorage() {
        this.managementView.registerStorageManager(this.storage);
    }

    private void manageJobs() {
        try {
            List jobs = this.jobSchedulerService.getAllJobs();
            for (JobDetail jobDetail : jobs) {
                if (!JobManager.forumJobs.contains(jobDetail.getJobClass().getName())) continue;
                this.managementView.registerJobManager(new JobManager(jobDetail));
            }
        }
        catch (Exception e) {
            log.error((Object)"failed to register jobs manager", (Throwable)e);
        }
    }

    private void managePlugins() {
        List<RoleRulesPlugin> plugins = this.storage.getRulesPlugins();
        for (RoleRulesPlugin plugin2 : plugins) {
            this.managementView.registerPlugin((ManagedPlugin)plugin2);
        }
        List<InitializeForumPlugin> defaultPlugins = this.storage.getDefaultPlugins();
        for (InitializeForumPlugin plugin2 : defaultPlugins) {
            this.managementView.registerPlugin(plugin2);
        }
    }

    public void stop() {
        if (this.completionService != null) {
            this.completionService.shutdownNow();
        }
    }

    @Override
    public void addMember(User user, UserProfile profileTemplate) throws Exception {
        boolean added = this.storage.populateUserProfile(user, profileTemplate, true);
        if (added) {
            this.forumStatisticsService.addMember(user.getUserName());
        }
    }

    @Override
    public void calculateDeletedUser(String userName) throws Exception {
        this.storage.calculateDeletedUser(userName);
    }

    @Override
    public void removeMember(User user) throws Exception {
        String userName = user.getUserName();
        if (this.storage.deleteUserProfile(userName)) {
            this.forumStatisticsService.removeMember(userName);
        }
    }

    @Override
    public void createUserProfile(User user) throws Exception {
    }

    @Override
    public void calculateDeletedGroup(String groupId, String groupName) throws Exception {
        this.storage.calculateDeletedGroup(groupId, groupName);
    }

    @Override
    public void updateUserProfile(User user) throws Exception {
        this.storage.populateUserProfile(user, null, false);
    }

    public void saveEmailUserProfile(String userId, String email) throws Exception {
    }

    @Override
    public void saveCategory(Category category, boolean isNew) throws Exception {
        this.storage.saveCategory(category, isNew);
        for (ForumEventLifeCycle forumEventLifeCycle : this.listeners_) {
            try {
                forumEventLifeCycle.saveCategory(category);
            }
            catch (Exception e) {
                log.debug((Object)"Failed to run function saveCategory in the class ForumEventLifeCycle. ", (Throwable)e);
            }
        }
    }

    @Override
    public void calculateModerator(String categoryPath, boolean isNew) throws Exception {
        this.storage.calculateModerator(categoryPath, false);
    }

    @Override
    public Category getCategory(String categoryId) {
        return this.storage.getCategory(categoryId);
    }

    @Override
    public Category getCategoryIncludedSpace() {
        return this.storage.getCategoryIncludedSpace();
    }

    @Override
    public String[] getPermissionTopicByCategory(String categoryId, String type) throws Exception {
        return this.storage.getPermissionTopicByCategory(categoryId, type);
    }

    @Override
    public List<Category> getCategories() {
        return this.storage.getCategories();
    }

    @Override
    public Category removeCategory(String categoryId) throws Exception {
        List<Forum> listForums = this.storage.getForums(new ForumFilter(categoryId, true));
        for (Forum forum : listForums) {
            String forumId = forum.getId();
            List<Topic> listTopics = this.storage.getTopics(categoryId, forumId);
            for (Topic topic : listTopics) {
                String topicId = topic.getId();
                String topicActivityId = this.storage.getActivityIdForOwner(categoryId.concat("/").concat(forumId).concat("/").concat(topicId));
                for (ForumEventLifeCycle forumEventLifeCycle : this.listeners_) {
                    try {
                        if (topic.getIsPoll()) {
                            String pollActivityId = this.getActivityIdForOwnerPath(categoryId.concat("/").concat(forumId).concat("/").concat(topicId).concat("/").concat(topicId.replace(Utils.TOPIC, Utils.POLL)));
                            forumEventLifeCycle.removeActivity(pollActivityId);
                        }
                        forumEventLifeCycle.removeActivity(topicActivityId);
                    }
                    catch (Exception e) {
                        log.debug((Object)"Failed to run function removeActivity in the class ForumEventLifeCycle. ", (Throwable)e);
                    }
                }
            }
        }
        return this.storage.removeCategory(categoryId);
    }

    @Override
    public void saveModOfCategory(List<String> moderatorCate, String userId, boolean isAdd) {
        this.storage.saveModOfCategory(moderatorCate, userId, isAdd);
    }

    @Override
    public void modifyForum(Forum forum, int type) throws Exception {
        this.storage.modifyForum(forum, type);
        List<Topic> topics = this.storage.getTopics(forum.getCategoryId(), forum.getId());
        for (ForumEventLifeCycle forumEventLifeCycle : this.listeners_) {
            try {
                forumEventLifeCycle.updateTopics(topics, forum.getIsLock());
            }
            catch (Exception e) {
                log.debug((Object)"Failed to run function updateTopic in the class ForumEventLifeCycle. ", (Throwable)e);
            }
        }
    }

    @Override
    public void saveForum(String categoryId, Forum forum, boolean isNew) throws Exception {
        this.storage.saveForum(categoryId, forum, isNew);
        for (ForumEventLifeCycle forumEventLifeCycle : this.listeners_) {
            try {
                forumEventLifeCycle.saveForum(forum);
            }
            catch (Exception e) {
                log.debug((Object)"Failed to run function saveForum in the class ForumEventLifeCycle. ", (Throwable)e);
            }
        }
    }

    @Override
    public void saveModerateOfForums(List<String> forumPaths, String userName, boolean isDelete) throws Exception {
        this.storage.saveModerateOfForums(forumPaths, userName, isDelete);
    }

    @Override
    public void moveForum(List<Forum> forums, String destCategoryPath) throws Exception {
        this.storage.moveForum(forums, destCategoryPath);
    }

    @Override
    public List<CategoryFilter> filterForumByName(String filterKey, String userName, int maxSize) throws Exception {
        return this.storage.filterForumByName(filterKey, userName, maxSize);
    }

    @Override
    public Forum getForum(String categoryId, String forumId) {
        return this.storage.getForum(categoryId, forumId);
    }

    @Override
    public List<Forum> getForums(String categoryId, String strQuery) throws Exception {
        return this.storage.getForums(categoryId, strQuery);
    }

    @Override
    public List<Forum> getForumSummaries(String categoryId, String strQuery) throws Exception {
        return this.storage.getForumSummaries(categoryId, strQuery);
    }

    @Override
    public List<Forum> getForums(ForumFilter filter) {
        return this.storage.getForums(filter);
    }

    @Override
    public Forum removeForum(String categoryId, String forumId) throws Exception {
        List<Topic> listTopics = this.getTopics(categoryId, forumId);
        if (listTopics == null) {
            return null;
        }
        for (Topic topic : listTopics) {
            String topicId = topic.getId();
            String topicActivityId = this.storage.getActivityIdForOwner(categoryId.concat("/").concat(forumId).concat("/").concat(topicId));
            for (ForumEventLifeCycle forumEventLifeCycle : this.listeners_) {
                try {
                    if (topic.getIsPoll()) {
                        String pollActivityId = this.getActivityIdForOwnerPath(categoryId.concat("/").concat(forumId).concat("/").concat(topicId).concat("/").concat(topicId.replace(Utils.TOPIC, Utils.POLL)));
                        forumEventLifeCycle.removeActivity(pollActivityId);
                    }
                    forumEventLifeCycle.removeActivity(topicActivityId);
                }
                catch (Exception e) {
                    log.debug((Object)"Failed to run function removeActivity in the class ForumEventLifeCycle. ", (Throwable)e);
                }
            }
        }
        return this.storage.removeForum(categoryId, forumId);
    }

    @Override
    public void modifyTopic(List<Topic> topics, int type) {
        ArrayList<Topic> editeds = new ArrayList<Topic>();
        Topic edited = null;
        for (Topic topic : topics) {
            try {
                edited = this.getTopic(topic.getCategoryId(), topic.getForumId(), topic.getId(), "");
            }
            catch (Exception e) {
                log.warn((Object)("Ca not get Topic for " + topic.getId()));
            }
            switch (type) {
                case 1: {
                    edited.setEditedIsClosed(topic.getIsClosed());
                    editeds.add(edited);
                    break;
                }
                case 2: {
                    edited.setEditedIsLock(topic.getIsLock());
                    editeds.add(edited);
                    break;
                }
                case 5: {
                    edited.setEditedIsWaiting(topic.getIsWaiting());
                    editeds.add(edited);
                    break;
                }
                case 6: {
                    edited.setEditedIsActive(topic.getIsActive());
                    editeds.add(edited);
                    break;
                }
                case 3: {
                    edited.setEditedIsApproved(topic.getIsApproved());
                    editeds.add(edited);
                    break;
                }
                case 7: {
                    edited.setEditedTopicName(topic.getTopicName());
                    editeds.add(edited);
                    break;
                }
                case 8: {
                    edited.setEditedVoteRating(topic.getVoteRating());
                    editeds.add(edited);
                }
            }
        }
        this.storage.modifyTopic(topics, type);
        for (ForumEventLifeCycle forumEventLifeCycle : this.listeners_) {
            for (Topic topic : editeds) {
                try {
                    forumEventLifeCycle.updateTopic(topic);
                }
                catch (Exception e) {
                    log.debug((Object)"Failed to run function updateTopic in the class ForumEventLifeCycle. ", (Throwable)e);
                }
            }
        }
    }

    @Override
    public void modifyMergedTopic(List<Topic> topics, int type) {
        this.storage.modifyTopic(topics, type);
    }

    @Deprecated
    public void saveTopic(String categoryId, String forumId, Topic topic, boolean isNew, boolean isMove, String defaultEmailContent) throws Exception {
        this.saveTopic(categoryId, forumId, topic, isNew, isMove, new MessageBuilder());
    }

    @Override
    public void saveTopic(String categoryId, String forumId, Topic topic, boolean isNew, boolean isMove, MessageBuilder messageBuilder) throws Exception {
        Topic edited = null;
        if (!isNew) {
            edited = this.getTopic(categoryId, forumId, topic.getId(), "");
            edited.setEditedDescription(topic.getDescription());
            edited.setEditedTopicName(topic.getTopicName());
            edited.setEditedIsClosed(topic.getIsClosed());
            edited.setEditedIsLock(topic.getIsLock());
            edited.setEditedIsWaiting(topic.getIsWaiting());
        }
        this.storage.saveTopic(categoryId, forumId, topic, isNew, isMove, messageBuilder);
        for (ForumEventLifeCycle forumEventLifeCycle : this.listeners_) {
            try {
                if (isNew && topic != null) {
                    forumEventLifeCycle.addTopic(topic);
                    continue;
                }
                if (edited == null) continue;
                forumEventLifeCycle.updateTopic(edited);
            }
            catch (Exception e) {
                log.debug((Object)"Failed to run function addTopic/updateTopic in the class ForumEventLifeCycle. ", (Throwable)e);
            }
        }
    }

    @Override
    public Topic getTopic(String categoryId, String forumId, String topicId, String userRead) throws Exception {
        return this.storage.getTopic(categoryId, forumId, topicId, userRead);
    }

    @Override
    public void setViewCountTopic(String path, String userRead) {
        this.storage.setViewCountTopic(path, userRead);
    }

    @Override
    public void writeReads() {
        this.storage.writeReads();
    }

    @Override
    public Topic getLastPostOfForum(String topicPath) throws Exception {
        return this.storage.getTopicSummary(topicPath, true);
    }

    @Override
    public Topic getTopicSummary(String topicPath) throws Exception {
        return this.storage.getTopicSummary(topicPath);
    }

    @Override
    public Topic getTopicByPath(String topicPath, boolean isLastPost) throws Exception {
        return this.storage.getTopicByPath(topicPath, isLastPost);
    }

    @Override
    public Topic getTopicUpdate(Topic topic, boolean isSummary) throws Exception {
        return this.storage.getTopicUpdate(topic, isSummary);
    }

    @Override
    public LazyPageList<Topic> getTopicList(String categoryId, String forumId, String strQuery, String strOrderBy, int pageSize) throws Exception {
        return this.storage.getTopicList(categoryId, forumId, strQuery, strOrderBy, pageSize);
    }

    @Override
    public JCRPageList getPageTopic(String categoryId, String forumId, String strQuery, String strOrderBy) throws Exception {
        return this.storage.getPageTopic(categoryId, forumId, strQuery, strOrderBy);
    }

    @Override
    public List<Topic> getTopics(String categoryId, String forumId) throws Exception {
        return this.storage.getTopics(categoryId, forumId);
    }

    @Override
    public ListAccess<Topic> getTopics(TopicFilter filter) throws Exception {
        return new TopicListAccess(TopicListAccess.Type.TOPICS, this.storage, filter);
    }

    @Override
    public void moveTopic(List<Topic> topics, String destForumPath, String mailContent, String link) throws Exception {
        this.storage.moveTopic(topics, destForumPath, mailContent, link);
        String toForumName = ((Forum)this.storage.getObjectNameByPath(destForumPath)).getForumName();
        String toCategoryName = ((Category)this.storage.getObjectNameByPath(Utils.getCategoryPath(destForumPath))).getCategoryName();
        for (ForumEventLifeCycle forumEventLifeCycle : this.listeners_) {
            for (Topic topic : topics) {
                topic.setPath(destForumPath.concat("/").concat(topic.getId()));
                try {
                    forumEventLifeCycle.moveTopic(topic, toCategoryName, toForumName);
                }
                catch (Exception e) {
                    log.debug((Object)"Failed to run function moveTopic in the class ForumEventLifeCycle. ", (Throwable)e);
                }
            }
        }
    }

    @Override
    public Topic removeTopic(String categoryId, String forumId, String topicId) throws Exception {
        String topicActivityId = this.storage.getActivityIdForOwner(categoryId.concat("/").concat(forumId).concat("/").concat(topicId));
        Topic topic = this.getTopic(categoryId, forumId, topicId, "");
        String pollActivityId = null;
        if (topic.getIsPoll()) {
            pollActivityId = this.getActivityIdForOwnerPath(categoryId.concat("/").concat(forumId).concat("/").concat(topicId).concat("/").concat(topicId.replace(Utils.TOPIC, Utils.POLL)));
        }
        topic = this.storage.removeTopic(categoryId, forumId, topicId);
        for (ForumEventLifeCycle forumEventLifeCycle : this.listeners_) {
            try {
                if (pollActivityId != null) {
                    forumEventLifeCycle.removeActivity(pollActivityId);
                }
                forumEventLifeCycle.removeActivity(topicActivityId);
            }
            catch (Exception e) {
                log.debug((Object)"Failed to run function removeActivity in the class ForumEventLifeCycle. ", (Throwable)e);
            }
        }
        return topic;
    }

    @Override
    public Post getPost(String categoryId, String forumId, String topicId, String postId) throws Exception {
        return this.storage.getPost(categoryId, forumId, topicId, postId);
    }

    @Override
    public long getLastReadIndex(String path, String isApproved, String isHidden, String userLogin) throws Exception {
        return this.storage.getLastReadIndex(path, isApproved, isHidden, userLogin);
    }

    @Override
    public JCRPageList getPostForSplitTopic(String topicPath) throws Exception {
        return this.storage.getPostForSplitTopic(topicPath);
    }

    @Override
    public JCRPageList getPosts(String categoryId, String forumId, String topicId, String isApproved, String isHidden, String strQuery, String userLogin) throws Exception {
        return this.storage.getPosts(categoryId, forumId, topicId, isApproved, isHidden, strQuery, userLogin);
    }

    @Override
    public ListAccess<Post> getPosts(PostFilter filter) throws Exception {
        return new PostListAccess(PostListAccess.Type.POSTS, this.storage, filter);
    }

    @Override
    public long getAvailablePost(String categoryId, String forumId, String topicId, String isApproved, String isHidden, String userLogin) throws Exception {
        PostFilter filter = new PostFilter(categoryId, forumId, topicId, isApproved, isHidden, isHidden, userLogin);
        return this.storage.getPostsCount(filter);
    }

    @Deprecated
    public void savePost(String categoryId, String forumId, String topicId, Post post, boolean isNew, String defaultEmailContent) throws Exception {
        this.savePost(categoryId, forumId, topicId, post, isNew, new MessageBuilder());
    }

    @Override
    public void savePost(String categoryId, String forumId, String topicId, Post post, boolean isNew, MessageBuilder messageBuilder) throws Exception {
        this.storage.savePost(categoryId, forumId, topicId, post, isNew, messageBuilder);
        if (post.getUserPrivate().length > 1) {
            return;
        }
        if (post != null) {
            for (ForumEventLifeCycle forumEventLifeCycle : this.listeners_) {
                try {
                    if (isNew) {
                        forumEventLifeCycle.addPost(post);
                        continue;
                    }
                    forumEventLifeCycle.updatePost(post);
                }
                catch (Exception e) {
                    log.debug((Object)"Failed to run function addPost/updatePost in the class ForumEventLifeCycle. ", (Throwable)e);
                }
            }
        }
    }

    @Override
    public void modifyPost(List<Post> posts, int type) {
        if (posts == null || posts.isEmpty()) {
            return;
        }
        this.storage.modifyPost(posts, type);
        for (ForumEventLifeCycle forumEventLifeCycle : this.listeners_) {
            for (Post post : posts) {
                try {
                    forumEventLifeCycle.updatePost(post, type);
                }
                catch (Exception e) {
                    log.debug((Object)"Failed to run function updatePost in the class ForumEventLifeCycle. ", (Throwable)e);
                }
            }
        }
    }

    public void movePost(List<Post> posts, String destTopicPath, boolean isCreatNewTopic, String mailContent, String link) throws Exception {
        ArrayList<String> postPaths = new ArrayList<String>();
        for (Post p : posts) {
            postPaths.add(p.getPath());
        }
        this.movePost(postPaths.toArray(new String[postPaths.size()]), destTopicPath, isCreatNewTopic, mailContent, link);
    }

    @Override
    public void movePost(String[] postPaths, String destTopicPath, boolean isCreatNewTopic, String mailContent, String link) throws Exception {
        ArrayList<Post> posts = new ArrayList<Post>();
        ArrayList<String> srcPostActivityIds = new ArrayList<String>();
        for (int i = 0; i < postPaths.length; ++i) {
            Post post = this.storage.getPost(Utils.getCategoryId(postPaths[i]), Utils.getForumId(postPaths[i]), Utils.getTopicId(postPaths[i]), Utils.getPostId(postPaths[i]));
            posts.add(post);
            srcPostActivityIds.add(this.storage.getActivityIdForOwner(post.getPath()));
        }
        this.storage.movePost(postPaths, destTopicPath, isCreatNewTopic, mailContent, link);
        for (ForumEventLifeCycle forumEventLifeCycle : this.listeners_) {
            try {
                forumEventLifeCycle.movePost(posts, srcPostActivityIds, destTopicPath);
            }
            catch (Exception e) {
                log.warn((Object)"Failed to run function movePost in the class ForumEventLifeCycle. ");
                log.debug((Object)e.getMessage(), (Throwable)e);
            }
        }
    }

    @Override
    public void mergeTopic(String srcTopicPath, String destTopicPath, String mailContent, String link, String topicMergeTitle) throws Exception {
        String srcActivityId = this.storage.getActivityIdForOwner(srcTopicPath);
        String destActivityId = this.storage.getActivityIdForOwner(destTopicPath);
        this.storage.mergeTopic(srcTopicPath, destTopicPath, mailContent, link);
        Topic newTopic = this.storage.getTopicByPath(destTopicPath, false);
        newTopic.setTopicName(topicMergeTitle);
        for (ForumEventLifeCycle forumEventLifeCycle : this.listeners_) {
            try {
                forumEventLifeCycle.mergeTopic(newTopic, srcActivityId, destActivityId);
            }
            catch (Exception e) {
                log.debug((Object)"Failed to run function mergeTopic in the class ForumEventLifeCycle. ", (Throwable)e);
            }
        }
    }

    @Override
    public void splitTopic(Topic newTopic, Post fistPost, List<String> postPathMove, String mailContent, String link) throws Exception {
        String srcTopicPath = Utils.getTopicPath(postPathMove.get(0));
        this.storage.splitTopic(newTopic, fistPost, postPathMove, mailContent, link);
        String srcActivityId = this.storage.getActivityIdForOwner(srcTopicPath);
        Topic srcTopic = this.storage.getTopicByPath(srcTopicPath, false);
        for (ForumEventLifeCycle forumEventLifeCycle : this.listeners_) {
            try {
                forumEventLifeCycle.splitTopic(newTopic, srcTopic, srcActivityId);
            }
            catch (Exception e) {
                log.debug((Object)"Failed to run function splitTopic in the class ForumEventLifeCycle. ", (Throwable)e);
            }
        }
    }

    @Override
    public Post removePost(String categoryId, String forumId, String topicId, String postId) {
        String topicActivityId = this.storage.getActivityIdForOwner(categoryId.concat("/").concat(forumId).concat("/").concat(topicId));
        String postActivityId = this.storage.getActivityIdForOwner(categoryId.concat("/").concat(forumId).concat("/").concat(topicId).concat("/").concat(postId));
        Post deleted = this.storage.removePost(categoryId, forumId, topicId, postId);
        for (ForumEventLifeCycle forumEventLifeCycle : this.listeners_) {
            try {
                forumEventLifeCycle.removeComment(topicActivityId, postActivityId);
            }
            catch (Exception e) {
                log.debug((Object)"Failed to run function removeComment in the class ForumEventLifeCycle. ", (Throwable)e);
            }
        }
        return deleted;
    }

    @Override
    public Object getObjectNameByPath(String path) throws Exception {
        return this.storage.getObjectNameByPath(path);
    }

    @Override
    public Object getObjectNameById(String path, String type) throws Exception {
        return this.storage.getObjectNameById(path, type);
    }

    @Override
    public List<ForumLinkData> getAllLink(String strQueryCate, String strQueryForum) throws Exception {
        return this.storage.getAllLink(strQueryCate, strQueryForum);
    }

    @Override
    public String getForumHomePath() throws Exception {
        return this.storage.getDataLocation().getForumHomeLocation();
    }

    @Override
    public void addTag(List<Tag> tags, String userName, String topicPath) throws Exception {
        this.storage.addTag(tags, userName, topicPath);
    }

    @Override
    public List<Tag> getAllTags() throws Exception {
        return this.storage.getAllTags();
    }

    @Override
    public List<Tag> getMyTagInTopic(String[] tagIds) throws Exception {
        return this.storage.getMyTagInTopic(tagIds);
    }

    @Override
    public Tag getTag(String tagId) throws Exception {
        return this.storage.getTag(tagId);
    }

    @Override
    public List<String> getAllTagName(String strQuery, String userAndTopicId) throws Exception {
        return this.storage.getAllTagName(strQuery, userAndTopicId);
    }

    @Override
    public List<String> getTagNameInTopic(String userAndTopicId) throws Exception {
        return this.storage.getTagNameInTopic(userAndTopicId);
    }

    @Override
    public JCRPageList getTopicByMyTag(String userIdAndtagId, String strOrderBy) throws Exception {
        return this.storage.getTopicByMyTag(userIdAndtagId, strOrderBy);
    }

    @Override
    public void saveTag(Tag newTag) throws Exception {
        this.storage.saveTag(newTag);
    }

    @Override
    public void unTag(String tagId, String userName, String topicPath) {
        this.storage.unTag(tagId, userName, topicPath);
    }

    @Override
    public void saveUserModerator(String userName, List<String> ids, boolean isModeCate) throws Exception {
        this.storage.saveUserModerator(userName, ids, isModeCate);
    }

    @Override
    public void saveUserProfile(UserProfile userProfile, boolean isOption, boolean isBan) throws Exception {
        this.storage.saveUserProfile(userProfile, isOption, isBan);
    }

    @Override
    public UserProfile getUserInfo(String userName) throws Exception {
        return this.storage.getUserInfo(userName);
    }

    @Override
    public List<String> getUserModerator(String userName, boolean isModeCate) throws Exception {
        return this.storage.getUserModerator(userName, isModeCate);
    }

    @Override
    public UserProfile getUserProfileManagement(String userName) throws Exception {
        return this.storage.getUserProfileManagement(userName);
    }

    @Override
    public void saveLastPostIdRead(String userId, String[] lastReadPostOfForum, String[] lastReadPostOfTopic) throws Exception {
        this.storage.saveLastPostIdRead(userId, lastReadPostOfForum, lastReadPostOfTopic);
    }

    @Override
    public void saveUserBookmark(String userName, String bookMark, boolean isNew) throws Exception {
        this.storage.saveUserBookmark(userName, bookMark, isNew);
    }

    @Override
    public void saveCollapsedCategories(String userName, String categoryId, boolean isAdd) throws Exception {
        this.storage.saveCollapsedCategories(userName, categoryId, isAdd);
    }

    @Override
    public JCRPageList getPageListUserProfile() throws Exception {
        return this.storage.getPageListUserProfile();
    }

    @Override
    public JCRPageList getPrivateMessage(String userName, String type) throws Exception {
        return this.storage.getPrivateMessage(userName, type);
    }

    @Override
    public long getNewPrivateMessage(String userName) throws Exception {
        return this.storage.getNewPrivateMessage(userName);
    }

    @Override
    public void removePrivateMessage(String messageId, String userName, String type) throws Exception {
        this.storage.removePrivateMessage(messageId, userName, type);
    }

    @Override
    public void saveReadMessage(String messageId, String userName, String type) throws Exception {
        this.storage.saveReadMessage(messageId, userName, type);
    }

    @Override
    public void savePrivateMessage(ForumPrivateMessage privateMessage) throws Exception {
        this.storage.savePrivateMessage(privateMessage);
    }

    @Override
    public ForumSubscription getForumSubscription(String userId) {
        return this.storage.getForumSubscription(userId);
    }

    @Override
    public void saveForumSubscription(ForumSubscription forumSubscription, String userId) throws Exception {
        this.storage.saveForumSubscription(forumSubscription, userId);
    }

    @Override
    public JCRPageList getPageTopicOld(long date, String forumPatch) throws Exception {
        return this.storage.getPageTopicOld(date, forumPatch);
    }

    @Override
    public ListAccess<Topic> getTopicsByDate(long date, String forumPath) throws Exception {
        return new TopicListAccess(TopicListAccess.Type.TOPICS, this.storage, new TopicFilter(date, forumPath));
    }

    @Override
    public List<Topic> getAllTopicsOld(long date, String forumPatch) throws Exception {
        return this.storage.getAllTopicsOld(date, forumPatch);
    }

    @Override
    public long getTotalTopicOld(long date, String forumPatch) {
        return this.storage.getTotalTopicOld(date, forumPatch);
    }

    @Override
    public JCRPageList getPageTopicByUser(String userName, boolean isMod, String strOrderBy) throws Exception {
        return this.storage.getPageTopicByUser(userName, isMod, strOrderBy);
    }

    @Override
    public ListAccess<Topic> getPageTopicByUser(TopicFilter filter) throws Exception {
        return new TopicListAccess(TopicListAccess.Type.TOPICS, this.storage, filter);
    }

    @Override
    public JCRPageList getPagePostByUser(String userName, String userId, boolean isMod, String strOrderBy) throws Exception {
        return this.storage.getPagePostByUser(userName, userId, isMod, strOrderBy);
    }

    @Override
    public ForumStatistic getForumStatistic() throws Exception {
        return this.storage.getForumStatistic();
    }

    @Override
    public void saveForumStatistic(ForumStatistic forumStatistic) throws Exception {
        this.storage.saveForumStatistic(forumStatistic);
    }

    @Override
    public void updateStatisticCounts(long topicCount, long postCount) throws Exception {
        this.storage.updateStatisticCounts(topicCount, postCount);
    }

    @Override
    public List<ForumSearchResult> getQuickSearch(String textQuery, String type, String pathQuery, String userId, List<String> listCateIds, List<String> listForumIds, List<String> forumIdsOfModerator) throws Exception {
        return this.storage.getQuickSearch(textQuery, type, pathQuery, userId, listCateIds, listForumIds, forumIdsOfModerator);
    }

    @Override
    public List<ForumSearchResult> getAdvancedSearch(ForumEventQuery eventQuery, List<String> listCateIds, List<String> listForumIds) {
        return this.storage.getAdvancedSearch(eventQuery, listCateIds, listForumIds);
    }

    @Override
    public ForumAdministration getForumAdministration() throws Exception {
        return this.storage.getForumAdministration();
    }

    @Override
    public void saveForumAdministration(ForumAdministration forumAdministration) throws Exception {
        this.storage.saveForumAdministration(forumAdministration);
    }

    @Override
    public void addWatch(int watchType, String path, List<String> values, String currentUser) throws Exception {
        this.storage.addWatch(watchType, path, values, currentUser);
    }

    @Override
    public void removeWatch(int watchType, String path, String values) throws Exception {
        this.storage.removeWatch(watchType, path, values);
    }

    @Override
    public List<ForumSearchResult> getJobWattingForModerator(String[] paths) {
        return this.storage.getJobWattingForModerator(paths);
    }

    @Override
    public int getJobWattingForModeratorByUser(String userId) throws Exception {
        return this.storage.getJobWattingForModeratorByUser(userId);
    }

    @Override
    public void updateLoggedinUsers(String repoName) throws Exception {
        LinkedList<UserLoginLogEntry> queue = this.queueMap_.get(repoName);
        if (queue == null || queue.size() == 0) {
            return;
        }
        this.queueMap_.remove(repoName);
        for (UserLoginLogEntry loginEntry_ : queue) {
            this.storage.updateLastLoginDate(loginEntry_.userName);
        }
        UserLoginLogEntry loginEntry = queue.getFirst();
        int maxOnline = loginEntry.totalOnline;
        Calendar timestamp = loginEntry.loginTime;
        ForumStatistic stats = this.storage.getForumStatistic();
        int jcrMostOnline = this.getMaxOnlineFromStorage(stats);
        if (maxOnline > jcrMostOnline) {
            stats.setMostUsersOnline(maxOnline + "," + timestamp.getTimeInMillis());
            this.storage.saveForumStatistic(stats);
        }
    }

    private int getMaxOnlineFromStorage(ForumStatistic stats) throws Exception {
        int mostOnline = 0;
        String mostUsersOnline = stats.getMostUsersOnline();
        if (mostUsersOnline != null && mostUsersOnline.length() > 0) {
            String[] array = mostUsersOnline.split(",");
            try {
                mostOnline = Integer.parseInt(array[0].trim());
            }
            catch (NumberFormatException e) {
                return 0;
            }
        }
        return mostOnline;
    }

    @Override
    public void updateLoggedinUsers() throws Exception {
        this.updateLoggedinUsers(Utils.DEFAULT_TENANT_NAME);
    }

    @Override
    public void userLogin(String userId) throws Exception {
        this.userLogin(Utils.DEFAULT_TENANT_NAME, userId);
        this.userStateService.ping(userId);
    }

    @Override
    public void userLogin(String repoName, String userId) throws Exception {
        int latestMaxOnline;
        if (this.userStateService.isOnline(userId)) {
            return;
        }
        LinkedList<UserLoginLogEntry> queue = this.queueMap_.get(repoName);
        if (queue == null) {
            queue = new LinkedList();
        }
        int onlineSize = this.userStateService.online().size() + 1;
        UserLoginLogEntry loginEntry = new UserLoginLogEntry(userId, Math.max(onlineSize, queue.size() + 1));
        int n = latestMaxOnline = queue.size() > 0 ? queue.getFirst().totalOnline : 0;
        if (latestMaxOnline < onlineSize) {
            queue.addFirst(loginEntry);
        } else {
            queue.addLast(loginEntry);
        }
        this.queueMap_.put(repoName, queue);
    }

    @Override
    public void userLogout(String userId) throws Exception {
        this.removeCacheUserProfile(userId);
    }

    @Override
    public boolean isOnline(String userId) throws Exception {
        return this.userStateService.isOnline(userId);
    }

    @Override
    public List<String> getOnlineUsers() throws Exception {
        ArrayList<String> onlineUsers = new ArrayList<String>();
        List onlines = this.userStateService.online();
        for (UserStateModel model : onlines) {
            onlineUsers.add(model.getUserId());
        }
        return onlineUsers;
    }

    @Override
    public String getLastLogin() throws Exception {
        List<String> onlineUsers = this.getOnlineUsers();
        int size = onlineUsers.size();
        return size > 0 ? onlineUsers.get(size - 1) : "";
    }

    @Override
    public SendMessageInfo getMessageInfo(String name) throws Exception {
        return this.storage.getMessageInfo(name);
    }

    @Override
    public Iterator<SendMessageInfo> getPendingMessages() throws Exception {
        return this.storage.getPendingMessages();
    }

    @Override
    public JCRPageList searchUserProfile(String userSearch) throws Exception {
        return this.storage.searchUserProfile(userSearch);
    }

    @Override
    public boolean isAdminRole(String userName) throws Exception {
        return this.storage.isAdminRole(userName);
    }

    @Override
    public boolean isAdminRoleConfig(String userName) throws Exception {
        return this.storage.isAdminRoleConfig(userName);
    }

    @Override
    public List<Post> getNewPosts(int number) throws Exception {
        return this.storage.getNewPosts(number);
    }

    @Override
    public List<Post> getRecentPostsForUser(String userName, int number) throws Exception {
        return this.storage.getRecentPostsForUser(userName, number);
    }

    @Override
    public NodeIterator search(String queryString) throws Exception {
        return this.storage.search(queryString);
    }

    @Override
    public void evaluateActiveUsers(String query) {
        this.storage.evaluateActiveUsers(query);
    }

    @Override
    public void updateTopicAccess(String userId, String topicId) {
        this.storage.updateTopicAccess(userId, topicId);
    }

    @Override
    public void updateForumAccess(String userId, String forumId) {
        this.storage.updateForumAccess(userId, forumId);
    }

    @Override
    public void writeViews() {
        this.storage.writeViews();
    }

    @Override
    public Object exportXML(String categoryId, String forumId, List<String> objectIds, String nodePath, ByteArrayOutputStream bos, boolean isExportAll) throws Exception {
        return this.storage.exportXML(categoryId, forumId, objectIds, nodePath, bos, isExportAll);
    }

    @Override
    public List<UserProfile> getQuickProfiles(List<String> userList) throws Exception {
        return this.storage.getQuickProfiles(userList);
    }

    @Override
    public UserProfile getQuickProfile(String userName) throws Exception {
        return this.storage.getQuickProfile(userName);
    }

    @Override
    public String getScreenName(String userName) throws Exception {
        return this.storage.getScreenName(userName);
    }

    @Override
    public UserProfile getUserInformations(UserProfile userProfile) throws Exception {
        return this.storage.getUserInformations(userProfile);
    }

    @Override
    public UserProfile getDefaultUserProfile(String userName, String ip) throws Exception {
        UserProfile userProfile = this.storage.getDefaultUserProfile(userName, null);
        if (!userProfile.getIsBanned() && ip != null) {
            userProfile.setIsBanned(this.storage.isBanIp(ip));
        }
        return userProfile;
    }

    @Override
    public UserProfile updateUserProfileSetting(UserProfile userProfile) throws Exception {
        return this.storage.updateUserProfileSetting(userProfile);
    }

    @Override
    public List<String> getBookmarks(String userName) throws Exception {
        return this.storage.getBookmarks(userName);
    }

    @Override
    public UserProfile getUserSettingProfile(String userName) throws Exception {
        return this.storage.getUserSettingProfile(userName);
    }

    @Override
    public void saveUserSettingProfile(UserProfile userProfile) throws Exception {
        this.storage.saveUserSettingProfile(userProfile);
    }

    @Override
    public void importXML(String nodePath, ByteArrayInputStream bis, int typeImport) throws Exception {
        this.storage.importXML(nodePath, bis, typeImport);
    }

    @Override
    public void updateForum(String path) throws Exception {
        this.storage.updateForum(path);
    }

    @Override
    public List<String> getBanList() throws Exception {
        return this.storage.getBanList();
    }

    @Override
    public boolean addBanIP(String ip) throws Exception {
        return this.storage.addBanIP(ip);
    }

    @Override
    public void removeBan(String ip) throws Exception {
        this.storage.removeBan(ip);
    }

    @Override
    public JCRPageList getListPostsByIP(String ip, String strOrderBy) throws Exception {
        return this.storage.getListPostsByIP(ip, strOrderBy);
    }

    @Override
    public List<String> getForumBanList(String forumId) throws Exception {
        return this.storage.getForumBanList(forumId);
    }

    @Override
    public boolean addBanIPForum(String ip, String forumId) throws Exception {
        return this.storage.addBanIPForum(ip, forumId);
    }

    @Override
    public void removeBanIPForum(String ip, String forumId) throws Exception {
        this.storage.removeBanIPForum(ip, forumId);
    }

    @Override
    public ForumAttachment getUserAvatar(String userName) throws Exception {
        return this.storage.getUserAvatar(userName);
    }

    @Override
    public void saveUserAvatar(String userId, ForumAttachment fileAttachment) throws Exception {
        this.storage.saveUserAvatar(userId, fileAttachment);
    }

    @Override
    public void setDefaultAvatar(String userName) {
        this.storage.setDefaultAvatar(userName);
    }

    @Override
    public List<Watch> getWatchByUser(String userId) throws Exception {
        return this.storage.getWatchByUser(userId);
    }

    @Override
    public void updateEmailWatch(List<String> listNodeId, String newEmailAdd, String userId) throws Exception {
        this.storage.updateEmailWatch(listNodeId, newEmailAdd, userId);
    }

    @Override
    public List<PruneSetting> getAllPruneSetting() throws Exception {
        return this.storage.getAllPruneSetting();
    }

    @Override
    public void savePruneSetting(PruneSetting pruneSetting) throws Exception {
        this.storage.savePruneSetting(pruneSetting);
    }

    @Override
    public PruneSetting getPruneSetting(String forumPath) throws Exception {
        return this.storage.getPruneSetting(forumPath);
    }

    @Override
    public void runPrune(PruneSetting pSetting) throws Exception {
        this.storage.runPrune(pSetting);
    }

    @Override
    public void runPrune(String forumPath) throws Exception {
        this.storage.runPrune(forumPath);
    }

    @Override
    public long checkPrune(PruneSetting pSetting) throws Exception {
        return this.storage.checkPrune(pSetting);
    }

    @Override
    public void updateUserProfileInfo(String name) throws Exception {
        this.storage.updateUserProfileInfo(name);
    }

    public DataStorage getStorage() {
        return this.storage;
    }

    public void setStorage(DataStorage storage) {
        this.storage = storage;
    }

    public ForumServiceManaged getManagementView() {
        return this.managementView;
    }

    public void setManagementView(ForumServiceManaged managementView) {
        this.managementView = managementView;
    }

    public ForumStatisticsService getForumStatisticsService() {
        return this.forumStatisticsService;
    }

    public void setForumStatisticsService(ForumStatisticsService forumStatisticsService) {
        this.forumStatisticsService = forumStatisticsService;
    }

    public JobSchedulerService getJobSchedulerService() {
        return this.jobSchedulerService;
    }

    public void setJobSchedulerService(JobSchedulerService jobSchedulerService) {
        this.jobSchedulerService = jobSchedulerService;
    }

    @Override
    public InputStream createForumRss(String objectId, String link) throws Exception {
        return this.storage.createForumRss(objectId, link);
    }

    @Override
    public InputStream createUserRss(String userId, String link) throws Exception {
        return this.storage.createUserRss(userId, link);
    }

    @Override
    public void addListenerPlugin(ForumEventListener listener) throws Exception {
        this.listeners_.add(listener);
    }

    @Override
    public void removeCacheUserProfile(String userName) {
        this.storage.removeCacheUserProfile(userName);
    }

    @Override
    public void saveActivityIdForOwnerId(String ownerId, String activityId) {
        this.storage.saveActivityIdForOwner(ownerId, Utils.TOPIC, activityId);
    }

    @Override
    public void saveActivityIdForOwnerPath(String ownerPath, String activityId) {
        this.storage.saveActivityIdForOwner(ownerPath, activityId);
    }

    @Override
    public String getActivityIdForOwnerId(String ownerId) {
        return this.storage.getActivityIdForOwner(ownerId, Utils.TOPIC);
    }

    @Override
    public String getActivityIdForOwnerPath(String ownerPath) {
        return this.storage.getActivityIdForOwner(ownerPath);
    }

    @Override
    public void saveCommentIdForOwnerId(String ownerId, String commentId) {
        this.storage.saveActivityIdForOwner(ownerId, Utils.POST, commentId);
    }

    @Override
    public void saveCommentIdForOwnerPath(String ownerPath, String commentId) {
        this.storage.saveActivityIdForOwner(ownerPath, commentId);
    }

    @Override
    public String getCommentIdForOwnerId(String ownerId) {
        return this.storage.getActivityIdForOwner(ownerId, Utils.POST);
    }

    @Override
    public String getCommentIdForOwnerPath(String ownerPath) {
        return this.storage.getActivityIdForOwner(ownerPath);
    }

    @Override
    public ListAccess<UserProfile> searchUserProfileByFilter(UserProfileFilter userProfileFilter) throws Exception {
        return new UserProfileListAccess(this.storage, userProfileFilter);
    }
}

