/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.commons.search.indexing.listeners;

import java.util.HashMap;
import org.exoplatform.commons.api.indexing.IndexingService;
import org.exoplatform.commons.api.indexing.data.SearchEntry;
import org.exoplatform.commons.api.indexing.data.SearchEntryId;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.wiki.mow.api.Page;
import org.exoplatform.wiki.service.listener.PageWikiListener;

public class UnifiedSearchPageWikiListener
extends PageWikiListener {
    private static Log log = ExoLogger.getLogger(UnifiedSearchPageWikiListener.class);
    private final IndexingService indexingService;

    public UnifiedSearchPageWikiListener(IndexingService indexingService) {
        this.indexingService = indexingService;
    }

    public void postAddPage(String wikiType, String wikiOwner, String pageId, Page page) throws Exception {
        if (this.indexingService != null) {
            HashMap<String, Page> content = new HashMap<String, Page>();
            content.put("page", page);
            SearchEntry searchEntry = new SearchEntry("wiki", wikiType, pageId, content);
            this.indexingService.add(searchEntry);
        }
    }

    public void postUpdatePage(String wikiType, String wikiOwner, String pageId, Page page, String wikiUpdateType) throws Exception {
        if (this.indexingService != null) {
            HashMap<String, Page> content = new HashMap<String, Page>();
            content.put("page", page);
            SearchEntryId searchEntryId = new SearchEntryId("wiki", wikiType, pageId);
            this.indexingService.update(searchEntryId, content);
        }
    }

    public void postDeletePage(String wikiType, String wikiOwner, String pageId, Page page) throws Exception {
        if (this.indexingService != null) {
            SearchEntryId searchEntryId = new SearchEntryId("wiki", wikiType, pageId);
            this.indexingService.delete(searchEntryId);
        }
    }
}

