/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.social.webui.profile;

import java.util.List;
import org.exoplatform.container.component.ComponentRequestLifecycle;
import org.exoplatform.container.component.RequestLifeCycle;
import org.exoplatform.services.organization.OrganizationService;
import org.exoplatform.services.organization.User;
import org.exoplatform.services.security.ConversationState;
import org.exoplatform.social.core.identity.model.Identity;
import org.exoplatform.social.core.identity.model.Profile;
import org.exoplatform.social.webui.Utils;
import org.exoplatform.social.webui.profile.UIProfileSection;
import org.exoplatform.social.webui.profile.UITitleBar;
import org.exoplatform.webui.application.WebuiRequestContext;
import org.exoplatform.webui.config.annotation.ComponentConfig;
import org.exoplatform.webui.config.annotation.EventConfig;
import org.exoplatform.webui.core.UIComponent;
import org.exoplatform.webui.core.lifecycle.UIFormLifecycle;
import org.exoplatform.webui.event.Event;
import org.exoplatform.webui.form.UIFormInput;
import org.exoplatform.webui.form.UIFormStringInput;
import org.exoplatform.webui.form.validator.EmailAddressValidator;
import org.exoplatform.webui.form.validator.MandatoryValidator;
import org.exoplatform.webui.form.validator.PersonalNameValidator;
import org.exoplatform.webui.form.validator.StringLengthValidator;

@ComponentConfig(lifecycle=UIFormLifecycle.class, template="war:/groovy/social/webui/profile/UIBasicInfoSection.gtmpl", events={@EventConfig(listeners={EditActionListener.class}, phase=Event.Phase.DECODE), @EventConfig(listeners={SaveActionListener.class}, csrfCheck=true), @EventConfig(listeners={UIProfileSection.CancelActionListener.class}, phase=Event.Phase.DECODE)})
public class UIBasicInfoSection
extends UIProfileSection {
    public String lastloadUser;

    public UIBasicInfoSection() throws Exception {
        this.addChild(UITitleBar.class, null, null);
        UIFormStringInput userName = new UIFormStringInput("username", "username", null);
        userName.setEditable(false);
        this.addUIFormInput((UIFormInput)userName.addValidator(MandatoryValidator.class, new Object[0]));
        this.addUIFormInput((UIFormInput)new UIFormStringInput("firstName", "firstName", null).addValidator(MandatoryValidator.class, new Object[0]).addValidator(PersonalNameValidator.class, new Object[0]).addValidator(StringLengthValidator.class, new Object[]{1, 45}));
        this.addUIFormInput((UIFormInput)new UIFormStringInput("lastName", "lastName", null).addValidator(MandatoryValidator.class, new Object[0]).addValidator(PersonalNameValidator.class, new Object[0]).addValidator(StringLengthValidator.class, new Object[]{1, 45}));
        this.addUIFormInput((UIFormInput)new UIFormStringInput("email", "email", null).addValidator(MandatoryValidator.class, new Object[0]).addValidator(EmailAddressValidator.class, new Object[0]));
    }

    public void reloadBasicInfo() {
        if (!this.isFirstLoad()) {
            Identity ownerIdentity = Utils.getOwnerIdentity(false);
            Profile profile = ownerIdentity.getProfile();
            this.getUIStringInput("username").setValue((Object)((String)profile.getProperty("username")));
            this.getUIStringInput("firstName").setValue((Object)((String)profile.getProperty("firstName")));
            this.getUIStringInput("lastName").setValue((Object)((String)profile.getProperty("lastName")));
            this.getUIStringInput("email").setValue((Object)((String)profile.getProperty("email")));
            if (this.isEditMode()) {
                this.setFirstLoad(true);
            }
        }
    }

    public List<UIComponent> getChilds() {
        return this.getChildren();
    }

    public static class SaveActionListener
    extends UIProfileSection.SaveActionListener {
        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void execute(Event<UIProfileSection> event) throws Exception {
            super.execute(event);
            UIBasicInfoSection uiForm = (UIBasicInfoSection)((Object)event.getSource());
            String firstName = (String)uiForm.getUIStringInput("firstName").getValue();
            String lastName = (String)uiForm.getUIStringInput("lastName").getValue();
            String newEmail = (String)uiForm.getUIStringInput("email").getValue();
            String fullName = firstName + " " + lastName;
            Identity viewerIdentity = Utils.getViewerIdentity(true);
            Profile profile = viewerIdentity.getProfile();
            boolean profileHasUpdated = false;
            if (!profile.getProperty("firstName").equals(firstName)) {
                profile.setProperty("firstName", (Object)firstName);
                profile.setProperty("fullName", (Object)fullName);
                profileHasUpdated = true;
            }
            if (!profile.getProperty("lastName").equals(lastName)) {
                profile.setProperty("lastName", (Object)lastName);
                profile.setProperty("fullName", (Object)fullName);
                profileHasUpdated = true;
            }
            if (!profile.getProperty("email").equals(newEmail)) {
                profile.setProperty("email", (Object)newEmail);
                profileHasUpdated = true;
            }
            if (profileHasUpdated) {
                Utils.getIdentityManager().updateProfile(profile);
                Utils.getOwnerIdentity(true);
                ConversationState state = ConversationState.getCurrent();
                OrganizationService organizationService = (OrganizationService)uiForm.getApplicationComponent(OrganizationService.class);
                try {
                    RequestLifeCycle.begin((ComponentRequestLifecycle)((ComponentRequestLifecycle)organizationService));
                    User user = organizationService.getUserHandler().findUserByName(state.getIdentity().getUserId());
                    state.setAttribute("UserProfile", (Object)user);
                }
                finally {
                    RequestLifeCycle.end();
                }
            }
            uiForm.setFirstLoad(false);
            Utils.updateWorkingWorkSpace();
        }
    }

    public static class EditActionListener
    extends UIProfileSection.EditActionListener {
        @Override
        public void execute(Event<UIProfileSection> event) throws Exception {
            super.execute(event);
            UIProfileSection sect = (UIProfileSection)((Object)event.getSource());
            UIBasicInfoSection uiForm = (UIBasicInfoSection)sect;
            WebuiRequestContext requestContext = event.getRequestContext();
            requestContext.addUIComponentToUpdateByAjax((UIComponent)uiForm);
            requestContext.addUIComponentToUpdateByAjax((UIComponent)sect);
            sect.setFirstLoad(false);
        }
    }
}

