/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.social.core.application;

import java.util.LinkedHashMap;
import org.apache.commons.lang.StringEscapeUtils;
import org.exoplatform.container.PortalContainer;
import org.exoplatform.container.xml.InitParams;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.social.core.activity.model.ExoSocialActivity;
import org.exoplatform.social.core.activity.model.ExoSocialActivityImpl;
import org.exoplatform.social.core.identity.model.Identity;
import org.exoplatform.social.core.identity.model.Profile;
import org.exoplatform.social.core.manager.ActivityManager;
import org.exoplatform.social.core.manager.IdentityManager;
import org.exoplatform.social.core.profile.ProfileLifeCycleEvent;
import org.exoplatform.social.core.profile.ProfileListenerPlugin;
import org.exoplatform.social.core.storage.api.IdentityStorage;

public class ProfileUpdatesPublisher
extends ProfileListenerPlugin {
    public static final String USER_NAME_PARAM = "USER_NAME_PARAM";
    public static final String USER_POSITION_PARAM = "USER_POSITION_PARAM";
    public static final String POSITION_TITLE_ID = "position_updated";
    private static final Log LOG = ExoLogger.getLogger(ProfileUpdatesPublisher.class);
    private ActivityManager activityManager;
    private IdentityManager identityManager;

    public ProfileUpdatesPublisher(InitParams params, ActivityManager activityManager, IdentityManager identityManager) {
        this.activityManager = activityManager;
        this.identityManager = identityManager;
    }

    @Override
    public void avatarUpdated(ProfileLifeCycleEvent event) {
        String activityMessage = "Avatar has been updated.";
        this.publishActivity(event, "Avatar has been updated.", "avatar_updated");
    }

    @Override
    public void basicInfoUpdated(ProfileLifeCycleEvent event) {
        String activityMessage = "Basic informations has been updated.";
        this.publishActivity(event, "Basic informations has been updated.", "basic_info_updated");
    }

    @Override
    public void contactSectionUpdated(ProfileLifeCycleEvent event) {
        String activityMessage = "Contact informations has been updated.";
        this.publishActivity(event, "Contact informations has been updated.", "contact_section_updated");
    }

    @Override
    public void experienceSectionUpdated(ProfileLifeCycleEvent event) {
        String activityMessage = "Experiences has been updated.";
        this.publishActivity(event, "Experiences has been updated.", "experience_section_updated");
    }

    @Override
    public void headerSectionUpdated(ProfileLifeCycleEvent event) {
        String activityMessage = "Position is now: " + StringEscapeUtils.unescapeHtml((String)event.getProfile().getPosition());
        this.publishActivity(event, activityMessage, POSITION_TITLE_ID);
    }

    private ExoSocialActivity createComment(String title, String titleId, Identity identity, String position) {
        ExoSocialActivityImpl comment = new ExoSocialActivityImpl();
        comment.setTitle(title);
        comment.setUserId(identity.getId());
        comment.setType("exosocial:people");
        comment.setTitleId(titleId);
        LinkedHashMap<String, String> templateParams = new LinkedHashMap<String, String>();
        if (POSITION_TITLE_ID.equals(titleId)) {
            templateParams.put(USER_POSITION_PARAM, StringEscapeUtils.unescapeHtml((String)position));
            templateParams.put("registeredKeysForProcessor", USER_POSITION_PARAM);
        }
        comment.setTemplateParams(templateParams);
        return comment;
    }

    private void publishActivity(ProfileLifeCycleEvent event, String activityMessage, String titleId) {
        String activityId = this.getStorage().getProfileActivityId(event.getProfile(), Profile.AttachedActivityType.USER);
        ExoSocialActivityImpl activity = (ExoSocialActivityImpl)this.activityManager.getActivity(activityId);
        if (activity == null) {
            activity = new ExoSocialActivityImpl();
            activity.setType("USER_PROFILE_ACTIVITY");
            activityId = null;
        }
        activity.setTitle(activityMessage);
        this.publish(event, activity, activityId, titleId);
    }

    private void publish(ProfileLifeCycleEvent event, ExoSocialActivity activity, String activityId, String titleId) {
        Profile profile = event.getProfile();
        Identity identity = profile.getIdentity();
        try {
            this.reloadIfNeeded(identity);
            if (activityId == null) {
                this.activityManager.saveActivityNoReturn(identity, activity);
                this.getStorage().updateProfileActivityId(identity, activity.getId(), Profile.AttachedActivityType.USER);
            }
            ExoSocialActivity comment = this.createComment(activity.getTitle(), titleId, identity, event.getProfile().getPosition());
            this.activityManager.saveComment(activity, comment);
        }
        catch (Exception e) {
            LOG.warn((Object)("Failed to publish event " + (Object)((Object)event) + ": " + e.getMessage()));
        }
    }

    private void reloadIfNeeded(Identity id1) throws Exception {
        if (id1.getId() == null || id1.getProfile().getFullName().length() == 0) {
            id1 = this.identityManager.getIdentity(id1.getGlobalId().toString(), true);
        }
    }

    private IdentityStorage getStorage() {
        return (IdentityStorage)PortalContainer.getInstance().getComponentInstanceOfType(IdentityStorage.class);
    }

    @Override
    public void createProfile(ProfileLifeCycleEvent event) {
    }
}

