/*
 * Decompiled with CFR 0.152.
 */
package juzu.impl.bridge;

import java.util.Collections;
import java.util.Map;
import java.util.Set;
import juzu.impl.common.Name;
import juzu.impl.common.Tools;
import juzu.impl.inject.spi.InjectorProvider;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BridgeConfig {
    public static final String RUN_MODE = "juzu.run_mode";
    public static final String INJECT = "juzu.inject";
    public static final String APP_NAME = "juzu.app_name";
    public static final String SOURCE_PATH = "juzu.src_path";
    public static final Set<String> NAMES = Collections.unmodifiableSet(Tools.set("juzu.run_mode", "juzu.inject", "juzu.app_name"));
    public final Name name;
    public final InjectorProvider injectImpl;

    public static Name getApplicationName(Map<String, String> config) {
        String applicationName = config.get(APP_NAME);
        return applicationName != null ? Name.parse(applicationName) : null;
    }

    public static InjectorProvider getInjectImplementation(Map<String, String> config) throws Exception {
        InjectorProvider implementation;
        String inject = config.get(INJECT);
        if (inject == null) {
            implementation = InjectorProvider.INJECT_GUICE;
        } else if ("weld".equals(inject = inject.trim().toLowerCase())) {
            implementation = InjectorProvider.CDI_WELD;
        } else if ("spring".equals(inject)) {
            implementation = InjectorProvider.INJECT_SPRING;
        } else if ("guice".equals(inject)) {
            implementation = InjectorProvider.INJECT_GUICE;
        } else {
            throw new Exception("unrecognized inject vendor " + inject);
        }
        return implementation;
    }

    public BridgeConfig(Map<String, String> config) throws Exception {
        this.name = BridgeConfig.getApplicationName(config);
        this.injectImpl = BridgeConfig.getInjectImplementation(config);
    }
}

