/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.ecm.webui.component.explorer.popup.actions;

import java.util.ArrayList;
import java.util.ResourceBundle;
import javax.jcr.Node;
import javax.jcr.lock.LockException;
import org.exoplatform.ecm.webui.component.explorer.UIJCRExplorer;
import org.exoplatform.ecm.webui.component.explorer.UIWorkingArea;
import org.exoplatform.services.cms.watch.WatchDocumentService;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.services.wcm.utils.WCMCoreUtils;
import org.exoplatform.web.application.ApplicationMessage;
import org.exoplatform.webui.application.WebuiRequestContext;
import org.exoplatform.webui.config.annotation.ComponentConfig;
import org.exoplatform.webui.config.annotation.EventConfig;
import org.exoplatform.webui.core.UIApplication;
import org.exoplatform.webui.core.UIPopupComponent;
import org.exoplatform.webui.core.lifecycle.UIFormLifecycle;
import org.exoplatform.webui.core.model.SelectItemOption;
import org.exoplatform.webui.event.Event;
import org.exoplatform.webui.event.EventListener;
import org.exoplatform.webui.form.UIForm;
import org.exoplatform.webui.form.UIFormInput;
import org.exoplatform.webui.form.UIFormRadioBoxInput;

@ComponentConfig(lifecycle=UIFormLifecycle.class, template="app:/groovy/webui/component/explorer/popup/action/UIWatchDocumentForm.gtmpl", events={@EventConfig(listeners={WatchActionListener.class}, phase=Event.Phase.DECODE), @EventConfig(listeners={CancelActionListener.class}, phase=Event.Phase.DECODE), @EventConfig(listeners={UnwatchActionListener.class}, phase=Event.Phase.DECODE)})
public class UIWatchDocumentForm
extends UIForm
implements UIPopupComponent {
    private static final Log LOG = ExoLogger.getLogger((String)UIWatchDocumentForm.class.getName());
    private static final String NOTIFICATION_TYPE = "notificationType";
    private static final String NOTIFICATION_TYPE_BY_EMAIL = "Email";

    public UIWatchDocumentForm() throws Exception {
        ArrayList<SelectItemOption> nodifyOptions = new ArrayList<SelectItemOption>();
        nodifyOptions.add(new SelectItemOption(NOTIFICATION_TYPE_BY_EMAIL, (Object)NOTIFICATION_TYPE_BY_EMAIL));
        UIFormRadioBoxInput notificationTypeRadioBoxInput = new UIFormRadioBoxInput(NOTIFICATION_TYPE, NOTIFICATION_TYPE, nodifyOptions);
        this.addUIFormInput((UIFormInput)notificationTypeRadioBoxInput);
    }

    public void activate() {
        block4: {
            try {
                if (!this.isWatching()) {
                    this.setActions(new String[]{"Watch", "Cancel"});
                } else {
                    this.setActions(new String[]{"Unwatch", "Cancel"});
                    UIFormRadioBoxInput notificationTypeRadioBoxInput = (UIFormRadioBoxInput)this.getChildById(NOTIFICATION_TYPE);
                    notificationTypeRadioBoxInput.setValue((Object)NOTIFICATION_TYPE_BY_EMAIL);
                    notificationTypeRadioBoxInput.setReadOnly(true);
                }
            }
            catch (Exception e) {
                if (!LOG.isErrorEnabled()) break block4;
                LOG.error("Unexpected error!", new Object[]{e.getMessage()});
            }
        }
    }

    public void deActivate() {
    }

    private Node getWatchNode() throws Exception {
        return ((UIJCRExplorer)this.getAncestorOfType(UIJCRExplorer.class)).getCurrentNode();
    }

    private String getUserName() {
        WebuiRequestContext context = (WebuiRequestContext)WebuiRequestContext.getCurrentInstance();
        return context.getRemoteUser();
    }

    private boolean isWatching() throws Exception {
        return 1 == this.getNotifyType();
    }

    private int getNotifyType() throws Exception {
        WatchDocumentService watchService = (WatchDocumentService)this.getApplicationComponent(WatchDocumentService.class);
        return watchService.getNotificationType(this.getWatchNode(), this.getUserName());
    }

    private void showFinishMessage(Event<UIWatchDocumentForm> event, String messageKey) throws Exception {
        ResourceBundle res = event.getRequestContext().getApplicationResourceBundle();
        UIJCRExplorer uiExplorer = (UIJCRExplorer)this.getAncestorOfType(UIJCRExplorer.class);
        ((UIWorkingArea)uiExplorer.getChild(UIWorkingArea.class)).setWCMNotice(res.getString(messageKey));
        uiExplorer.updateAjax(event);
    }

    private void toogleWatch(Event<UIWatchDocumentForm> event) throws Exception {
        UIApplication uiApp = (UIApplication)this.getAncestorOfType(UIApplication.class);
        ((UIJCRExplorer)this.getAncestorOfType(UIJCRExplorer.class)).addLockToken(this.getWatchNode());
        try {
            WatchDocumentService watchService = (WatchDocumentService)WCMCoreUtils.getService(WatchDocumentService.class);
            if (this.isWatching()) {
                watchService.unwatchDocument(this.getWatchNode(), this.getUserName(), 1);
                this.showFinishMessage(event, "UIWatchDocumentForm.msg.unwatching-successfully");
            } else {
                watchService.watchDocument(this.getWatchNode(), this.getUserName(), 1);
                this.showFinishMessage(event, "UIWatchDocumentForm.msg.watching-successfully");
            }
        }
        catch (LockException e) {
            uiApp.addMessage(new ApplicationMessage("UIWatchDocumentForm.msg.node-is-locked", null, 1));
        }
        catch (Exception e) {
            uiApp.addMessage(new ApplicationMessage("UIWatchDocumentForm.msg.unknown-error", null, 0));
        }
    }

    public static class UnwatchActionListener
    extends EventListener<UIWatchDocumentForm> {
        public void execute(Event<UIWatchDocumentForm> event) throws Exception {
            UIWatchDocumentForm uiForm = (UIWatchDocumentForm)((Object)event.getSource());
            uiForm.toogleWatch((Event<UIWatchDocumentForm>)event);
        }
    }

    public static class WatchActionListener
    extends EventListener<UIWatchDocumentForm> {
        public void execute(Event<UIWatchDocumentForm> event) throws Exception {
            UIWatchDocumentForm uiForm = (UIWatchDocumentForm)((Object)event.getSource());
            UIApplication uiApp = (UIApplication)uiForm.getAncestorOfType(UIApplication.class);
            ((UIJCRExplorer)uiForm.getAncestorOfType(UIJCRExplorer.class)).addLockToken(uiForm.getWatchNode());
            boolean isNotifyByEmail = UIWatchDocumentForm.NOTIFICATION_TYPE_BY_EMAIL.equalsIgnoreCase((String)((UIFormRadioBoxInput)uiForm.getChildById(UIWatchDocumentForm.NOTIFICATION_TYPE)).getValue());
            if (isNotifyByEmail) {
                uiForm.toogleWatch((Event<UIWatchDocumentForm>)event);
            } else {
                uiApp.addMessage(new ApplicationMessage("UIWatchDocumentForm.msg.not-support", null, 1));
            }
        }
    }

    public static class CancelActionListener
    extends EventListener<UIWatchDocumentForm> {
        public void execute(Event<UIWatchDocumentForm> event) throws Exception {
            UIJCRExplorer uiExplorer = (UIJCRExplorer)((UIWatchDocumentForm)((Object)event.getSource())).getAncestorOfType(UIJCRExplorer.class);
            uiExplorer.cancelAction();
        }
    }
}

