/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.ecm.webui.component.explorer.rightclick.manager;

import java.util.Arrays;
import java.util.List;
import java.util.regex.Matcher;
import javax.jcr.AccessDeniedException;
import javax.jcr.Item;
import javax.jcr.Node;
import javax.jcr.PathNotFoundException;
import javax.jcr.Session;
import javax.jcr.lock.LockException;
import javax.jcr.version.VersionException;
import org.exoplatform.ecm.webui.component.explorer.UIJCRExplorer;
import org.exoplatform.ecm.webui.component.explorer.UIWorkingArea;
import org.exoplatform.ecm.webui.component.explorer.control.filter.HasRemovePermissionFilter;
import org.exoplatform.ecm.webui.component.explorer.control.filter.IsCheckedOutFilter;
import org.exoplatform.ecm.webui.component.explorer.control.filter.IsFavouriteFilter;
import org.exoplatform.ecm.webui.component.explorer.control.filter.IsNotInTrashFilter;
import org.exoplatform.ecm.webui.component.explorer.control.filter.IsNotLockedFilter;
import org.exoplatform.ecm.webui.component.explorer.control.filter.IsNotTrashHomeNodeFilter;
import org.exoplatform.ecm.webui.component.explorer.control.listener.UIWorkingAreaActionListener;
import org.exoplatform.ecm.webui.utils.JCRExceptionManager;
import org.exoplatform.ecm.webui.utils.PermissionUtil;
import org.exoplatform.services.cms.documents.FavoriteService;
import org.exoplatform.services.cms.link.LinkManager;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.services.security.ConversationState;
import org.exoplatform.services.wcm.utils.WCMCoreUtils;
import org.exoplatform.web.application.ApplicationMessage;
import org.exoplatform.webui.config.annotation.ComponentConfig;
import org.exoplatform.webui.config.annotation.EventConfig;
import org.exoplatform.webui.core.UIApplication;
import org.exoplatform.webui.core.UIComponent;
import org.exoplatform.webui.event.Event;
import org.exoplatform.webui.ext.filter.UIExtensionFilter;
import org.exoplatform.webui.ext.filter.UIExtensionFilters;
import org.exoplatform.webui.ext.manager.UIAbstractManager;
import org.exoplatform.webui.ext.manager.UIAbstractManagerComponent;

@ComponentConfig(events={@EventConfig(listeners={RemoveFromFavouriteActionListener.class})})
public class RemoveFavouriteManageComponent
extends UIAbstractManagerComponent {
    private static final List<UIExtensionFilter> FILTERS = Arrays.asList(new UIExtensionFilter[]{new IsNotInTrashFilter(), new IsFavouriteFilter(), new IsNotLockedFilter(), new IsCheckedOutFilter(), new HasRemovePermissionFilter(), new IsNotTrashHomeNodeFilter()});
    private static final Log LOG = ExoLogger.getLogger((String)RemoveFavouriteManageComponent.class.getName());

    @UIExtensionFilters
    public List<UIExtensionFilter> getFilters() {
        return FILTERS;
    }

    private static void multiRemoveFromFavourite(String[] paths, Event<UIComponent> event) throws Exception {
        for (String path : paths) {
            RemoveFavouriteManageComponent.removeFromFavourite(path, event);
        }
    }

    private static void removeFromFavourite(String srcPath, Event<UIComponent> event) throws Exception {
        UIWorkingArea uiWorkingArea = (UIWorkingArea)((UIComponent)event.getSource()).getParent();
        UIJCRExplorer uiExplorer = (UIJCRExplorer)uiWorkingArea.getAncestorOfType(UIJCRExplorer.class);
        FavoriteService favoriteService = (FavoriteService)WCMCoreUtils.getService(FavoriteService.class);
        UIApplication uiApp = (UIApplication)uiWorkingArea.getAncestorOfType(UIApplication.class);
        Matcher matcher = UIWorkingArea.FILE_EXPLORER_URL_SYNTAX.matcher(srcPath);
        String wsName = null;
        Node node = null;
        if (!matcher.find()) {
            throw new IllegalArgumentException("The ObjectId is invalid '" + srcPath + "'");
        }
        wsName = matcher.group(1);
        srcPath = matcher.group(2);
        Session session = uiExplorer.getSessionByWorkspace(wsName);
        try {
            node = uiExplorer.getNodeByPath(srcPath, session, false);
            LinkManager lnkManager = (LinkManager)uiExplorer.getApplicationComponent(LinkManager.class);
            if (lnkManager.isLink((Item)node) && lnkManager.isTargetReachable(node)) {
                node = lnkManager.getTarget(node);
            }
            session = node.getSession();
        }
        catch (PathNotFoundException path) {
            uiApp.addMessage(new ApplicationMessage("UIPopupMenu.msg.path-not-found-exception", null, 1));
            return;
        }
        try {
            uiExplorer.addLockToken(node);
        }
        catch (Exception e) {
            JCRExceptionManager.process((UIApplication)uiApp, (Exception)e);
            return;
        }
        try {
            if (!node.isCheckedOut()) {
                throw new VersionException("node is locked, can't remove favourite of node :" + node.getPath());
            }
            if (!PermissionUtil.canRemoveNode((Node)node)) {
                throw new AccessDeniedException("access denied, can't remove favourite of node:" + node.getPath());
            }
            favoriteService.removeFavorite(node, ConversationState.getCurrent().getIdentity().getUserId());
            uiExplorer.updateAjax(event);
        }
        catch (LockException e) {
            if (LOG.isErrorEnabled()) {
                LOG.error((Object)("node is locked, can't remove favourite of node :" + node.getPath()));
            }
            JCRExceptionManager.process((UIApplication)uiApp, (Exception)((Object)e));
            uiExplorer.updateAjax(event);
        }
        catch (VersionException e) {
            if (LOG.isErrorEnabled()) {
                LOG.error((Object)("node is checked in, can't remove favourite of node:" + node.getPath()));
            }
            JCRExceptionManager.process((UIApplication)uiApp, (Exception)((Object)e));
            uiExplorer.updateAjax(event);
        }
        catch (AccessDeniedException e) {
            if (LOG.isErrorEnabled()) {
                LOG.error((Object)("access denied, can't remove favourite of node:" + node.getPath()));
            }
            JCRExceptionManager.process((UIApplication)uiApp, (Exception)((Object)e));
            uiExplorer.updateAjax(event);
        }
        catch (Exception e) {
            if (LOG.isErrorEnabled()) {
                LOG.error((Object)"an unexpected error occurs", (Throwable)e);
            }
            JCRExceptionManager.process((UIApplication)uiApp, (Exception)e);
            uiExplorer.updateAjax(event);
        }
    }

    public static void removeFavouriteManage(Event<UIComponent> event) throws Exception {
        String srcPath = event.getRequestContext().getRequestParameter("objectId");
        if (srcPath.indexOf(59) > -1) {
            RemoveFavouriteManageComponent.multiRemoveFromFavourite(srcPath.split(";"), event);
        } else {
            RemoveFavouriteManageComponent.removeFromFavourite(srcPath, event);
        }
    }

    public Class<? extends UIAbstractManager> getUIAbstractManagerClass() {
        return null;
    }

    public static class RemoveFromFavouriteActionListener
    extends UIWorkingAreaActionListener<RemoveFavouriteManageComponent> {
        public void processEvent(Event<RemoveFavouriteManageComponent> event) throws Exception {
            Event event_ = new Event(event.getSource(), event.getName(), event.getRequestContext());
            RemoveFavouriteManageComponent.removeFavouriteManage((Event<UIComponent>)event_);
        }
    }
}

