/*
 * Decompiled with CFR 0.152.
 */
package com.google.javascript.rhino;

import com.google.javascript.rhino.Kit;
import com.google.javascript.rhino.TokenStream;
import java.text.MessageFormat;
import java.util.Locale;
import java.util.MissingResourceException;
import java.util.ResourceBundle;

public class ScriptRuntime {
    public static final double NaN = Double.longBitsToDouble(9221120237041090560L);
    public static final double negativeZero = Double.longBitsToDouble(Long.MIN_VALUE);

    protected ScriptRuntime() {
    }

    public static boolean isJSLineTerminator(int c) {
        if ((c & 0xDFD0) != 0) {
            return false;
        }
        return c == 10 || c == 13 || c == 8232 || c == 8233;
    }

    static double stringToNumber(String s, int start, int radix) {
        int end;
        char digitMax = '9';
        char lowerCaseBound = 'a';
        char upperCaseBound = 'A';
        int len = s.length();
        if (radix < 10) {
            digitMax = (char)(48 + radix - 1);
        }
        if (radix > 10) {
            lowerCaseBound = (char)(97 + radix - 10);
            upperCaseBound = (char)(65 + radix - 10);
        }
        double sum = 0.0;
        for (end = start; end < len; ++end) {
            int newDigit;
            char c = s.charAt(end);
            if ('0' <= c && c <= digitMax) {
                newDigit = c - 48;
            } else if ('a' <= c && c < lowerCaseBound) {
                newDigit = c - 97 + 10;
            } else {
                if ('A' > c || c >= upperCaseBound) break;
                newDigit = c - 65 + 10;
            }
            sum = sum * (double)radix + (double)newDigit;
        }
        if (start == end) {
            return NaN;
        }
        if (sum >= 9.007199254740992E15) {
            if (radix == 10) {
                try {
                    return Double.valueOf(s.substring(start, end));
                }
                catch (NumberFormatException nfe) {
                    return NaN;
                }
            }
            if (radix == 2 || radix == 4 || radix == 8 || radix == 16 || radix == 32) {
                int bitShiftInChar = 1;
                int digit = 0;
                boolean SKIP_LEADING_ZEROS = false;
                boolean FIRST_EXACT_53_BITS = true;
                int AFTER_BIT_53 = 2;
                int ZEROS_AFTER_54 = 3;
                int MIXED_AFTER_54 = 4;
                int state = 0;
                int exactBitsLimit = 53;
                double factor = 0.0;
                boolean bit53 = false;
                boolean bit54 = false;
                while (true) {
                    if (bitShiftInChar == 1) {
                        if (start == end) break;
                        digit = 48 <= (digit = (int)s.charAt(start++)) && digit <= 57 ? (digit -= 48) : (97 <= digit && digit <= 122 ? (digit -= 87) : (digit -= 55));
                        bitShiftInChar = radix;
                    }
                    boolean bit = (digit & (bitShiftInChar >>= 1)) != 0;
                    switch (state) {
                        case 0: {
                            if (!bit) break;
                            --exactBitsLimit;
                            sum = 1.0;
                            state = 1;
                            break;
                        }
                        case 1: {
                            sum *= 2.0;
                            if (bit) {
                                sum += 1.0;
                            }
                            if (--exactBitsLimit != 0) break;
                            bit53 = bit;
                            state = 2;
                            break;
                        }
                        case 2: {
                            bit54 = bit;
                            factor = 2.0;
                            state = 3;
                            break;
                        }
                        case 3: {
                            if (bit) {
                                state = 4;
                            }
                        }
                        case 4: {
                            factor *= 2.0;
                        }
                    }
                }
                switch (state) {
                    case 0: {
                        sum = 0.0;
                        break;
                    }
                    case 1: 
                    case 2: {
                        break;
                    }
                    case 3: {
                        if (bit54 & bit53) {
                            sum += 1.0;
                        }
                        sum *= factor;
                        break;
                    }
                    case 4: {
                        if (bit54) {
                            sum += 1.0;
                        }
                        sum *= factor;
                    }
                }
            }
        }
        return sum;
    }

    public static String escapeString(String s) {
        return ScriptRuntime.escapeString(s, '\"');
    }

    public static String escapeString(String s, char escapeQuote) {
        if (escapeQuote != '\"' && escapeQuote != '\'') {
            Kit.codeBug();
        }
        StringBuffer sb = null;
        int L = s.length();
        for (int i = 0; i != L; ++i) {
            int hexSize;
            char c = s.charAt(i);
            if (' ' <= c && c <= '~' && c != escapeQuote && c != '\\') {
                if (sb == null) continue;
                sb.append(c);
                continue;
            }
            if (sb == null) {
                sb = new StringBuffer(L + 3);
                sb.append(s);
                sb.setLength(i);
            }
            int escape = -1;
            switch (c) {
                case '\b': {
                    escape = 98;
                    break;
                }
                case '\f': {
                    escape = 102;
                    break;
                }
                case '\n': {
                    escape = 110;
                    break;
                }
                case '\r': {
                    escape = 114;
                    break;
                }
                case '\t': {
                    escape = 116;
                    break;
                }
                case '\u000b': {
                    escape = 118;
                    break;
                }
                case ' ': {
                    escape = 32;
                    break;
                }
                case '\\': {
                    escape = 92;
                }
            }
            if (escape >= 0) {
                sb.append('\\');
                sb.append((char)escape);
                continue;
            }
            if (c == escapeQuote) {
                sb.append('\\');
                sb.append(escapeQuote);
                continue;
            }
            if (c < '\u0100') {
                sb.append("\\x");
                hexSize = 2;
            } else {
                sb.append("\\u");
                hexSize = 4;
            }
            for (int shift = (hexSize - 1) * 4; shift >= 0; shift -= 4) {
                int digit = 0xF & c >> shift;
                int hc = digit < 10 ? 48 + digit : 87 + digit;
                sb.append((char)hc);
            }
        }
        return sb == null ? s : sb.toString();
    }

    static boolean isValidIdentifierName(String s) {
        int L = s.length();
        if (L == 0) {
            return false;
        }
        if (!Character.isJavaIdentifierStart(s.charAt(0))) {
            return false;
        }
        for (int i = 1; i != L; ++i) {
            if (Character.isJavaIdentifierPart(s.charAt(i))) continue;
            return false;
        }
        return !TokenStream.isKeyword(s);
    }

    public static long testUint32String(String str) {
        int MAX_VALUE_LENGTH = 10;
        int len = str.length();
        if (1 <= len && len <= 10) {
            int c = str.charAt(0);
            if ((c -= 48) == 0) {
                return len == 1 ? 0L : -1L;
            }
            if (1 <= c && c <= 9) {
                long v = c;
                for (int i = 1; i != len; ++i) {
                    c = str.charAt(i) - 48;
                    if (0 > c || c > 9) {
                        return -1L;
                    }
                    v = 10L * v + (long)c;
                }
                if (v >>> 32 == 0L) {
                    return v;
                }
            }
        }
        return -1L;
    }

    static boolean isSpecialProperty(String s) {
        return s.equals("__proto__") || s.equals("__parent__");
    }

    public static String getMessage0(String messageId) {
        return ScriptRuntime.getMessage(messageId, null);
    }

    public static String getMessage1(String messageId, Object arg1) {
        Object[] arguments = new Object[]{arg1};
        return ScriptRuntime.getMessage(messageId, arguments);
    }

    public static String getMessage(String messageId, Object[] arguments) {
        String formatString;
        String defaultResource = "rhino_ast.java.com.google.javascript.rhino.Messages";
        Locale locale = Locale.getDefault();
        ResourceBundle rb = ResourceBundle.getBundle("rhino_ast.java.com.google.javascript.rhino.Messages", locale);
        try {
            formatString = rb.getString(messageId);
        }
        catch (MissingResourceException mre) {
            throw new RuntimeException("no message resource found for message property " + messageId);
        }
        MessageFormat formatter = new MessageFormat(formatString);
        return formatter.format(arguments);
    }
}

